/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Supplier;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.ContextMappingIterator;
import net.sf.saxon.expr.ContextSwitchingExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.PushElaborator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.GroupAdjacentIterator;
import net.sf.saxon.expr.sort.GroupBreakingIterator;
import net.sf.saxon.expr.sort.GroupByIterator;
import net.sf.saxon.expr.sort.GroupEndingIterator;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.expr.sort.GroupStartingIterator;
import net.sf.saxon.expr.sort.SortExpression;
import net.sf.saxon.expr.sort.SortKeyDefinition;
import net.sf.saxon.expr.sort.SortKeyDefinitionList;
import net.sf.saxon.expr.sort.SortKeyEvaluator;
import net.sf.saxon.expr.sort.SortedGroupIterator;
import net.sf.saxon.functions.CurrentGroupCall;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public class ForEachGroup
extends Instruction
implements SortKeyEvaluator,
ContextSwitchingExpression {
    public static final int GROUP_BY = 0;
    public static final int GROUP_ADJACENT = 1;
    public static final int GROUP_STARTING = 2;
    public static final int GROUP_ENDING = 3;
    public static final int GROUP_SPLIT_WHEN = 4;
    private final byte algorithm;
    private StringCollator collator;
    private AtomicComparer[] sortComparators = null;
    private ItemEvaluator[] sortKeyEvaluators = null;
    private boolean composite = false;
    private boolean inFork = false;
    private final Operand selectOp;
    private final Operand actionOp;
    private final Operand keyOp;
    private Operand collationOp;
    private Operand sortKeysOp;

    public ForEachGroup(Expression select, Expression action, byte algorithm, Expression key, StringCollator collator, Expression collationNameExpression, SortKeyDefinitionList sortKeys) {
        this.selectOp = new Operand(this, select, OperandRole.FOCUS_CONTROLLING_SELECT);
        this.actionOp = new Operand(this, action, OperandRole.FOCUS_CONTROLLED_ACTION);
        OperandRole keyRole = algorithm == 3 || algorithm == 2 ? OperandRole.PATTERN : OperandRole.NEW_FOCUS_ATOMIC;
        this.keyOp = new Operand(this, key, keyRole);
        if (collationNameExpression != null) {
            this.collationOp = new Operand(this, collationNameExpression, OperandRole.SINGLE_ATOMIC);
        }
        if (sortKeys != null) {
            this.sortKeysOp = new Operand(this, sortKeys, OperandRole.CONSTRAINED_SINGLE_ATOMIC);
        }
        this.algorithm = algorithm;
        this.collator = collator;
        for (Operand o : this.operands()) {
            this.adoptChildExpression(o.getChildExpression());
        }
    }

    @Override
    public int getInstructionNameCode() {
        return 156;
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandSparseList(this.selectOp, this.actionOp, this.keyOp, this.collationOp, this.sortKeysOp);
    }

    @Override
    public Expression getSelectExpression() {
        return this.selectOp.getChildExpression();
    }

    @Override
    public Expression getActionExpression() {
        return this.actionOp.getChildExpression();
    }

    public byte getAlgorithm() {
        return this.algorithm;
    }

    public Expression getGroupingKey() {
        return this.keyOp.getChildExpression();
    }

    public SortKeyDefinitionList getSortKeyDefinitions() {
        return this.sortKeysOp == null ? null : (SortKeyDefinitionList)this.sortKeysOp.getChildExpression();
    }

    public AtomicComparer[] getSortKeyComparators() {
        return this.sortComparators;
    }

    public StringCollator getCollation() {
        return this.collator;
    }

    public URI getBaseURI() {
        try {
            return this.getRetainedStaticContext().getStaticBaseUri();
        }
        catch (XPathException err) {
            return null;
        }
    }

    public boolean isComposite() {
        return this.composite;
    }

    public void setComposite(boolean composite) {
        this.composite = composite;
    }

    public boolean isInFork() {
        return this.inFork;
    }

    public void setIsInFork(boolean inFork) {
        this.inFork = inFork;
    }

    @Override
    public boolean allowExtractingCommonSubexpressions() {
        return false;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        ItemType selectedItemType;
        this.selectOp.typeCheck(visitor, contextInfo);
        if (this.collationOp != null) {
            this.collationOp.typeCheck(visitor, contextInfo);
        }
        if ((selectedItemType = this.getSelectExpression().getItemType()) == ErrorType.getInstance()) {
            return Literal.makeEmptySequence();
        }
        ForEachGroup.fixupGroupReferences(this, this, selectedItemType, false);
        ContextItemStaticInfo cit = visitor.getConfiguration().makeContextItemStaticInfo(selectedItemType, false);
        cit.setContextSettingExpression(this.getSelectExpression());
        this.actionOp.typeCheck(visitor, cit);
        this.keyOp.typeCheck(visitor, cit);
        if (Literal.isEmptySequence(this.getSelectExpression())) {
            return this.getSelectExpression();
        }
        if (Literal.isEmptySequence(this.getActionExpression())) {
            return this.getActionExpression();
        }
        if (this.getSortKeyDefinitions() != null) {
            boolean allFixed = true;
            for (SortKeyDefinition sk : this.getSortKeyDefinitions()) {
                Expression sortKey = sk.getSortKey();
                sortKey = sortKey.typeCheck(visitor, cit);
                if (sk.isBackwardsCompatible()) {
                    sortKey = FirstItemExpression.makeFirstItemExpression(sortKey);
                } else {
                    Supplier<RoleDiagnostic> role = () -> new RoleDiagnostic(4, "xsl:sort/select", 0, "XTTE1020");
                    sortKey = CardinalityChecker.makeCardinalityChecker(sortKey, 24576, role);
                }
                sk.setSortKey(sortKey, true);
                sk.typeCheck(visitor, contextInfo);
                if (sk.isFixed()) {
                    AtomicComparer comp = sk.makeComparator(visitor.getStaticContext().makeEarlyEvaluationContext());
                    sk.setFinalComparator(comp);
                    continue;
                }
                allFixed = false;
            }
            if (allFixed) {
                this.sortComparators = new AtomicComparer[this.getSortKeyDefinitions().size()];
                for (int i = 0; i < this.getSortKeyDefinitions().size(); ++i) {
                    this.sortComparators[i] = this.getSortKeyDefinitions().getSortKeyDefinition(i).getFinalComparator();
                }
            }
        }
        return this;
    }

    private static void fixupGroupReferences(Expression exp, ForEachGroup feg, ItemType selectedItemType, boolean isInLoop) {
        block2: {
            block4: {
                ForEachGroup feg2;
                block5: {
                    block3: {
                        if (exp == null) break block2;
                        if (!(exp instanceof CurrentGroupCall)) break block3;
                        ((CurrentGroupCall)exp).setControllingInstruction(feg, selectedItemType, isInLoop);
                        break block2;
                    }
                    if (!(exp instanceof ForEachGroup)) break block4;
                    feg2 = (ForEachGroup)exp;
                    if (feg2 != feg) break block5;
                    ForEachGroup.fixupGroupReferences(feg2.getActionExpression(), feg, selectedItemType, false);
                    break block2;
                }
                ForEachGroup.fixupGroupReferences(feg2.getSelectExpression(), feg, selectedItemType, isInLoop);
                ForEachGroup.fixupGroupReferences(feg2.getGroupingKey(), feg, selectedItemType, isInLoop);
                if (feg2.getSortKeyDefinitions() == null) break block2;
                for (SortKeyDefinition skd : feg2.getSortKeyDefinitions()) {
                    ForEachGroup.fixupGroupReferences(skd.getOrder(), feg, selectedItemType, isInLoop);
                    ForEachGroup.fixupGroupReferences(skd.getCaseOrder(), feg, selectedItemType, isInLoop);
                    ForEachGroup.fixupGroupReferences(skd.getDataTypeExpression(), feg, selectedItemType, isInLoop);
                    ForEachGroup.fixupGroupReferences(skd.getLanguage(), feg, selectedItemType, isInLoop);
                    ForEachGroup.fixupGroupReferences(skd.getCollationNameExpression(), feg, selectedItemType, isInLoop);
                    ForEachGroup.fixupGroupReferences(skd.getOrder(), feg, selectedItemType, isInLoop);
                }
                break block2;
            }
            for (Operand o : exp.operands()) {
                ForEachGroup.fixupGroupReferences(o.getChildExpression(), feg, selectedItemType, isInLoop || o.isHigherOrder());
            }
        }
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        this.selectOp.optimize(visitor, contextItemType);
        ItemType selectedItemType = this.getSelectExpression().getItemType();
        ContextItemStaticInfo sit = visitor.getConfiguration().makeContextItemStaticInfo(selectedItemType, false);
        sit.setContextSettingExpression(this.getSelectExpression());
        this.actionOp.optimize(visitor, sit);
        this.keyOp.optimize(visitor, sit);
        if (Literal.isEmptySequence(this.getSelectExpression())) {
            return this.getSelectExpression();
        }
        if (Literal.isEmptySequence(this.getActionExpression())) {
            return this.getActionExpression();
        }
        if (this.getSortKeyDefinitions() != null) {
            for (SortKeyDefinition skd : this.getSortKeyDefinitions()) {
                Expression sortKey = skd.getSortKey();
                sortKey = sortKey.optimize(visitor, sit);
                skd.setSortKey(sortKey, true);
            }
        }
        if (this.collationOp != null) {
            this.collationOp.optimize(visitor, contextItemType);
        }
        if (this.collator == null && this.getCollationNameExpression() instanceof StringLiteral) {
            String collation = ((StringLiteral)this.getCollationNameExpression()).stringify();
            try {
                URI collationURI = new URI(collation);
                if (!collationURI.isAbsolute()) {
                    collationURI = this.getStaticBaseURI().resolve(collationURI);
                    String collationNameString = collationURI.toString();
                    this.setCollationNameExpression(new StringLiteral(collationNameString));
                    this.collator = visitor.getConfiguration().getCollation(collationNameString);
                    if (this.collator == null) {
                        throw new XPathException("Unknown collation " + Err.wrap(collationURI.toString(), 7)).withErrorCode("XTDE1110").withLocation(this.getLocation());
                    }
                }
            }
            catch (URISyntaxException err) {
                throw new XPathException("Collation name '" + this.getCollationNameExpression() + "' is not a valid URI").withErrorCode("XTDE1110").withLocation(this.getLocation());
            }
        }
        return this;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        SortKeyDefinition[] newKeyDef = null;
        if (this.getSortKeyDefinitions() != null) {
            newKeyDef = new SortKeyDefinition[this.getSortKeyDefinitions().size()];
            for (int i = 0; i < this.getSortKeyDefinitions().size(); ++i) {
                newKeyDef[i] = this.getSortKeyDefinitions().getSortKeyDefinition(i).copy(rebindings);
            }
        }
        ForEachGroup feg = new ForEachGroup(this.getSelectExpression().copy(rebindings), this.getActionExpression().copy(rebindings), this.algorithm, this.getGroupingKey().copy(rebindings), this.collator, this.getCollationNameExpression().copy(rebindings), newKeyDef == null ? null : new SortKeyDefinitionList(newKeyDef));
        ExpressionTool.copyLocationInfo(this, feg);
        feg.setComposite(this.isComposite());
        ForEachGroup.fixupGroupReferences(feg, feg, this.getSelectExpression().getItemType(), false);
        return feg;
    }

    @Override
    public ItemType getItemType() {
        return this.getActionExpression().getItemType();
    }

    @Override
    public int computeDependencies() {
        int dependencies = 0;
        dependencies |= this.getSelectExpression().getDependencies();
        dependencies |= this.getGroupingKey().getDependencies() & 0xFFFFFFE1;
        dependencies |= this.getActionExpression().getDependencies() & 0xFFFFFFC1;
        if (this.getSortKeyDefinitions() != null) {
            for (SortKeyDefinition skd : this.getSortKeyDefinitions()) {
                dependencies |= skd.getSortKey().getDependencies() & 0xFFFFFFE1;
                Expression e = skd.getCaseOrder();
                if (e != null && !(e instanceof Literal)) {
                    dependencies |= e.getDependencies();
                }
                if ((e = skd.getDataTypeExpression()) != null && !(e instanceof Literal)) {
                    dependencies |= e.getDependencies();
                }
                if ((e = skd.getOrder()) != null && !(e instanceof Literal)) {
                    dependencies |= e.getDependencies();
                }
                if ((e = skd.getCollationNameExpression()) != null && !(e instanceof Literal)) {
                    dependencies |= e.getDependencies();
                }
                if ((e = skd.getStable()) != null && !(e instanceof Literal)) {
                    dependencies |= e.getDependencies();
                }
                if ((e = skd.getLanguage()) == null || e instanceof Literal) continue;
                dependencies |= e.getDependencies();
            }
        }
        if (this.getCollationNameExpression() != null) {
            dependencies |= this.getCollationNameExpression().getDependencies();
        }
        return dependencies;
    }

    @Override
    protected int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p |= this.getActionExpression().getSpecialProperties() & 0x8000000;
    }

    @Override
    public final boolean mayCreateNewNodes() {
        int props = this.getActionExpression().getSpecialProperties();
        return (props & 0x800000) == 0;
    }

    @Override
    public String getStreamerName() {
        return "ForEachGroup";
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet target = this.getSelectExpression().addToPathMap(pathMap, pathMapNodeSet);
        if (this.getCollationNameExpression() != null) {
            this.getCollationNameExpression().addToPathMap(pathMap, pathMapNodeSet);
        }
        if (this.getSortKeyDefinitions() != null) {
            for (SortKeyDefinition skd : this.getSortKeyDefinitions()) {
                skd.getSortKey().addToPathMap(pathMap, target);
                SortExpression.addSortKeyDetailsToPathMap(pathMap, pathMapNodeSet, skd);
            }
        }
        return this.getActionExpression().addToPathMap(pathMap, target);
    }

    @Override
    public void checkPermittedContents(SchemaType parentType, boolean whole) throws XPathException {
        this.getActionExpression().checkPermittedContents(parentType, false);
    }

    public Expression getCollationNameExpression() {
        return this.collationOp == null ? null : this.collationOp.getChildExpression();
    }

    private StringCollator getCollator(XPathContext context) throws XPathException {
        if (this.getCollationNameExpression() != null) {
            StringValue collationValue = (StringValue)this.getCollationNameExpression().evaluateItem(context);
            assert (collationValue != null);
            String cname = collationValue.getStringValue();
            try {
                return context.getConfiguration().getCollation(cname, this.getStaticBaseURIString(), "FOCH0002");
            }
            catch (XPathException e) {
                throw e.withLocation(this.getLocation());
            }
        }
        return CodepointCollator.getInstance();
    }

    public GroupIterator getGroupIterator(PullEvaluator selectPull, XPathContext context) throws XPathException {
        GroupIterator groupIterator;
        switch (this.algorithm) {
            case 0: {
                StringCollator coll = this.collator;
                if (coll == null) {
                    coll = this.getCollator(context);
                }
                XPathContextMinor c2 = context.newMinorContext();
                FocusIterator population = c2.trackFocus(selectPull.iterate(context));
                groupIterator = new GroupByIterator(population, this.getGroupingKey(), c2, coll, this.composite);
                break;
            }
            case 1: {
                StringCollator coll = this.collator;
                if (coll == null) {
                    coll = this.getCollator(context);
                }
                groupIterator = new GroupAdjacentIterator(selectPull, this.getGroupingKey(), context, coll, this.composite);
                break;
            }
            case 2: {
                groupIterator = new GroupStartingIterator(selectPull, (Pattern)this.getGroupingKey(), context);
                break;
            }
            case 3: {
                groupIterator = new GroupEndingIterator(selectPull, (Pattern)this.getGroupingKey(), context);
                break;
            }
            case 4: {
                FunctionItem breakWhen = (FunctionItem)this.getGroupingKey().evaluateItem(context);
                groupIterator = new GroupBreakingIterator(selectPull, breakWhen, context);
                break;
            }
            default: {
                throw new AssertionError((Object)"Unknown grouping algorithm");
            }
        }
        if (this.getSortKeyDefinitions() != null) {
            AtomicComparer[] comps = this.sortComparators;
            XPathContextMinor xpc = context.newMinorContext();
            if (comps == null) {
                comps = new AtomicComparer[this.getSortKeyDefinitions().size()];
                for (int s = 0; s < this.getSortKeyDefinitions().size(); ++s) {
                    comps[s] = this.getSortKeyDefinitions().getSortKeyDefinition(s).makeComparator(xpc);
                }
            }
            this.makeSortKeyEvaluators();
            groupIterator = new SortedGroupIterator(xpc, groupIterator, this, comps);
        }
        return groupIterator;
    }

    private void makeSortKeyEvaluators() {
        if (this.sortKeyEvaluators == null && this.getSortKeyDefinitions() != null) {
            this.sortKeyEvaluators = new ItemEvaluator[this.getSortKeyDefinitions().size()];
            for (int s = 0; s < this.getSortKeyDefinitions().size(); ++s) {
                this.sortKeyEvaluators[s] = this.getSortKeyDefinitions().getSortKeyDefinition(s).getSortKey().makeElaborator().elaborateForItem();
            }
        }
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return this.makeElaborator().elaborateForPull().iterate(context);
    }

    @Override
    public AtomicValue evaluateSortKey(int n, XPathContext c) throws XPathException {
        return (AtomicValue)this.sortKeyEvaluators[n].eval(c);
    }

    public SortKeyDefinitionList getSortKeyDefinitionList() {
        if (this.sortKeysOp == null) {
            return null;
        }
        return (SortKeyDefinitionList)this.sortKeysOp.getChildExpression();
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("forEachGroup", this);
        out.emitAttribute("algorithm", ForEachGroup.getAlgorithmName(this.algorithm));
        String flags = "";
        if (this.composite) {
            flags = "c";
        }
        if (this.isInFork()) {
            flags = flags + "k";
        }
        if (!flags.isEmpty()) {
            out.emitAttribute("flags", flags);
        }
        out.setChildRole("select");
        this.getSelectExpression().export(out);
        out.setChildRole(this.algorithm == 0 || this.algorithm == 1 || this.algorithm == 4 ? "key" : "match");
        this.getGroupingKey().export(out);
        if (this.getSortKeyDefinitions() != null) {
            out.setChildRole("sort");
            this.getSortKeyDefinitionList().export(out);
        }
        if (this.getCollationNameExpression() != null) {
            out.setChildRole("collation");
            this.getCollationNameExpression().export(out);
        }
        out.setChildRole("content");
        this.getActionExpression().export(out);
        out.endElement();
    }

    private static String getAlgorithmName(byte algorithm) {
        switch (algorithm) {
            case 0: {
                return "by";
            }
            case 1: {
                return "adjacent";
            }
            case 2: {
                return "starting";
            }
            case 3: {
                return "ending";
            }
            case 4: {
                return "split";
            }
        }
        return "** unknown algorithm **";
    }

    public void setSelect(Expression select) {
        this.selectOp.setChildExpression(select);
    }

    public void setAction(Expression action) {
        this.actionOp.setChildExpression(action);
    }

    public void setKey(Expression key) {
        this.keyOp.setChildExpression(key);
    }

    public void setCollationNameExpression(Expression collationNameExpression) {
        if (this.collationOp == null) {
            this.collationOp = new Operand(this, collationNameExpression, OperandRole.SINGLE_ATOMIC);
        } else {
            this.collationOp.setChildExpression(collationNameExpression);
        }
    }

    @Override
    public Elaborator getElaborator() {
        return new ForEachGroupElaborator();
    }

    public static class ForEachGroupElaborator
    extends PushElaborator {
        private PullEvaluator getGroupIteratorProvider() {
            ForEachGroup expr = (ForEachGroup)this.getExpression();
            Expression select = expr.getSelectExpression();
            PullEvaluator selectPull = select.makeElaborator().elaborateForPull();
            byte algorithm = expr.getAlgorithm();
            switch (algorithm) {
                case 0: {
                    return context -> {
                        StringCollator coll = expr.collator;
                        if (coll == null) {
                            coll = expr.getCollator(context);
                        }
                        XPathContextMinor c2 = context.newMinorContext();
                        FocusIterator population = c2.trackFocus(selectPull.iterate(context));
                        return new GroupByIterator(population, expr.getGroupingKey(), c2, coll, expr.composite);
                    };
                }
                case 1: {
                    return context -> {
                        StringCollator coll = expr.collator;
                        if (coll == null) {
                            coll = expr.getCollator(context);
                        }
                        return new GroupAdjacentIterator(selectPull, expr.getGroupingKey(), context, coll, expr.composite);
                    };
                }
                case 2: {
                    return context -> new GroupStartingIterator(selectPull, (Pattern)expr.getGroupingKey(), context);
                }
                case 3: {
                    return context -> new GroupEndingIterator(selectPull, (Pattern)expr.getGroupingKey(), context);
                }
                case 4: {
                    return context -> {
                        FunctionItem breakWhen = (FunctionItem)expr.getGroupingKey().evaluateItem(context);
                        return new GroupBreakingIterator(selectPull, breakWhen, context);
                    };
                }
            }
            throw new AssertionError((Object)"Unknown grouping algorithm");
        }

        private PullEvaluator getSortedGroupIteratorProvider() {
            ForEachGroup expr = (ForEachGroup)this.getExpression();
            if (expr.getSortKeyDefinitions() != null) {
                if (expr.sortComparators == null) {
                    return context -> {
                        XPathContextMinor xpc = context.newMinorContext();
                        AtomicComparer[] comps = new AtomicComparer[expr.getSortKeyDefinitions().size()];
                        for (int s = 0; s < expr.getSortKeyDefinitions().size(); ++s) {
                            comps[s] = expr.getSortKeyDefinitions().getSortKeyDefinition(s).makeComparator(xpc);
                        }
                        PullEvaluator grouper = this.getGroupIteratorProvider();
                        return new SortedGroupIterator(xpc, (GroupIterator)grouper.iterate(xpc), expr, comps);
                    };
                }
                AtomicComparer[] comps = expr.sortComparators;
                PullEvaluator grouper = this.getGroupIteratorProvider();
                return context -> {
                    XPathContextMinor xpc = context.newMinorContext();
                    return new SortedGroupIterator(xpc, (GroupIterator)grouper.iterate(xpc), expr, comps);
                };
            }
            return this.getGroupIteratorProvider();
        }

        @Override
        public PushEvaluator elaborateForPush() {
            ForEachGroup expr = (ForEachGroup)this.getExpression();
            expr.makeSortKeyEvaluators();
            PullEvaluator grouper = this.getSortedGroupIteratorProvider();
            PushEvaluator action = expr.getActionExpression().makeElaborator().elaborateForPush();
            return (output, context) -> {
                Controller controller = context.getController();
                assert (controller != null);
                PipelineConfiguration pipe = output.getPipelineConfiguration();
                GroupIterator groupIterator = (GroupIterator)grouper.iterate(context);
                XPathContextMajor c2 = context.newContext();
                c2.setOrigin(expr);
                FocusIterator focusIterator = c2.trackFocus(groupIterator);
                c2.setCurrentGroupIterator(groupIterator);
                c2.setCurrentTemplateRule(null);
                pipe.setXPathContext(c2);
                if (controller.isTracing()) {
                    Item item;
                    TraceListener listener = controller.getTraceListener();
                    assert (listener != null);
                    while ((item = focusIterator.next()) != null) {
                        listener.startCurrentItem(item);
                        TailCall tc = action.processLeavingTail(output, c2);
                        Expression.dispatchTailCall(tc);
                        listener.endCurrentItem(item);
                    }
                } else {
                    while (focusIterator.next() != null) {
                        TailCall tc = action.processLeavingTail(output, c2);
                        Expression.dispatchTailCall(tc);
                    }
                }
                pipe.setXPathContext(context);
                return null;
            };
        }

        @Override
        public PullEvaluator elaborateForPull() {
            ForEachGroup expr = (ForEachGroup)this.getExpression();
            expr.makeSortKeyEvaluators();
            PullEvaluator grouper = this.getSortedGroupIteratorProvider();
            PullEvaluator action = expr.getActionExpression().makeElaborator().elaborateForPull();
            return context -> {
                GroupIterator master = (GroupIterator)grouper.iterate(context);
                XPathContextMajor c2 = context.newContext();
                c2.setOrigin(expr);
                c2.trackFocus(master);
                c2.setCurrentGroupIterator(master);
                c2.setCurrentTemplateRule(null);
                return new ContextMappingIterator(cxt -> action.iterate(cxt), c2);
            };
        }
    }
}

