/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAMeasureGEO;
import org.verapdf.gf.model.impl.arlington.GFAMeasureRL;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAPointData;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.APointData;
import org.verapdf.model.alayer.AViewport;
import org.verapdf.model.baselayer.Object;

public class GFAViewport
extends GFAObject
implements AViewport {
    public GFAViewport(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AViewport");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Measure": {
                return this.getMeasure();
            }
            case "PtData": {
                return this.getPtData();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<Object> getMeasure() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return this.getMeasure1_6();
            }
            case ARLINGTON2_0: {
                return this.getMeasure2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<Object> getMeasure1_6() {
        COSObject object = this.getMeasureValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAMeasureRL> list = new ArrayList<GFAMeasureRL>(1);
            list.add(new GFAMeasureRL((COSDictionary)object.getDirectBase(), this.baseObject, "Measure"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<Object> getMeasure2_0() {
        COSObject object = this.getMeasureValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            Object result = this.getMeasureDictionary2_0(object.getDirectBase(), "Measure");
            ArrayList<Object> list = new ArrayList<Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private Object getMeasureDictionary2_0(COSBase base, String keyName) {
        String subtypeValue;
        COSObject subtype = base.getKey(ASAtom.getASAtom("Subtype"));
        String string = subtypeValue = subtype != null ? subtype.getString() : null;
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "GEO": {
                return new GFAMeasureGEO(base, this.baseObject, keyName);
            }
            case "RL": {
                return new GFAMeasureRL(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<APointData> getPtData() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getPtData2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<APointData> getPtData2_0() {
        COSObject object = this.getPtDataValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAPointData> list = new ArrayList<GFAPointData>(1);
            list.add(new GFAPointData((COSDictionary)object.getDirectBase(), this.baseObject, "PtData"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsBBox() {
        return this.baseObject.knownKey(ASAtom.getASAtom("BBox"));
    }

    public COSObject getBBoxValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("BBox"));
        return object;
    }

    @Override
    public String getBBoxType() {
        COSObject BBox = this.getBBoxValue();
        return this.getObjectType(BBox);
    }

    @Override
    public Boolean getBBoxHasTypeRectangle() {
        COSObject BBox = this.getBBoxValue();
        return GFAViewport.getHasTypeRectangle(BBox);
    }

    @Override
    public Boolean getcontainsMeasure() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Measure"));
    }

    public COSObject getMeasureValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Measure"));
        return object;
    }

    @Override
    public String getMeasureType() {
        COSObject Measure = this.getMeasureValue();
        return this.getObjectType(Measure);
    }

    @Override
    public Boolean getMeasureHasTypeDictionary() {
        COSObject Measure = this.getMeasureValue();
        return GFAViewport.getHasTypeDictionary(Measure);
    }

    @Override
    public Boolean getcontainsName() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Name"));
    }

    public COSObject getNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Name"));
        return object;
    }

    @Override
    public String getNameType() {
        COSObject Name4 = this.getNameValue();
        return this.getObjectType(Name4);
    }

    @Override
    public Boolean getNameHasTypeStringText() {
        COSObject Name4 = this.getNameValue();
        return GFAViewport.getHasTypeStringText(Name4);
    }

    @Override
    public Boolean getcontainsPtData() {
        return this.baseObject.knownKey(ASAtom.getASAtom("PtData"));
    }

    public COSObject getPtDataValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("PtData"));
        return object;
    }

    @Override
    public String getPtDataType() {
        COSObject PtData = this.getPtDataValue();
        return this.getObjectType(PtData);
    }

    @Override
    public Boolean getPtDataHasTypeDictionary() {
        COSObject PtData = this.getPtDataValue();
        return GFAViewport.getHasTypeDictionary(PtData);
    }

    @Override
    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
        return object;
    }

    @Override
    public String getTypeType() {
        COSObject Type2 = this.getTypeValue();
        return this.getObjectType(Type2);
    }

    @Override
    public Boolean getTypeHasTypeName() {
        COSObject Type2 = this.getTypeValue();
        return GFAViewport.getHasTypeName(Type2);
    }

    @Override
    public String getTypeNameValue() {
        COSObject Type2 = this.getTypeValue();
        return GFAViewport.getNameValue(Type2);
    }
}

