/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.FilterFactory;
import net.sf.saxon.expr.accum.Accumulator;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.lib.ErrorReporter;
import net.sf.saxon.lib.InvalidityHandler;
import net.sf.saxon.lib.StandardErrorReporter;
import net.sf.saxon.lib.ValidationStatisticsRecipient;
import net.sf.saxon.ma.trie.ImmutableHashTrieMap;
import net.sf.saxon.ma.trie.ImmutableMap;
import net.sf.saxon.ma.trie.TrieKVP;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.trans.Maker;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.ValidationParams;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class ParseOptions {
    private final ImmutableMap<Key, Object> properties;
    private List<Key> cacheKeys;
    private List<Object> cacheValues;
    private List<ParseOptions> cacheResults;

    public ParseOptions() {
        this.properties = this.init();
    }

    private ParseOptions(ImmutableMap<Key, Object> properties) {
        this.properties = properties;
    }

    private ImmutableMap<Key, Object> init() {
        return ImmutableHashTrieMap.empty();
    }

    private synchronized ParseOptions searchCache(Key key, Object value) {
        if (this.cacheKeys == null) {
            return null;
        }
        for (int i = 0; i < this.cacheKeys.size(); ++i) {
            if (this.cacheKeys.get(i) != key || this.cacheValues.get(i) != value) continue;
            return this.cacheResults.get(i);
        }
        return null;
    }

    private synchronized void addToCache(Key key, Object value, ParseOptions result) {
        if (this.cacheKeys == null) {
            this.cacheKeys = new ArrayList<Key>(10);
            this.cacheValues = new ArrayList<Object>(10);
            this.cacheResults = new ArrayList<ParseOptions>(10);
        } else if (this.cacheKeys.size() >= 10) {
            this.cacheKeys.clear();
            this.cacheValues.clear();
            this.cacheResults.clear();
        }
        this.cacheKeys.add(key);
        this.cacheValues.add(value);
        this.cacheResults.add(result);
    }

    private ParseOptions withProperty(Key key, Object value) {
        if (value == this.properties.get(key)) {
            return this;
        }
        ParseOptions result = this.searchCache(key, value);
        if (result != null) {
            return result;
        }
        result = value == null ? new ParseOptions(this.properties.remove(key)) : new ParseOptions(this.properties.put(key, value));
        this.addToCache(key, value, result);
        return result;
    }

    private Object getProperty(Key key) {
        return this.properties.get(key);
    }

    private boolean hasProperty(Key key) {
        return this.properties.get(key) != null;
    }

    private int getIntegerProperty(Key key, int defaultValue) {
        Object value = this.properties.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (Integer)value;
    }

    private boolean getBooleanProperty(Key key, boolean defaultValue) {
        Object value = this.properties.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (Boolean)value;
    }

    public ParseOptions merge(ParseOptions other) {
        ParseOptions result = this;
        if (other.getDTDValidationMode() != 0) {
            result = result.withDTDValidationMode(other.getDTDValidationMode());
        }
        if (other.getSchemaValidationMode() != 0) {
            result = result.withSchemaValidationMode(other.getSchemaValidationMode());
        }
        result = result.withPropertyIfNotNull(Key.INVALIDITY_HANDLER, other.getInvalidityHandler());
        result = result.withPropertyIfNotNull(Key.TOP_LEVEL_ELEMENT, other.getTopLevelElement());
        result = result.withPropertyIfNotNull(Key.TOP_LEVEL_TYPE, other.getTopLevelType());
        result = result.withPropertyIfNotNull(Key.SPACE_STRIPPING_RULE, other.getSpaceStrippingRule());
        result = result.withPropertyIfNotNull(Key.TREE_MODEL, other.getTreeModel());
        if (other.hasProperty(Key.LINE_NUMBERING)) {
            result = result.withLineNumbering(other.isLineNumbering());
        }
        if (other.isPleaseCloseAfterUse()) {
            result = result.withPleaseCloseAfterUse(true);
        }
        if (other.getFilters() != null) {
            for (FilterFactory filterFactory : other.getFilters()) {
                result = result.withFilter(filterFactory);
            }
        }
        if (other.getParserFeatures() != null) {
            for (Map.Entry entry : other.getParserFeatures().entrySet()) {
                result = result.withParserFeature((String)entry.getKey(), (Boolean)entry.getValue());
            }
        }
        if (other.getParserProperties() != null) {
            for (Map.Entry entry : other.getParserProperties().entrySet()) {
                result = result.withParserProperty((String)entry.getKey(), entry.getValue());
            }
        }
        if (!other.isExpandAttributeDefaults()) {
            result = result.withExpandAttributeDefaults(false);
        }
        if (!other.isUseXsiSchemaLocation()) {
            result = result.withUseXsiSchemaLocation(false);
        }
        if (other.isAddCommentsAfterValidationErrors()) {
            result = result.withUseXsiSchemaLocation(true);
        }
        result = result.withValidationErrorLimit(Math.min(this.getValidationErrorLimit(), other.getValidationErrorLimit()));
        result = result.withPropertyIfNotNull(Key.XML_READER, other.getXMLReader());
        result = result.withPropertyIfNotNull(Key.ERROR_REPORTER, other.getErrorReporter());
        return result;
    }

    private ParseOptions withPropertyIfNotNull(Key key, Object value) {
        if (value != null) {
            return this.withProperty(key, value);
        }
        return this;
    }

    public ParseOptions applyDefaults(Configuration config) {
        ParseOptions result = this;
        if (this.getDTDValidationMode() == 0) {
            result = result.withDTDValidationMode(config.isValidation() ? 1 : 4);
        }
        if (this.getSchemaValidationMode() == 0) {
            result = result.withSchemaValidationMode(config.getSchemaValidationMode());
        }
        if (this.getModel() == null) {
            result = result.withModel(TreeModel.getTreeModel(config.getTreeModel()));
        }
        if (this.getSpaceStrippingRule() == null) {
            result = result.withSpaceStrippingRule(config.getParseOptions().getSpaceStrippingRule());
        }
        if (this.getProperty(Key.LINE_NUMBERING) == null) {
            result = result.withProperty(Key.LINE_NUMBERING, config.isLineNumbering());
        }
        if (this.getProperty(Key.ERROR_REPORTER) == null) {
            result = result.withErrorReporter(config.makeErrorReporter());
        }
        return result;
    }

    public ParseOptions withFilter(FilterFactory filterFactory) {
        List<FilterFactory> list = this.getFilters();
        list = list == null ? new ArrayList<FilterFactory>(2) : new ArrayList<FilterFactory>(list);
        list.add(filterFactory);
        return this.withProperty(Key.FILTERS, list);
    }

    public List<FilterFactory> getFilters() {
        return (List)this.getProperty(Key.FILTERS);
    }

    public SpaceStrippingRule getSpaceStrippingRule() {
        return (SpaceStrippingRule)this.getProperty(Key.SPACE_STRIPPING_RULE);
    }

    public ParseOptions withSpaceStrippingRule(SpaceStrippingRule rule) {
        return this.withProperty(Key.SPACE_STRIPPING_RULE, rule);
    }

    public ParseOptions withTreeModel(int model) {
        return this.withProperty(Key.TREE_MODEL, model);
    }

    public ParseOptions withParserFeature(String uri, boolean value) {
        Map parserFeatures = (Map)this.getProperty(Key.PARSER_FEATURES);
        HashMap<String, Boolean> parserFeatures2 = parserFeatures == null ? new HashMap<String, Boolean>(4) : new HashMap(parserFeatures);
        Boolean old = parserFeatures2.put(uri, value);
        return old != null && old == value ? this : this.withProperty(Key.PARSER_FEATURES, parserFeatures2);
    }

    public ParseOptions withParserProperty(String uri, Object value) {
        Map parserProperties = (Map)this.getProperty(Key.PARSER_FEATURES);
        HashMap<String, Object> parserProperties2 = parserProperties == null ? new HashMap<String, Object>(4) : new HashMap(parserProperties);
        Object old = value != null ? parserProperties2.put(uri, value) : parserProperties2.remove(uri);
        return old != null && old.equals(value) ? this : this.withProperty(Key.PARSER_PROPERTIES, parserProperties2);
    }

    public boolean hasParserFeature(String uri) {
        Map parserFeatures = (Map)this.getProperty(Key.PARSER_FEATURES);
        if (parserFeatures == null) {
            return false;
        }
        Boolean value = (Boolean)parserFeatures.get(uri);
        return value != null && value != false;
    }

    public boolean isParserFeatureSet(String uri) {
        Map parserFeatures = (Map)this.getProperty(Key.PARSER_FEATURES);
        if (parserFeatures == null) {
            return false;
        }
        Boolean value = (Boolean)parserFeatures.get(uri);
        return value != null;
    }

    public Object getParserProperty(String name) {
        Map parserProperties = (Map)this.getProperty(Key.PARSER_PROPERTIES);
        if (parserProperties == null) {
            return null;
        }
        return parserProperties.get(name);
    }

    public Map<String, Boolean> getParserFeatures() {
        Map parserFeatures = (Map)this.getProperty(Key.PARSER_FEATURES);
        if (parserFeatures == null) {
            return Collections.emptyMap();
        }
        return parserFeatures;
    }

    public Map<String, Object> getParserProperties() {
        Map parserProperties = (Map)this.getProperty(Key.PARSER_PROPERTIES);
        if (parserProperties == null) {
            return Collections.emptyMap();
        }
        return parserProperties;
    }

    public int getTreeModel() {
        TreeModel model = this.getModel();
        if (model == null) {
            return -1;
        }
        return model.getSymbolicValue();
    }

    public ParseOptions withModel(TreeModel model) {
        return this.withProperty(Key.MODEL, model);
    }

    public TreeModel getModel() {
        TreeModel treeModel = (TreeModel)this.getProperty(Key.MODEL);
        return treeModel == null ? TreeModel.TINY_TREE : treeModel;
    }

    public ParseOptions withSchemaValidationMode(int option) {
        return this.withProperty(Key.SCHEMA_VALIDATION, option);
    }

    public int getSchemaValidationMode() {
        return this.getIntegerProperty(Key.SCHEMA_VALIDATION, 0);
    }

    public ParseOptions withExpandAttributeDefaults(boolean expand) {
        return this.withProperty(Key.EXPAND_ATTRIBUTE_DEFAULTS, expand);
    }

    public boolean isExpandAttributeDefaults() {
        return this.getBooleanProperty(Key.EXPAND_ATTRIBUTE_DEFAULTS, true);
    }

    public ParseOptions withTopLevelElement(StructuredQName elementName) {
        return this.withProperty(Key.TOP_LEVEL_ELEMENT, elementName);
    }

    public StructuredQName getTopLevelElement() {
        return (StructuredQName)this.getProperty(Key.TOP_LEVEL_ELEMENT);
    }

    public ParseOptions withTopLevelType(SchemaType type) {
        return this.withProperty(Key.TOP_LEVEL_TYPE, type);
    }

    public SchemaType getTopLevelType() {
        return (SchemaType)this.getProperty(Key.TOP_LEVEL_TYPE);
    }

    public ParseOptions withUseXsiSchemaLocation(boolean use) {
        return this.withProperty(Key.USE_XSI_SCHEMA_LOCATION, use);
    }

    public boolean isUseXsiSchemaLocation() {
        return this.getBooleanProperty(Key.USE_XSI_SCHEMA_LOCATION, true);
    }

    public int getValidationErrorLimit() {
        return this.getIntegerProperty(Key.VALIDATION_ERROR_LIMIT, Integer.MAX_VALUE);
    }

    public ParseOptions withValidationErrorLimit(int validationErrorLimit) {
        return this.withProperty(Key.VALIDATION_ERROR_LIMIT, validationErrorLimit);
    }

    public ParseOptions withDTDValidationMode(int option) {
        return this.withParserFeature("http://xml.org/sax/features/validation", option == 1 || option == 2).withProperty(Key.DTD_VALIDATION, option);
    }

    public int getDTDValidationMode() {
        return this.getIntegerProperty(Key.DTD_VALIDATION, 4);
    }

    public ParseOptions withValidationStatisticsRecipient(ValidationStatisticsRecipient recipient) {
        return this.withProperty(Key.VALIDATION_STATISTICS_RECIPIENT, recipient);
    }

    public ValidationStatisticsRecipient getValidationStatisticsRecipient() {
        return (ValidationStatisticsRecipient)this.getProperty(Key.VALIDATION_STATISTICS_RECIPIENT);
    }

    public ParseOptions withLineNumbering(boolean lineNumbering) {
        return this.withProperty(Key.LINE_NUMBERING, lineNumbering);
    }

    public boolean isLineNumbering() {
        return this.getBooleanProperty(Key.LINE_NUMBERING, false);
    }

    public boolean isLineNumberingSet() {
        return this.hasProperty(Key.LINE_NUMBERING);
    }

    public ParseOptions withXMLReader(XMLReader parser) {
        return this.withProperty(Key.XML_READER, parser);
    }

    public XMLReader getXMLReader() {
        return (XMLReader)this.getProperty(Key.XML_READER);
    }

    public ParseOptions withXMLReaderMaker(Maker<XMLReader> parserMaker) {
        return this.withProperty(Key.XML_READER_MAKER, parserMaker);
    }

    public Maker<XMLReader> getXMLReaderMaker() {
        return (Maker)this.getProperty(Key.XML_READER_MAKER);
    }

    public XMLReader obtainXMLReader() throws XPathException {
        Maker<XMLReader> factory = this.getXMLReaderMaker();
        if (factory != null) {
            return factory.make();
        }
        return this.getXMLReader();
    }

    public ParseOptions withEntityResolver(EntityResolver resolver) {
        return this.withProperty(Key.ENTITY_RESOLVER, resolver);
    }

    public EntityResolver getEntityResolver() {
        return (EntityResolver)this.getProperty(Key.ENTITY_RESOLVER);
    }

    public ParseOptions withErrorHandler(ErrorHandler handler) {
        return this.withProperty(Key.ERROR_HANDLER, handler);
    }

    public ErrorHandler getErrorHandler() {
        return (ErrorHandler)this.getProperty(Key.ERROR_HANDLER);
    }

    public ParseOptions withXIncludeAware(boolean state) {
        return this.withParserFeature("http://apache.org/xml/features/xinclude", state);
    }

    public boolean isXIncludeAwareSet() {
        return this.isParserFeatureSet("http://apache.org/xml/features/xinclude");
    }

    public boolean isXIncludeAware() {
        return this.hasParserFeature("http://apache.org/xml/features/xinclude");
    }

    public ParseOptions withErrorReporter(ErrorReporter reporter) {
        if (reporter == null) {
            reporter = new StandardErrorReporter();
        }
        return this.withProperty(Key.ERROR_REPORTER, reporter);
    }

    public ErrorReporter getErrorReporter() {
        return (ErrorReporter)this.getProperty(Key.ERROR_REPORTER);
    }

    public ParseOptions withContinueAfterValidationErrors(boolean keepGoing) {
        return this.withProperty(Key.CONTINUE_AFTER_VALIDATION_ERRORS, keepGoing);
    }

    public boolean isContinueAfterValidationErrors() {
        return this.getBooleanProperty(Key.CONTINUE_AFTER_VALIDATION_ERRORS, false);
    }

    public ParseOptions withAddCommentsAfterValidationErrors(boolean addComments) {
        return this.withProperty(Key.ADD_COMMENTS_AFTER_VALIDATION_ERRORS, addComments);
    }

    public boolean isAddCommentsAfterValidationErrors() {
        return this.getBooleanProperty(Key.ADD_COMMENTS_AFTER_VALIDATION_ERRORS, false);
    }

    public ParseOptions withValidationParams(ValidationParams params) {
        return this.withProperty(Key.VALIDATION_PARAMS, params);
    }

    public ValidationParams getValidationParams() {
        return (ValidationParams)this.getProperty(Key.VALIDATION_PARAMS);
    }

    public ParseOptions withCheckEntityReferences(boolean check) {
        return this.withProperty(Key.CHECK_ENTITY_REFERENCES, check);
    }

    public boolean isCheckEntityReferences() {
        return this.getBooleanProperty(Key.CHECK_ENTITY_REFERENCES, false);
    }

    public boolean isStable() {
        return this.getBooleanProperty(Key.STABLE, true);
    }

    public ParseOptions withStable(boolean stable) {
        return this.withProperty(Key.STABLE, stable);
    }

    public InvalidityHandler getInvalidityHandler() {
        return (InvalidityHandler)this.getProperty(Key.INVALIDITY_HANDLER);
    }

    public ParseOptions withInvalidityHandler(InvalidityHandler invalidityHandler) {
        return this.withProperty(Key.INVALIDITY_HANDLER, invalidityHandler);
    }

    public ParseOptions withApplicableAccumulators(Set<? extends Accumulator> accumulators) {
        return this.withProperty(Key.APPLICABLE_ACCUMULATORS, accumulators);
    }

    public Set<? extends Accumulator> getApplicableAccumulators() {
        return (Set)this.getProperty(Key.APPLICABLE_ACCUMULATORS);
    }

    public ParseOptions withPleaseCloseAfterUse(boolean close) {
        return this.withProperty(Key.PLEASE_CLOSE, close);
    }

    public boolean isPleaseCloseAfterUse() {
        return this.getBooleanProperty(Key.PLEASE_CLOSE, false);
    }

    public static void close(Source source) {
        try {
            if (source instanceof StreamSource) {
                StreamSource ss = (StreamSource)source;
                if (ss.getInputStream() != null) {
                    ss.getInputStream().close();
                }
                if (ss.getReader() != null) {
                    ss.getReader().close();
                }
            } else if (source instanceof SAXSource) {
                InputSource is = ((SAXSource)source).getInputSource();
                if (is != null) {
                    if (is.getByteStream() != null) {
                        is.getByteStream().close();
                    }
                    if (is.getCharacterStream() != null) {
                        is.getCharacterStream().close();
                    }
                }
            } else if (source instanceof AugmentedSource) {
                ((AugmentedSource)source).close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (TrieKVP<Key, Object> trieKVP : this.properties) {
            sb.append((Object)trieKVP.getKey());
            sb.append('=');
            sb.append(trieKVP.getValue());
            sb.append(' ');
        }
        return sb.toString();
    }

    private static enum Key {
        PARSER_FEATURES,
        PARSER_PROPERTIES,
        ENTITY_RESOLVER,
        XINCLUDE_AWARE,
        XML_READER,
        XML_READER_MAKER,
        ADD_COMMENTS_AFTER_VALIDATION_ERRORS,
        APPLICABLE_ACCUMULATORS,
        CHECK_ENTITY_REFERENCES,
        CONTINUE_AFTER_VALIDATION_ERRORS,
        DTD_VALIDATION,
        ERROR_HANDLER,
        ERROR_REPORTER,
        EXPAND_ATTRIBUTE_DEFAULTS,
        FILTERS,
        INVALIDITY_HANDLER,
        LINE_NUMBERING,
        MODEL,
        PLEASE_CLOSE,
        SCHEMA_VALIDATION,
        SPACE_STRIPPING_RULE,
        STABLE,
        TOP_LEVEL_ELEMENT,
        TOP_LEVEL_TYPE,
        TREE_MODEL,
        USE_XSI_SCHEMA_LOCATION,
        VALIDATION_ERROR_LIMIT,
        VALIDATION_PARAMS,
        VALIDATION_STATISTICS_RECIPIENT,
        WRAP_DOCUMENT;

    }
}

