/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans.rules;

import java.util.Collection;
import java.util.HashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.instruct.TemplateRule;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.style.StylesheetModule;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.SimpleMode;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.VisibilityProvenance;
import net.sf.saxon.trans.XPathException;

public final class RuleManager {
    private final StylesheetPackage stylesheetPackage;
    private final Configuration config;
    private final SimpleMode unnamedMode;
    private final HashMap<StructuredQName, Mode> modes;
    private boolean unnamedModeExplicit;
    private CompilerInfo compilerInfo;
    private int nextSequenceNumber = 0;

    public RuleManager(StylesheetPackage pack) {
        this(pack, pack.getConfiguration().getDefaultXsltCompilerInfo());
    }

    public RuleManager(StylesheetPackage pack, CompilerInfo compilerInfo) {
        this.stylesheetPackage = pack;
        this.config = pack.getConfiguration();
        this.compilerInfo = compilerInfo;
        this.unnamedMode = this.config.makeMode(Mode.UNNAMED_MODE_NAME, this.compilerInfo);
        Component c = this.unnamedMode.makeDeclaringComponent(Visibility.PRIVATE, this.stylesheetPackage);
        c.setVisibility(Visibility.PRIVATE, VisibilityProvenance.DEFAULTED);
        this.stylesheetPackage.addComponent(c);
        this.modes = new HashMap(5);
    }

    public void setUnnamedModeExplicit(boolean declared) {
        this.unnamedModeExplicit = declared;
    }

    public boolean isUnnamedModeExplicit() {
        return this.unnamedModeExplicit;
    }

    public void setCompilerInfo(CompilerInfo compilerInfo) {
        this.compilerInfo = compilerInfo;
    }

    public StylesheetPackage getStylesheetPackage() {
        return this.stylesheetPackage;
    }

    public Collection<Mode> getAllNamedModes() {
        return this.modes.values();
    }

    public SimpleMode getUnnamedMode() {
        return this.unnamedMode;
    }

    public Mode obtainMode(StructuredQName modeName, boolean createIfAbsent) {
        if (modeName == null || modeName.equals(Mode.UNNAMED_MODE_NAME)) {
            return this.unnamedMode;
        }
        if (modeName.equals(Mode.OMNI_MODE_NAME)) {
            throw new IllegalArgumentException("#all is not a real mode");
        }
        Mode m = this.modes.get(modeName);
        if (m == null && createIfAbsent) {
            m = this.config.makeMode(modeName, this.compilerInfo);
            this.modes.put(modeName, m);
            Component c = m.makeDeclaringComponent(Visibility.PRIVATE, this.stylesheetPackage);
            c.setVisibility(Visibility.PRIVATE, VisibilityProvenance.DEFAULTED);
            this.stylesheetPackage.addComponent(c);
        }
        return m;
    }

    public void registerMode(Mode mode) {
        this.modes.put(mode.getModeName(), mode);
    }

    public int allocateSequenceNumber() {
        return this.nextSequenceNumber++;
    }

    public int registerRule(Pattern pattern, TemplateRule eh, Mode mode, StylesheetModule module, double priority, int position, int part) {
        if (Double.isNaN(priority)) {
            priority = pattern.getDefaultPriority();
        }
        if (mode instanceof SimpleMode) {
            ((SimpleMode)mode).addRule(pattern, eh, module, module.getPrecedence(), priority, position, part);
        } else {
            mode.getActivePart().addRule(pattern, eh, module, mode.getMaxPrecedence(), priority, position, part);
        }
        return 1;
    }

    public void computeRankings() throws XPathException {
        this.unnamedMode.computeRankings(0);
        for (Mode mode : this.modes.values()) {
            mode.computeRankings(0);
        }
    }

    public void invertStreamableTemplates() throws XPathException {
        this.unnamedMode.invertStreamableTemplates();
        for (Mode mode : this.modes.values()) {
            mode.getActivePart().invertStreamableTemplates();
        }
    }

    public void checkConsistency() throws XPathException {
        this.unnamedMode.resolveProperties(this);
        for (Mode mode : this.modes.values()) {
            mode.getActivePart().resolveProperties(this);
        }
    }

    public void explainTemplateRules(ExpressionPresenter presenter) throws XPathException {
        this.unnamedMode.explain(presenter);
        for (Mode mode : this.modes.values()) {
            mode.explain(presenter);
        }
    }

    public void optimizeRules() {
        this.unnamedMode.optimizeRules();
        for (Mode mode : this.modes.values()) {
            mode.getActivePart().optimizeRules();
        }
    }
}

