/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.report;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.xml.transform.TransformerException;
import org.verapdf.ReleaseDetails;
import org.verapdf.pdfa.Foundries;
import org.verapdf.report.XsltTransformer;

public final class HTMLReport {
    private static final String resourceRoot = "org/verapdf/report/";
    private static final String xslExt = ".xsl";
    private static final String detailedReport = "org/verapdf/report/DetailedHtmlReport.xsl";
    private static final String summaryReport = "org/verapdf/report/SummaryHtmlReport.xsl";
    private static final String GUI = "gui-arlington";
    private static final String VERAPDF_REST = "verapdf-rest-arlington";

    private HTMLReport() {
    }

    public static void writeHTMLReport(InputStream source, OutputStream destination, boolean isMultiJob, String wikiPath, boolean isFullHTML) throws TransformerException {
        String parserId = Foundries.defaultInstance().getParserId();
        HTMLReport.writeHTMLReport(source, new PrintWriter(new OutputStreamWriter(destination, StandardCharsets.UTF_8)), isMultiJob, wikiPath, parserId, isFullHTML);
    }

    public static void writeHTMLReport(InputStream source, PrintWriter destination, boolean isMultiJob, String wikiPath, boolean isFullHTML) throws TransformerException {
        String parserId = Foundries.defaultInstance().getParserId();
        HTMLReport.writeHTMLReport(source, destination, isMultiJob, wikiPath, parserId, isFullHTML);
    }

    public static void writeHTMLReport(InputStream source, PrintWriter destination, boolean isMultiJob, String wikiPath, String parserType, boolean isFullHTML) throws TransformerException {
        String reportPath = isMultiJob ? summaryReport : detailedReport;
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("wikiPath", wikiPath);
        arguments.put("isFullHTML", Boolean.toString(isFullHTML));
        arguments.put("parserType", parserType);
        arguments.put("appName", HTMLReport.getAppName());
        XsltTransformer.transform(source, HTMLReport.class.getClassLoader().getResourceAsStream(reportPath), destination, arguments);
    }

    private static String getAppName() {
        for (ReleaseDetails details : ReleaseDetails.getDetails()) {
            if (!VERAPDF_REST.equals(details.getId())) continue;
            return VERAPDF_REST;
        }
        return GUI;
    }
}

