/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAStream;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.A3DReference;
import org.verapdf.model.alayer.AStream;
import org.verapdf.model.baselayer.Object;

public class GFA3DReference
extends GFAObject
implements A3DReference {
    public GFA3DReference(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "A3DReference");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "entry3DD": {
                return this.getentry3DD();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AStream> getentry3DD() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getentry3DD1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<AStream> getentry3DD1_6() {
        COSObject object = this.getentry3DDValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAStream> list = new ArrayList<GFAStream>(1);
            list.add(new GFAStream((COSStream)object.getDirectBase(), this.baseObject, "3DD"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontains3DD() {
        return this.baseObject.knownKey(ASAtom.getASAtom("3DD"));
    }

    public COSObject getentry3DDValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("3DD"));
        return object;
    }

    @Override
    public Boolean getisentry3DDIndirect() {
        COSObject entry3DD = this.getentry3DDValue();
        return GFA3DReference.getisIndirect(entry3DD);
    }

    @Override
    public String getentry3DDType() {
        COSObject entry3DD = this.getentry3DDValue();
        return this.getObjectType(entry3DD);
    }

    @Override
    public Boolean getentry3DDHasTypeStream() {
        COSObject entry3DD = this.getentry3DDValue();
        return GFA3DReference.getHasTypeStream(entry3DD);
    }

    @Override
    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
        return object;
    }

    @Override
    public String getTypeType() {
        COSObject Type2 = this.getTypeValue();
        return this.getObjectType(Type2);
    }

    @Override
    public Boolean getTypeHasTypeName() {
        COSObject Type2 = this.getTypeValue();
        return GFA3DReference.getHasTypeName(Type2);
    }

    @Override
    public String getTypeNameValue() {
        COSObject Type2 = this.getTypeValue();
        return GFA3DReference.getNameValue(Type2);
    }
}

