/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.gfse;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.pd.GFPDStructElem;
import org.verapdf.gf.model.impl.pd.gfse.GFSETD;
import org.verapdf.gf.model.impl.pd.gfse.GFSETH;
import org.verapdf.gf.model.impl.pd.gfse.GFSETableCell;
import org.verapdf.model.selayer.SETable;
import org.verapdf.pd.structure.PDStructElem;
import org.verapdf.pdfa.flavours.PDFFlavours;

public class GFSETable
extends GFPDStructElem
implements SETable {
    public static final String TABLE_STRUCTURE_ELEMENT_TYPE = "SETable";
    private Boolean useHeadersAndIdOrScope;
    private Long columnSpan;
    private Long rowSpan;
    private Long numberOfRowWithWrongColumnSpan = null;
    private Long numberOfColumnWithWrongRowSpan = null;
    private Long wrongColumnSpan;

    public GFSETable(PDStructElem structElemDictionary) {
        super(structElemDictionary, "Table", TABLE_STRUCTURE_ELEMENT_TYPE);
    }

    @Override
    public Boolean getuseHeadersAndIdOrScope() {
        if (this.useHeadersAndIdOrScope == null) {
            this.checkTable();
        }
        return this.useHeadersAndIdOrScope;
    }

    private void checkTable() {
        LinkedList<Integer> rowGroupingsIndexes = new LinkedList<Integer>();
        List<GFPDStructElem> listTR = this.getTR(rowGroupingsIndexes);
        int numberOfRows = this.getNumberOfRows(listTR);
        this.rowSpan = numberOfRows;
        if (numberOfRows == 0) {
            this.useHeadersAndIdOrScope = true;
            return;
        }
        int numberOfColumns = this.getNumberOfColumns(listTR.get(0));
        this.columnSpan = numberOfColumns;
        GFSETableCell[][] cells = new GFSETableCell[numberOfRows][numberOfColumns];
        if (!this.checkRegular(listTR, cells, numberOfRows, numberOfColumns, rowGroupingsIndexes)) {
            this.useHeadersAndIdOrScope = true;
            return;
        }
        HashSet<String> idSet = new HashSet<String>();
        if (this.hasScope(cells, numberOfRows, numberOfColumns, idSet)) {
            this.useHeadersAndIdOrScope = true;
            return;
        }
        this.useHeadersAndIdOrScope = this.hasHeaders(cells, idSet, numberOfRows, numberOfColumns);
    }

    private boolean hasScope(GFSETableCell[][] cells, int numberOfRows, int numberOfColumns, Set<String> idSet) {
        boolean hasScope = true;
        for (int rowNumber = 0; rowNumber < numberOfRows; ++rowNumber) {
            for (int columnNumber = 0; columnNumber < numberOfColumns; ++columnNumber) {
                GFSETableCell cell = cells[rowNumber][columnNumber];
                if (!"TH".equals(cell.getstandardType())) continue;
                GFSETH tableHeader = (GFSETH)cell;
                String id = tableHeader.getTHID();
                if (id != null && !id.isEmpty()) {
                    idSet.add(id);
                }
                if (tableHeader.getScope() != null) continue;
                hasScope = false;
            }
        }
        return hasScope;
    }

    private boolean checkRegular(List<GFPDStructElem> listTR, GFSETableCell[][] cells, int numberOfRows, int numberOfColumns, List<Integer> rowGroupingsIndexes) {
        int rowNumber;
        for (rowNumber = 0; rowNumber < listTR.size(); ++rowNumber) {
            int columnNumber = 0;
            for (org.verapdf.model.pdlayer.PDStructElem pDStructElem : listTR.get(rowNumber).getStructuralSignificanceChildren()) {
                String type = pDStructElem.getstandardType();
                if (!"TD".equals(type) && !"TH".equals(type)) continue;
                GFSETableCell cell = (GFSETableCell)pDStructElem;
                long colSpan = cell.getColSpan();
                long rowSpan = cell.getRowSpan();
                while (columnNumber < numberOfColumns && cells[rowNumber][columnNumber] != null) {
                    ++columnNumber;
                }
                if ((long)columnNumber + colSpan > (long)numberOfColumns) {
                    this.numberOfRowWithWrongColumnSpan = rowNumber;
                    return false;
                }
                if ((long)rowNumber + rowSpan > (long)numberOfRows) {
                    this.numberOfColumnWithWrongRowSpan = columnNumber;
                    return false;
                }
                if (PDFFlavours.isPDFUA2RelatedFlavour(StaticContainers.getFlavour())) {
                    for (Integer rowGroupsIndex : rowGroupingsIndexes) {
                        if ((long)rowNumber + rowSpan <= (long)rowGroupsIndex.intValue() || rowNumber >= rowGroupsIndex) continue;
                        this.numberOfColumnWithWrongRowSpan = columnNumber;
                        return false;
                    }
                }
                if (!this.checkRegular(cells, cell, rowSpan, colSpan, rowNumber, columnNumber).booleanValue()) {
                    return false;
                }
                columnNumber = (int)((long)columnNumber + colSpan);
            }
        }
        for (rowNumber = 0; rowNumber < numberOfRows; ++rowNumber) {
            int numberOfEmptyCells = 0;
            for (int columnNumber = 0; columnNumber < numberOfColumns; ++columnNumber) {
                if (cells[rowNumber][columnNumber] != null) continue;
                ++numberOfEmptyCells;
            }
            if (numberOfEmptyCells == 0) continue;
            this.numberOfRowWithWrongColumnSpan = rowNumber;
            this.wrongColumnSpan = numberOfColumns - numberOfEmptyCells;
            return false;
        }
        return true;
    }

    private boolean hasHeaders(GFSETableCell[][] cells, Set<String> idSet, int numberOfRows, int numberOfColumns) {
        for (int rowNumber = 0; rowNumber < numberOfRows; ++rowNumber) {
            for (int columnNumber = 0; columnNumber < numberOfColumns; ++columnNumber) {
                GFSETableCell cell = cells[rowNumber][columnNumber];
                String type = cell.getstandardType();
                if (!"TD".equals(type) || rowNumber != cell.getRowNumber() || columnNumber != cell.getColumnNumber()) continue;
                GFSETD tableCell = (GFSETD)cell;
                boolean hasHeaders = false;
                List<String> list = tableCell.getHeaders();
                if (list != null && !list.isEmpty()) {
                    hasHeaders = true;
                    for (String header : list) {
                        if (idSet.contains(header)) continue;
                        hasHeaders = false;
                        break;
                    }
                }
                if (hasHeaders || this.hasHeaders(cells, rowNumber, columnNumber, rowNumber + tableCell.getRowSpan().intValue(), columnNumber + tableCell.getColSpan().intValue())) {
                    tableCell.setHasConnectedHeader(true);
                    continue;
                }
                tableCell.setHasConnectedHeader(false);
                if (list != null) {
                    for (String header : list) {
                        if (idSet.contains(header)) continue;
                        tableCell.addUnknownHeader(header);
                    }
                }
                return false;
            }
        }
        return true;
    }

    private boolean hasHeaders(GFSETableCell[][] cells, int cellRowNumber, int cellColumnNumber, int cellEndRowNumber, int cellEndColumnNumber) {
        boolean headerFound;
        if (cellRowNumber > 0) {
            block0: for (int columnNumber = cellColumnNumber; columnNumber < cellEndColumnNumber; ++columnNumber) {
                headerFound = false;
                for (int rowNumber = cellRowNumber - 1; rowNumber >= 0; --rowNumber) {
                    if (this.hasScope(cells[rowNumber][columnNumber], rowNumber, columnNumber, "Column")) {
                        return true;
                    }
                    if ("TH".equals(cells[rowNumber][columnNumber].getstandardType())) {
                        headerFound = true;
                        continue;
                    }
                    if (headerFound) continue block0;
                }
            }
        }
        if (cellColumnNumber > 0) {
            block2: for (int rowNumber = cellRowNumber; rowNumber < cellEndRowNumber; ++rowNumber) {
                headerFound = false;
                for (int columnNumber = cellColumnNumber - 1; columnNumber >= 0; --columnNumber) {
                    if (this.hasScope(cells[rowNumber][columnNumber], rowNumber, columnNumber, "Row")) {
                        return true;
                    }
                    if ("TH".equals(cells[rowNumber][columnNumber].getstandardType())) {
                        headerFound = true;
                        continue;
                    }
                    if (headerFound) continue block2;
                }
            }
        }
        return false;
    }

    private boolean hasScope(GFSETableCell cell, int rowNumber, int columnNumber, String value) {
        if ("TH".equals(cell.getstandardType())) {
            String scope = ((GFSETH)cell).getScope();
            if (scope == null) {
                scope = GFSETH.getDefaultScope(rowNumber, columnNumber);
            }
            if ("Both".equals(scope) || value.equals(scope)) {
                return true;
            }
        }
        return false;
    }

    private List<GFPDStructElem> getTR(List<Integer> rowGroupingsIndexes) {
        LinkedList<GFPDStructElem> listTR = new LinkedList<GFPDStructElem>();
        for (GFPDStructElem elem : this.getStructuralSignificanceChildren()) {
            String type = elem.getstandardType();
            if ("TR".equals(type)) {
                listTR.add(elem);
                continue;
            }
            if (!"THead".equals(type) && !"TBody".equals(type) && !"TFoot".equals(type)) continue;
            rowGroupingsIndexes.add(listTR.size());
            for (GFPDStructElem child : elem.getStructuralSignificanceChildren()) {
                if (!"TR".equals(child.getstandardType())) continue;
                listTR.add(child);
            }
            rowGroupingsIndexes.add(listTR.size());
        }
        return listTR;
    }

    private Integer getNumberOfColumns(GFPDStructElem firstTR) {
        int numberOfColumns = 0;
        for (org.verapdf.model.pdlayer.PDStructElem pDStructElem : firstTR.getStructuralSignificanceChildren()) {
            String type = pDStructElem.getstandardType();
            if (!"TH".equals(type) && !"TD".equals(type)) continue;
            numberOfColumns = (int)((long)numberOfColumns + ((GFSETableCell)pDStructElem).getColSpan());
        }
        return numberOfColumns;
    }

    private Integer getNumberOfRows(List<GFPDStructElem> listTR) {
        int numberOfRows = 0;
        for (int rowNumber = 0; rowNumber < listTR.size(); ++rowNumber) {
            org.verapdf.model.pdlayer.PDStructElem elem;
            String type;
            List<GFPDStructElem> children = listTR.get(rowNumber).getStructuralSignificanceChildren();
            if (children.isEmpty() || !"TH".equals(type = (elem = (org.verapdf.model.pdlayer.PDStructElem)children.get(0)).getstandardType()) && !"TD".equals(type)) continue;
            Long rowSpan = ((GFSETableCell)elem).getRowSpan();
            numberOfRows = (int)((long)numberOfRows + rowSpan);
            if (rowSpan <= 1L) continue;
            rowNumber = (int)((long)rowNumber + (rowSpan - 1L));
        }
        return numberOfRows;
    }

    private Boolean checkRegular(GFSETableCell[][] cells, GFSETableCell cell, long rowSpan, long colSpan, int rowNumber, int columnNumber) {
        cell.setRowNumber(rowNumber);
        cell.setColumnNumber(columnNumber);
        int i = 0;
        while ((long)i < rowSpan) {
            int j = 0;
            while ((long)j < colSpan) {
                if (cells[rowNumber + i][columnNumber + j] != null) {
                    cell.setHasIntersection(true);
                    cells[rowNumber + i][columnNumber + j].setHasIntersection(true);
                    return false;
                }
                cells[rowNumber + i][columnNumber + j] = cell;
                ++j;
            }
            ++i;
        }
        return true;
    }

    @Override
    public Long getcolumnSpan() {
        if (this.rowSpan == null) {
            this.checkTable();
        }
        return this.columnSpan;
    }

    @Override
    public Long getrowSpan() {
        if (this.rowSpan == null) {
            this.checkTable();
        }
        return this.rowSpan;
    }

    @Override
    public Long getnumberOfRowWithWrongColumnSpan() {
        if (this.rowSpan == null) {
            this.checkTable();
        }
        return this.numberOfRowWithWrongColumnSpan;
    }

    @Override
    public Long getnumberOfColumnWithWrongRowSpan() {
        if (this.rowSpan == null) {
            this.checkTable();
        }
        return this.numberOfColumnWithWrongRowSpan;
    }

    @Override
    public Long getwrongColumnSpan() {
        if (this.rowSpan == null) {
            this.checkTable();
        }
        return this.wrongColumnSpan;
    }
}

