/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.factory.colors;

import org.verapdf.gf.model.factory.operators.GraphicState;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.pd.colors.GFPDCalGray;
import org.verapdf.gf.model.impl.pd.colors.GFPDCalRGB;
import org.verapdf.gf.model.impl.pd.colors.GFPDColorSpace;
import org.verapdf.gf.model.impl.pd.colors.GFPDDeviceCMYK;
import org.verapdf.gf.model.impl.pd.colors.GFPDDeviceGray;
import org.verapdf.gf.model.impl.pd.colors.GFPDDeviceN;
import org.verapdf.gf.model.impl.pd.colors.GFPDDeviceRGB;
import org.verapdf.gf.model.impl.pd.colors.GFPDEmptyColorSpace;
import org.verapdf.gf.model.impl.pd.colors.GFPDICCBased;
import org.verapdf.gf.model.impl.pd.colors.GFPDICCBasedCMYK;
import org.verapdf.gf.model.impl.pd.colors.GFPDIndexed;
import org.verapdf.gf.model.impl.pd.colors.GFPDLab;
import org.verapdf.gf.model.impl.pd.colors.GFPDSeparation;
import org.verapdf.gf.model.impl.pd.patterns.GFPDShadingPattern;
import org.verapdf.gf.model.impl.pd.patterns.GFPDTilingPattern;
import org.verapdf.gf.model.impl.pd.util.PDResourcesHandler;
import org.verapdf.model.pdlayer.PDPattern;
import org.verapdf.pd.colors.PDCalGray;
import org.verapdf.pd.colors.PDCalRGB;
import org.verapdf.pd.colors.PDColorSpace;
import org.verapdf.pd.colors.PDDeviceN;
import org.verapdf.pd.colors.PDICCBased;
import org.verapdf.pd.colors.PDIndexed;
import org.verapdf.pd.colors.PDLab;
import org.verapdf.pd.colors.PDSeparation;
import org.verapdf.pd.patterns.PDShadingPattern;
import org.verapdf.pd.patterns.PDTilingPattern;

public class ColorSpaceFactory {
    public static final String CAL_GRAY = "/CalGray";
    public static final String CAL_RGB = "/CalRGB";
    public static final String DEVICE_CMYK = "/DeviceCMYK";
    public static final String DEVICE_RGB = "/DeviceRGB";
    public static final String DEVICE_GRAY = "/DeviceGray";
    public static final String ICC_BASED = "/ICCBased";
    public static final String LAB = "/Lab";
    public static final String DEVICE_N = "/DeviceN";
    public static final String SEPARATION = "/Separation";
    public static final String INDEXED = "/Indexed";
    public static final String PATTERN = "/Pattern";

    private ColorSpaceFactory() {
    }

    public static org.verapdf.model.pdlayer.PDColorSpace getColorSpace(PDColorSpace colorSpace) {
        return ColorSpaceFactory.getColorSpace(colorSpace, PDResourcesHandler.EMPTY, 0, false, null);
    }

    public static org.verapdf.model.pdlayer.PDColorSpace getColorSpace(PDColorSpace colorSpace, PDResourcesHandler resourcesHandler, GraphicState inheritedGraphicSpace) {
        return ColorSpaceFactory.getColorSpace(colorSpace, resourcesHandler, 0, false, inheritedGraphicSpace);
    }

    public static org.verapdf.model.pdlayer.PDColorSpace getColorSpace(PDColorSpace colorSpace, PDResourcesHandler resourcesHandler, int opm, boolean overprintingFlag, GraphicState inheritedGraphicSpace) {
        GFPDColorSpace result;
        if (colorSpace == null) {
            return new GFPDEmptyColorSpace();
        }
        String uniqueID = ColorSpaceFactory.getColorSpaceUniqueIdentifier(colorSpace, opm, overprintingFlag);
        if (StaticContainers.cachedColorSpaces.containsKey(uniqueID)) {
            return StaticContainers.cachedColorSpaces.get(uniqueID);
        }
        switch (colorSpace.getType().toString()) {
            case "/CalGray": {
                result = new GFPDCalGray((PDCalGray)colorSpace);
                break;
            }
            case "/CalRGB": {
                result = new GFPDCalRGB((PDCalRGB)colorSpace);
                break;
            }
            case "/DeviceCMYK": {
                if (colorSpace.isInherited()) {
                    return GFPDDeviceCMYK.getInheritedInstance();
                }
                return GFPDDeviceCMYK.getInstance();
            }
            case "/DeviceRGB": {
                if (colorSpace.isInherited()) {
                    return GFPDDeviceRGB.getInheritedInstance();
                }
                return GFPDDeviceRGB.getInstance();
            }
            case "/DeviceGray": {
                if (colorSpace.isInherited()) {
                    return GFPDDeviceGray.getInheritedInstance();
                }
                return GFPDDeviceGray.getInstance();
            }
            case "/ICCBased": {
                result = colorSpace.getNumberOfComponents() != 4 ? new GFPDICCBased((PDICCBased)colorSpace) : new GFPDICCBasedCMYK((PDICCBased)colorSpace, opm, overprintingFlag);
                break;
            }
            case "/Lab": {
                result = new GFPDLab((PDLab)colorSpace);
                break;
            }
            case "/Separation": {
                result = new GFPDSeparation((PDSeparation)colorSpace);
                break;
            }
            case "/Indexed": {
                result = new GFPDIndexed((PDIndexed)colorSpace);
                break;
            }
            case "/DeviceN": {
                result = new GFPDDeviceN((PDDeviceN)colorSpace);
                break;
            }
            case "/Pattern": {
                return ColorSpaceFactory.getPattern((org.verapdf.pd.patterns.PDPattern)colorSpace, resourcesHandler, inheritedGraphicSpace);
            }
            default: {
                return null;
            }
        }
        StaticContainers.cachedColorSpaces.put(uniqueID, result);
        return result;
    }

    private static PDPattern getPattern(org.verapdf.pd.patterns.PDPattern pattern, PDResourcesHandler resourcesHandler, GraphicState inheritedGraphicState) {
        switch (pattern.getPatternType()) {
            case 1: {
                return new GFPDTilingPattern((PDTilingPattern)pattern, resourcesHandler.getExtendedResources(((PDTilingPattern)pattern).getResources()), inheritedGraphicState);
            }
            case 2: {
                return new GFPDShadingPattern((PDShadingPattern)pattern);
            }
        }
        return null;
    }

    private static String getColorSpaceUniqueIdentifier(PDColorSpace base, int opm, boolean overprintFlag) {
        if (ICC_BASED.equals(base.getType().toString()) && base.getNumberOfComponents() == 4) {
            return String.valueOf(base.hashCode() + " " + opm + " " + overprintFlag);
        }
        return String.valueOf(base.hashCode());
    }
}

