/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.cos;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.cos.COSName;
import org.verapdf.gf.model.impl.cos.GFCosName;
import org.verapdf.model.coslayer.CosUnicodeName;

public class GFCosUnicodeName
extends GFCosName
implements CosUnicodeName {
    public static final Logger LOGGER = Logger.getLogger(GFCosUnicodeName.class.getCanonicalName());
    public static final String COS_UNICODE_NAME_TYPE = "CosUnicodeName";

    public GFCosUnicodeName(COSName cosName) {
        super(cosName, COS_UNICODE_NAME_TYPE);
    }

    @Override
    public Boolean getisValidUtf8() {
        ByteBuffer tmp;
        CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
        CharsetEncoder encoder = Charset.forName("Windows-1252").newEncoder();
        try {
            tmp = encoder.encode(CharBuffer.wrap(this.baseObject.getString()));
        }
        catch (CharacterCodingException e) {
            LOGGER.log(Level.FINE, e.getMessage(), e);
            return Boolean.FALSE;
        }
        try {
            decoder.decode(tmp);
            return Boolean.TRUE;
        }
        catch (CharacterCodingException e) {
            LOGGER.log(Level.FINE, e.getMessage(), e);
            return Boolean.FALSE;
        }
    }

    @Override
    public String getunicodeValue() {
        String name = this.baseObject.getString();
        byte[] bytes = name.getBytes();
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.log(Level.FINE, "Can not transform " + name + " to unicode string.", e);
            return null;
        }
    }
}

