/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.external;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.core.VeraPDFException;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.GFModelParser;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.external.GFExternal;
import org.verapdf.gf.model.impl.pd.colors.GFPDSeparation;
import org.verapdf.gf.model.impl.pd.util.TaggedPDFRoleMapHelper;
import org.verapdf.model.external.EmbeddedFile;
import org.verapdf.model.operator.Glyph;
import org.verapdf.model.pdlayer.PDColorSpace;
import org.verapdf.model.pdlayer.PDFont;
import org.verapdf.pd.PDDocument;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.cmap.CMap;
import org.verapdf.pd.structure.PDStructureNameSpace;
import org.verapdf.pdfa.PDFAValidator;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.results.ValidationResult;
import org.verapdf.pdfa.validation.validators.ValidatorFactory;
import org.verapdf.tools.StaticResources;

public class GFEmbeddedFile
extends GFExternal
implements EmbeddedFile {
    private static final Logger LOGGER = Logger.getLogger(GFEmbeddedFile.class.getCanonicalName());
    public static final String EMBEDDED_FILE_TYPE = "EmbeddedFile";
    private final COSStream stream;
    private PDDocument document;
    private PDFAFlavour flavour;
    private TaggedPDFRoleMapHelper roleMapHelper;
    private Map<String, List<GFPDSeparation>> separations;
    private List<String> inconsistentSeparations;
    private Map<String, PDColorSpace> cachedColorSpaces;
    private Set<COSKey> fileSpecificationKeys;
    private Stack<COSKey> transparencyVisitedContentStreams;
    private Map<String, PDFont> cachedPDFonts;
    private Map<String, Glyph> cachedGlyphs;
    private boolean validPDF;
    private Map<String, CMap> cMapCache;
    private Map<COSKey, PDStructureNameSpace> structureNameSpaceCache;
    private Map<String, FontProgram> cachedFonts;

    public GFEmbeddedFile(COSStream stream) {
        super(EMBEDDED_FILE_TYPE);
        this.stream = stream;
    }

    @Override
    public String getSubtype() {
        if (this.stream != null) {
            ASAtom s = this.stream.getNameKey(ASAtom.SUBTYPE);
            return s == null ? null : s.getValue();
        }
        return null;
    }

    @Override
    public Boolean getisValidPDFA12() {
        if (this.stream == null) {
            return Boolean.TRUE;
        }
        boolean retVal = false;
        this.saveStaticContainersState();
        try (ASInputStream unfilteredStream = this.stream.getData(COSStream.FilterFlags.DECODE);){
            retVal = GFEmbeddedFile.isValidPdfaStream(unfilteredStream, PDFAFlavour.PDFA_1_B);
            if (!retVal) {
                ((InputStream)unfilteredStream).reset();
                retVal = GFEmbeddedFile.isValidPdfaStream(unfilteredStream, PDFAFlavour.PDFA_2_B);
            }
        }
        catch (IOException | VeraPDFException e) {
            LOGGER.log(Level.FINE, "Exception during validation of embedded file", e);
        }
        this.restoreSavedSCState();
        return retVal;
    }

    private static boolean isValidPdfaStream(InputStream toValidate, PDFAFlavour flavour) throws VeraPDFException {
        try (GFModelParser parser = GFModelParser.createModelWithFlavour(toValidate, flavour);){
            PDFAValidator validator1b = ValidatorFactory.createValidator(flavour, false, 1);
            ValidationResult result1b = validator1b.validate(parser);
            parser.close();
            boolean bl = result1b.isCompliant();
            return bl;
        }
    }

    private void saveStaticContainersState() {
        this.document = StaticContainers.getDocument();
        this.flavour = StaticContainers.getFlavour();
        this.separations = StaticContainers.separations;
        this.inconsistentSeparations = StaticContainers.inconsistentSeparations;
        this.cachedColorSpaces = StaticContainers.cachedColorSpaces;
        this.cachedPDFonts = StaticContainers.cachedFonts;
        this.roleMapHelper = StaticContainers.roleMapHelper;
        this.fileSpecificationKeys = StaticContainers.fileSpecificationKeys;
        this.transparencyVisitedContentStreams = StaticContainers.transparencyVisitedContentStreams;
        this.validPDF = StaticContainers.validPDF;
        this.cachedGlyphs = StaticContainers.cachedGlyphs;
        this.cMapCache = new HashMap<String, CMap>(StaticResources.cMapCache);
        this.structureNameSpaceCache = new HashMap<COSKey, PDStructureNameSpace>(StaticResources.structureNameSpaceCache);
        this.cachedFonts = new HashMap<String, FontProgram>(StaticResources.cachedFonts);
    }

    private void restoreSavedSCState() {
        StaticContainers.setDocument(this.document);
        StaticContainers.setFlavour(this.flavour);
        StaticContainers.separations = this.separations;
        StaticContainers.inconsistentSeparations = this.inconsistentSeparations;
        StaticContainers.cachedColorSpaces = this.cachedColorSpaces;
        StaticContainers.cachedFonts = this.cachedPDFonts;
        StaticContainers.roleMapHelper = this.roleMapHelper;
        StaticContainers.fileSpecificationKeys = this.fileSpecificationKeys;
        StaticContainers.transparencyVisitedContentStreams = this.transparencyVisitedContentStreams;
        StaticContainers.validPDF = this.validPDF;
        StaticContainers.cachedGlyphs = this.cachedGlyphs;
        StaticResources.cMapCache = this.cMapCache;
        StaticResources.structureNameSpaceCache = this.structureNameSpaceCache;
        StaticResources.cachedFonts = this.cachedFonts;
    }
}

