/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.cos.GFCosNumber;
import org.verapdf.gf.model.impl.pd.GFPDContentStream;
import org.verapdf.gf.model.impl.pd.GFPDObject;
import org.verapdf.gf.model.impl.pd.actions.GFPDAction;
import org.verapdf.gf.model.impl.pd.util.PDResourcesHandler;
import org.verapdf.model.coslayer.CosNumber;
import org.verapdf.model.pdlayer.PDAnnot;
import org.verapdf.model.pdlayer.PDContentStream;
import org.verapdf.pd.PDAnnotation;
import org.verapdf.pd.PDAppearanceEntry;
import org.verapdf.pd.PDAppearanceStream;
import org.verapdf.pd.PDGroup;
import org.verapdf.pd.actions.PDAction;
import org.verapdf.pd.actions.PDAnnotationAdditionalActions;
import org.verapdf.pd.structure.StructureElementAccessObject;

public class GFPDAnnot
extends GFPDObject
implements PDAnnot {
    public static final String ANNOTATION_TYPE = "PDAnnot";
    public static final String DICT = "Dict";
    public static final String STREAM = "Stream";
    public static final String APPEARANCE = "appearance";
    public static final String C = "C";
    public static final String IC = "IC";
    public static final String A = "A";
    public static final String ADDITIONAL_ACTION = "AA";
    public static final int MAX_COUNT_OF_ACTIONS = 10;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    private final PDResourcesHandler resources;
    private List<PDContentStream> appearance = null;
    private boolean containsTransparency = false;

    public GFPDAnnot(PDAnnotation annot, PDResourcesHandler pageResources) {
        super(annot, ANNOTATION_TYPE);
        this.resources = pageResources;
    }

    @Override
    public String getSubtype() {
        ASAtom subtype = ((PDAnnotation)this.simplePDObject).getSubtype();
        return subtype == null ? null : subtype.getValue();
    }

    @Override
    public String getAP() {
        COSObject apLocal = ((PDAnnotation)this.simplePDObject).getCOSAP();
        if (apLocal != null) {
            StringBuilder result = new StringBuilder();
            for (ASAtom key : apLocal.getKeySet()) {
                result.append(key.getValue());
                result.append(' ');
            }
            return result.length() <= 0 ? result.toString() : result.substring(0, result.length() - 1);
        }
        return null;
    }

    @Override
    public Long getF() {
        return ((PDAnnotation)this.simplePDObject).getF();
    }

    @Override
    public Double getCA() {
        return ((PDAnnotation)this.simplePDObject).getCA();
    }

    @Override
    public String getN_type() {
        PDAppearanceEntry normalAppearance = ((PDAnnotation)this.simplePDObject).getNormalAppearance();
        if (normalAppearance == null) {
            return null;
        }
        if (normalAppearance.isSubDictionary()) {
            return DICT;
        }
        return STREAM;
    }

    @Override
    public String getFT() {
        ASAtom ft = ((PDAnnotation)this.simplePDObject).getFT();
        return ft == null ? null : ft.getValue();
    }

    @Override
    public Double getwidth() {
        return GFPDAnnot.getDifference(((PDAnnotation)this.simplePDObject).getRect(), 0);
    }

    @Override
    public Double getheight() {
        return GFPDAnnot.getDifference(((PDAnnotation)this.simplePDObject).getRect(), 1);
    }

    @Override
    public Boolean getcontainsAA() {
        return this.simplePDObject.knownKey(ASAtom.AA);
    }

    private static Double getDifference(double[] array, int shift) {
        if (array != null && array.length > shift + 2) {
            return array[shift + 2] - array[shift];
        }
        return null;
    }

    @Override
    public Boolean getcontainsA() {
        return this.simplePDObject.knownKey(ASAtom.A);
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "AA": {
                return this.getAdditionalActions();
            }
            case "A": {
                return this.getA();
            }
            case "IC": {
                return this.getIC();
            }
            case "C": {
                return this.getC();
            }
            case "appearance": {
                return this.getAppearance();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<org.verapdf.model.pdlayer.PDAction> getAdditionalActions() {
        PDAnnotationAdditionalActions additionalActions = ((PDAnnotation)this.simplePDObject).getAdditionalActions();
        if (additionalActions != null) {
            ArrayList<org.verapdf.model.pdlayer.PDAction> actions = new ArrayList<org.verapdf.model.pdlayer.PDAction>(10);
            PDAction buffer = additionalActions.getBl();
            this.addAction(actions, buffer);
            buffer = additionalActions.getD();
            this.addAction(actions, buffer);
            buffer = additionalActions.getE();
            this.addAction(actions, buffer);
            buffer = additionalActions.getFo();
            this.addAction(actions, buffer);
            buffer = additionalActions.getPC();
            this.addAction(actions, buffer);
            buffer = additionalActions.getPI();
            this.addAction(actions, buffer);
            buffer = additionalActions.getPO();
            this.addAction(actions, buffer);
            buffer = additionalActions.getPV();
            this.addAction(actions, buffer);
            buffer = additionalActions.getU();
            this.addAction(actions, buffer);
            buffer = additionalActions.getX();
            this.addAction(actions, buffer);
            return Collections.unmodifiableList(actions);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.pdlayer.PDAction> getA() {
        PDAction action = ((PDAnnotation)this.simplePDObject).getA();
        if (action != null) {
            ArrayList<org.verapdf.model.pdlayer.PDAction> res = new ArrayList<org.verapdf.model.pdlayer.PDAction>(1);
            res.add(GFPDAction.getAction(action));
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    private List<CosNumber> getIC() {
        COSObject ic = ((PDAnnotation)this.simplePDObject).getCOSIC();
        if (ic != null) {
            return GFPDAnnot.getNumbersFromArray(ic);
        }
        return Collections.emptyList();
    }

    private List<CosNumber> getC() {
        COSObject c = ((PDAnnotation)this.simplePDObject).getCOSC();
        if (c != null) {
            return GFPDAnnot.getNumbersFromArray(c);
        }
        return Collections.emptyList();
    }

    private static List<CosNumber> getNumbersFromArray(COSObject array) {
        if (array.size() > 0) {
            ArrayList<GFCosNumber> color = new ArrayList<GFCosNumber>();
            for (COSObject colorValue : (COSArray)array.getDirectBase()) {
                if (!colorValue.getType().isNumber()) continue;
                color.add(GFCosNumber.fromPDFParserNumber(colorValue.get()));
            }
            return Collections.unmodifiableList(color);
        }
        ArrayList<CosNumber> res = new ArrayList<CosNumber>(1);
        res.add(GFCosNumber.fromPDFParserNumber(COSInteger.construct(0L).getDirectBase()));
        return res;
    }

    private List<PDContentStream> getAppearance() {
        if (this.appearance == null) {
            this.appearance = this.parseAppearance();
        }
        return this.appearance;
    }

    boolean isContainsTransparency() {
        if (this.appearance == null) {
            this.appearance = this.parseAppearance();
        }
        return this.containsTransparency;
    }

    private List<PDContentStream> parseAppearance() {
        PDAppearanceEntry normalAppearance = ((PDAnnotation)this.simplePDObject).getNormalAppearance();
        PDAppearanceEntry downAppearance = ((PDAnnotation)this.simplePDObject).getDownAppearance();
        PDAppearanceEntry rolloverAppearance = ((PDAnnotation)this.simplePDObject).getRolloverAppearance();
        if (normalAppearance != null || downAppearance != null || rolloverAppearance != null) {
            ArrayList<PDContentStream> appearances = new ArrayList<PDContentStream>();
            this.addContentStreamsFromAppearanceEntry(normalAppearance, appearances);
            this.addContentStreamsFromAppearanceEntry(downAppearance, appearances);
            this.addContentStreamsFromAppearanceEntry(rolloverAppearance, appearances);
            return Collections.unmodifiableList(appearances);
        }
        return Collections.emptyList();
    }

    private void addContentStreamsFromAppearanceEntry(PDAppearanceEntry appearanceEntry, List<PDContentStream> appearances) {
        if (appearanceEntry != null) {
            if (appearanceEntry.isSubDictionary()) {
                Map<ASAtom, PDAppearanceStream> subDictionary = appearanceEntry.getSubDictionary();
                for (PDAppearanceStream stream : subDictionary.values()) {
                    this.addAppearance(appearances, stream);
                }
            } else {
                this.addAppearance(appearances, appearanceEntry.getAppearanceStream());
            }
        }
    }

    private void addAppearance(List<PDContentStream> list, PDAppearanceStream toAdd) {
        if (toAdd != null) {
            PDResourcesHandler resources = this.resources.getExtendedResources(toAdd.getResources());
            GFPDContentStream stream = new GFPDContentStream(toAdd, resources, null, new StructureElementAccessObject(this.simpleCOSObject));
            this.containsTransparency |= stream.isContainsTransparency();
            PDGroup group = toAdd.getGroup();
            this.containsTransparency |= group != null && ASAtom.TRANSPARENCY.equals(group.getSubtype());
            list.add(stream);
        }
    }
}

