/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.font;

import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.gf.model.factory.operators.RenderingMode;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.pd.font.GFPDSimpleFont;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.cff.CFFFontProgram;
import org.verapdf.pd.font.cff.CFFType1FontProgram;
import org.verapdf.pd.font.opentype.OpenTypeFontProgram;
import org.verapdf.pd.font.type1.PDType1Font;
import org.verapdf.pd.font.type1.Type1FontProgram;

public class GFPDType1Font
extends GFPDSimpleFont
implements org.verapdf.model.pdlayer.PDType1Font {
    private static final Logger LOGGER = Logger.getLogger(GFPDType1Font.class.getCanonicalName());
    public static final String TYPE1_FONT_TYPE = "PDType1Font";
    public static final String NOTDEF_STRING = ".notdef";

    public GFPDType1Font(PDType1Font pdFont, RenderingMode renderingMode) {
        super(pdFont, renderingMode, TYPE1_FONT_TYPE);
        if (pdFont != null) {
            FontProgram program = pdFont.getFontProgram();
            if (program != null) {
                StaticContainers.getDocument().getDocument().getResourceHandler().addResource(program.getFontProgramResource());
            }
            if (program != null) {
                try {
                    if (!program.isAttemptedParsing()) {
                        program.parseFont();
                    }
                    this.fontProgramParsed = program.isSuccessfulParsing();
                    this.pdFont.setSuccessfullyParsed(program.isSuccessfulParsing());
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, "Can't parse font program of font " + pdFont.getName(), e);
                    this.fontProgramParsed = false;
                    this.pdFont.setSuccessfullyParsed(false);
                }
            }
        }
    }

    @Override
    public String getCharSet() {
        String res = this.pdFont.getFontDescriptor().getStringKey(ASAtom.CHAR_SET);
        return res;
    }

    @Override
    public Boolean getcharSetListsAllGlyphs() {
        Set<String> fontProgramCharSet;
        if (!this.fontProgramParsed) {
            return false;
        }
        Set<String> descriptorCharSet = ((PDType1Font)this.pdFont).getDescriptorCharSet();
        if (this.pdFont.getFontProgram() instanceof Type1FontProgram) {
            fontProgramCharSet = ((Type1FontProgram)this.pdFont.getFontProgram()).getCharSet();
        } else if (this.pdFont.getFontProgram() instanceof CFFFontProgram) {
            fontProgramCharSet = ((CFFType1FontProgram)((CFFFontProgram)this.pdFont.getFontProgram()).getFont()).getCharSet();
        } else if (this.pdFont.getFontProgram() instanceof OpenTypeFontProgram) {
            CFFFontProgram cff = (CFFFontProgram)((OpenTypeFontProgram)this.pdFont.getFontProgram()).getFont();
            fontProgramCharSet = ((CFFType1FontProgram)cff.getFont()).getCharSet();
        } else {
            fontProgramCharSet = new TreeSet<String>();
        }
        if (descriptorCharSet.size() != fontProgramCharSet.size() && descriptorCharSet.size() != fontProgramCharSet.size() - 1) {
            return false;
        }
        for (String glyphName : fontProgramCharSet) {
            if (glyphName.equals(NOTDEF_STRING) || descriptorCharSet.contains(glyphName)) continue;
            return false;
        }
        for (String glyphName : descriptorCharSet) {
            if (glyphName.equals(NOTDEF_STRING) || fontProgramCharSet.contains(glyphName)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean getisStandard() {
        return ((PDType1Font)this.pdFont).isStandard();
    }
}

