/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.encryption;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.filters.io.ASBufferedInFilter;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.as.io.ASMemoryInStream;
import org.verapdf.cos.COSDocument;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.cos.COSString;
import org.verapdf.cos.filters.COSFilterAESDecryptionDefault;
import org.verapdf.cos.filters.COSFilterRC4DecryptionDefault;
import org.verapdf.pd.encryption.PDCryptFilter;
import org.verapdf.pd.encryption.PDEncryption;
import org.verapdf.tools.EncryptionToolsRevision4;
import org.verapdf.tools.EncryptionToolsRevision6;
import org.verapdf.tools.resource.ASFileStreamCloser;

public class StandardSecurityHandler {
    private static final Logger LOGGER = Logger.getLogger(StandardSecurityHandler.class.getCanonicalName());
    private PDEncryption pdEncryption;
    private COSObject id;
    private Boolean isEmptyStringPassword;
    private byte[] encryptionKey;
    private boolean isRC4Decryption;
    private ASAtom method;
    private COSDocument document;

    public StandardSecurityHandler(PDEncryption pdEncryption, COSObject id, COSDocument document) {
        this.pdEncryption = pdEncryption != null ? pdEncryption : new PDEncryption();
        this.id = id;
        this.document = document;
        PDCryptFilter stdCrypt = this.pdEncryption.getStandardCryptFilter();
        if (stdCrypt != null) {
            this.method = stdCrypt.getMethod();
        }
        this.isRC4Decryption = this.isRC4Decryption();
    }

    public Boolean authenticateEmptyPassword() {
        byte[] o = this.getO();
        Long p = this.pdEncryption.getP();
        byte[] id = this.getID();
        Long revision = this.pdEncryption.getR();
        boolean encMetadata = this.pdEncryption.isEncryptMetadata();
        int length = this.pdEncryption.getLength();
        byte[] u = this.getU();
        if (o != null && p != null && id != null && revision != null && u != null) {
            try {
                if (revision <= 4L) {
                    this.encryptionKey = EncryptionToolsRevision4.authenticateUserPassword("", o, p.intValue(), id, revision.intValue(), encMetadata, length, u);
                } else if (revision >= 5L) {
                    this.encryptionKey = EncryptionToolsRevision6.getFileEncryptionKey("".getBytes(), o, u, this.getOE(), this.getUE());
                }
                this.isEmptyStringPassword = this.encryptionKey != null;
                return this.isEmptyStringPassword;
            }
            catch (GeneralSecurityException e) {
                LOGGER.log(Level.FINE, "Caught Security Exception while document decryption", e);
                this.isEmptyStringPassword = false;
                return this.isEmptyStringPassword;
            }
        }
        LOGGER.log(Level.FINE, "Can't authenticate password in encrypted PDF, something is null.");
        this.isEmptyStringPassword = false;
        return this.isEmptyStringPassword;
    }

    public byte[] getEncryptionKey() {
        if (this.isEmptyStringPassword == null) {
            this.authenticateEmptyPassword();
        }
        if (!this.isEmptyStringPassword.booleanValue()) {
            return null;
        }
        return this.encryptionKey;
    }

    public boolean isEmptyStringPassword() {
        if (this.isEmptyStringPassword == null) {
            this.authenticateEmptyPassword();
        }
        return this.isEmptyStringPassword;
    }

    public void decryptString(COSString string, COSKey stringKey) throws IOException, GeneralSecurityException {
        byte[] stringBytes = StandardSecurityHandler.getBytesOfHexString(string);
        ASMemoryInStream stream = new ASMemoryInStream(stringBytes);
        ASBufferedInFilter filter = this.isRC4Decryption ? new COSFilterRC4DecryptionDefault(stream, stringKey, this.encryptionKey) : new COSFilterAESDecryptionDefault(stream, stringKey, this.encryptionKey, false, this.method);
        byte[] buf = new byte[2048];
        byte[] res = new byte[]{};
        int read = ((ASInputStream)filter).read(buf, buf.length);
        while (read != -1) {
            res = ASBufferedInFilter.concatenate(res, res.length, buf, read);
            read = ((ASInputStream)filter).read(buf, buf.length);
        }
        ((ASInputStream)filter).close();
        string.set(res);
    }

    public void decryptStream(COSStream stream, COSKey key) throws IOException, GeneralSecurityException {
        ASInputStream encStream = stream.getData();
        ASBufferedInFilter filter = this.isRC4Decryption ? new COSFilterRC4DecryptionDefault(encStream, key, this.encryptionKey) : new COSFilterAESDecryptionDefault(encStream, key, this.encryptionKey, true, this.method);
        this.document.addFileResource(new ASFileStreamCloser(filter));
        stream.setData(filter, COSStream.FilterFlags.RAW_DATA);
    }

    public PDEncryption getPdEncryption() {
        return this.pdEncryption;
    }

    private byte[] getO() {
        return StandardSecurityHandler.getBytesOfHexString(this.pdEncryption.getO());
    }

    private byte[] getU() {
        return StandardSecurityHandler.getBytesOfHexString(this.pdEncryption.getU());
    }

    private byte[] getOE() {
        return StandardSecurityHandler.getBytesOfHexString(this.pdEncryption.getOE());
    }

    private byte[] getUE() {
        return StandardSecurityHandler.getBytesOfHexString(this.pdEncryption.getUE());
    }

    private byte[] getID() {
        COSObject id1;
        if (this.id != null && this.id.getType() == COSObjType.COS_ARRAY && (id1 = this.id.at(0)).getType() == COSObjType.COS_STRING) {
            return StandardSecurityHandler.getBytesOfHexString((COSString)id1.getDirectBase());
        }
        return null;
    }

    private static byte[] getBytesOfHexString(COSString s) {
        if (s == null) {
            return null;
        }
        return s.get();
    }

    private boolean isRC4Decryption() {
        if (this.pdEncryption.getV() >= 4) {
            return this.method != ASAtom.AESV3 && this.method != ASAtom.AESV2;
        }
        return true;
    }
}

