/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.truetype;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.verapdf.io.SeekableInputStream;
import org.verapdf.pd.font.truetype.TrueTypePredefined;
import org.verapdf.pd.font.truetype.TrueTypeTable;

class TrueTypePostTable
extends TrueTypeTable {
    private long length;
    private int numGlyphs;
    private Map<String, Integer> stringToGid;

    TrueTypePostTable(SeekableInputStream source, long offset, long length) {
        super(source, offset);
        this.length = length;
        this.stringToGid = new HashMap<String, Integer>();
    }

    void setNumGlyphs(int numGlyphs) {
        this.numGlyphs = numGlyphs;
    }

    @Override
    void readTable() throws IOException {
        long startingOffset = this.source.getOffset();
        this.source.seek(this.offset);
        float format = this.readFixed();
        this.source.skip(28);
        if (format == 2.0f) {
            this.source.skip(2);
            int[] glyphNameIndexInt = new int[this.numGlyphs];
            for (int i = 0; i < this.numGlyphs; ++i) {
                glyphNameIndexInt[i] = this.readUShort();
            }
            LinkedList<String> strings = new LinkedList<String>();
            while (this.source.getOffset() < this.offset + this.length) {
                strings.add(this.readPascalString());
            }
            for (int i = 0; i < this.numGlyphs; ++i) {
                if (glyphNameIndexInt[i] < TrueTypePredefined.MAC_INDEX_TO_GLYPH_NAME.length) {
                    this.stringToGid.put(TrueTypePredefined.MAC_INDEX_TO_GLYPH_NAME[glyphNameIndexInt[i]], i);
                    continue;
                }
                int index = glyphNameIndexInt[i] - TrueTypePredefined.MAC_INDEX_TO_GLYPH_NAME.length;
                if (index < 0 || index >= strings.size()) continue;
                this.stringToGid.put((String)strings.get(index), i);
            }
        } else if (format == 2.5f) {
            try {
                for (int i = 0; i < this.numGlyphs; ++i) {
                    byte tableOffset = this.readChar();
                    String glyphName = TrueTypePredefined.MAC_INDEX_TO_GLYPH_NAME[tableOffset + i];
                    this.stringToGid.put(glyphName, i);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IOException("Error in reading post table", e);
            }
        }
        this.source.seek(startingOffset);
    }

    int getGID(String s) {
        Integer res = this.stringToGid.get(s);
        return res == null ? 0 : res;
    }

    boolean containsGlyph(String glyphName) {
        return this.stringToGid.containsKey(glyphName);
    }

    private String readPascalString() throws IOException {
        int length = this.readByte();
        byte[] str = new byte[length];
        this.source.read(str, length);
        return new String(str);
    }
}

