/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.results;

import java.util.Set;
import javax.xml.bind.JAXBException;
import org.verapdf.core.XmlSerialiser;
import org.verapdf.pdfa.results.Location;
import org.verapdf.pdfa.results.LocationImpl;
import org.verapdf.pdfa.results.TestAssertion;
import org.verapdf.pdfa.results.TestAssertionImpl;
import org.verapdf.pdfa.results.ValidationResult;
import org.verapdf.pdfa.results.ValidationResultImpl;
import org.verapdf.pdfa.validation.profiles.RuleId;
import org.verapdf.pdfa.validation.profiles.ValidationProfile;

public class ValidationResults {
    private static final String NOT_NULL_MESSAGE = " cannot be null.";
    private static final String VALIDATION_PROFILE_NOT_NULL_MESSAGE = "Validation profile  cannot be null.";
    private static final String ASSERTIONS_NOT_NULL_MESSAGE = "Assertions  cannot be null.";

    private ValidationResults() {
        throw new AssertionError((Object)"Should never enter ValidationResults().");
    }

    public static ValidationResult resultFromValues(ValidationProfile validationProfile, Set<TestAssertion> assertions, boolean isCompliant) {
        if (validationProfile == null) {
            throw new NullPointerException(VALIDATION_PROFILE_NOT_NULL_MESSAGE);
        }
        if (assertions == null) {
            throw new NullPointerException(ASSERTIONS_NOT_NULL_MESSAGE);
        }
        return ValidationResultImpl.fromValues(validationProfile, assertions, isCompliant, assertions.size());
    }

    public static ValidationResult resultFromValues(ValidationProfile validationProfile, Set<TestAssertion> assertions, boolean isCompliant, int totalAssertions) {
        if (validationProfile == null) {
            throw new NullPointerException(VALIDATION_PROFILE_NOT_NULL_MESSAGE);
        }
        if (assertions == null) {
            throw new NullPointerException(ASSERTIONS_NOT_NULL_MESSAGE);
        }
        return ValidationResultImpl.fromValues(validationProfile, assertions, isCompliant, totalAssertions);
    }

    public static ValidationResult resultFromValues(ValidationProfile validationProfile, Set<TestAssertion> assertions) {
        if (validationProfile == null) {
            throw new NullPointerException(VALIDATION_PROFILE_NOT_NULL_MESSAGE);
        }
        if (assertions == null) {
            throw new NullPointerException(ASSERTIONS_NOT_NULL_MESSAGE);
        }
        boolean isCompliant = true;
        for (TestAssertion assertion : assertions) {
            if (assertion.getStatus() != TestAssertion.Status.FAILED) continue;
            isCompliant = false;
            break;
        }
        return ValidationResults.resultFromValues(validationProfile, assertions, isCompliant);
    }

    public static ValidationResult resultFromXmlString(String xmlSource) throws JAXBException {
        return (ValidationResult)XmlSerialiser.typeFromXml(ValidationResultImpl.class, xmlSource);
    }

    public static ValidationResult defaultResult() {
        return ValidationResultImpl.defaultInstance();
    }

    public static TestAssertion assertionFromValues(int ordinal, RuleId ruleId, TestAssertion.Status status, String message, Location location) {
        return TestAssertionImpl.fromValues(ordinal, ruleId, status, message, location);
    }

    public static TestAssertion defaultAssertion() {
        return TestAssertionImpl.defaultInstance();
    }

    public static Location locationFromValues(String level, String context) {
        return LocationImpl.fromValues(level, context);
    }

    public static Location defaultLocation() {
        return LocationImpl.defaultInstance();
    }

    public static ValidationResult stripPassedTests(ValidationResult toStrip) {
        if (toStrip == null) {
            throw new NullPointerException("toStrip can not be null.");
        }
        return ValidationResultImpl.stripPassedTests(toStrip);
    }
}

