/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import com.adobe.xmp.impl.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.verapdf.as.ASAtom;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.pd.GFPDFormField;
import org.verapdf.gf.model.impl.pd.GFPDObject;
import org.verapdf.model.pdlayer.PDAcroForm;
import org.verapdf.model.pdlayer.PDFormField;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class GFPDAcroForm
extends GFPDObject
implements PDAcroForm {
    private static final Logger LOGGER = Logger.getLogger(GFPDAcroForm.class.getCanonicalName());
    public static final String ACRO_FORM_TYPE = "PDAcroForm";
    public static final String FORM_FIELDS = "formFields";
    public static final String XDP = "xdp:xdp";
    public static final String CONFIG = "config";
    public static final String ACROBAT = "acrobat";
    public static final String ACROBAT7 = "acrobat7";
    public static final String DYNAMIC_RENDER = "dynamicRender";

    public GFPDAcroForm(org.verapdf.pd.form.PDAcroForm acroForm) {
        super(acroForm, ACRO_FORM_TYPE);
    }

    @Override
    public Boolean getNeedAppearances() {
        COSObject cosNeedAppearances = ((org.verapdf.pd.form.PDAcroForm)this.simplePDObject).getNeedAppearances();
        if (cosNeedAppearances.getType() == COSObjType.COS_BOOLEAN) {
            return cosNeedAppearances.getBoolean();
        }
        if (cosNeedAppearances.empty()) {
            return null;
        }
        LOGGER.log(Level.SEVERE, "Value of NeedAppearances key is not a boolean. Ignoring NeedAppearances");
        return true;
    }

    @Override
    public Boolean getcontainsXFA() {
        return this.simplePDObject.knownKey(ASAtom.XFA);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getdynamicRender() {
        COSObject object = this.simplePDObject.getKey(ASAtom.XFA);
        if (object == null) {
            return null;
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            COSArray array = (COSArray)object.getDirectBase();
            COSObject afterConfig = null;
            for (int i = 0; i < array.size() - 1; ++i) {
                COSObject element = array.at(i);
                if (element.getType() != COSObjType.COS_STRING || !CONFIG.equals(element.getDirectBase().getString())) continue;
                afterConfig = array.at(i + 1);
                break;
            }
            object = afterConfig;
        }
        if (object.getType() != COSObjType.COS_STREAM) return null;
        try (ASInputStream asInputStream = object.getDirectBase().getData(COSStream.FilterFlags.DECODE);){
            Node config;
            Node acrobat;
            Node acrobat7;
            Node dynamicRender;
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            builder.setErrorHandler(null);
            Document doc = builder.parse(new InputSource(new ByteBuffer(asInputStream).getByteStream()));
            Node configParent = this.getProperty(doc, XDP);
            if (configParent == null) {
                configParent = doc;
            }
            if ((dynamicRender = this.getProperty(acrobat7 = this.getProperty(acrobat = this.getProperty(config = this.getProperty(configParent, CONFIG), ACROBAT), ACROBAT7), DYNAMIC_RENDER)) == null) return null;
            String string = dynamicRender.getChildNodes().item(0).getNodeValue();
            return string;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Problems with parsing XFA");
            return null;
        }
    }

    private Node getProperty(Node parent, String propertyName) {
        if (parent == null) {
            return null;
        }
        NodeList childNodes = parent.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.item(i);
            if (!propertyName.equals(item.getNodeName())) continue;
            return item;
        }
        return null;
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "formFields": {
                return this.getFormFields();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<PDFormField> getFormFields() {
        List<org.verapdf.pd.form.PDFormField> fields = ((org.verapdf.pd.form.PDAcroForm)this.simplePDObject).getFields();
        ArrayList<GFPDFormField> formFields = new ArrayList<GFPDFormField>(1);
        for (org.verapdf.pd.form.PDFormField field : fields) {
            formFields.add(GFPDFormField.createTypedFormField(field));
        }
        return Collections.unmodifiableList(formFields);
    }
}

