/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.pd.GFPDObject;
import org.verapdf.model.pdlayer.PDOCConfig;
import org.verapdf.pd.PDObject;

public class GFPDOCConfig
extends GFPDObject
implements PDOCConfig {
    public static final Logger LOGGER = Logger.getLogger(GFPDOCConfig.class.getCanonicalName());
    public static final String OC_CONFIG_TYPE = "PDOCConfig";
    public static final String EVENT_KEY = "Event";
    private final List<String> groupNames;
    private final boolean duplicateName;

    public GFPDOCConfig(PDObject simplePDObject) {
        super(simplePDObject, OC_CONFIG_TYPE);
        this.groupNames = Collections.emptyList();
        this.duplicateName = false;
    }

    public GFPDOCConfig(PDObject simplePDObject, List<String> groupNames, boolean duplicateName) {
        super(simplePDObject, OC_CONFIG_TYPE);
        this.groupNames = groupNames == null ? Collections.emptyList() : groupNames;
        this.duplicateName = duplicateName;
    }

    @Override
    public Boolean getdoesOrderContainAllOCGs() {
        TreeSet<String> groupNamesSet = new TreeSet<String>(this.groupNames);
        COSObject order = this.simplePDObject.getKey(ASAtom.ORDER);
        if (!order.empty()) {
            if (order.getType() == COSObjType.COS_ARRAY) {
                for (int i = 0; i < order.size(); ++i) {
                    COSObject element = order.at(i);
                    if (element.getType() == COSObjType.COS_ARRAY) {
                        this.processCOSArrayInOrder(element, groupNamesSet);
                        continue;
                    }
                    if (element.getType() == COSObjType.COS_DICT) {
                        this.processCOSDictionaryInOrder(element, groupNamesSet);
                        continue;
                    }
                    LOGGER.log(Level.SEVERE, "Invalid object type in order array. Ignoring the object.");
                }
                if (!groupNamesSet.isEmpty()) {
                    return Boolean.FALSE;
                }
            } else {
                LOGGER.log(Level.SEVERE, "Invalid object type of Order entry. Ignoring the Order entry.");
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public String getAS() {
        COSObject asArray = this.simplePDObject.getKey(ASAtom.AS);
        if (!asArray.empty()) {
            String result = "";
            if (asArray.getType() == COSObjType.COS_ARRAY) {
                for (int i = 0; i < asArray.size(); ++i) {
                    COSObject element = asArray.at(i);
                    if (element.getType() == COSObjType.COS_DICT) {
                        String event = element.getStringKey(ASAtom.EVENT);
                        if (event == null || event.isEmpty()) continue;
                        result = result.concat(event);
                        continue;
                    }
                    LOGGER.log(Level.FINE, "Invalid object type in the AS array. Ignoring the object.");
                }
                return result;
            }
            LOGGER.log(Level.SEVERE, "Invalid object type of AS entry. Ignoring the entry.");
            return result;
        }
        return null;
    }

    @Override
    public Boolean gethasDuplicateName() {
        return this.duplicateName;
    }

    @Override
    public String getName() {
        return this.simplePDObject.getObject().getStringKey(ASAtom.NAME);
    }

    private void processCOSArrayInOrder(COSObject array, Set<String> groupNames) {
        for (int i = 0; i < array.size(); ++i) {
            COSObject element = array.at(i);
            if (element.getType() == COSObjType.COS_ARRAY) {
                this.processCOSArrayInOrder(element, groupNames);
                continue;
            }
            if (element.getType() != COSObjType.COS_DICT) continue;
            this.processCOSDictionaryInOrder(element, groupNames);
        }
    }

    private void processCOSDictionaryInOrder(COSObject element, Set<String> groupNames) {
        String name = element.getStringKey(ASAtom.NAME);
        if (name != null) {
            groupNames.remove(name);
        }
    }
}

