/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.gfse;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.verapdf.gf.model.impl.pd.GFPDStructElem;
import org.verapdf.gf.model.impl.pd.gfse.GFSEGeneral;
import org.verapdf.gf.model.impl.pd.gfse.GFSETD;
import org.verapdf.gf.model.impl.pd.gfse.GFSETH;
import org.verapdf.model.selayer.SETable;
import org.verapdf.pd.structure.PDStructElem;

public class GFSETable
extends GFSEGeneral
implements SETable {
    public static final String TABLE_STRUCTURE_ELEMENT_TYPE = "SETable";

    public GFSETable(PDStructElem structElemDictionary) {
        super(structElemDictionary, "Table", TABLE_STRUCTURE_ELEMENT_TYPE);
    }

    @Override
    public Boolean getuseHeadersAndIdOrScope() {
        Stack<org.verapdf.model.pdlayer.PDStructElem> stack = new Stack<org.verapdf.model.pdlayer.PDStructElem>();
        Boolean hasScope = true;
        Boolean hasID = true;
        Boolean hasHeaders = true;
        HashSet<String> idSet = new HashSet<String>();
        HashSet<Object> headersSet = new HashSet<Object>();
        stack.push(this);
        while (!stack.empty()) {
            List<Object> list;
            org.verapdf.model.pdlayer.PDStructElem elem = (org.verapdf.model.pdlayer.PDStructElem)stack.pop();
            String string = elem.getstandardType();
            if ("TD".equals(string)) {
                list = ((GFSETD)elem).getHeaders();
                if (list != null && !list.isEmpty()) {
                    headersSet.addAll(list);
                } else {
                    hasHeaders = false;
                }
            } else if ("TH".equals(string)) {
                String id = ((GFSETH)elem).getTHID();
                if (id == null || id.isEmpty()) {
                    hasID = false;
                } else {
                    idSet.add(id);
                }
                if (((GFSETH)elem).getScope() == null) {
                    hasScope = false;
                }
            }
            list = ((GFPDStructElem)elem).getChildren();
            for (org.verapdf.model.pdlayer.PDStructElem pDStructElem : list) {
                stack.push(pDStructElem);
            }
        }
        if (hasScope.booleanValue()) {
            return true;
        }
        if (!hasID.booleanValue() || !hasHeaders.booleanValue()) {
            return false;
        }
        for (String string : headersSet) {
            if (idSet.contains(string)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean getisRegular() {
        int j;
        int i;
        List<org.verapdf.model.pdlayer.PDStructElem> listTR = this.getTR();
        int rowNum = listTR.size();
        int columnNum = this.getColumnNum((GFPDStructElem)listTR.get(0));
        boolean[][] cells = new boolean[rowNum][columnNum];
        for (i = 0; i < rowNum; ++i) {
            j = 0;
            for (org.verapdf.model.pdlayer.PDStructElem elem : ((GFPDStructElem)listTR.get(i)).getChildren()) {
                long rowSpan;
                long colSpan;
                String type = elem.getstandardType();
                if ("TH".equals(type)) {
                    colSpan = ((GFSETH)elem).getColSpan();
                    rowSpan = ((GFSETH)elem).getRowSpan();
                } else {
                    if (!"TD".equals(type)) continue;
                    colSpan = ((GFSETD)elem).getColSpan();
                    rowSpan = ((GFSETD)elem).getRowSpan();
                }
                while (j < columnNum && cells[i][j]) {
                    ++j;
                }
                if (j >= columnNum) {
                    return false;
                }
                if ((long)i + rowSpan > (long)rowNum || (long)j + colSpan > (long)columnNum) {
                    return false;
                }
                if (!this.checkRegular(cells, rowSpan, colSpan, i, j).booleanValue()) {
                    return false;
                }
                j = (int)((long)j + colSpan);
            }
        }
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < columnNum; ++j) {
                if (cells[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    private List<org.verapdf.model.pdlayer.PDStructElem> getTR() {
        LinkedList<org.verapdf.model.pdlayer.PDStructElem> listTR = new LinkedList<org.verapdf.model.pdlayer.PDStructElem>();
        for (org.verapdf.model.pdlayer.PDStructElem elem : this.getChildren()) {
            String type = elem.getstandardType();
            if ((this.addTRtoList(listTR, elem) || !"THead".equals(type)) && !"TBody".equals(type) && !"TFoot".equals(type)) continue;
            for (org.verapdf.model.pdlayer.PDStructElem child : ((GFPDStructElem)elem).getChildren()) {
                this.addTRtoList(listTR, child);
            }
        }
        return listTR;
    }

    private boolean addTRtoList(List<org.verapdf.model.pdlayer.PDStructElem> listTR, org.verapdf.model.pdlayer.PDStructElem elem) {
        if ("TR".equals(elem.getstandardType())) {
            listTR.add(elem);
            return true;
        }
        return false;
    }

    private Integer getColumnNum(GFPDStructElem firstTR) {
        int columnNum = 0;
        for (org.verapdf.model.pdlayer.PDStructElem elem : firstTR.getChildren()) {
            String type = elem.getstandardType();
            if ("TH".equals(type)) {
                columnNum = (int)((long)columnNum + ((GFSETH)elem).getColSpan());
                continue;
            }
            if (!"TD".equals(type)) continue;
            columnNum = (int)((long)columnNum + ((GFSETD)elem).getColSpan());
        }
        return columnNum;
    }

    private Boolean checkRegular(boolean[][] cells, long rowSpan, long colSpan, int i, int j) {
        int k = 0;
        while ((long)k < rowSpan) {
            int l = 0;
            while ((long)l < colSpan) {
                if (cells[i + k][j + l]) {
                    return false;
                }
                cells[i + k][j + l] = true;
                ++l;
            }
            ++k;
        }
        return true;
    }
}

