/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ModelHelper {
    private static final Map<String, String> mapOfSuperNames = new HashMap<String, String>();
    private static final Map<String, List<String>> mapOfProperties = new HashMap<String, List<String>>();
    private static final Map<String, List<String>> mapOfLinks = new HashMap<String, List<String>>();
    private static List<String> properties;
    private static List<String> links;

    private ModelHelper() {
    }

    public static List<String> getListOfSuperNames(String objectName) {
        ArrayList<String> res = new ArrayList<String>();
        String currentObject = mapOfSuperNames.get(objectName);
        while (currentObject != null) {
            res.add(currentObject);
            currentObject = mapOfSuperNames.get(currentObject);
        }
        return res;
    }

    public static Set<String> getTypes() {
        return mapOfSuperNames.keySet();
    }

    public static List<String> getListOfProperties(String objectName) {
        ArrayList<String> res = new ArrayList<String>();
        String currentObject = objectName;
        while (currentObject != null) {
            for (String prop : mapOfProperties.get(currentObject)) {
                res.add(prop);
            }
            currentObject = mapOfSuperNames.get(currentObject);
        }
        return res;
    }

    public static List<String> getListOfLinks(String objectName) {
        ArrayList<String> res = new ArrayList<String>();
        String currentObject = objectName;
        while (currentObject != null) {
            for (String link : mapOfLinks.get(currentObject)) {
                res.add(link);
            }
            currentObject = mapOfSuperNames.get(currentObject);
        }
        return res;
    }

    /*
     * Opcode count of 20228 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        mapOfSuperNames.put("PDObject", "Object");
        mapOfSuperNames.put("PDDocument", "PDObject");
        mapOfSuperNames.put("PDPage", "PDObject");
        mapOfSuperNames.put("TransparencyColorSpace", "Object");
        mapOfSuperNames.put("OutputIntents", "Object");
        mapOfSuperNames.put("PDContentStream", "PDObject");
        mapOfSuperNames.put("PDSemanticContentStream", "PDContentStream");
        mapOfSuperNames.put("PDResource", "PDObject");
        mapOfSuperNames.put("PDColorSpace", "PDResource");
        mapOfSuperNames.put("PDAdditionalActions", "PDObject");
        mapOfSuperNames.put("PDDeviceGray", "PDColorSpace");
        mapOfSuperNames.put("PDDeviceRGB", "PDColorSpace");
        mapOfSuperNames.put("PDDeviceCMYK", "PDColorSpace");
        mapOfSuperNames.put("PDICCBased", "PDColorSpace");
        mapOfSuperNames.put("PDICCBasedCMYK", "PDICCBased");
        mapOfSuperNames.put("PDLab", "PDColorSpace");
        mapOfSuperNames.put("PDCalGray", "PDColorSpace");
        mapOfSuperNames.put("PDCalRGB", "PDColorSpace");
        mapOfSuperNames.put("PDSeparation", "PDColorSpace");
        mapOfSuperNames.put("PDDeviceN", "PDColorSpace");
        mapOfSuperNames.put("PDIndexed", "PDColorSpace");
        mapOfSuperNames.put("PDPattern", "PDColorSpace");
        mapOfSuperNames.put("PDTilingPattern", "PDPattern");
        mapOfSuperNames.put("PDShadingPattern", "PDPattern");
        mapOfSuperNames.put("PDFont", "PDResource");
        mapOfSuperNames.put("PDSimpleFont", "PDFont");
        mapOfSuperNames.put("PDTrueTypeFont", "PDSimpleFont");
        mapOfSuperNames.put("PDType1Font", "PDSimpleFont");
        mapOfSuperNames.put("PDType3Font", "PDSimpleFont");
        mapOfSuperNames.put("PDCIDFont", "PDFont");
        mapOfSuperNames.put("PDType0Font", "PDFont");
        mapOfSuperNames.put("PDCMap", "PDObject");
        mapOfSuperNames.put("PDReferencedCMap", "PDCMap");
        mapOfSuperNames.put("PDXObject", "PDResource");
        mapOfSuperNames.put("PDXImage", "PDXObject");
        mapOfSuperNames.put("PDSMaskImage", "PDXImage");
        mapOfSuperNames.put("PDInlineImage", "PDXImage");
        mapOfSuperNames.put("PDXForm", "PDXObject");
        mapOfSuperNames.put("PDResources", "PDObject");
        mapOfSuperNames.put("PDGroup", "PDObject");
        mapOfSuperNames.put("PDExtGState", "PDResource");
        mapOfSuperNames.put("PDHalftone", "PDObject");
        mapOfSuperNames.put("PDShading", "PDResource");
        mapOfSuperNames.put("PDAnnot", "PDObject");
        mapOfSuperNames.put("PD3DAnnot", "PDAnnot");
        mapOfSuperNames.put("PDWidgetAnnot", "PDAnnot");
        mapOfSuperNames.put("PDPrinterMarkAnnot", "PDAnnot");
        mapOfSuperNames.put("PDLinkAnnot", "PDAnnot");
        mapOfSuperNames.put("PDTrapNetAnnot", "PDAnnot");
        mapOfSuperNames.put("PD3DStream", "PDObject");
        mapOfSuperNames.put("PDAcroForm", "PDObject");
        mapOfSuperNames.put("PDFormField", "PDObject");
        mapOfSuperNames.put("PDSignatureField", "PDFormField");
        mapOfSuperNames.put("PDSignature", "PDObject");
        mapOfSuperNames.put("PDAction", "PDObject");
        mapOfSuperNames.put("PDRenditionAction", "PDAction");
        mapOfSuperNames.put("PDEncryption", "PDObject");
        mapOfSuperNames.put("PDMediaClip", "PDObject");
        mapOfSuperNames.put("PDNamedAction", "PDAction");
        mapOfSuperNames.put("PDGoToAction", "PDAction");
        mapOfSuperNames.put("PDGoToRemoteAction", "PDGoToAction");
        mapOfSuperNames.put("PDMetadata", "PDObject");
        mapOfSuperNames.put("PDOutputIntent", "PDObject");
        mapOfSuperNames.put("PDOCProperties", "PDObject");
        mapOfSuperNames.put("PDOCConfig", "PDObject");
        mapOfSuperNames.put("PDOutline", "PDObject");
        mapOfSuperNames.put("PDStructTreeRoot", "PDObject");
        mapOfSuperNames.put("PDStructElem", "PDObject");
        mapOfSuperNames.put("PDPerms", "PDObject");
        mapOfSuperNames.put("PDSigRef", "PDObject");
        mapOfSuperNames.put("PDFunction", "PDObject");
        mapOfSuperNames.put("PDType0Function", "PDFunction");
        mapOfSuperNames.put("PDType2Function", "PDFunction");
        mapOfSuperNames.put("PDType3Function", "PDFunction");
        mapOfSuperNames.put("PDType4Function", "PDFunction");
        properties = new ArrayList<String>();
        mapOfProperties.put("PDObject", properties);
        properties = new ArrayList<String>();
        properties.add("containsAlternatePresentations");
        properties.add("validPDF");
        properties.add("containsAA");
        properties.add("outputColorSpace");
        properties.add("Version");
        mapOfProperties.put("PDDocument", properties);
        properties = new ArrayList<String>();
        properties.add("containsPresSteps");
        properties.add("containsTransparency");
        properties.add("containsGroupCS");
        properties.add("containsAA");
        properties.add("Tabs");
        properties.add("orientation");
        properties.add("outputColorSpace");
        mapOfProperties.put("PDPage", properties);
        properties = new ArrayList<String>();
        properties.add("colorSpaceType");
        mapOfProperties.put("TransparencyColorSpace", properties);
        properties = new ArrayList<String>();
        properties.add("sameOutputProfileIndirect");
        mapOfProperties.put("OutputIntents", properties);
        properties = new ArrayList<String>();
        properties.add("containsUndefinedResource");
        mapOfProperties.put("PDContentStream", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDSemanticContentStream", properties);
        properties = new ArrayList<String>();
        properties.add("isInherited");
        mapOfProperties.put("PDResource", properties);
        properties = new ArrayList<String>();
        properties.add("nrComponents");
        mapOfProperties.put("PDColorSpace", properties);
        properties = new ArrayList<String>();
        properties.add("containsOtherActions");
        mapOfProperties.put("PDAdditionalActions", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDDeviceGray", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDDeviceRGB", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDDeviceCMYK", properties);
        properties = new ArrayList<String>();
        properties.add("ICCProfileIndirect");
        properties.add("currentTransparencyProfileIndirect");
        properties.add("ICCProfileMD5");
        properties.add("currentTransparencyICCProfileMD5");
        mapOfProperties.put("PDICCBased", properties);
        properties = new ArrayList<String>();
        properties.add("OPM");
        properties.add("overprintFlag");
        mapOfProperties.put("PDICCBasedCMYK", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDLab", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDCalGray", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDCalRGB", properties);
        properties = new ArrayList<String>();
        properties.add("name");
        properties.add("areTintAndAlternateConsistent");
        mapOfProperties.put("PDSeparation", properties);
        properties = new ArrayList<String>();
        properties.add("areColorantsPresent");
        mapOfProperties.put("PDDeviceN", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDIndexed", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDPattern", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDTilingPattern", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDShadingPattern", properties);
        properties = new ArrayList<String>();
        properties.add("Type");
        properties.add("Subtype");
        properties.add("fontName");
        properties.add("isSymbolic");
        properties.add("renderingMode");
        properties.add("fontFileSubtype");
        properties.add("isItalic");
        mapOfProperties.put("PDFont", properties);
        properties = new ArrayList<String>();
        properties.add("isStandard");
        properties.add("FirstChar");
        properties.add("LastChar");
        properties.add("Widths_size");
        properties.add("Encoding");
        properties.add("containsDifferences");
        mapOfProperties.put("PDSimpleFont", properties);
        properties = new ArrayList<String>();
        properties.add("differencesAreUnicodeCompliant");
        mapOfProperties.put("PDTrueTypeFont", properties);
        properties = new ArrayList<String>();
        properties.add("CharSet");
        properties.add("charSetListsAllGlyphs");
        mapOfProperties.put("PDType1Font", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDType3Font", properties);
        properties = new ArrayList<String>();
        properties.add("CIDToGIDMap");
        properties.add("cidSetListsAllGlyphs");
        mapOfProperties.put("PDCIDFont", properties);
        properties = new ArrayList<String>();
        properties.add("areRegistryOrderingCompatible");
        properties.add("isSupplementCompatible");
        properties.add("cmapName");
        mapOfProperties.put("PDType0Font", properties);
        properties = new ArrayList<String>();
        properties.add("CMapName");
        mapOfProperties.put("PDCMap", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDReferencedCMap", properties);
        properties = new ArrayList<String>();
        properties.add("Subtype");
        properties.add("containsOPI");
        properties.add("containsSMask");
        mapOfProperties.put("PDXObject", properties);
        properties = new ArrayList<String>();
        properties.add("Interpolate");
        properties.add("containsAlternates");
        mapOfProperties.put("PDXImage", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDSMaskImage", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDInlineImage", properties);
        properties = new ArrayList<String>();
        properties.add("Subtype2");
        properties.add("containsPS");
        properties.add("containsRef");
        properties.add("isUniqueSemanticParent");
        mapOfProperties.put("PDXForm", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDResources", properties);
        properties = new ArrayList<String>();
        properties.add("S");
        mapOfProperties.put("PDGroup", properties);
        properties = new ArrayList<String>();
        properties.add("TR");
        properties.add("TR2");
        properties.add("containsHTP");
        properties.add("containsHTO");
        properties.add("SMask");
        properties.add("BM");
        properties.add("ca");
        properties.add("CA");
        mapOfProperties.put("PDExtGState", properties);
        properties = new ArrayList<String>();
        properties.add("HalftoneType");
        properties.add("HalftoneName");
        properties.add("colorantName");
        properties.add("TransferFunction");
        mapOfProperties.put("PDHalftone", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDShading", properties);
        properties = new ArrayList<String>();
        properties.add("Subtype");
        properties.add("CA");
        properties.add("F");
        properties.add("AP");
        properties.add("FT");
        properties.add("N_type");
        properties.add("width");
        properties.add("height");
        properties.add("containsA");
        properties.add("containsAA");
        properties.add("structParentType");
        properties.add("Contents");
        properties.add("Alt");
        properties.add("isOutsideCropBox");
        mapOfProperties.put("PDAnnot", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PD3DAnnot", properties);
        properties = new ArrayList<String>();
        properties.add("TU");
        mapOfProperties.put("PDWidgetAnnot", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDPrinterMarkAnnot", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDLinkAnnot", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDTrapNetAnnot", properties);
        properties = new ArrayList<String>();
        properties.add("Subtype");
        mapOfProperties.put("PD3DStream", properties);
        properties = new ArrayList<String>();
        properties.add("NeedAppearances");
        properties.add("containsXFA");
        properties.add("dynamicRender");
        mapOfProperties.put("PDAcroForm", properties);
        properties = new ArrayList<String>();
        properties.add("FT");
        properties.add("containsAA");
        properties.add("TU");
        mapOfProperties.put("PDFormField", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDSignatureField", properties);
        properties = new ArrayList<String>();
        properties.add("doesByteRangeCoverEntireDocument");
        mapOfProperties.put("PDSignature", properties);
        properties = new ArrayList<String>();
        properties.add("S");
        mapOfProperties.put("PDAction", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDRenditionAction", properties);
        properties = new ArrayList<String>();
        properties.add("P");
        mapOfProperties.put("PDEncryption", properties);
        properties = new ArrayList<String>();
        properties.add("CT");
        properties.add("Alt");
        properties.add("hasCorrectAlt");
        mapOfProperties.put("PDMediaClip", properties);
        properties = new ArrayList<String>();
        properties.add("N");
        mapOfProperties.put("PDNamedAction", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDGoToAction", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDGoToRemoteAction", properties);
        properties = new ArrayList<String>();
        properties.add("Filter");
        mapOfProperties.put("PDMetadata", properties);
        properties = new ArrayList<String>();
        properties.add("destOutputProfileIndirect");
        properties.add("containsDestOutputProfileRef");
        properties.add("OutputConditionIdentifier");
        properties.add("S");
        properties.add("ICCProfileMD5");
        mapOfProperties.put("PDOutputIntent", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDOCProperties", properties);
        properties = new ArrayList<String>();
        properties.add("Name");
        properties.add("hasDuplicateName");
        properties.add("AS");
        properties.add("doesOrderContainAllOCGs");
        mapOfProperties.put("PDOCConfig", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDOutline", properties);
        properties = new ArrayList<String>();
        properties.add("topLevelFirstElementStandartType");
        properties.add("kidsStandardTypes");
        properties.add("hasContentItems");
        mapOfProperties.put("PDStructTreeRoot", properties);
        properties = new ArrayList<String>();
        properties.add("Type");
        properties.add("kidsStandardTypes");
        properties.add("parentStandardType");
        properties.add("hasContentItems");
        properties.add("standardType");
        properties.add("parentLang");
        properties.add("isRemappedStandardType");
        properties.add("Alt");
        properties.add("ActualText");
        properties.add("E");
        properties.add("circularMappingExist");
        mapOfProperties.put("PDStructElem", properties);
        properties = new ArrayList<String>();
        properties.add("containsOtherEntries");
        mapOfProperties.put("PDPerms", properties);
        properties = new ArrayList<String>();
        properties.add("containsDigestEntries");
        properties.add("permsContainDocMDP");
        mapOfProperties.put("PDSigRef", properties);
        properties = new ArrayList<String>();
        properties.add("FunctionType");
        mapOfProperties.put("PDFunction", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDType0Function", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDType2Function", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDType3Function", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDType4Function", properties);
        links = new ArrayList<String>();
        mapOfLinks.put("PDObject", links);
        links = new ArrayList<String>();
        links.add("outputIntents");
        links.add("pages");
        links.add("metadata");
        links.add("AcroForm");
        links.add("AA");
        links.add("OpenAction");
        links.add("Outlines");
        links.add("OCProperties");
        links.add("StructTreeRoot");
        links.add("Lang");
        links.add("Perms");
        mapOfLinks.put("PDDocument", links);
        links = new ArrayList<String>();
        links.add("outputIntents");
        links.add("annots");
        links.add("AA");
        links.add("transparencyColorSpace");
        links.add("contentStream");
        links.add("parentTransparencyColorSpace");
        links.add("Group");
        links.add("MediaBox");
        links.add("CropBox");
        links.add("BleedBox");
        links.add("TrimBox");
        links.add("ArtBox");
        links.add("resources");
        mapOfLinks.put("PDPage", links);
        links = new ArrayList<String>();
        mapOfLinks.put("TransparencyColorSpace", links);
        links = new ArrayList<String>();
        links.add("outputIntents");
        mapOfLinks.put("OutputIntents", links);
        links = new ArrayList<String>();
        links.add("operators");
        links.add("resources");
        mapOfLinks.put("PDContentStream", links);
        links = new ArrayList<String>();
        links.add("content");
        mapOfLinks.put("PDSemanticContentStream", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDResource", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDColorSpace", links);
        links = new ArrayList<String>();
        links.add("Actions");
        mapOfLinks.put("PDAdditionalActions", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDDeviceGray", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDDeviceRGB", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDDeviceCMYK", links);
        links = new ArrayList<String>();
        links.add("iccProfile");
        mapOfLinks.put("PDICCBased", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDICCBasedCMYK", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDLab", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDCalGray", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDCalRGB", links);
        links = new ArrayList<String>();
        links.add("tintTransform");
        links.add("alternate");
        links.add("colorantName");
        mapOfLinks.put("PDSeparation", links);
        links = new ArrayList<String>();
        links.add("tintTransform");
        links.add("alternate");
        links.add("colorantNames");
        links.add("Colorants");
        links.add("processColor");
        mapOfLinks.put("PDDeviceN", links);
        links = new ArrayList<String>();
        links.add("base");
        mapOfLinks.put("PDIndexed", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDPattern", links);
        links = new ArrayList<String>();
        links.add("contentStream");
        mapOfLinks.put("PDTilingPattern", links);
        links = new ArrayList<String>();
        links.add("shading");
        mapOfLinks.put("PDShadingPattern", links);
        links = new ArrayList<String>();
        links.add("BaseFont");
        links.add("fontFile");
        mapOfLinks.put("PDFont", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDSimpleFont", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDTrueTypeFont", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDType1Font", links);
        links = new ArrayList<String>();
        links.add("charStrings");
        mapOfLinks.put("PDType3Font", links);
        links = new ArrayList<String>();
        links.add("CIDSet");
        mapOfLinks.put("PDCIDFont", links);
        links = new ArrayList<String>();
        links.add("DescendantFonts");
        links.add("Encoding");
        mapOfLinks.put("PDType0Font", links);
        links = new ArrayList<String>();
        links.add("UseCMap");
        links.add("embeddedFile");
        mapOfLinks.put("PDCMap", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDReferencedCMap", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDXObject", links);
        links = new ArrayList<String>();
        links.add("imageCS");
        links.add("Alternates");
        links.add("Intent");
        links.add("jpxStream");
        links.add("SMask");
        mapOfLinks.put("PDXImage", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDSMaskImage", links);
        links = new ArrayList<String>();
        links.add("F");
        mapOfLinks.put("PDInlineImage", links);
        links = new ArrayList<String>();
        links.add("transparencyColorSpace");
        links.add("contentStream");
        links.add("parentTransparencyColorSpace");
        links.add("Group");
        mapOfLinks.put("PDXForm", links);
        links = new ArrayList<String>();
        links.add("resourcesNames");
        mapOfLinks.put("PDResources", links);
        links = new ArrayList<String>();
        links.add("colorSpace");
        mapOfLinks.put("PDGroup", links);
        links = new ArrayList<String>();
        links.add("HT");
        links.add("bm");
        links.add("RI");
        links.add("fontSize");
        links.add("customFunctions");
        mapOfLinks.put("PDExtGState", links);
        links = new ArrayList<String>();
        links.add("customFunction");
        links.add("halftones");
        mapOfLinks.put("PDHalftone", links);
        links = new ArrayList<String>();
        links.add("colorSpace");
        mapOfLinks.put("PDShading", links);
        links = new ArrayList<String>();
        links.add("appearance");
        links.add("C");
        links.add("IC");
        links.add("A");
        links.add("AA");
        links.add("Lang");
        links.add("BM");
        mapOfLinks.put("PDAnnot", links);
        links = new ArrayList<String>();
        links.add("stream3D");
        mapOfLinks.put("PD3DAnnot", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDWidgetAnnot", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDPrinterMarkAnnot", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDLinkAnnot", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDTrapNetAnnot", links);
        links = new ArrayList<String>();
        links.add("colorSpace");
        mapOfLinks.put("PD3DStream", links);
        links = new ArrayList<String>();
        links.add("formFields");
        mapOfLinks.put("PDAcroForm", links);
        links = new ArrayList<String>();
        links.add("AA");
        links.add("Lang");
        mapOfLinks.put("PDFormField", links);
        links = new ArrayList<String>();
        links.add("V");
        mapOfLinks.put("PDSignatureField", links);
        links = new ArrayList<String>();
        links.add("Contents");
        links.add("Reference");
        mapOfLinks.put("PDSignature", links);
        links = new ArrayList<String>();
        links.add("Next");
        mapOfLinks.put("PDAction", links);
        links = new ArrayList<String>();
        links.add("C");
        mapOfLinks.put("PDRenditionAction", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDEncryption", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDMediaClip", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDNamedAction", links);
        links = new ArrayList<String>();
        links.add("D");
        mapOfLinks.put("PDGoToAction", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDGoToRemoteAction", links);
        links = new ArrayList<String>();
        links.add("XMPPackage");
        links.add("stream");
        mapOfLinks.put("PDMetadata", links);
        links = new ArrayList<String>();
        links.add("destProfile");
        mapOfLinks.put("PDOutputIntent", links);
        links = new ArrayList<String>();
        links.add("D");
        links.add("Configs");
        mapOfLinks.put("PDOCProperties", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDOCConfig", links);
        links = new ArrayList<String>();
        links.add("A");
        mapOfLinks.put("PDOutline", links);
        links = new ArrayList<String>();
        links.add("K");
        links.add("roleMapNames");
        mapOfLinks.put("PDStructTreeRoot", links);
        links = new ArrayList<String>();
        links.add("K");
        links.add("S");
        links.add("Lang");
        links.add("actualText");
        mapOfLinks.put("PDStructElem", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDPerms", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDSigRef", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDFunction", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDType0Function", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDType2Function", links);
        links = new ArrayList<String>();
        links.add("Functions");
        mapOfLinks.put("PDType3Function", links);
        links = new ArrayList<String>();
        links.add("operators");
        mapOfLinks.put("PDType4Function", links);
        mapOfSuperNames.put("External", "Object");
        mapOfSuperNames.put("ICCProfile", "External");
        mapOfSuperNames.put("ICCInputProfile", "ICCProfile");
        mapOfSuperNames.put("ICCOutputProfile", "ICCProfile");
        mapOfSuperNames.put("FontProgram", "External");
        mapOfSuperNames.put("TrueTypeFontProgram", "FontProgram");
        mapOfSuperNames.put("CMapFile", "External");
        mapOfSuperNames.put("JPEG2000", "External");
        mapOfSuperNames.put("EmbeddedFile", "External");
        mapOfSuperNames.put("PKCSDataObject", "External");
        properties = new ArrayList<String>();
        mapOfProperties.put("External", properties);
        properties = new ArrayList<String>();
        properties.add("N");
        properties.add("deviceClass");
        properties.add("colorSpace");
        properties.add("version");
        properties.add("isValid");
        mapOfProperties.put("ICCProfile", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("ICCInputProfile", properties);
        properties = new ArrayList<String>();
        properties.add("S");
        mapOfProperties.put("ICCOutputProfile", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("FontProgram", properties);
        properties = new ArrayList<String>();
        properties.add("isSymbolic");
        properties.add("nrCmaps");
        properties.add("cmap30Present");
        properties.add("cmap31Present");
        properties.add("cmap10Present");
        mapOfProperties.put("TrueTypeFontProgram", properties);
        properties = new ArrayList<String>();
        properties.add("WMode");
        properties.add("dictWMode");
        properties.add("maximalCID");
        mapOfProperties.put("CMapFile", properties);
        properties = new ArrayList<String>();
        properties.add("nrColorChannels");
        properties.add("nrColorSpaceSpecs");
        properties.add("nrColorSpacesWithApproxField");
        properties.add("colrMethod");
        properties.add("colrEnumCS");
        properties.add("bitDepth");
        properties.add("bpccBoxPresent");
        properties.add("hasColorSpace");
        mapOfProperties.put("JPEG2000", properties);
        properties = new ArrayList<String>();
        properties.add("Subtype");
        properties.add("isValidPDFA12");
        properties.add("isValidPDFA124");
        mapOfProperties.put("EmbeddedFile", properties);
        properties = new ArrayList<String>();
        properties.add("SignerInfoCount");
        properties.add("signingCertificatePresent");
        mapOfProperties.put("PKCSDataObject", properties);
        links = new ArrayList<String>();
        mapOfLinks.put("External", links);
        links = new ArrayList<String>();
        mapOfLinks.put("ICCProfile", links);
        links = new ArrayList<String>();
        mapOfLinks.put("ICCInputProfile", links);
        links = new ArrayList<String>();
        mapOfLinks.put("ICCOutputProfile", links);
        links = new ArrayList<String>();
        mapOfLinks.put("FontProgram", links);
        links = new ArrayList<String>();
        mapOfLinks.put("TrueTypeFontProgram", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CMapFile", links);
        links = new ArrayList<String>();
        mapOfLinks.put("JPEG2000", links);
        links = new ArrayList<String>();
        mapOfLinks.put("EmbeddedFile", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PKCSDataObject", links);
        mapOfSuperNames.put("XMPObject", "Object");
        mapOfSuperNames.put("XMPPackage", "XMPObject");
        mapOfSuperNames.put("MainXMPPackage", "XMPPackage");
        mapOfSuperNames.put("XMPProperty", "XMPObject");
        mapOfSuperNames.put("XMPMMHistoryProperty", "XMPProperty");
        mapOfSuperNames.put("XMPLangAlt", "XMPProperty");
        mapOfSuperNames.put("XMPMMHistoryResourceEvent", "XMPObject");
        mapOfSuperNames.put("PDFAIdentification", "XMPObject");
        mapOfSuperNames.put("PDFUAIdentification", "XMPObject");
        mapOfSuperNames.put("ExtensionSchemaObject", "XMPObject");
        mapOfSuperNames.put("ExtensionSchemasContainer", "XMPObject");
        mapOfSuperNames.put("ExtensionSchemaDefinition", "ExtensionSchemaObject");
        mapOfSuperNames.put("ExtensionSchemaProperty", "ExtensionSchemaObject");
        mapOfSuperNames.put("ExtensionSchemaValueType", "ExtensionSchemaObject");
        mapOfSuperNames.put("ExtensionSchemaField", "ExtensionSchemaObject");
        properties = new ArrayList<String>();
        mapOfProperties.put("XMPObject", properties);
        properties = new ArrayList<String>();
        properties.add("isSerializationValid");
        properties.add("actualEncoding");
        properties.add("bytes");
        properties.add("encoding");
        mapOfProperties.put("XMPPackage", properties);
        properties = new ArrayList<String>();
        properties.add("dc_title");
        mapOfProperties.put("MainXMPPackage", properties);
        properties = new ArrayList<String>();
        properties.add("isPredefinedInXMP2004");
        properties.add("isPredefinedInXMP2005");
        properties.add("isDefinedInCurrentPackage");
        properties.add("isDefinedInMainPackage");
        properties.add("isValueTypeCorrect");
        mapOfProperties.put("XMPProperty", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("XMPMMHistoryProperty", properties);
        properties = new ArrayList<String>();
        properties.add("xDefault");
        mapOfProperties.put("XMPLangAlt", properties);
        properties = new ArrayList<String>();
        properties.add("action");
        properties.add("parameters");
        properties.add("when");
        mapOfProperties.put("XMPMMHistoryResourceEvent", properties);
        properties = new ArrayList<String>();
        properties.add("part");
        properties.add("conformance");
        properties.add("rev");
        properties.add("partPrefix");
        properties.add("conformancePrefix");
        properties.add("amdPrefix");
        properties.add("corrPrefix");
        properties.add("revPrefix");
        mapOfProperties.put("PDFAIdentification", properties);
        properties = new ArrayList<String>();
        properties.add("part");
        mapOfProperties.put("PDFUAIdentification", properties);
        properties = new ArrayList<String>();
        properties.add("containsUndefinedFields");
        mapOfProperties.put("ExtensionSchemaObject", properties);
        properties = new ArrayList<String>();
        properties.add("prefix");
        properties.add("isValidBag");
        mapOfProperties.put("ExtensionSchemasContainer", properties);
        properties = new ArrayList<String>();
        properties.add("isNamespaceURIValidURI");
        properties.add("isPrefixValidText");
        properties.add("isPropertyValidSeq");
        properties.add("isSchemaValidText");
        properties.add("isValueTypeValidSeq");
        properties.add("namespaceURIPrefix");
        properties.add("prefixPrefix");
        properties.add("propertyPrefix");
        properties.add("schemaPrefix");
        properties.add("valueTypePrefix");
        mapOfProperties.put("ExtensionSchemaDefinition", properties);
        properties = new ArrayList<String>();
        properties.add("category");
        properties.add("isCategoryValidText");
        properties.add("isDescriptionValidText");
        properties.add("isNameValidText");
        properties.add("isValueTypeValidText");
        properties.add("isValueTypeDefined");
        properties.add("categoryPrefix");
        properties.add("descriptionPrefix");
        properties.add("namePrefix");
        properties.add("valueTypePrefix");
        mapOfProperties.put("ExtensionSchemaProperty", properties);
        properties = new ArrayList<String>();
        properties.add("isDescriptionValidText");
        properties.add("isFieldValidSeq");
        properties.add("isNamespaceURIValidURI");
        properties.add("isPrefixValidText");
        properties.add("isTypeValidText");
        properties.add("descriptionPrefix");
        properties.add("fieldPrefix");
        properties.add("namespaceURIPrefix");
        properties.add("prefixPrefix");
        properties.add("typePrefix");
        mapOfProperties.put("ExtensionSchemaValueType", properties);
        properties = new ArrayList<String>();
        properties.add("isDescriptionValidText");
        properties.add("isNameValidText");
        properties.add("isValueTypeValidText");
        properties.add("isValueTypeDefined");
        properties.add("descriptionPrefix");
        properties.add("namePrefix");
        properties.add("valueTypePrefix");
        mapOfProperties.put("ExtensionSchemaField", properties);
        links = new ArrayList<String>();
        mapOfLinks.put("XMPObject", links);
        links = new ArrayList<String>();
        links.add("Properties");
        links.add("ExtensionSchemasContainers");
        mapOfLinks.put("XMPPackage", links);
        links = new ArrayList<String>();
        links.add("Identification");
        links.add("UAIdentification");
        mapOfLinks.put("MainXMPPackage", links);
        links = new ArrayList<String>();
        mapOfLinks.put("XMPProperty", links);
        links = new ArrayList<String>();
        links.add("ResourceEvents");
        mapOfLinks.put("XMPMMHistoryProperty", links);
        links = new ArrayList<String>();
        mapOfLinks.put("XMPLangAlt", links);
        links = new ArrayList<String>();
        mapOfLinks.put("XMPMMHistoryResourceEvent", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDFAIdentification", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDFUAIdentification", links);
        links = new ArrayList<String>();
        mapOfLinks.put("ExtensionSchemaObject", links);
        links = new ArrayList<String>();
        links.add("ExtensionSchemaDefinitions");
        mapOfLinks.put("ExtensionSchemasContainer", links);
        links = new ArrayList<String>();
        links.add("ExtensionSchemaProperties");
        links.add("ExtensionSchemaValueTypes");
        mapOfLinks.put("ExtensionSchemaDefinition", links);
        links = new ArrayList<String>();
        mapOfLinks.put("ExtensionSchemaProperty", links);
        links = new ArrayList<String>();
        links.add("ExtensionSchemaFields");
        mapOfLinks.put("ExtensionSchemaValueType", links);
        links = new ArrayList<String>();
        mapOfLinks.put("ExtensionSchemaField", links);
        mapOfSuperNames.put("Operator", "Object");
        mapOfSuperNames.put("OpGeneralGS", "Operator");
        mapOfSuperNames.put("Op_w_line_width", "OpGeneralGS");
        mapOfSuperNames.put("Op_J_line_cap", "OpGeneralGS");
        mapOfSuperNames.put("Op_j_line_join", "OpGeneralGS");
        mapOfSuperNames.put("Op_M_miter_limit", "OpGeneralGS");
        mapOfSuperNames.put("Op_d", "OpGeneralGS");
        mapOfSuperNames.put("Op_ri", "OpGeneralGS");
        mapOfSuperNames.put("Op_i", "OpGeneralGS");
        mapOfSuperNames.put("Op_gs", "OpGeneralGS");
        mapOfSuperNames.put("OpSpecialGS", "Operator");
        mapOfSuperNames.put("Op_q_gsave", "OpSpecialGS");
        mapOfSuperNames.put("Op_Q_grestore", "OpSpecialGS");
        mapOfSuperNames.put("Op_cm", "OpSpecialGS");
        mapOfSuperNames.put("OpPathConstruction", "Operator");
        mapOfSuperNames.put("Op_m_moveto", "OpPathConstruction");
        mapOfSuperNames.put("Op_l", "OpPathConstruction");
        mapOfSuperNames.put("Op_c", "OpPathConstruction");
        mapOfSuperNames.put("Op_v", "OpPathConstruction");
        mapOfSuperNames.put("Op_y", "OpPathConstruction");
        mapOfSuperNames.put("Op_h", "OpPathConstruction");
        mapOfSuperNames.put("Op_re", "OpPathConstruction");
        mapOfSuperNames.put("OpPathPaint", "Operator");
        mapOfSuperNames.put("Op_s_close_stroke", "OpPathPaint");
        mapOfSuperNames.put("Op_S_stroke", "OpPathPaint");
        mapOfSuperNames.put("Op_f_fill", "OpPathPaint");
        mapOfSuperNames.put("Op_F_fill_obsolete", "OpPathPaint");
        mapOfSuperNames.put("Op_FStar", "OpPathPaint");
        mapOfSuperNames.put("Op_B_fill_stroke", "OpPathPaint");
        mapOfSuperNames.put("Op_BStar_eofill_stroke", "OpPathPaint");
        mapOfSuperNames.put("Op_b_closepath_fill_stroke", "OpPathPaint");
        mapOfSuperNames.put("Op_bstar_closepath_eofill_stroke", "OpPathPaint");
        mapOfSuperNames.put("Op_n", "OpPathPaint");
        mapOfSuperNames.put("OpClip", "Operator");
        mapOfSuperNames.put("Op_W_clip", "OpClip");
        mapOfSuperNames.put("Op_WStar", "OpClip");
        mapOfSuperNames.put("OpTextObject", "Operator");
        mapOfSuperNames.put("Op_ET", "OpTextObject");
        mapOfSuperNames.put("Op_BT", "OpTextObject");
        mapOfSuperNames.put("OpTextState", "Operator");
        mapOfSuperNames.put("Op_Tz", "OpTextState");
        mapOfSuperNames.put("Op_Tr", "OpTextState");
        mapOfSuperNames.put("Op_Tc", "OpTextState");
        mapOfSuperNames.put("Op_Tf", "OpTextState");
        mapOfSuperNames.put("Op_Tl", "OpTextState");
        mapOfSuperNames.put("Op_Ts", "OpTextState");
        mapOfSuperNames.put("Op_Tw", "OpTextState");
        mapOfSuperNames.put("OpTextPosition", "Operator");
        mapOfSuperNames.put("Op_Td", "OpTextPosition");
        mapOfSuperNames.put("Op_TD_Big", "OpTextPosition");
        mapOfSuperNames.put("Op_Tm", "OpTextPosition");
        mapOfSuperNames.put("Op_T_Star", "OpTextPosition");
        mapOfSuperNames.put("OpTextShow", "Operator");
        mapOfSuperNames.put("Op_Tj", "OpTextShow");
        mapOfSuperNames.put("Op_TJ_Big", "OpTextShow");
        mapOfSuperNames.put("Op_Quote", "OpTextShow");
        mapOfSuperNames.put("Op_DoubleQuote", "OpTextShow");
        mapOfSuperNames.put("OpType3Font", "Operator");
        mapOfSuperNames.put("Op_d0", "OpType3Font");
        mapOfSuperNames.put("Op_d1", "OpType3Font");
        mapOfSuperNames.put("OpSetColor", "Operator");
        mapOfSuperNames.put("Op_SC_stroke", "OpSetColor");
        mapOfSuperNames.put("Op_sc_fill", "OpSetColor");
        mapOfSuperNames.put("OpColor", "OpSetColor");
        mapOfSuperNames.put("Op_SCN_stroke", "OpColor");
        mapOfSuperNames.put("Op_scn_fill", "OpColor");
        mapOfSuperNames.put("Op_G_stroke", "OpColor");
        mapOfSuperNames.put("Op_g_fill", "OpColor");
        mapOfSuperNames.put("Op_RG_stroke", "OpColor");
        mapOfSuperNames.put("Op_rg_fill", "OpColor");
        mapOfSuperNames.put("Op_K_stroke", "OpColor");
        mapOfSuperNames.put("Op_k_fill", "OpColor");
        mapOfSuperNames.put("OpShading", "Operator");
        mapOfSuperNames.put("Op_sh", "OpShading");
        mapOfSuperNames.put("OpInlineImage", "Operator");
        mapOfSuperNames.put("Op_BI", "OpInlineImage");
        mapOfSuperNames.put("Op_ID", "OpInlineImage");
        mapOfSuperNames.put("Op_EI", "OpInlineImage");
        mapOfSuperNames.put("OpXObject", "Operator");
        mapOfSuperNames.put("Op_Do", "OpXObject");
        mapOfSuperNames.put("OpMarkedContent", "Operator");
        mapOfSuperNames.put("Op_MP", "OpMarkedContent");
        mapOfSuperNames.put("Op_DP", "OpMarkedContent");
        mapOfSuperNames.put("Op_BMC", "OpMarkedContent");
        mapOfSuperNames.put("Op_BDC", "OpMarkedContent");
        mapOfSuperNames.put("Op_EMC", "OpMarkedContent");
        mapOfSuperNames.put("OpCompatibility", "Operator");
        mapOfSuperNames.put("Op_BX", "OpCompatibility");
        mapOfSuperNames.put("Op_EX", "OpCompatibility");
        mapOfSuperNames.put("Op_Undefined", "OpCompatibility");
        mapOfSuperNames.put("Glyph", "Object");
        mapOfSuperNames.put("CIDGlyph", "Glyph");
        properties = new ArrayList<String>();
        mapOfProperties.put("Operator", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpGeneralGS", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_w_line_width", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_J_line_cap", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_j_line_join", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_M_miter_limit", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_d", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_ri", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_i", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_gs", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpSpecialGS", properties);
        properties = new ArrayList<String>();
        properties.add("nestingLevel");
        mapOfProperties.put("Op_q_gsave", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Q_grestore", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_cm", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpPathConstruction", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_m_moveto", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_l", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_c", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_v", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_y", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_h", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_re", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpPathPaint", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_s_close_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_S_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_f_fill", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_F_fill_obsolete", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_FStar", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_B_fill_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_BStar_eofill_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_b_closepath_fill_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_bstar_closepath_eofill_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_n", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpClip", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_W_clip", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_WStar", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpTextObject", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_ET", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_BT", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpTextState", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tz", properties);
        properties = new ArrayList<String>();
        properties.add("renderingMode");
        mapOfProperties.put("Op_Tr", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tc", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tf", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tl", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Ts", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tw", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpTextPosition", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Td", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_TD_Big", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tm", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_T_Star", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpTextShow", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tj", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_TJ_Big", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Quote", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_DoubleQuote", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpType3Font", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_d0", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_d1", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpSetColor", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_SC_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_sc_fill", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpColor", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_SCN_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_scn_fill", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_G_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_g_fill", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_RG_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_rg_fill", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_K_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_k_fill", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpShading", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_sh", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpInlineImage", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_BI", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_ID", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_EI", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpXObject", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Do", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpMarkedContent", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_MP", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_DP", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_BMC", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_BDC", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_EMC", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpCompatibility", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_BX", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_EX", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Undefined", properties);
        properties = new ArrayList<String>();
        properties.add("name");
        properties.add("isWidthConsistent");
        properties.add("isGlyphPresent");
        properties.add("toUnicode");
        properties.add("renderingMode");
        properties.add("unicodePUA");
        properties.add("actualTextPresent");
        mapOfProperties.put("Glyph", properties);
        properties = new ArrayList<String>();
        properties.add("CID");
        mapOfProperties.put("CIDGlyph", properties);
        links = new ArrayList<String>();
        mapOfLinks.put("Operator", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpGeneralGS", links);
        links = new ArrayList<String>();
        links.add("lineWidth");
        mapOfLinks.put("Op_w_line_width", links);
        links = new ArrayList<String>();
        links.add("lineCap");
        mapOfLinks.put("Op_J_line_cap", links);
        links = new ArrayList<String>();
        links.add("lineJoin");
        mapOfLinks.put("Op_j_line_join", links);
        links = new ArrayList<String>();
        links.add("miterLimit");
        mapOfLinks.put("Op_M_miter_limit", links);
        links = new ArrayList<String>();
        links.add("dashArray");
        links.add("dashPhase");
        mapOfLinks.put("Op_d", links);
        links = new ArrayList<String>();
        links.add("renderingIntent");
        mapOfLinks.put("Op_ri", links);
        links = new ArrayList<String>();
        links.add("flatness");
        mapOfLinks.put("Op_i", links);
        links = new ArrayList<String>();
        links.add("extGState");
        mapOfLinks.put("Op_gs", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpSpecialGS", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_q_gsave", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_Q_grestore", links);
        links = new ArrayList<String>();
        links.add("matrix");
        mapOfLinks.put("Op_cm", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpPathConstruction", links);
        links = new ArrayList<String>();
        links.add("point");
        mapOfLinks.put("Op_m_moveto", links);
        links = new ArrayList<String>();
        links.add("point");
        mapOfLinks.put("Op_l", links);
        links = new ArrayList<String>();
        links.add("controlPoints");
        mapOfLinks.put("Op_c", links);
        links = new ArrayList<String>();
        links.add("controlPoints");
        mapOfLinks.put("Op_v", links);
        links = new ArrayList<String>();
        links.add("controlPoints");
        mapOfLinks.put("Op_y", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_h", links);
        links = new ArrayList<String>();
        links.add("rectBox");
        mapOfLinks.put("Op_re", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpPathPaint", links);
        links = new ArrayList<String>();
        links.add("strokeCS");
        mapOfLinks.put("Op_s_close_stroke", links);
        links = new ArrayList<String>();
        links.add("strokeCS");
        mapOfLinks.put("Op_S_stroke", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        mapOfLinks.put("Op_f_fill", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        mapOfLinks.put("Op_F_fill_obsolete", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        mapOfLinks.put("Op_FStar", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        links.add("strokeCS");
        mapOfLinks.put("Op_B_fill_stroke", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        links.add("strokeCS");
        mapOfLinks.put("Op_BStar_eofill_stroke", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        links.add("strokeCS");
        mapOfLinks.put("Op_b_closepath_fill_stroke", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        links.add("strokeCS");
        mapOfLinks.put("Op_bstar_closepath_eofill_stroke", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_n", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpClip", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_W_clip", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_WStar", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpTextObject", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_ET", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_BT", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpTextState", links);
        links = new ArrayList<String>();
        links.add("scale");
        mapOfLinks.put("Op_Tz", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_Tr", links);
        links = new ArrayList<String>();
        links.add("charSpace");
        mapOfLinks.put("Op_Tc", links);
        links = new ArrayList<String>();
        links.add("size");
        links.add("fontName");
        mapOfLinks.put("Op_Tf", links);
        links = new ArrayList<String>();
        links.add("leading");
        mapOfLinks.put("Op_Tl", links);
        links = new ArrayList<String>();
        links.add("rise");
        mapOfLinks.put("Op_Ts", links);
        links = new ArrayList<String>();
        links.add("wordSpace");
        mapOfLinks.put("Op_Tw", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpTextPosition", links);
        links = new ArrayList<String>();
        links.add("horizontalOffset");
        links.add("verticalOffset");
        mapOfLinks.put("Op_Td", links);
        links = new ArrayList<String>();
        links.add("horizontalOffset");
        links.add("verticalOffset");
        mapOfLinks.put("Op_TD_Big", links);
        links = new ArrayList<String>();
        links.add("controlPoints");
        mapOfLinks.put("Op_Tm", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_T_Star", links);
        links = new ArrayList<String>();
        links.add("font");
        links.add("usedGlyphs");
        links.add("fillCS");
        links.add("strokeCS");
        mapOfLinks.put("OpTextShow", links);
        links = new ArrayList<String>();
        links.add("showString");
        mapOfLinks.put("Op_Tj", links);
        links = new ArrayList<String>();
        links.add("specialStrings");
        mapOfLinks.put("Op_TJ_Big", links);
        links = new ArrayList<String>();
        links.add("showString");
        mapOfLinks.put("Op_Quote", links);
        links = new ArrayList<String>();
        links.add("showString");
        links.add("wordSpacing");
        links.add("characterSpacing");
        mapOfLinks.put("Op_DoubleQuote", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpType3Font", links);
        links = new ArrayList<String>();
        links.add("horizontalDisplacement");
        links.add("verticalDisplacement");
        mapOfLinks.put("Op_d0", links);
        links = new ArrayList<String>();
        links.add("controlPoints");
        mapOfLinks.put("Op_d1", links);
        links = new ArrayList<String>();
        links.add("colorValues");
        mapOfLinks.put("OpSetColor", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_SC_stroke", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_sc_fill", links);
        links = new ArrayList<String>();
        links.add("colorSpace");
        links.add("patternName");
        mapOfLinks.put("OpColor", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_SCN_stroke", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_scn_fill", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_G_stroke", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_g_fill", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_RG_stroke", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_rg_fill", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_K_stroke", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_k_fill", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpShading", links);
        links = new ArrayList<String>();
        links.add("shading");
        mapOfLinks.put("Op_sh", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpInlineImage", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_BI", links);
        links = new ArrayList<String>();
        links.add("inlineImageDictionary");
        mapOfLinks.put("Op_ID", links);
        links = new ArrayList<String>();
        links.add("inlineImage");
        mapOfLinks.put("Op_EI", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpXObject", links);
        links = new ArrayList<String>();
        links.add("xObject");
        mapOfLinks.put("Op_Do", links);
        links = new ArrayList<String>();
        links.add("actualText");
        mapOfLinks.put("OpMarkedContent", links);
        links = new ArrayList<String>();
        links.add("tag");
        mapOfLinks.put("Op_MP", links);
        links = new ArrayList<String>();
        links.add("tag");
        links.add("properties");
        mapOfLinks.put("Op_DP", links);
        links = new ArrayList<String>();
        links.add("tag");
        mapOfLinks.put("Op_BMC", links);
        links = new ArrayList<String>();
        links.add("tag");
        links.add("properties");
        links.add("Lang");
        mapOfLinks.put("Op_BDC", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_EMC", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpCompatibility", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_BX", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_EX", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_Undefined", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Glyph", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CIDGlyph", links);
        mapOfSuperNames.put("SAPDFDocument", "Object");
        mapOfSuperNames.put("SAStructTreeRoot", "Object");
        mapOfSuperNames.put("SAStructElem", "Object");
        mapOfSuperNames.put("SAChunk", "Object");
        mapOfSuperNames.put("SAPage", "Object");
        mapOfSuperNames.put("SAAnnotation", "Object");
        mapOfSuperNames.put("SARepeatedCharacters", "Object");
        mapOfSuperNames.put("SALinkAnnotation", "SAAnnotation");
        mapOfSuperNames.put("SATextChunk", "SAChunk");
        mapOfSuperNames.put("SAImageChunk", "SAChunk");
        mapOfSuperNames.put("SADocument", "SAStructElem");
        mapOfSuperNames.put("SAPart", "SAStructElem");
        mapOfSuperNames.put("SADiv", "SAStructElem");
        mapOfSuperNames.put("SACaption", "SAStructElem");
        mapOfSuperNames.put("SAH", "SAStructElem");
        mapOfSuperNames.put("SAP", "SAStructElem");
        mapOfSuperNames.put("SAL", "SAStructElem");
        mapOfSuperNames.put("SALI", "SAStructElem");
        mapOfSuperNames.put("SALbl", "SAStructElem");
        mapOfSuperNames.put("SALBody", "SAStructElem");
        mapOfSuperNames.put("SATable", "SAStructElem");
        mapOfSuperNames.put("SATR", "SAStructElem");
        mapOfSuperNames.put("SATH", "SAStructElem");
        mapOfSuperNames.put("SATD", "SAStructElem");
        mapOfSuperNames.put("SASpan", "SAStructElem");
        mapOfSuperNames.put("SALink", "SAStructElem");
        mapOfSuperNames.put("SAArt", "SAStructElem");
        mapOfSuperNames.put("SASect", "SAStructElem");
        mapOfSuperNames.put("SABlockQuote", "SAStructElem");
        mapOfSuperNames.put("SATOC", "SAStructElem");
        mapOfSuperNames.put("SATOCI", "SAStructElem");
        mapOfSuperNames.put("SAIndex", "SAStructElem");
        mapOfSuperNames.put("SANonStruct", "SAStructElem");
        mapOfSuperNames.put("SAPrivate", "SAStructElem");
        mapOfSuperNames.put("SAQuote", "SAStructElem");
        mapOfSuperNames.put("SANote", "SAStructElem");
        mapOfSuperNames.put("SAReference", "SAStructElem");
        mapOfSuperNames.put("SABibEntry", "SAStructElem");
        mapOfSuperNames.put("SACode", "SAStructElem");
        mapOfSuperNames.put("SAHn", "SAStructElem");
        mapOfSuperNames.put("SAFigure", "SAStructElem");
        mapOfSuperNames.put("SAFormula", "SAStructElem");
        mapOfSuperNames.put("SAForm", "SAStructElem");
        mapOfSuperNames.put("SATHead", "SAStructElem");
        mapOfSuperNames.put("SATBody", "SAStructElem");
        mapOfSuperNames.put("SATFoot", "SAStructElem");
        mapOfSuperNames.put("SAAnnot", "SAStructElem");
        mapOfSuperNames.put("SARuby", "SAStructElem");
        mapOfSuperNames.put("SAWarichu", "SAStructElem");
        mapOfSuperNames.put("SARB", "SAStructElem");
        mapOfSuperNames.put("SART", "SAStructElem");
        mapOfSuperNames.put("SARP", "SAStructElem");
        mapOfSuperNames.put("SAWT", "SAStructElem");
        mapOfSuperNames.put("SAWP", "SAStructElem");
        mapOfSuperNames.put("SADocumentFragment", "SAStructElem");
        mapOfSuperNames.put("SAAside", "SAStructElem");
        mapOfSuperNames.put("SATitle", "SAStructElem");
        mapOfSuperNames.put("SAFENote", "SAStructElem");
        mapOfSuperNames.put("SASub", "SAStructElem");
        mapOfSuperNames.put("SAEm", "SAStructElem");
        mapOfSuperNames.put("SAStrong", "SAStructElem");
        mapOfSuperNames.put("SAArtifact", "SAStructElem");
        mapOfSuperNames.put("SANonStandard", "SAStructElem");
        properties = new ArrayList<String>();
        mapOfProperties.put("SAPDFDocument", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAStructTreeRoot", properties);
        properties = new ArrayList<String>();
        properties.add("correctSemanticScore");
        properties.add("hasCorrectType");
        properties.add("correctType");
        properties.add("standardType");
        properties.add("isTableElem");
        properties.add("isTableChild");
        properties.add("isListElem");
        properties.add("isListChild");
        properties.add("structureID");
        properties.add("isLeafElem");
        properties.add("numberOfSameCharacters");
        properties.add("numberOfRepeatedSpaces");
        properties.add("positionOfRepeatedSpaces");
        properties.add("parentsStandardTypes");
        mapOfProperties.put("SAStructElem", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAChunk", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAPage", properties);
        properties = new ArrayList<String>();
        properties.add("textValue");
        properties.add("F");
        properties.add("Contents");
        properties.add("Alt");
        properties.add("isOutsideCropBox");
        mapOfProperties.put("SAAnnotation", properties);
        properties = new ArrayList<String>();
        properties.add("isNonSpace");
        properties.add("numberOfRepeatedCharacters");
        mapOfProperties.put("SARepeatedCharacters", properties);
        properties = new ArrayList<String>();
        properties.add("textValueIsLink");
        properties.add("contentsIsLink");
        properties.add("altIsLink");
        mapOfProperties.put("SALinkAnnotation", properties);
        properties = new ArrayList<String>();
        properties.add("textSize");
        properties.add("contrastRatio");
        properties.add("textWeight");
        properties.add("hasSpecialStyle");
        properties.add("isUnderlined");
        properties.add("parentsStandardTypes");
        mapOfProperties.put("SATextChunk", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAImageChunk", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SADocument", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAPart", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SADiv", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SACaption", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAH", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAP", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAL", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SALI", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SALbl", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SALBody", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SATable", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SATR", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SATH", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SATD", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SASpan", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SALink", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAArt", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SASect", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SABlockQuote", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SATOC", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SATOCI", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAIndex", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SANonStruct", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAPrivate", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAQuote", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SANote", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAReference", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SABibEntry", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SACode", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAHn", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAFigure", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAFormula", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAForm", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SATHead", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SATBody", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SATFoot", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAAnnot", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SARuby", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAWarichu", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SARB", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SART", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SARP", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAWT", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAWP", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SADocumentFragment", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAAside", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SATitle", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAFENote", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SASub", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAEm", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAStrong", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAArtifact", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SANonStandard", properties);
        links = new ArrayList<String>();
        links.add("StructTreeRoot");
        links.add("pages");
        links.add("repeatedCharacters");
        mapOfLinks.put("SAPDFDocument", links);
        links = new ArrayList<String>();
        links.add("children");
        mapOfLinks.put("SAStructTreeRoot", links);
        links = new ArrayList<String>();
        links.add("children");
        mapOfLinks.put("SAStructElem", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAChunk", links);
        links = new ArrayList<String>();
        links.add("artifacts");
        links.add("annots");
        mapOfLinks.put("SAPage", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAAnnotation", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SARepeatedCharacters", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SALinkAnnotation", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SATextChunk", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAImageChunk", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SADocument", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAPart", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SADiv", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SACaption", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAH", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAP", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAL", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SALI", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SALbl", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SALBody", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SATable", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SATR", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SATH", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SATD", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SASpan", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SALink", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAArt", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SASect", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SABlockQuote", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SATOC", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SATOCI", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAIndex", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SANonStruct", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAPrivate", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAQuote", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SANote", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAReference", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SABibEntry", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SACode", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAHn", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAFigure", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAFormula", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAForm", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SATHead", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SATBody", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SATFoot", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAAnnot", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SARuby", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAWarichu", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SARB", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SART", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SARP", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAWT", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAWP", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SADocumentFragment", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAAside", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SATitle", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAFENote", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SASub", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAEm", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAStrong", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAArtifact", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SANonStandard", links);
        mapOfSuperNames.put("Object", null);
        properties = new ArrayList<String>();
        mapOfProperties.put("Object", properties);
        links = new ArrayList<String>();
        mapOfLinks.put("Object", links);
        mapOfSuperNames.put("CosObject", "Object");
        mapOfSuperNames.put("CosDocument", "CosObject");
        mapOfSuperNames.put("CosIndirect", "CosObject");
        mapOfSuperNames.put("CosNull", "CosObject");
        mapOfSuperNames.put("CosBool", "CosObject");
        mapOfSuperNames.put("CosNumber", "CosObject");
        mapOfSuperNames.put("CosReal", "CosNumber");
        mapOfSuperNames.put("CosInteger", "CosNumber");
        mapOfSuperNames.put("CosName", "CosObject");
        mapOfSuperNames.put("CosBM", "CosName");
        mapOfSuperNames.put("CosActualText", "CosString");
        mapOfSuperNames.put("CosUnicodeName", "CosName");
        mapOfSuperNames.put("CosRenderingIntent", "CosName");
        mapOfSuperNames.put("CosFilter", "CosName");
        mapOfSuperNames.put("CosIIFilter", "CosName");
        mapOfSuperNames.put("CosString", "CosObject");
        mapOfSuperNames.put("CosTextString", "CosString");
        mapOfSuperNames.put("CosLang", "CosTextString");
        mapOfSuperNames.put("CosDict", "CosObject");
        mapOfSuperNames.put("CosStream", "CosDict");
        mapOfSuperNames.put("CosFileSpecification", "CosDict");
        mapOfSuperNames.put("CosTrailer", "CosDict");
        mapOfSuperNames.put("CosInfo", "CosDict");
        mapOfSuperNames.put("CosArray", "CosObject");
        mapOfSuperNames.put("CosBBox", "CosArray");
        mapOfSuperNames.put("CosXRef", "CosObject");
        properties = new ArrayList<String>();
        mapOfProperties.put("CosObject", properties);
        properties = new ArrayList<String>();
        properties.add("nrIndirects");
        properties.add("headerVersion");
        properties.add("isOptionalContentPresent");
        properties.add("postEOFDataSize");
        properties.add("doesInfoMatchXMP");
        properties.add("firstPageID");
        properties.add("lastID");
        properties.add("isLinearized");
        properties.add("headerOffset");
        properties.add("header");
        properties.add("headerByte1");
        properties.add("headerByte2");
        properties.add("headerByte3");
        properties.add("headerByte4");
        properties.add("Marked");
        properties.add("Requirements");
        properties.add("NeedsRendering");
        properties.add("containsEmbeddedFiles");
        properties.add("Suspects");
        properties.add("DisplayDocTitle");
        properties.add("containsInfo");
        properties.add("containsPieceInfo");
        mapOfProperties.put("CosDocument", properties);
        properties = new ArrayList<String>();
        properties.add("spacingCompliesPDFA");
        mapOfProperties.put("CosIndirect", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("CosNull", properties);
        properties = new ArrayList<String>();
        properties.add("value");
        mapOfProperties.put("CosBool", properties);
        properties = new ArrayList<String>();
        properties.add("stringValue");
        properties.add("intValue");
        properties.add("realValue");
        mapOfProperties.put("CosNumber", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("CosReal", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("CosInteger", properties);
        properties = new ArrayList<String>();
        properties.add("internalRepresentation");
        mapOfProperties.put("CosName", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("CosBM", properties);
        properties = new ArrayList<String>();
        properties.add("containsPUA");
        mapOfProperties.put("CosActualText", properties);
        properties = new ArrayList<String>();
        properties.add("isValidUtf8");
        properties.add("unicodeValue");
        mapOfProperties.put("CosUnicodeName", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("CosRenderingIntent", properties);
        properties = new ArrayList<String>();
        properties.add("decodeParms");
        mapOfProperties.put("CosFilter", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("CosIIFilter", properties);
        properties = new ArrayList<String>();
        properties.add("value");
        properties.add("isHex");
        properties.add("containsOnlyHex");
        properties.add("hexCount");
        mapOfProperties.put("CosString", properties);
        properties = new ArrayList<String>();
        properties.add("unicodeValue");
        mapOfProperties.put("CosTextString", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("CosLang", properties);
        properties = new ArrayList<String>();
        properties.add("size");
        mapOfProperties.put("CosDict", properties);
        properties = new ArrayList<String>();
        properties.add("Length");
        properties.add("F");
        properties.add("FFilter");
        properties.add("FDecodeParms");
        properties.add("streamKeywordCRLFCompliant");
        properties.add("endstreamKeywordEOLCompliant");
        properties.add("isLengthCorrect");
        mapOfProperties.put("CosStream", properties);
        properties = new ArrayList<String>();
        properties.add("containsEF");
        properties.add("F");
        properties.add("UF");
        properties.add("AFRelationship");
        properties.add("isAssociatedFile");
        mapOfProperties.put("CosFileSpecification", properties);
        properties = new ArrayList<String>();
        properties.add("isEncrypted");
        mapOfProperties.put("CosTrailer", properties);
        properties = new ArrayList<String>();
        properties.add("ModDate");
        mapOfProperties.put("CosInfo", properties);
        properties = new ArrayList<String>();
        properties.add("size");
        mapOfProperties.put("CosArray", properties);
        properties = new ArrayList<String>();
        properties.add("top");
        properties.add("bottom");
        properties.add("left");
        properties.add("right");
        mapOfProperties.put("CosBBox", properties);
        properties = new ArrayList<String>();
        properties.add("subsectionHeaderSpaceSeparated");
        properties.add("xrefEOLMarkersComplyPDFA");
        mapOfProperties.put("CosXRef", properties);
        links = new ArrayList<String>();
        mapOfLinks.put("CosObject", links);
        links = new ArrayList<String>();
        links.add("doc");
        links.add("EmbeddedFiles");
        links.add("xref");
        links.add("trailer");
        links.add("indirectObjects");
        links.add("document");
        mapOfLinks.put("CosDocument", links);
        links = new ArrayList<String>();
        links.add("directObject");
        mapOfLinks.put("CosIndirect", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosNull", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosBool", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosNumber", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosReal", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosInteger", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosName", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosBM", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosActualText", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosUnicodeName", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosRenderingIntent", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosFilter", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosIIFilter", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosString", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosTextString", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosLang", links);
        links = new ArrayList<String>();
        links.add("keys");
        links.add("values");
        links.add("metadata");
        mapOfLinks.put("CosDict", links);
        links = new ArrayList<String>();
        links.add("filters");
        mapOfLinks.put("CosStream", links);
        links = new ArrayList<String>();
        links.add("EF");
        mapOfLinks.put("CosFileSpecification", links);
        links = new ArrayList<String>();
        links.add("Catalog");
        links.add("Encrypt");
        links.add("Info");
        mapOfLinks.put("CosTrailer", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosInfo", links);
        links = new ArrayList<String>();
        links.add("elements");
        mapOfLinks.put("CosArray", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosBBox", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosXRef", links);
        mapOfSuperNames.put("SENonStandard", "PDStructElem");
        mapOfSuperNames.put("SEDocument", "PDStructElem");
        mapOfSuperNames.put("SEPart", "PDStructElem");
        mapOfSuperNames.put("SEDiv", "PDStructElem");
        mapOfSuperNames.put("SECaption", "PDStructElem");
        mapOfSuperNames.put("SEH", "PDStructElem");
        mapOfSuperNames.put("SEP", "PDStructElem");
        mapOfSuperNames.put("SEL", "PDStructElem");
        mapOfSuperNames.put("SELI", "PDStructElem");
        mapOfSuperNames.put("SELbl", "PDStructElem");
        mapOfSuperNames.put("SELBody", "PDStructElem");
        mapOfSuperNames.put("SETable", "PDStructElem");
        mapOfSuperNames.put("SETR", "PDStructElem");
        mapOfSuperNames.put("SETH", "PDStructElem");
        mapOfSuperNames.put("SETD", "PDStructElem");
        mapOfSuperNames.put("SESpan", "PDStructElem");
        mapOfSuperNames.put("SELink", "PDStructElem");
        mapOfSuperNames.put("SEArt", "PDStructElem");
        mapOfSuperNames.put("SESect", "PDStructElem");
        mapOfSuperNames.put("SEBlockQuote", "PDStructElem");
        mapOfSuperNames.put("SETOC", "PDStructElem");
        mapOfSuperNames.put("SETOCI", "PDStructElem");
        mapOfSuperNames.put("SEIndex", "PDStructElem");
        mapOfSuperNames.put("SENonStruct", "PDStructElem");
        mapOfSuperNames.put("SEPrivate", "PDStructElem");
        mapOfSuperNames.put("SEQuote", "PDStructElem");
        mapOfSuperNames.put("SENote", "PDStructElem");
        mapOfSuperNames.put("SEReference", "PDStructElem");
        mapOfSuperNames.put("SEBibEntry", "PDStructElem");
        mapOfSuperNames.put("SECode", "PDStructElem");
        mapOfSuperNames.put("SEHn", "PDStructElem");
        mapOfSuperNames.put("SEFigure", "PDStructElem");
        mapOfSuperNames.put("SEFormula", "PDStructElem");
        mapOfSuperNames.put("SEContentItem", "Object");
        mapOfSuperNames.put("SESimpleContentItem", "SEContentItem");
        mapOfSuperNames.put("SEMarkedContent", "SEContentItem");
        mapOfSuperNames.put("SEUnmarkedContent", "SEContentItem");
        mapOfSuperNames.put("SETextItem", "SESimpleContentItem");
        mapOfSuperNames.put("SELineArtItem", "SESimpleContentItem");
        mapOfSuperNames.put("SEShadingItem", "SESimpleContentItem");
        mapOfSuperNames.put("SEImageItem", "SESimpleContentItem");
        mapOfSuperNames.put("SEInlineImageItem", "SEImageItem");
        mapOfSuperNames.put("SEImageXObjectItem", "SEImageItem");
        mapOfSuperNames.put("SEForm", "PDStructElem");
        mapOfSuperNames.put("SETHead", "PDStructElem");
        mapOfSuperNames.put("SETBody", "PDStructElem");
        mapOfSuperNames.put("SETFoot", "PDStructElem");
        mapOfSuperNames.put("SEAnnot", "PDStructElem");
        mapOfSuperNames.put("SERuby", "PDStructElem");
        mapOfSuperNames.put("SEWarichu", "PDStructElem");
        mapOfSuperNames.put("SERB", "PDStructElem");
        mapOfSuperNames.put("SERT", "PDStructElem");
        mapOfSuperNames.put("SERP", "PDStructElem");
        mapOfSuperNames.put("SEWT", "PDStructElem");
        mapOfSuperNames.put("SEWP", "PDStructElem");
        mapOfSuperNames.put("SEDocumentFragment", "PDStructElem");
        mapOfSuperNames.put("SEAside", "PDStructElem");
        mapOfSuperNames.put("SETitle", "PDStructElem");
        mapOfSuperNames.put("SEFENote", "PDStructElem");
        mapOfSuperNames.put("SESub", "PDStructElem");
        mapOfSuperNames.put("SEEm", "PDStructElem");
        mapOfSuperNames.put("SEStrong", "PDStructElem");
        mapOfSuperNames.put("SEArtifact", "PDStructElem");
        properties = new ArrayList<String>();
        mapOfProperties.put("SENonStandard", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEDocument", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEPart", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEDiv", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SECaption", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEH", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEP", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEL", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SELI", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SELbl", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SELBody", properties);
        properties = new ArrayList<String>();
        properties.add("useHeadersAndIdOrScope");
        properties.add("isRegular");
        mapOfProperties.put("SETable", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SETR", properties);
        properties = new ArrayList<String>();
        properties.add("ColSpan");
        properties.add("RowSpan");
        mapOfProperties.put("SETH", properties);
        properties = new ArrayList<String>();
        properties.add("ColSpan");
        properties.add("RowSpan");
        mapOfProperties.put("SETD", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SESpan", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SELink", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEArt", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SESect", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEBlockQuote", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SETOC", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SETOCI", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEIndex", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SENonStruct", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEPrivate", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEQuote", properties);
        properties = new ArrayList<String>();
        properties.add("noteID");
        properties.add("hasDuplicateNoteID");
        mapOfProperties.put("SENote", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEReference", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEBibEntry", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SECode", properties);
        properties = new ArrayList<String>();
        properties.add("hasCorrectNestingLevel");
        mapOfProperties.put("SEHn", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEFigure", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEFormula", properties);
        properties = new ArrayList<String>();
        properties.add("suspectRole");
        properties.add("parentsTags");
        properties.add("parentStructureTag");
        properties.add("parentStandardTag");
        mapOfProperties.put("SEContentItem", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SESimpleContentItem", properties);
        properties = new ArrayList<String>();
        properties.add("tag");
        properties.add("structureTag");
        properties.add("E");
        properties.add("Alt");
        properties.add("ActualText");
        properties.add("inheritedLang");
        mapOfProperties.put("SEMarkedContent", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEUnmarkedContent", properties);
        properties = new ArrayList<String>();
        properties.add("fontName");
        properties.add("scaleFactor");
        properties.add("Lang");
        mapOfProperties.put("SETextItem", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SELineArtItem", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEShadingItem", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEImageItem", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEInlineImageItem", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEImageXObjectItem", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEForm", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SETHead", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SETBody", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SETFoot", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEAnnot", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SERuby", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEWarichu", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SERB", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SERT", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SERP", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEWT", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEWP", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEDocumentFragment", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEAside", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SETitle", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEFENote", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SESub", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEEm", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEStrong", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEArtifact", properties);
        links = new ArrayList<String>();
        mapOfLinks.put("SENonStandard", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEDocument", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEPart", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEDiv", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SECaption", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEH", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEP", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEL", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SELI", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SELbl", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SELBody", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SETable", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SETR", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SETH", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SETD", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SESpan", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SELink", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEArt", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SESect", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEBlockQuote", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SETOC", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SETOCI", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEIndex", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SENonStruct", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEPrivate", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEQuote", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SENote", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEReference", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEBibEntry", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SECode", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEHn", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEFigure", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEFormula", links);
        links = new ArrayList<String>();
        links.add("contentItem");
        mapOfLinks.put("SEContentItem", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SESimpleContentItem", links);
        links = new ArrayList<String>();
        links.add("Lang");
        mapOfLinks.put("SEMarkedContent", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEUnmarkedContent", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SETextItem", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SELineArtItem", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEShadingItem", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEImageItem", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEInlineImageItem", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEImageXObjectItem", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEForm", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SETHead", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SETBody", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SETFoot", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEAnnot", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SERuby", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEWarichu", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SERB", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SERT", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SERP", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEWT", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEWP", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEDocumentFragment", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEAside", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SETitle", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEFENote", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SESub", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEEm", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEStrong", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEArtifact", links);
        mapOfSuperNames.put("PDObject", "Object");
        mapOfSuperNames.put("PDDocument", "PDObject");
        mapOfSuperNames.put("PDPage", "PDObject");
        mapOfSuperNames.put("TransparencyColorSpace", "Object");
        mapOfSuperNames.put("OutputIntents", "Object");
        mapOfSuperNames.put("PDContentStream", "PDObject");
        mapOfSuperNames.put("PDSemanticContentStream", "PDContentStream");
        mapOfSuperNames.put("PDResource", "PDObject");
        mapOfSuperNames.put("PDColorSpace", "PDResource");
        mapOfSuperNames.put("PDAdditionalActions", "PDObject");
        mapOfSuperNames.put("PDDeviceGray", "PDColorSpace");
        mapOfSuperNames.put("PDDeviceRGB", "PDColorSpace");
        mapOfSuperNames.put("PDDeviceCMYK", "PDColorSpace");
        mapOfSuperNames.put("PDICCBased", "PDColorSpace");
        mapOfSuperNames.put("PDICCBasedCMYK", "PDICCBased");
        mapOfSuperNames.put("PDLab", "PDColorSpace");
        mapOfSuperNames.put("PDCalGray", "PDColorSpace");
        mapOfSuperNames.put("PDCalRGB", "PDColorSpace");
        mapOfSuperNames.put("PDSeparation", "PDColorSpace");
        mapOfSuperNames.put("PDDeviceN", "PDColorSpace");
        mapOfSuperNames.put("PDIndexed", "PDColorSpace");
        mapOfSuperNames.put("PDPattern", "PDColorSpace");
        mapOfSuperNames.put("PDTilingPattern", "PDPattern");
        mapOfSuperNames.put("PDShadingPattern", "PDPattern");
        mapOfSuperNames.put("PDFont", "PDResource");
        mapOfSuperNames.put("PDSimpleFont", "PDFont");
        mapOfSuperNames.put("PDTrueTypeFont", "PDSimpleFont");
        mapOfSuperNames.put("PDType1Font", "PDSimpleFont");
        mapOfSuperNames.put("PDType3Font", "PDSimpleFont");
        mapOfSuperNames.put("PDCIDFont", "PDFont");
        mapOfSuperNames.put("PDType0Font", "PDFont");
        mapOfSuperNames.put("PDCMap", "PDObject");
        mapOfSuperNames.put("PDReferencedCMap", "PDCMap");
        mapOfSuperNames.put("PDXObject", "PDResource");
        mapOfSuperNames.put("PDXImage", "PDXObject");
        mapOfSuperNames.put("PDSMaskImage", "PDXImage");
        mapOfSuperNames.put("PDInlineImage", "PDXImage");
        mapOfSuperNames.put("PDXForm", "PDXObject");
        mapOfSuperNames.put("PDResources", "PDObject");
        mapOfSuperNames.put("PDGroup", "PDObject");
        mapOfSuperNames.put("PDExtGState", "PDResource");
        mapOfSuperNames.put("PDHalftone", "PDObject");
        mapOfSuperNames.put("PDShading", "PDResource");
        mapOfSuperNames.put("PDAnnot", "PDObject");
        mapOfSuperNames.put("PD3DAnnot", "PDAnnot");
        mapOfSuperNames.put("PDWidgetAnnot", "PDAnnot");
        mapOfSuperNames.put("PDPrinterMarkAnnot", "PDAnnot");
        mapOfSuperNames.put("PDLinkAnnot", "PDAnnot");
        mapOfSuperNames.put("PDTrapNetAnnot", "PDAnnot");
        mapOfSuperNames.put("PD3DStream", "PDObject");
        mapOfSuperNames.put("PDAcroForm", "PDObject");
        mapOfSuperNames.put("PDFormField", "PDObject");
        mapOfSuperNames.put("PDSignatureField", "PDFormField");
        mapOfSuperNames.put("PDSignature", "PDObject");
        mapOfSuperNames.put("PDAction", "PDObject");
        mapOfSuperNames.put("PDRenditionAction", "PDAction");
        mapOfSuperNames.put("PDEncryption", "PDObject");
        mapOfSuperNames.put("PDMediaClip", "PDObject");
        mapOfSuperNames.put("PDNamedAction", "PDAction");
        mapOfSuperNames.put("PDGoToAction", "PDAction");
        mapOfSuperNames.put("PDGoToRemoteAction", "PDGoToAction");
        mapOfSuperNames.put("PDMetadata", "PDObject");
        mapOfSuperNames.put("PDOutputIntent", "PDObject");
        mapOfSuperNames.put("PDOCProperties", "PDObject");
        mapOfSuperNames.put("PDOCConfig", "PDObject");
        mapOfSuperNames.put("PDOutline", "PDObject");
        mapOfSuperNames.put("PDStructTreeRoot", "PDObject");
        mapOfSuperNames.put("PDStructElem", "PDObject");
        mapOfSuperNames.put("PDPerms", "PDObject");
        mapOfSuperNames.put("PDSigRef", "PDObject");
        mapOfSuperNames.put("PDFunction", "PDObject");
        mapOfSuperNames.put("PDType0Function", "PDFunction");
        mapOfSuperNames.put("PDType2Function", "PDFunction");
        mapOfSuperNames.put("PDType3Function", "PDFunction");
        mapOfSuperNames.put("PDType4Function", "PDFunction");
        properties = new ArrayList<String>();
        mapOfProperties.put("PDObject", properties);
        properties = new ArrayList<String>();
        properties.add("containsAlternatePresentations");
        properties.add("validPDF");
        properties.add("containsAA");
        properties.add("outputColorSpace");
        properties.add("Version");
        mapOfProperties.put("PDDocument", properties);
        properties = new ArrayList<String>();
        properties.add("containsPresSteps");
        properties.add("containsTransparency");
        properties.add("containsGroupCS");
        properties.add("containsAA");
        properties.add("Tabs");
        properties.add("orientation");
        properties.add("outputColorSpace");
        mapOfProperties.put("PDPage", properties);
        properties = new ArrayList<String>();
        properties.add("colorSpaceType");
        mapOfProperties.put("TransparencyColorSpace", properties);
        properties = new ArrayList<String>();
        properties.add("sameOutputProfileIndirect");
        mapOfProperties.put("OutputIntents", properties);
        properties = new ArrayList<String>();
        properties.add("containsUndefinedResource");
        mapOfProperties.put("PDContentStream", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDSemanticContentStream", properties);
        properties = new ArrayList<String>();
        properties.add("isInherited");
        mapOfProperties.put("PDResource", properties);
        properties = new ArrayList<String>();
        properties.add("nrComponents");
        mapOfProperties.put("PDColorSpace", properties);
        properties = new ArrayList<String>();
        properties.add("containsOtherActions");
        mapOfProperties.put("PDAdditionalActions", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDDeviceGray", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDDeviceRGB", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDDeviceCMYK", properties);
        properties = new ArrayList<String>();
        properties.add("ICCProfileIndirect");
        properties.add("currentTransparencyProfileIndirect");
        properties.add("ICCProfileMD5");
        properties.add("currentTransparencyICCProfileMD5");
        mapOfProperties.put("PDICCBased", properties);
        properties = new ArrayList<String>();
        properties.add("OPM");
        properties.add("overprintFlag");
        mapOfProperties.put("PDICCBasedCMYK", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDLab", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDCalGray", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDCalRGB", properties);
        properties = new ArrayList<String>();
        properties.add("name");
        properties.add("areTintAndAlternateConsistent");
        mapOfProperties.put("PDSeparation", properties);
        properties = new ArrayList<String>();
        properties.add("areColorantsPresent");
        mapOfProperties.put("PDDeviceN", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDIndexed", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDPattern", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDTilingPattern", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDShadingPattern", properties);
        properties = new ArrayList<String>();
        properties.add("Type");
        properties.add("Subtype");
        properties.add("fontName");
        properties.add("isSymbolic");
        properties.add("renderingMode");
        properties.add("fontFileSubtype");
        properties.add("isItalic");
        mapOfProperties.put("PDFont", properties);
        properties = new ArrayList<String>();
        properties.add("isStandard");
        properties.add("FirstChar");
        properties.add("LastChar");
        properties.add("Widths_size");
        properties.add("Encoding");
        properties.add("containsDifferences");
        mapOfProperties.put("PDSimpleFont", properties);
        properties = new ArrayList<String>();
        properties.add("differencesAreUnicodeCompliant");
        mapOfProperties.put("PDTrueTypeFont", properties);
        properties = new ArrayList<String>();
        properties.add("CharSet");
        properties.add("charSetListsAllGlyphs");
        mapOfProperties.put("PDType1Font", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDType3Font", properties);
        properties = new ArrayList<String>();
        properties.add("CIDToGIDMap");
        properties.add("cidSetListsAllGlyphs");
        mapOfProperties.put("PDCIDFont", properties);
        properties = new ArrayList<String>();
        properties.add("areRegistryOrderingCompatible");
        properties.add("isSupplementCompatible");
        properties.add("cmapName");
        mapOfProperties.put("PDType0Font", properties);
        properties = new ArrayList<String>();
        properties.add("CMapName");
        mapOfProperties.put("PDCMap", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDReferencedCMap", properties);
        properties = new ArrayList<String>();
        properties.add("Subtype");
        properties.add("containsOPI");
        properties.add("containsSMask");
        mapOfProperties.put("PDXObject", properties);
        properties = new ArrayList<String>();
        properties.add("Interpolate");
        properties.add("containsAlternates");
        mapOfProperties.put("PDXImage", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDSMaskImage", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDInlineImage", properties);
        properties = new ArrayList<String>();
        properties.add("Subtype2");
        properties.add("containsPS");
        properties.add("containsRef");
        properties.add("isUniqueSemanticParent");
        mapOfProperties.put("PDXForm", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDResources", properties);
        properties = new ArrayList<String>();
        properties.add("S");
        mapOfProperties.put("PDGroup", properties);
        properties = new ArrayList<String>();
        properties.add("TR");
        properties.add("TR2");
        properties.add("containsHTP");
        properties.add("containsHTO");
        properties.add("SMask");
        properties.add("BM");
        properties.add("ca");
        properties.add("CA");
        mapOfProperties.put("PDExtGState", properties);
        properties = new ArrayList<String>();
        properties.add("HalftoneType");
        properties.add("HalftoneName");
        properties.add("colorantName");
        properties.add("TransferFunction");
        mapOfProperties.put("PDHalftone", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDShading", properties);
        properties = new ArrayList<String>();
        properties.add("Subtype");
        properties.add("CA");
        properties.add("F");
        properties.add("AP");
        properties.add("FT");
        properties.add("N_type");
        properties.add("width");
        properties.add("height");
        properties.add("containsA");
        properties.add("containsAA");
        properties.add("structParentType");
        properties.add("Contents");
        properties.add("Alt");
        properties.add("isOutsideCropBox");
        mapOfProperties.put("PDAnnot", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PD3DAnnot", properties);
        properties = new ArrayList<String>();
        properties.add("TU");
        mapOfProperties.put("PDWidgetAnnot", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDPrinterMarkAnnot", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDLinkAnnot", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDTrapNetAnnot", properties);
        properties = new ArrayList<String>();
        properties.add("Subtype");
        mapOfProperties.put("PD3DStream", properties);
        properties = new ArrayList<String>();
        properties.add("NeedAppearances");
        properties.add("containsXFA");
        properties.add("dynamicRender");
        mapOfProperties.put("PDAcroForm", properties);
        properties = new ArrayList<String>();
        properties.add("FT");
        properties.add("containsAA");
        properties.add("TU");
        mapOfProperties.put("PDFormField", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDSignatureField", properties);
        properties = new ArrayList<String>();
        properties.add("doesByteRangeCoverEntireDocument");
        mapOfProperties.put("PDSignature", properties);
        properties = new ArrayList<String>();
        properties.add("S");
        mapOfProperties.put("PDAction", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDRenditionAction", properties);
        properties = new ArrayList<String>();
        properties.add("P");
        mapOfProperties.put("PDEncryption", properties);
        properties = new ArrayList<String>();
        properties.add("CT");
        properties.add("Alt");
        properties.add("hasCorrectAlt");
        mapOfProperties.put("PDMediaClip", properties);
        properties = new ArrayList<String>();
        properties.add("N");
        mapOfProperties.put("PDNamedAction", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDGoToAction", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDGoToRemoteAction", properties);
        properties = new ArrayList<String>();
        properties.add("Filter");
        mapOfProperties.put("PDMetadata", properties);
        properties = new ArrayList<String>();
        properties.add("destOutputProfileIndirect");
        properties.add("containsDestOutputProfileRef");
        properties.add("OutputConditionIdentifier");
        properties.add("S");
        properties.add("ICCProfileMD5");
        mapOfProperties.put("PDOutputIntent", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDOCProperties", properties);
        properties = new ArrayList<String>();
        properties.add("Name");
        properties.add("hasDuplicateName");
        properties.add("AS");
        properties.add("doesOrderContainAllOCGs");
        mapOfProperties.put("PDOCConfig", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDOutline", properties);
        properties = new ArrayList<String>();
        properties.add("topLevelFirstElementStandartType");
        properties.add("kidsStandardTypes");
        properties.add("hasContentItems");
        mapOfProperties.put("PDStructTreeRoot", properties);
        properties = new ArrayList<String>();
        properties.add("Type");
        properties.add("kidsStandardTypes");
        properties.add("parentStandardType");
        properties.add("hasContentItems");
        properties.add("standardType");
        properties.add("parentLang");
        properties.add("isRemappedStandardType");
        properties.add("Alt");
        properties.add("ActualText");
        properties.add("E");
        properties.add("circularMappingExist");
        mapOfProperties.put("PDStructElem", properties);
        properties = new ArrayList<String>();
        properties.add("containsOtherEntries");
        mapOfProperties.put("PDPerms", properties);
        properties = new ArrayList<String>();
        properties.add("containsDigestEntries");
        properties.add("permsContainDocMDP");
        mapOfProperties.put("PDSigRef", properties);
        properties = new ArrayList<String>();
        properties.add("FunctionType");
        mapOfProperties.put("PDFunction", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDType0Function", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDType2Function", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDType3Function", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDType4Function", properties);
        links = new ArrayList<String>();
        mapOfLinks.put("PDObject", links);
        links = new ArrayList<String>();
        links.add("outputIntents");
        links.add("pages");
        links.add("metadata");
        links.add("AcroForm");
        links.add("AA");
        links.add("OpenAction");
        links.add("Outlines");
        links.add("OCProperties");
        links.add("StructTreeRoot");
        links.add("Lang");
        links.add("Perms");
        mapOfLinks.put("PDDocument", links);
        links = new ArrayList<String>();
        links.add("outputIntents");
        links.add("annots");
        links.add("AA");
        links.add("transparencyColorSpace");
        links.add("contentStream");
        links.add("parentTransparencyColorSpace");
        links.add("Group");
        links.add("MediaBox");
        links.add("CropBox");
        links.add("BleedBox");
        links.add("TrimBox");
        links.add("ArtBox");
        links.add("resources");
        mapOfLinks.put("PDPage", links);
        links = new ArrayList<String>();
        mapOfLinks.put("TransparencyColorSpace", links);
        links = new ArrayList<String>();
        links.add("outputIntents");
        mapOfLinks.put("OutputIntents", links);
        links = new ArrayList<String>();
        links.add("operators");
        links.add("resources");
        mapOfLinks.put("PDContentStream", links);
        links = new ArrayList<String>();
        links.add("content");
        mapOfLinks.put("PDSemanticContentStream", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDResource", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDColorSpace", links);
        links = new ArrayList<String>();
        links.add("Actions");
        mapOfLinks.put("PDAdditionalActions", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDDeviceGray", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDDeviceRGB", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDDeviceCMYK", links);
        links = new ArrayList<String>();
        links.add("iccProfile");
        mapOfLinks.put("PDICCBased", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDICCBasedCMYK", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDLab", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDCalGray", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDCalRGB", links);
        links = new ArrayList<String>();
        links.add("tintTransform");
        links.add("alternate");
        links.add("colorantName");
        mapOfLinks.put("PDSeparation", links);
        links = new ArrayList<String>();
        links.add("tintTransform");
        links.add("alternate");
        links.add("colorantNames");
        links.add("Colorants");
        links.add("processColor");
        mapOfLinks.put("PDDeviceN", links);
        links = new ArrayList<String>();
        links.add("base");
        mapOfLinks.put("PDIndexed", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDPattern", links);
        links = new ArrayList<String>();
        links.add("contentStream");
        mapOfLinks.put("PDTilingPattern", links);
        links = new ArrayList<String>();
        links.add("shading");
        mapOfLinks.put("PDShadingPattern", links);
        links = new ArrayList<String>();
        links.add("BaseFont");
        links.add("fontFile");
        mapOfLinks.put("PDFont", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDSimpleFont", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDTrueTypeFont", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDType1Font", links);
        links = new ArrayList<String>();
        links.add("charStrings");
        mapOfLinks.put("PDType3Font", links);
        links = new ArrayList<String>();
        links.add("CIDSet");
        mapOfLinks.put("PDCIDFont", links);
        links = new ArrayList<String>();
        links.add("DescendantFonts");
        links.add("Encoding");
        mapOfLinks.put("PDType0Font", links);
        links = new ArrayList<String>();
        links.add("UseCMap");
        links.add("embeddedFile");
        mapOfLinks.put("PDCMap", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDReferencedCMap", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDXObject", links);
        links = new ArrayList<String>();
        links.add("imageCS");
        links.add("Alternates");
        links.add("Intent");
        links.add("jpxStream");
        links.add("SMask");
        mapOfLinks.put("PDXImage", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDSMaskImage", links);
        links = new ArrayList<String>();
        links.add("F");
        mapOfLinks.put("PDInlineImage", links);
        links = new ArrayList<String>();
        links.add("transparencyColorSpace");
        links.add("contentStream");
        links.add("parentTransparencyColorSpace");
        links.add("Group");
        mapOfLinks.put("PDXForm", links);
        links = new ArrayList<String>();
        links.add("resourcesNames");
        mapOfLinks.put("PDResources", links);
        links = new ArrayList<String>();
        links.add("colorSpace");
        mapOfLinks.put("PDGroup", links);
        links = new ArrayList<String>();
        links.add("HT");
        links.add("bm");
        links.add("RI");
        links.add("fontSize");
        links.add("customFunctions");
        mapOfLinks.put("PDExtGState", links);
        links = new ArrayList<String>();
        links.add("customFunction");
        links.add("halftones");
        mapOfLinks.put("PDHalftone", links);
        links = new ArrayList<String>();
        links.add("colorSpace");
        mapOfLinks.put("PDShading", links);
        links = new ArrayList<String>();
        links.add("appearance");
        links.add("C");
        links.add("IC");
        links.add("A");
        links.add("AA");
        links.add("Lang");
        links.add("BM");
        mapOfLinks.put("PDAnnot", links);
        links = new ArrayList<String>();
        links.add("stream3D");
        mapOfLinks.put("PD3DAnnot", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDWidgetAnnot", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDPrinterMarkAnnot", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDLinkAnnot", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDTrapNetAnnot", links);
        links = new ArrayList<String>();
        links.add("colorSpace");
        mapOfLinks.put("PD3DStream", links);
        links = new ArrayList<String>();
        links.add("formFields");
        mapOfLinks.put("PDAcroForm", links);
        links = new ArrayList<String>();
        links.add("AA");
        links.add("Lang");
        mapOfLinks.put("PDFormField", links);
        links = new ArrayList<String>();
        links.add("V");
        mapOfLinks.put("PDSignatureField", links);
        links = new ArrayList<String>();
        links.add("Contents");
        links.add("Reference");
        mapOfLinks.put("PDSignature", links);
        links = new ArrayList<String>();
        links.add("Next");
        mapOfLinks.put("PDAction", links);
        links = new ArrayList<String>();
        links.add("C");
        mapOfLinks.put("PDRenditionAction", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDEncryption", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDMediaClip", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDNamedAction", links);
        links = new ArrayList<String>();
        links.add("D");
        mapOfLinks.put("PDGoToAction", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDGoToRemoteAction", links);
        links = new ArrayList<String>();
        links.add("XMPPackage");
        links.add("stream");
        mapOfLinks.put("PDMetadata", links);
        links = new ArrayList<String>();
        links.add("destProfile");
        mapOfLinks.put("PDOutputIntent", links);
        links = new ArrayList<String>();
        links.add("D");
        links.add("Configs");
        mapOfLinks.put("PDOCProperties", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDOCConfig", links);
        links = new ArrayList<String>();
        links.add("A");
        mapOfLinks.put("PDOutline", links);
        links = new ArrayList<String>();
        links.add("K");
        links.add("roleMapNames");
        mapOfLinks.put("PDStructTreeRoot", links);
        links = new ArrayList<String>();
        links.add("K");
        links.add("S");
        links.add("Lang");
        links.add("actualText");
        mapOfLinks.put("PDStructElem", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDPerms", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDSigRef", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDFunction", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDType0Function", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDType2Function", links);
        links = new ArrayList<String>();
        links.add("Functions");
        mapOfLinks.put("PDType3Function", links);
        links = new ArrayList<String>();
        links.add("operators");
        mapOfLinks.put("PDType4Function", links);
        mapOfSuperNames.put("External", "Object");
        mapOfSuperNames.put("ICCProfile", "External");
        mapOfSuperNames.put("ICCInputProfile", "ICCProfile");
        mapOfSuperNames.put("ICCOutputProfile", "ICCProfile");
        mapOfSuperNames.put("FontProgram", "External");
        mapOfSuperNames.put("TrueTypeFontProgram", "FontProgram");
        mapOfSuperNames.put("CMapFile", "External");
        mapOfSuperNames.put("JPEG2000", "External");
        mapOfSuperNames.put("EmbeddedFile", "External");
        mapOfSuperNames.put("PKCSDataObject", "External");
        properties = new ArrayList<String>();
        mapOfProperties.put("External", properties);
        properties = new ArrayList<String>();
        properties.add("N");
        properties.add("deviceClass");
        properties.add("colorSpace");
        properties.add("version");
        properties.add("isValid");
        mapOfProperties.put("ICCProfile", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("ICCInputProfile", properties);
        properties = new ArrayList<String>();
        properties.add("S");
        mapOfProperties.put("ICCOutputProfile", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("FontProgram", properties);
        properties = new ArrayList<String>();
        properties.add("isSymbolic");
        properties.add("nrCmaps");
        properties.add("cmap30Present");
        properties.add("cmap31Present");
        properties.add("cmap10Present");
        mapOfProperties.put("TrueTypeFontProgram", properties);
        properties = new ArrayList<String>();
        properties.add("WMode");
        properties.add("dictWMode");
        properties.add("maximalCID");
        mapOfProperties.put("CMapFile", properties);
        properties = new ArrayList<String>();
        properties.add("nrColorChannels");
        properties.add("nrColorSpaceSpecs");
        properties.add("nrColorSpacesWithApproxField");
        properties.add("colrMethod");
        properties.add("colrEnumCS");
        properties.add("bitDepth");
        properties.add("bpccBoxPresent");
        properties.add("hasColorSpace");
        mapOfProperties.put("JPEG2000", properties);
        properties = new ArrayList<String>();
        properties.add("Subtype");
        properties.add("isValidPDFA12");
        properties.add("isValidPDFA124");
        mapOfProperties.put("EmbeddedFile", properties);
        properties = new ArrayList<String>();
        properties.add("SignerInfoCount");
        properties.add("signingCertificatePresent");
        mapOfProperties.put("PKCSDataObject", properties);
        links = new ArrayList<String>();
        mapOfLinks.put("External", links);
        links = new ArrayList<String>();
        mapOfLinks.put("ICCProfile", links);
        links = new ArrayList<String>();
        mapOfLinks.put("ICCInputProfile", links);
        links = new ArrayList<String>();
        mapOfLinks.put("ICCOutputProfile", links);
        links = new ArrayList<String>();
        mapOfLinks.put("FontProgram", links);
        links = new ArrayList<String>();
        mapOfLinks.put("TrueTypeFontProgram", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CMapFile", links);
        links = new ArrayList<String>();
        mapOfLinks.put("JPEG2000", links);
        links = new ArrayList<String>();
        mapOfLinks.put("EmbeddedFile", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PKCSDataObject", links);
        mapOfSuperNames.put("XMPObject", "Object");
        mapOfSuperNames.put("XMPPackage", "XMPObject");
        mapOfSuperNames.put("MainXMPPackage", "XMPPackage");
        mapOfSuperNames.put("XMPProperty", "XMPObject");
        mapOfSuperNames.put("XMPMMHistoryProperty", "XMPProperty");
        mapOfSuperNames.put("XMPLangAlt", "XMPProperty");
        mapOfSuperNames.put("XMPMMHistoryResourceEvent", "XMPObject");
        mapOfSuperNames.put("PDFAIdentification", "XMPObject");
        mapOfSuperNames.put("PDFUAIdentification", "XMPObject");
        mapOfSuperNames.put("ExtensionSchemaObject", "XMPObject");
        mapOfSuperNames.put("ExtensionSchemasContainer", "XMPObject");
        mapOfSuperNames.put("ExtensionSchemaDefinition", "ExtensionSchemaObject");
        mapOfSuperNames.put("ExtensionSchemaProperty", "ExtensionSchemaObject");
        mapOfSuperNames.put("ExtensionSchemaValueType", "ExtensionSchemaObject");
        mapOfSuperNames.put("ExtensionSchemaField", "ExtensionSchemaObject");
        properties = new ArrayList<String>();
        mapOfProperties.put("XMPObject", properties);
        properties = new ArrayList<String>();
        properties.add("isSerializationValid");
        properties.add("actualEncoding");
        properties.add("bytes");
        properties.add("encoding");
        mapOfProperties.put("XMPPackage", properties);
        properties = new ArrayList<String>();
        properties.add("dc_title");
        mapOfProperties.put("MainXMPPackage", properties);
        properties = new ArrayList<String>();
        properties.add("isPredefinedInXMP2004");
        properties.add("isPredefinedInXMP2005");
        properties.add("isDefinedInCurrentPackage");
        properties.add("isDefinedInMainPackage");
        properties.add("isValueTypeCorrect");
        mapOfProperties.put("XMPProperty", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("XMPMMHistoryProperty", properties);
        properties = new ArrayList<String>();
        properties.add("xDefault");
        mapOfProperties.put("XMPLangAlt", properties);
        properties = new ArrayList<String>();
        properties.add("action");
        properties.add("parameters");
        properties.add("when");
        mapOfProperties.put("XMPMMHistoryResourceEvent", properties);
        properties = new ArrayList<String>();
        properties.add("part");
        properties.add("conformance");
        properties.add("rev");
        properties.add("partPrefix");
        properties.add("conformancePrefix");
        properties.add("amdPrefix");
        properties.add("corrPrefix");
        properties.add("revPrefix");
        mapOfProperties.put("PDFAIdentification", properties);
        properties = new ArrayList<String>();
        properties.add("part");
        mapOfProperties.put("PDFUAIdentification", properties);
        properties = new ArrayList<String>();
        properties.add("containsUndefinedFields");
        mapOfProperties.put("ExtensionSchemaObject", properties);
        properties = new ArrayList<String>();
        properties.add("prefix");
        properties.add("isValidBag");
        mapOfProperties.put("ExtensionSchemasContainer", properties);
        properties = new ArrayList<String>();
        properties.add("isNamespaceURIValidURI");
        properties.add("isPrefixValidText");
        properties.add("isPropertyValidSeq");
        properties.add("isSchemaValidText");
        properties.add("isValueTypeValidSeq");
        properties.add("namespaceURIPrefix");
        properties.add("prefixPrefix");
        properties.add("propertyPrefix");
        properties.add("schemaPrefix");
        properties.add("valueTypePrefix");
        mapOfProperties.put("ExtensionSchemaDefinition", properties);
        properties = new ArrayList<String>();
        properties.add("category");
        properties.add("isCategoryValidText");
        properties.add("isDescriptionValidText");
        properties.add("isNameValidText");
        properties.add("isValueTypeValidText");
        properties.add("isValueTypeDefined");
        properties.add("categoryPrefix");
        properties.add("descriptionPrefix");
        properties.add("namePrefix");
        properties.add("valueTypePrefix");
        mapOfProperties.put("ExtensionSchemaProperty", properties);
        properties = new ArrayList<String>();
        properties.add("isDescriptionValidText");
        properties.add("isFieldValidSeq");
        properties.add("isNamespaceURIValidURI");
        properties.add("isPrefixValidText");
        properties.add("isTypeValidText");
        properties.add("descriptionPrefix");
        properties.add("fieldPrefix");
        properties.add("namespaceURIPrefix");
        properties.add("prefixPrefix");
        properties.add("typePrefix");
        mapOfProperties.put("ExtensionSchemaValueType", properties);
        properties = new ArrayList<String>();
        properties.add("isDescriptionValidText");
        properties.add("isNameValidText");
        properties.add("isValueTypeValidText");
        properties.add("isValueTypeDefined");
        properties.add("descriptionPrefix");
        properties.add("namePrefix");
        properties.add("valueTypePrefix");
        mapOfProperties.put("ExtensionSchemaField", properties);
        links = new ArrayList<String>();
        mapOfLinks.put("XMPObject", links);
        links = new ArrayList<String>();
        links.add("Properties");
        links.add("ExtensionSchemasContainers");
        mapOfLinks.put("XMPPackage", links);
        links = new ArrayList<String>();
        links.add("Identification");
        links.add("UAIdentification");
        mapOfLinks.put("MainXMPPackage", links);
        links = new ArrayList<String>();
        mapOfLinks.put("XMPProperty", links);
        links = new ArrayList<String>();
        links.add("ResourceEvents");
        mapOfLinks.put("XMPMMHistoryProperty", links);
        links = new ArrayList<String>();
        mapOfLinks.put("XMPLangAlt", links);
        links = new ArrayList<String>();
        mapOfLinks.put("XMPMMHistoryResourceEvent", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDFAIdentification", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDFUAIdentification", links);
        links = new ArrayList<String>();
        mapOfLinks.put("ExtensionSchemaObject", links);
        links = new ArrayList<String>();
        links.add("ExtensionSchemaDefinitions");
        mapOfLinks.put("ExtensionSchemasContainer", links);
        links = new ArrayList<String>();
        links.add("ExtensionSchemaProperties");
        links.add("ExtensionSchemaValueTypes");
        mapOfLinks.put("ExtensionSchemaDefinition", links);
        links = new ArrayList<String>();
        mapOfLinks.put("ExtensionSchemaProperty", links);
        links = new ArrayList<String>();
        links.add("ExtensionSchemaFields");
        mapOfLinks.put("ExtensionSchemaValueType", links);
        links = new ArrayList<String>();
        mapOfLinks.put("ExtensionSchemaField", links);
        mapOfSuperNames.put("Operator", "Object");
        mapOfSuperNames.put("OpGeneralGS", "Operator");
        mapOfSuperNames.put("Op_w_line_width", "OpGeneralGS");
        mapOfSuperNames.put("Op_J_line_cap", "OpGeneralGS");
        mapOfSuperNames.put("Op_j_line_join", "OpGeneralGS");
        mapOfSuperNames.put("Op_M_miter_limit", "OpGeneralGS");
        mapOfSuperNames.put("Op_d", "OpGeneralGS");
        mapOfSuperNames.put("Op_ri", "OpGeneralGS");
        mapOfSuperNames.put("Op_i", "OpGeneralGS");
        mapOfSuperNames.put("Op_gs", "OpGeneralGS");
        mapOfSuperNames.put("OpSpecialGS", "Operator");
        mapOfSuperNames.put("Op_q_gsave", "OpSpecialGS");
        mapOfSuperNames.put("Op_Q_grestore", "OpSpecialGS");
        mapOfSuperNames.put("Op_cm", "OpSpecialGS");
        mapOfSuperNames.put("OpPathConstruction", "Operator");
        mapOfSuperNames.put("Op_m_moveto", "OpPathConstruction");
        mapOfSuperNames.put("Op_l", "OpPathConstruction");
        mapOfSuperNames.put("Op_c", "OpPathConstruction");
        mapOfSuperNames.put("Op_v", "OpPathConstruction");
        mapOfSuperNames.put("Op_y", "OpPathConstruction");
        mapOfSuperNames.put("Op_h", "OpPathConstruction");
        mapOfSuperNames.put("Op_re", "OpPathConstruction");
        mapOfSuperNames.put("OpPathPaint", "Operator");
        mapOfSuperNames.put("Op_s_close_stroke", "OpPathPaint");
        mapOfSuperNames.put("Op_S_stroke", "OpPathPaint");
        mapOfSuperNames.put("Op_f_fill", "OpPathPaint");
        mapOfSuperNames.put("Op_F_fill_obsolete", "OpPathPaint");
        mapOfSuperNames.put("Op_FStar", "OpPathPaint");
        mapOfSuperNames.put("Op_B_fill_stroke", "OpPathPaint");
        mapOfSuperNames.put("Op_BStar_eofill_stroke", "OpPathPaint");
        mapOfSuperNames.put("Op_b_closepath_fill_stroke", "OpPathPaint");
        mapOfSuperNames.put("Op_bstar_closepath_eofill_stroke", "OpPathPaint");
        mapOfSuperNames.put("Op_n", "OpPathPaint");
        mapOfSuperNames.put("OpClip", "Operator");
        mapOfSuperNames.put("Op_W_clip", "OpClip");
        mapOfSuperNames.put("Op_WStar", "OpClip");
        mapOfSuperNames.put("OpTextObject", "Operator");
        mapOfSuperNames.put("Op_ET", "OpTextObject");
        mapOfSuperNames.put("Op_BT", "OpTextObject");
        mapOfSuperNames.put("OpTextState", "Operator");
        mapOfSuperNames.put("Op_Tz", "OpTextState");
        mapOfSuperNames.put("Op_Tr", "OpTextState");
        mapOfSuperNames.put("Op_Tc", "OpTextState");
        mapOfSuperNames.put("Op_Tf", "OpTextState");
        mapOfSuperNames.put("Op_Tl", "OpTextState");
        mapOfSuperNames.put("Op_Ts", "OpTextState");
        mapOfSuperNames.put("Op_Tw", "OpTextState");
        mapOfSuperNames.put("OpTextPosition", "Operator");
        mapOfSuperNames.put("Op_Td", "OpTextPosition");
        mapOfSuperNames.put("Op_TD_Big", "OpTextPosition");
        mapOfSuperNames.put("Op_Tm", "OpTextPosition");
        mapOfSuperNames.put("Op_T_Star", "OpTextPosition");
        mapOfSuperNames.put("OpTextShow", "Operator");
        mapOfSuperNames.put("Op_Tj", "OpTextShow");
        mapOfSuperNames.put("Op_TJ_Big", "OpTextShow");
        mapOfSuperNames.put("Op_Quote", "OpTextShow");
        mapOfSuperNames.put("Op_DoubleQuote", "OpTextShow");
        mapOfSuperNames.put("OpType3Font", "Operator");
        mapOfSuperNames.put("Op_d0", "OpType3Font");
        mapOfSuperNames.put("Op_d1", "OpType3Font");
        mapOfSuperNames.put("OpSetColor", "Operator");
        mapOfSuperNames.put("Op_SC_stroke", "OpSetColor");
        mapOfSuperNames.put("Op_sc_fill", "OpSetColor");
        mapOfSuperNames.put("OpColor", "OpSetColor");
        mapOfSuperNames.put("Op_SCN_stroke", "OpColor");
        mapOfSuperNames.put("Op_scn_fill", "OpColor");
        mapOfSuperNames.put("Op_G_stroke", "OpColor");
        mapOfSuperNames.put("Op_g_fill", "OpColor");
        mapOfSuperNames.put("Op_RG_stroke", "OpColor");
        mapOfSuperNames.put("Op_rg_fill", "OpColor");
        mapOfSuperNames.put("Op_K_stroke", "OpColor");
        mapOfSuperNames.put("Op_k_fill", "OpColor");
        mapOfSuperNames.put("OpShading", "Operator");
        mapOfSuperNames.put("Op_sh", "OpShading");
        mapOfSuperNames.put("OpInlineImage", "Operator");
        mapOfSuperNames.put("Op_BI", "OpInlineImage");
        mapOfSuperNames.put("Op_ID", "OpInlineImage");
        mapOfSuperNames.put("Op_EI", "OpInlineImage");
        mapOfSuperNames.put("OpXObject", "Operator");
        mapOfSuperNames.put("Op_Do", "OpXObject");
        mapOfSuperNames.put("OpMarkedContent", "Operator");
        mapOfSuperNames.put("Op_MP", "OpMarkedContent");
        mapOfSuperNames.put("Op_DP", "OpMarkedContent");
        mapOfSuperNames.put("Op_BMC", "OpMarkedContent");
        mapOfSuperNames.put("Op_BDC", "OpMarkedContent");
        mapOfSuperNames.put("Op_EMC", "OpMarkedContent");
        mapOfSuperNames.put("OpCompatibility", "Operator");
        mapOfSuperNames.put("Op_BX", "OpCompatibility");
        mapOfSuperNames.put("Op_EX", "OpCompatibility");
        mapOfSuperNames.put("Op_Undefined", "OpCompatibility");
        mapOfSuperNames.put("Glyph", "Object");
        mapOfSuperNames.put("CIDGlyph", "Glyph");
        properties = new ArrayList<String>();
        mapOfProperties.put("Operator", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpGeneralGS", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_w_line_width", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_J_line_cap", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_j_line_join", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_M_miter_limit", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_d", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_ri", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_i", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_gs", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpSpecialGS", properties);
        properties = new ArrayList<String>();
        properties.add("nestingLevel");
        mapOfProperties.put("Op_q_gsave", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Q_grestore", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_cm", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpPathConstruction", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_m_moveto", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_l", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_c", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_v", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_y", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_h", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_re", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpPathPaint", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_s_close_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_S_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_f_fill", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_F_fill_obsolete", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_FStar", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_B_fill_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_BStar_eofill_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_b_closepath_fill_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_bstar_closepath_eofill_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_n", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpClip", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_W_clip", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_WStar", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpTextObject", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_ET", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_BT", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpTextState", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tz", properties);
        properties = new ArrayList<String>();
        properties.add("renderingMode");
        mapOfProperties.put("Op_Tr", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tc", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tf", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tl", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Ts", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tw", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpTextPosition", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Td", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_TD_Big", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tm", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_T_Star", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpTextShow", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tj", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_TJ_Big", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Quote", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_DoubleQuote", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpType3Font", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_d0", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_d1", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpSetColor", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_SC_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_sc_fill", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpColor", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_SCN_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_scn_fill", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_G_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_g_fill", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_RG_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_rg_fill", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_K_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_k_fill", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpShading", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_sh", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpInlineImage", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_BI", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_ID", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_EI", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpXObject", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Do", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpMarkedContent", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_MP", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_DP", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_BMC", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_BDC", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_EMC", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpCompatibility", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_BX", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_EX", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Undefined", properties);
        properties = new ArrayList<String>();
        properties.add("name");
        properties.add("isWidthConsistent");
        properties.add("isGlyphPresent");
        properties.add("toUnicode");
        properties.add("renderingMode");
        properties.add("unicodePUA");
        properties.add("actualTextPresent");
        mapOfProperties.put("Glyph", properties);
        properties = new ArrayList<String>();
        properties.add("CID");
        mapOfProperties.put("CIDGlyph", properties);
        links = new ArrayList<String>();
        mapOfLinks.put("Operator", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpGeneralGS", links);
        links = new ArrayList<String>();
        links.add("lineWidth");
        mapOfLinks.put("Op_w_line_width", links);
        links = new ArrayList<String>();
        links.add("lineCap");
        mapOfLinks.put("Op_J_line_cap", links);
        links = new ArrayList<String>();
        links.add("lineJoin");
        mapOfLinks.put("Op_j_line_join", links);
        links = new ArrayList<String>();
        links.add("miterLimit");
        mapOfLinks.put("Op_M_miter_limit", links);
        links = new ArrayList<String>();
        links.add("dashArray");
        links.add("dashPhase");
        mapOfLinks.put("Op_d", links);
        links = new ArrayList<String>();
        links.add("renderingIntent");
        mapOfLinks.put("Op_ri", links);
        links = new ArrayList<String>();
        links.add("flatness");
        mapOfLinks.put("Op_i", links);
        links = new ArrayList<String>();
        links.add("extGState");
        mapOfLinks.put("Op_gs", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpSpecialGS", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_q_gsave", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_Q_grestore", links);
        links = new ArrayList<String>();
        links.add("matrix");
        mapOfLinks.put("Op_cm", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpPathConstruction", links);
        links = new ArrayList<String>();
        links.add("point");
        mapOfLinks.put("Op_m_moveto", links);
        links = new ArrayList<String>();
        links.add("point");
        mapOfLinks.put("Op_l", links);
        links = new ArrayList<String>();
        links.add("controlPoints");
        mapOfLinks.put("Op_c", links);
        links = new ArrayList<String>();
        links.add("controlPoints");
        mapOfLinks.put("Op_v", links);
        links = new ArrayList<String>();
        links.add("controlPoints");
        mapOfLinks.put("Op_y", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_h", links);
        links = new ArrayList<String>();
        links.add("rectBox");
        mapOfLinks.put("Op_re", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpPathPaint", links);
        links = new ArrayList<String>();
        links.add("strokeCS");
        mapOfLinks.put("Op_s_close_stroke", links);
        links = new ArrayList<String>();
        links.add("strokeCS");
        mapOfLinks.put("Op_S_stroke", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        mapOfLinks.put("Op_f_fill", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        mapOfLinks.put("Op_F_fill_obsolete", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        mapOfLinks.put("Op_FStar", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        links.add("strokeCS");
        mapOfLinks.put("Op_B_fill_stroke", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        links.add("strokeCS");
        mapOfLinks.put("Op_BStar_eofill_stroke", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        links.add("strokeCS");
        mapOfLinks.put("Op_b_closepath_fill_stroke", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        links.add("strokeCS");
        mapOfLinks.put("Op_bstar_closepath_eofill_stroke", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_n", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpClip", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_W_clip", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_WStar", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpTextObject", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_ET", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_BT", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpTextState", links);
        links = new ArrayList<String>();
        links.add("scale");
        mapOfLinks.put("Op_Tz", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_Tr", links);
        links = new ArrayList<String>();
        links.add("charSpace");
        mapOfLinks.put("Op_Tc", links);
        links = new ArrayList<String>();
        links.add("size");
        links.add("fontName");
        mapOfLinks.put("Op_Tf", links);
        links = new ArrayList<String>();
        links.add("leading");
        mapOfLinks.put("Op_Tl", links);
        links = new ArrayList<String>();
        links.add("rise");
        mapOfLinks.put("Op_Ts", links);
        links = new ArrayList<String>();
        links.add("wordSpace");
        mapOfLinks.put("Op_Tw", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpTextPosition", links);
        links = new ArrayList<String>();
        links.add("horizontalOffset");
        links.add("verticalOffset");
        mapOfLinks.put("Op_Td", links);
        links = new ArrayList<String>();
        links.add("horizontalOffset");
        links.add("verticalOffset");
        mapOfLinks.put("Op_TD_Big", links);
        links = new ArrayList<String>();
        links.add("controlPoints");
        mapOfLinks.put("Op_Tm", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_T_Star", links);
        links = new ArrayList<String>();
        links.add("font");
        links.add("usedGlyphs");
        links.add("fillCS");
        links.add("strokeCS");
        mapOfLinks.put("OpTextShow", links);
        links = new ArrayList<String>();
        links.add("showString");
        mapOfLinks.put("Op_Tj", links);
        links = new ArrayList<String>();
        links.add("specialStrings");
        mapOfLinks.put("Op_TJ_Big", links);
        links = new ArrayList<String>();
        links.add("showString");
        mapOfLinks.put("Op_Quote", links);
        links = new ArrayList<String>();
        links.add("showString");
        links.add("wordSpacing");
        links.add("characterSpacing");
        mapOfLinks.put("Op_DoubleQuote", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpType3Font", links);
        links = new ArrayList<String>();
        links.add("horizontalDisplacement");
        links.add("verticalDisplacement");
        mapOfLinks.put("Op_d0", links);
        links = new ArrayList<String>();
        links.add("controlPoints");
        mapOfLinks.put("Op_d1", links);
        links = new ArrayList<String>();
        links.add("colorValues");
        mapOfLinks.put("OpSetColor", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_SC_stroke", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_sc_fill", links);
        links = new ArrayList<String>();
        links.add("colorSpace");
        links.add("patternName");
        mapOfLinks.put("OpColor", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_SCN_stroke", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_scn_fill", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_G_stroke", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_g_fill", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_RG_stroke", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_rg_fill", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_K_stroke", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_k_fill", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpShading", links);
        links = new ArrayList<String>();
        links.add("shading");
        mapOfLinks.put("Op_sh", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpInlineImage", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_BI", links);
        links = new ArrayList<String>();
        links.add("inlineImageDictionary");
        mapOfLinks.put("Op_ID", links);
        links = new ArrayList<String>();
        links.add("inlineImage");
        mapOfLinks.put("Op_EI", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpXObject", links);
        links = new ArrayList<String>();
        links.add("xObject");
        mapOfLinks.put("Op_Do", links);
        links = new ArrayList<String>();
        links.add("actualText");
        mapOfLinks.put("OpMarkedContent", links);
        links = new ArrayList<String>();
        links.add("tag");
        mapOfLinks.put("Op_MP", links);
        links = new ArrayList<String>();
        links.add("tag");
        links.add("properties");
        mapOfLinks.put("Op_DP", links);
        links = new ArrayList<String>();
        links.add("tag");
        mapOfLinks.put("Op_BMC", links);
        links = new ArrayList<String>();
        links.add("tag");
        links.add("properties");
        links.add("Lang");
        mapOfLinks.put("Op_BDC", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_EMC", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpCompatibility", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_BX", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_EX", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_Undefined", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Glyph", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CIDGlyph", links);
        mapOfSuperNames.put("SAPDFDocument", "Object");
        mapOfSuperNames.put("SAStructTreeRoot", "Object");
        mapOfSuperNames.put("SAStructElem", "Object");
        mapOfSuperNames.put("SAChunk", "Object");
        mapOfSuperNames.put("SAPage", "Object");
        mapOfSuperNames.put("SAAnnotation", "Object");
        mapOfSuperNames.put("SARepeatedCharacters", "Object");
        mapOfSuperNames.put("SALinkAnnotation", "SAAnnotation");
        mapOfSuperNames.put("SATextChunk", "SAChunk");
        mapOfSuperNames.put("SAImageChunk", "SAChunk");
        mapOfSuperNames.put("SADocument", "SAStructElem");
        mapOfSuperNames.put("SAPart", "SAStructElem");
        mapOfSuperNames.put("SADiv", "SAStructElem");
        mapOfSuperNames.put("SACaption", "SAStructElem");
        mapOfSuperNames.put("SAH", "SAStructElem");
        mapOfSuperNames.put("SAP", "SAStructElem");
        mapOfSuperNames.put("SAL", "SAStructElem");
        mapOfSuperNames.put("SALI", "SAStructElem");
        mapOfSuperNames.put("SALbl", "SAStructElem");
        mapOfSuperNames.put("SALBody", "SAStructElem");
        mapOfSuperNames.put("SATable", "SAStructElem");
        mapOfSuperNames.put("SATR", "SAStructElem");
        mapOfSuperNames.put("SATH", "SAStructElem");
        mapOfSuperNames.put("SATD", "SAStructElem");
        mapOfSuperNames.put("SASpan", "SAStructElem");
        mapOfSuperNames.put("SALink", "SAStructElem");
        mapOfSuperNames.put("SAArt", "SAStructElem");
        mapOfSuperNames.put("SASect", "SAStructElem");
        mapOfSuperNames.put("SABlockQuote", "SAStructElem");
        mapOfSuperNames.put("SATOC", "SAStructElem");
        mapOfSuperNames.put("SATOCI", "SAStructElem");
        mapOfSuperNames.put("SAIndex", "SAStructElem");
        mapOfSuperNames.put("SANonStruct", "SAStructElem");
        mapOfSuperNames.put("SAPrivate", "SAStructElem");
        mapOfSuperNames.put("SAQuote", "SAStructElem");
        mapOfSuperNames.put("SANote", "SAStructElem");
        mapOfSuperNames.put("SAReference", "SAStructElem");
        mapOfSuperNames.put("SABibEntry", "SAStructElem");
        mapOfSuperNames.put("SACode", "SAStructElem");
        mapOfSuperNames.put("SAHn", "SAStructElem");
        mapOfSuperNames.put("SAFigure", "SAStructElem");
        mapOfSuperNames.put("SAFormula", "SAStructElem");
        mapOfSuperNames.put("SAForm", "SAStructElem");
        mapOfSuperNames.put("SATHead", "SAStructElem");
        mapOfSuperNames.put("SATBody", "SAStructElem");
        mapOfSuperNames.put("SATFoot", "SAStructElem");
        mapOfSuperNames.put("SAAnnot", "SAStructElem");
        mapOfSuperNames.put("SARuby", "SAStructElem");
        mapOfSuperNames.put("SAWarichu", "SAStructElem");
        mapOfSuperNames.put("SARB", "SAStructElem");
        mapOfSuperNames.put("SART", "SAStructElem");
        mapOfSuperNames.put("SARP", "SAStructElem");
        mapOfSuperNames.put("SAWT", "SAStructElem");
        mapOfSuperNames.put("SAWP", "SAStructElem");
        mapOfSuperNames.put("SADocumentFragment", "SAStructElem");
        mapOfSuperNames.put("SAAside", "SAStructElem");
        mapOfSuperNames.put("SATitle", "SAStructElem");
        mapOfSuperNames.put("SAFENote", "SAStructElem");
        mapOfSuperNames.put("SASub", "SAStructElem");
        mapOfSuperNames.put("SAEm", "SAStructElem");
        mapOfSuperNames.put("SAStrong", "SAStructElem");
        mapOfSuperNames.put("SAArtifact", "SAStructElem");
        mapOfSuperNames.put("SANonStandard", "SAStructElem");
        properties = new ArrayList<String>();
        mapOfProperties.put("SAPDFDocument", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAStructTreeRoot", properties);
        properties = new ArrayList<String>();
        properties.add("correctSemanticScore");
        properties.add("hasCorrectType");
        properties.add("correctType");
        properties.add("standardType");
        properties.add("isTableElem");
        properties.add("isTableChild");
        properties.add("isListElem");
        properties.add("isListChild");
        properties.add("structureID");
        properties.add("isLeafElem");
        properties.add("numberOfSameCharacters");
        properties.add("numberOfRepeatedSpaces");
        properties.add("positionOfRepeatedSpaces");
        properties.add("parentsStandardTypes");
        mapOfProperties.put("SAStructElem", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAChunk", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAPage", properties);
        properties = new ArrayList<String>();
        properties.add("textValue");
        properties.add("F");
        properties.add("Contents");
        properties.add("Alt");
        properties.add("isOutsideCropBox");
        mapOfProperties.put("SAAnnotation", properties);
        properties = new ArrayList<String>();
        properties.add("isNonSpace");
        properties.add("numberOfRepeatedCharacters");
        mapOfProperties.put("SARepeatedCharacters", properties);
        properties = new ArrayList<String>();
        properties.add("textValueIsLink");
        properties.add("contentsIsLink");
        properties.add("altIsLink");
        mapOfProperties.put("SALinkAnnotation", properties);
        properties = new ArrayList<String>();
        properties.add("textSize");
        properties.add("contrastRatio");
        properties.add("textWeight");
        properties.add("hasSpecialStyle");
        properties.add("isUnderlined");
        properties.add("parentsStandardTypes");
        mapOfProperties.put("SATextChunk", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAImageChunk", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SADocument", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAPart", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SADiv", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SACaption", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAH", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAP", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAL", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SALI", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SALbl", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SALBody", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SATable", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SATR", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SATH", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SATD", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SASpan", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SALink", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAArt", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SASect", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SABlockQuote", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SATOC", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SATOCI", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAIndex", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SANonStruct", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAPrivate", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAQuote", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SANote", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAReference", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SABibEntry", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SACode", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAHn", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAFigure", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAFormula", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAForm", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SATHead", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SATBody", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SATFoot", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAAnnot", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SARuby", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAWarichu", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SARB", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SART", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SARP", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAWT", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAWP", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SADocumentFragment", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAAside", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SATitle", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAFENote", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SASub", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAEm", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAStrong", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SAArtifact", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SANonStandard", properties);
        links = new ArrayList<String>();
        links.add("StructTreeRoot");
        links.add("pages");
        links.add("repeatedCharacters");
        mapOfLinks.put("SAPDFDocument", links);
        links = new ArrayList<String>();
        links.add("children");
        mapOfLinks.put("SAStructTreeRoot", links);
        links = new ArrayList<String>();
        links.add("children");
        mapOfLinks.put("SAStructElem", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAChunk", links);
        links = new ArrayList<String>();
        links.add("artifacts");
        links.add("annots");
        mapOfLinks.put("SAPage", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAAnnotation", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SARepeatedCharacters", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SALinkAnnotation", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SATextChunk", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAImageChunk", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SADocument", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAPart", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SADiv", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SACaption", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAH", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAP", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAL", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SALI", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SALbl", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SALBody", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SATable", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SATR", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SATH", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SATD", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SASpan", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SALink", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAArt", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SASect", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SABlockQuote", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SATOC", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SATOCI", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAIndex", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SANonStruct", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAPrivate", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAQuote", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SANote", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAReference", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SABibEntry", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SACode", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAHn", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAFigure", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAFormula", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAForm", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SATHead", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SATBody", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SATFoot", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAAnnot", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SARuby", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAWarichu", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SARB", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SART", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SARP", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAWT", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAWP", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SADocumentFragment", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAAside", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SATitle", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAFENote", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SASub", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAEm", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAStrong", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SAArtifact", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SANonStandard", links);
        mapOfSuperNames.put("Object", null);
        properties = new ArrayList<String>();
        mapOfProperties.put("Object", properties);
        links = new ArrayList<String>();
        mapOfLinks.put("Object", links);
        mapOfSuperNames.put("CosObject", "Object");
        mapOfSuperNames.put("CosDocument", "CosObject");
        mapOfSuperNames.put("CosIndirect", "CosObject");
        mapOfSuperNames.put("CosNull", "CosObject");
        mapOfSuperNames.put("CosBool", "CosObject");
        mapOfSuperNames.put("CosNumber", "CosObject");
        mapOfSuperNames.put("CosReal", "CosNumber");
        mapOfSuperNames.put("CosInteger", "CosNumber");
        mapOfSuperNames.put("CosName", "CosObject");
        mapOfSuperNames.put("CosBM", "CosName");
        mapOfSuperNames.put("CosActualText", "CosString");
        mapOfSuperNames.put("CosUnicodeName", "CosName");
        mapOfSuperNames.put("CosRenderingIntent", "CosName");
        mapOfSuperNames.put("CosFilter", "CosName");
        mapOfSuperNames.put("CosIIFilter", "CosName");
        mapOfSuperNames.put("CosString", "CosObject");
        mapOfSuperNames.put("CosTextString", "CosString");
        mapOfSuperNames.put("CosLang", "CosTextString");
        mapOfSuperNames.put("CosDict", "CosObject");
        mapOfSuperNames.put("CosStream", "CosDict");
        mapOfSuperNames.put("CosFileSpecification", "CosDict");
        mapOfSuperNames.put("CosTrailer", "CosDict");
        mapOfSuperNames.put("CosInfo", "CosDict");
        mapOfSuperNames.put("CosArray", "CosObject");
        mapOfSuperNames.put("CosBBox", "CosArray");
        mapOfSuperNames.put("CosXRef", "CosObject");
        properties = new ArrayList<String>();
        mapOfProperties.put("CosObject", properties);
        properties = new ArrayList<String>();
        properties.add("nrIndirects");
        properties.add("headerVersion");
        properties.add("isOptionalContentPresent");
        properties.add("postEOFDataSize");
        properties.add("doesInfoMatchXMP");
        properties.add("firstPageID");
        properties.add("lastID");
        properties.add("isLinearized");
        properties.add("headerOffset");
        properties.add("header");
        properties.add("headerByte1");
        properties.add("headerByte2");
        properties.add("headerByte3");
        properties.add("headerByte4");
        properties.add("Marked");
        properties.add("Requirements");
        properties.add("NeedsRendering");
        properties.add("containsEmbeddedFiles");
        properties.add("Suspects");
        properties.add("DisplayDocTitle");
        properties.add("containsInfo");
        properties.add("containsPieceInfo");
        mapOfProperties.put("CosDocument", properties);
        properties = new ArrayList<String>();
        properties.add("spacingCompliesPDFA");
        mapOfProperties.put("CosIndirect", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("CosNull", properties);
        properties = new ArrayList<String>();
        properties.add("value");
        mapOfProperties.put("CosBool", properties);
        properties = new ArrayList<String>();
        properties.add("stringValue");
        properties.add("intValue");
        properties.add("realValue");
        mapOfProperties.put("CosNumber", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("CosReal", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("CosInteger", properties);
        properties = new ArrayList<String>();
        properties.add("internalRepresentation");
        mapOfProperties.put("CosName", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("CosBM", properties);
        properties = new ArrayList<String>();
        properties.add("containsPUA");
        mapOfProperties.put("CosActualText", properties);
        properties = new ArrayList<String>();
        properties.add("isValidUtf8");
        properties.add("unicodeValue");
        mapOfProperties.put("CosUnicodeName", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("CosRenderingIntent", properties);
        properties = new ArrayList<String>();
        properties.add("decodeParms");
        mapOfProperties.put("CosFilter", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("CosIIFilter", properties);
        properties = new ArrayList<String>();
        properties.add("value");
        properties.add("isHex");
        properties.add("containsOnlyHex");
        properties.add("hexCount");
        mapOfProperties.put("CosString", properties);
        properties = new ArrayList<String>();
        properties.add("unicodeValue");
        mapOfProperties.put("CosTextString", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("CosLang", properties);
        properties = new ArrayList<String>();
        properties.add("size");
        mapOfProperties.put("CosDict", properties);
        properties = new ArrayList<String>();
        properties.add("Length");
        properties.add("F");
        properties.add("FFilter");
        properties.add("FDecodeParms");
        properties.add("streamKeywordCRLFCompliant");
        properties.add("endstreamKeywordEOLCompliant");
        properties.add("isLengthCorrect");
        mapOfProperties.put("CosStream", properties);
        properties = new ArrayList<String>();
        properties.add("containsEF");
        properties.add("F");
        properties.add("UF");
        properties.add("AFRelationship");
        properties.add("isAssociatedFile");
        mapOfProperties.put("CosFileSpecification", properties);
        properties = new ArrayList<String>();
        properties.add("isEncrypted");
        mapOfProperties.put("CosTrailer", properties);
        properties = new ArrayList<String>();
        properties.add("ModDate");
        mapOfProperties.put("CosInfo", properties);
        properties = new ArrayList<String>();
        properties.add("size");
        mapOfProperties.put("CosArray", properties);
        properties = new ArrayList<String>();
        properties.add("top");
        properties.add("bottom");
        properties.add("left");
        properties.add("right");
        mapOfProperties.put("CosBBox", properties);
        properties = new ArrayList<String>();
        properties.add("subsectionHeaderSpaceSeparated");
        properties.add("xrefEOLMarkersComplyPDFA");
        mapOfProperties.put("CosXRef", properties);
        links = new ArrayList<String>();
        mapOfLinks.put("CosObject", links);
        links = new ArrayList<String>();
        links.add("doc");
        links.add("EmbeddedFiles");
        links.add("xref");
        links.add("trailer");
        links.add("indirectObjects");
        links.add("document");
        mapOfLinks.put("CosDocument", links);
        links = new ArrayList<String>();
        links.add("directObject");
        mapOfLinks.put("CosIndirect", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosNull", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosBool", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosNumber", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosReal", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosInteger", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosName", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosBM", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosActualText", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosUnicodeName", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosRenderingIntent", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosFilter", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosIIFilter", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosString", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosTextString", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosLang", links);
        links = new ArrayList<String>();
        links.add("keys");
        links.add("values");
        links.add("metadata");
        mapOfLinks.put("CosDict", links);
        links = new ArrayList<String>();
        links.add("filters");
        mapOfLinks.put("CosStream", links);
        links = new ArrayList<String>();
        links.add("EF");
        mapOfLinks.put("CosFileSpecification", links);
        links = new ArrayList<String>();
        links.add("Catalog");
        links.add("Encrypt");
        links.add("Info");
        mapOfLinks.put("CosTrailer", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosInfo", links);
        links = new ArrayList<String>();
        links.add("elements");
        mapOfLinks.put("CosArray", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosBBox", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosXRef", links);
        mapOfSuperNames.put("SENonStandard", "PDStructElem");
        mapOfSuperNames.put("SEDocument", "PDStructElem");
        mapOfSuperNames.put("SEPart", "PDStructElem");
        mapOfSuperNames.put("SEDiv", "PDStructElem");
        mapOfSuperNames.put("SECaption", "PDStructElem");
        mapOfSuperNames.put("SEH", "PDStructElem");
        mapOfSuperNames.put("SEP", "PDStructElem");
        mapOfSuperNames.put("SEL", "PDStructElem");
        mapOfSuperNames.put("SELI", "PDStructElem");
        mapOfSuperNames.put("SELbl", "PDStructElem");
        mapOfSuperNames.put("SELBody", "PDStructElem");
        mapOfSuperNames.put("SETable", "PDStructElem");
        mapOfSuperNames.put("SETR", "PDStructElem");
        mapOfSuperNames.put("SETH", "PDStructElem");
        mapOfSuperNames.put("SETD", "PDStructElem");
        mapOfSuperNames.put("SESpan", "PDStructElem");
        mapOfSuperNames.put("SELink", "PDStructElem");
        mapOfSuperNames.put("SEArt", "PDStructElem");
        mapOfSuperNames.put("SESect", "PDStructElem");
        mapOfSuperNames.put("SEBlockQuote", "PDStructElem");
        mapOfSuperNames.put("SETOC", "PDStructElem");
        mapOfSuperNames.put("SETOCI", "PDStructElem");
        mapOfSuperNames.put("SEIndex", "PDStructElem");
        mapOfSuperNames.put("SENonStruct", "PDStructElem");
        mapOfSuperNames.put("SEPrivate", "PDStructElem");
        mapOfSuperNames.put("SEQuote", "PDStructElem");
        mapOfSuperNames.put("SENote", "PDStructElem");
        mapOfSuperNames.put("SEReference", "PDStructElem");
        mapOfSuperNames.put("SEBibEntry", "PDStructElem");
        mapOfSuperNames.put("SECode", "PDStructElem");
        mapOfSuperNames.put("SEHn", "PDStructElem");
        mapOfSuperNames.put("SEFigure", "PDStructElem");
        mapOfSuperNames.put("SEFormula", "PDStructElem");
        mapOfSuperNames.put("SEContentItem", "Object");
        mapOfSuperNames.put("SESimpleContentItem", "SEContentItem");
        mapOfSuperNames.put("SEMarkedContent", "SEContentItem");
        mapOfSuperNames.put("SEUnmarkedContent", "SEContentItem");
        mapOfSuperNames.put("SETextItem", "SESimpleContentItem");
        mapOfSuperNames.put("SELineArtItem", "SESimpleContentItem");
        mapOfSuperNames.put("SEShadingItem", "SESimpleContentItem");
        mapOfSuperNames.put("SEImageItem", "SESimpleContentItem");
        mapOfSuperNames.put("SEInlineImageItem", "SEImageItem");
        mapOfSuperNames.put("SEImageXObjectItem", "SEImageItem");
        mapOfSuperNames.put("SEForm", "PDStructElem");
        mapOfSuperNames.put("SETHead", "PDStructElem");
        mapOfSuperNames.put("SETBody", "PDStructElem");
        mapOfSuperNames.put("SETFoot", "PDStructElem");
        mapOfSuperNames.put("SEAnnot", "PDStructElem");
        mapOfSuperNames.put("SERuby", "PDStructElem");
        mapOfSuperNames.put("SEWarichu", "PDStructElem");
        mapOfSuperNames.put("SERB", "PDStructElem");
        mapOfSuperNames.put("SERT", "PDStructElem");
        mapOfSuperNames.put("SERP", "PDStructElem");
        mapOfSuperNames.put("SEWT", "PDStructElem");
        mapOfSuperNames.put("SEWP", "PDStructElem");
        mapOfSuperNames.put("SEDocumentFragment", "PDStructElem");
        mapOfSuperNames.put("SEAside", "PDStructElem");
        mapOfSuperNames.put("SETitle", "PDStructElem");
        mapOfSuperNames.put("SEFENote", "PDStructElem");
        mapOfSuperNames.put("SESub", "PDStructElem");
        mapOfSuperNames.put("SEEm", "PDStructElem");
        mapOfSuperNames.put("SEStrong", "PDStructElem");
        mapOfSuperNames.put("SEArtifact", "PDStructElem");
        properties = new ArrayList<String>();
        mapOfProperties.put("SENonStandard", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEDocument", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEPart", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEDiv", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SECaption", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEH", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEP", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEL", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SELI", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SELbl", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SELBody", properties);
        properties = new ArrayList<String>();
        properties.add("useHeadersAndIdOrScope");
        properties.add("isRegular");
        mapOfProperties.put("SETable", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SETR", properties);
        properties = new ArrayList<String>();
        properties.add("ColSpan");
        properties.add("RowSpan");
        mapOfProperties.put("SETH", properties);
        properties = new ArrayList<String>();
        properties.add("ColSpan");
        properties.add("RowSpan");
        mapOfProperties.put("SETD", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SESpan", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SELink", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEArt", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SESect", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEBlockQuote", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SETOC", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SETOCI", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEIndex", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SENonStruct", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEPrivate", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEQuote", properties);
        properties = new ArrayList<String>();
        properties.add("noteID");
        properties.add("hasDuplicateNoteID");
        mapOfProperties.put("SENote", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEReference", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEBibEntry", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SECode", properties);
        properties = new ArrayList<String>();
        properties.add("hasCorrectNestingLevel");
        mapOfProperties.put("SEHn", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEFigure", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEFormula", properties);
        properties = new ArrayList<String>();
        properties.add("suspectRole");
        properties.add("parentsTags");
        properties.add("parentStructureTag");
        properties.add("parentStandardTag");
        mapOfProperties.put("SEContentItem", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SESimpleContentItem", properties);
        properties = new ArrayList<String>();
        properties.add("tag");
        properties.add("structureTag");
        properties.add("E");
        properties.add("Alt");
        properties.add("ActualText");
        properties.add("inheritedLang");
        mapOfProperties.put("SEMarkedContent", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEUnmarkedContent", properties);
        properties = new ArrayList<String>();
        properties.add("fontName");
        properties.add("scaleFactor");
        properties.add("Lang");
        mapOfProperties.put("SETextItem", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SELineArtItem", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEShadingItem", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEImageItem", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEInlineImageItem", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEImageXObjectItem", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEForm", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SETHead", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SETBody", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SETFoot", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEAnnot", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SERuby", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEWarichu", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SERB", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SERT", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SERP", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEWT", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEWP", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEDocumentFragment", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEAside", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SETitle", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEFENote", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SESub", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEEm", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEStrong", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("SEArtifact", properties);
        links = new ArrayList<String>();
        mapOfLinks.put("SENonStandard", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEDocument", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEPart", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEDiv", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SECaption", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEH", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEP", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEL", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SELI", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SELbl", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SELBody", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SETable", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SETR", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SETH", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SETD", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SESpan", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SELink", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEArt", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SESect", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEBlockQuote", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SETOC", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SETOCI", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEIndex", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SENonStruct", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEPrivate", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEQuote", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SENote", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEReference", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEBibEntry", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SECode", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEHn", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEFigure", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEFormula", links);
        links = new ArrayList<String>();
        links.add("contentItem");
        mapOfLinks.put("SEContentItem", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SESimpleContentItem", links);
        links = new ArrayList<String>();
        links.add("Lang");
        mapOfLinks.put("SEMarkedContent", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEUnmarkedContent", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SETextItem", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SELineArtItem", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEShadingItem", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEImageItem", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEInlineImageItem", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEImageXObjectItem", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEForm", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SETHead", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SETBody", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SETFoot", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEAnnot", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SERuby", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEWarichu", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SERB", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SERT", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SERP", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEWT", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEWP", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEDocumentFragment", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEAside", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SETitle", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEFENote", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SESub", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEEm", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEStrong", links);
        links = new ArrayList<String>();
        mapOfLinks.put("SEArtifact", links);
    }
}

