/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cli;

import com.beust.jcommander.DefaultUsageFormatter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.Strings;
import com.beust.jcommander.WrappedParameter;
import java.util.EnumSet;
import java.util.List;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.validation.profiles.Profiles;

public class FormatterHelper
extends DefaultUsageFormatter {
    private static final String FLAVOUR = "flavour";

    public FormatterHelper(JCommander commander) {
        super(commander);
    }

    @Override
    public void appendAllParametersDetails(StringBuilder out, int indentCount, String indent, List<ParameterDescription> sortedParameters) {
        if (sortedParameters.size() > 0) {
            out.append(indent).append("  Options:\n");
        }
        for (ParameterDescription pd : sortedParameters) {
            Class<?> type;
            WrappedParameter parameter = pd.getParameter();
            String description = pd.getDescription();
            boolean hasDescription = !description.isEmpty();
            out.append(indent).append("  ").append(parameter.required() ? "* " : "  ").append(pd.getNames()).append("\n");
            if (hasDescription) {
                this.wrapDescription(out, indentCount, FormatterHelper.s(indentCount) + description);
            }
            Object def = pd.getDefault();
            if (pd.isDynamicParameter()) {
                String syntax = "Syntax: " + parameter.names()[0] + "key" + parameter.getAssignment() + "value";
                if (hasDescription) {
                    out.append(FormatterHelper.newLineAndIndent(indentCount));
                } else {
                    out.append(FormatterHelper.s(indentCount));
                }
                out.append(syntax);
            }
            if (def != null && !pd.isHelp()) {
                String displayedDef = Strings.isStringEmpty(def.toString()) ? "<empty string>" : def.toString();
                String defaultText = "Default: " + (parameter.password() ? "********" : displayedDef);
                if (hasDescription) {
                    out.append(FormatterHelper.newLineAndIndent(indentCount));
                } else {
                    out.append(FormatterHelper.s(indentCount));
                }
                out.append(defaultText);
            }
            if ((type = pd.getParameterized().getType()).isEnum()) {
                String valueList;
                if (PDFAFlavour.class.getCanonicalName().equals(type.getName())) {
                    EnumSet<PDFAFlavour> flavours = EnumSet.copyOf(Profiles.getVeraProfileDirectory().getPDFAFlavours());
                    if (FLAVOUR.equals(pd.getParameterized().getName())) {
                        flavours.add(PDFAFlavour.NO_FLAVOUR);
                    }
                    valueList = flavours.toString();
                } else {
                    valueList = EnumSet.allOf(type).toString();
                }
                String possibleValues = "Possible Values: " + valueList;
                if (!description.contains("Options: " + valueList)) {
                    if (hasDescription) {
                        out.append(FormatterHelper.newLineAndIndent(indentCount));
                    } else {
                        out.append(FormatterHelper.s(indentCount));
                    }
                    out.append(possibleValues);
                }
            }
            out.append("\n");
        }
    }

    private static String newLineAndIndent(int indent) {
        return "\n" + FormatterHelper.s(indent);
    }
}

