/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cli.multithread;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;
import org.verapdf.apps.Applications;
import org.verapdf.apps.utils.ApplicationUtils;
import org.verapdf.cli.CliConstants;
import org.verapdf.cli.commands.VeraCliArgParser;
import org.verapdf.cli.multithread.BaseCliRunner;
import org.verapdf.processor.FormatOption;
import org.verapdf.processor.reports.ResultStructure;
import org.verapdf.processor.reports.multithread.MultiThreadProcessingHandler;
import org.verapdf.processor.reports.multithread.MultiThreadProcessingHandlerImpl;
import org.verapdf.processor.reports.multithread.writer.ReportWriter;
import org.verapdf.report.HTMLReport;

public class MultiThreadProcessor {
    private static final Logger LOGGER = Logger.getLogger(MultiThreadProcessor.class.getCanonicalName());
    private static final int DEFAULT_BUFFER_SIZE = 512;
    private static final int COEFFICIENT_BUFFER_SIZE = 1024;
    private final Queue<File> filesToProcess;
    private int filesQuantity;
    private File veraPDFStarterPath;
    private List<String> veraPDFParameters;
    private OutputStream os;
    private OutputStream errorStream;
    private ReportWriter reportWriter;
    private MultiThreadProcessingHandler processingHandler;
    private boolean isFirstReport = true;
    private boolean isHTMLReport;
    private File xmlReport;
    private String wikiPath;
    private CliConstants.ExitCodes currentExitCode = CliConstants.ExitCodes.VALID;
    private CountDownLatch latch;

    private MultiThreadProcessor(VeraCliArgParser cliArgParser, String wikiPath) {
        boolean bl = this.isHTMLReport = cliArgParser.getFormat() == FormatOption.HTML;
        if (this.isHTMLReport) {
            try {
                this.xmlReport = File.createTempFile("veraPDF", "report.xml");
                this.os = new BufferedOutputStream(new FileOutputStream(this.xmlReport), 524288);
            }
            catch (IOException e) {
                this.isHTMLReport = false;
                LOGGER.log(Level.WARNING, "Problem with generating html report");
            }
        }
        if (!this.isHTMLReport) {
            this.os = new BufferedOutputStream(System.out, 524288);
        }
        this.wikiPath = wikiPath;
        this.errorStream = new BufferedOutputStream(System.err, 512);
        this.veraPDFStarterPath = this.getVeraPdfStarterFile(cliArgParser);
        this.veraPDFParameters = VeraCliArgParser.getBaseVeraPDFParameters(cliArgParser);
        this.filesToProcess = new ConcurrentLinkedQueue<File>();
        this.filesToProcess.addAll(this.getFiles(cliArgParser.getPdfPaths(), cliArgParser.isRecurse(), cliArgParser.nonPdfExt()));
        this.filesQuantity = this.filesToProcess.size();
        FormatOption outputFormat = this.getOutputFormat(cliArgParser.getFormat().getOption());
        this.reportWriter = ReportWriter.newInstance(this.os, outputFormat, this.errorStream);
        this.processingHandler = new MultiThreadProcessingHandlerImpl(this.reportWriter);
    }

    public static CliConstants.ExitCodes process(VeraCliArgParser cliArgParser, String wikiPath) throws InterruptedException {
        MultiThreadProcessor processor = new MultiThreadProcessor(cliArgParser, wikiPath);
        if (processor.currentExitCode != CliConstants.ExitCodes.VALID) {
            return processor.currentExitCode;
        }
        return processor.startProcesses(cliArgParser.getNumberOfProcesses());
    }

    private File getVeraPdfStarterFile(VeraCliArgParser cliArgParser) {
        File veraPDFPath = cliArgParser.getVeraCLIPath();
        if (veraPDFPath == null || !veraPDFPath.isFile()) {
            try {
                veraPDFPath = Applications.getVeraScriptFile();
                if (veraPDFPath == null) {
                    throw new IllegalStateException("Can't obtain executable veraPDF CLI script path");
                }
            }
            catch (IllegalStateException e) {
                LOGGER.log(Level.SEVERE, "Can't obtain veraPDF CLI script path", e);
                this.currentExitCode = CliConstants.ExitCodes.FAILED_MULTIPROCESS_START;
            }
        }
        return veraPDFPath;
    }

    private FormatOption getOutputFormat(String outputFormat) {
        FormatOption formatOption = FormatOption.fromOption(outputFormat);
        if (formatOption == FormatOption.HTML) {
            return FormatOption.MRR;
        }
        return formatOption;
    }

    public synchronized void write(ResultStructure result) {
        if (this.isFirstReport) {
            this.processingHandler.startReport();
            this.processingHandler.fillReport(result);
            this.isFirstReport = false;
        } else {
            this.processingHandler.fillReport(result);
        }
        --this.filesQuantity;
        if (this.filesQuantity == 0) {
            this.processingHandler.endReport();
            if (this.isHTMLReport) {
                this.os = new BufferedOutputStream(System.out, 524288);
                try (FileInputStream inputStream = new FileInputStream(this.xmlReport);){
                    HTMLReport.writeHTMLReport(inputStream, this.os, true, this.wikiPath, true);
                }
                catch (IOException | TransformerException e) {
                    LOGGER.log(Level.WARNING, "Problem with generating html report");
                }
            }
        }
    }

    private List<File> getFiles(List<String> pdfPaths, boolean isRecurse, boolean nonPdfExt) {
        ArrayList<File> toFilter = new ArrayList<File>(pdfPaths.size());
        pdfPaths.forEach(path -> toFilter.add(new File((String)path)));
        return ApplicationUtils.filterPdfFiles(toFilter, isRecurse, nonPdfExt);
    }

    private CliConstants.ExitCodes startProcesses(int numberOfProcesses) throws InterruptedException {
        int processesQuantity = Math.min(numberOfProcesses, this.filesToProcess.size());
        this.latch = new CountDownLatch(processesQuantity);
        ExecutorService executor = Executors.newFixedThreadPool(processesQuantity);
        for (int i = 0; i < processesQuantity; ++i) {
            BaseCliRunner veraPDFRunner = new BaseCliRunner(this, this.veraPDFStarterPath.getAbsolutePath(), this.veraPDFParameters, this.filesToProcess);
            executor.submit(veraPDFRunner);
        }
        this.latch.await();
        return this.currentExitCode;
    }

    public void countDown(CliConstants.ExitCodes exitCode) {
        if (exitCode != null && exitCode.value > this.currentExitCode.value) {
            this.currentExitCode = exitCode;
        }
        if (this.latch != null) {
            this.latch.countDown();
        }
    }
}

