/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.cos;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSEmbeddedFileDict;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.cos.GFCosDict;
import org.verapdf.gf.model.impl.external.GFEmbeddedFile;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosFileSpecification;
import org.verapdf.model.external.EmbeddedFile;

public class GFCosFileSpecification
extends GFCosDict
implements CosFileSpecification {
    public static final String COS_FILE_SPECIFICATION_TYPE = "CosFileSpecification";
    public static final String EF = "EF";
    private final String f;
    private final String uf;
    private final String afrelationship;

    public GFCosFileSpecification(COSDictionary dictionary) {
        super(dictionary, COS_FILE_SPECIFICATION_TYPE);
        this.f = this.baseObject.getStringKey(ASAtom.F);
        this.uf = this.baseObject.getStringKey(ASAtom.UF);
        this.afrelationship = dictionary.getStringKey(ASAtom.AF_RELATIONSHIP);
    }

    @Override
    public String getF() {
        return this.f;
    }

    @Override
    public String getUF() {
        return this.uf;
    }

    @Override
    public String getAFRelationship() {
        return this.afrelationship;
    }

    @Override
    public Boolean getisAssociatedFile() {
        return this.baseObject != null && StaticContainers.getFileSpecificationKeys().contains(this.baseObject.getObjectKey());
    }

    @Override
    public Boolean getcontainsEF() {
        return this.baseObject != null && this.baseObject.knownKey(ASAtom.EF) != false;
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        if (EF.equals(link)) {
            return this.getEFFile();
        }
        return super.getLinkedObjects(link);
    }

    private List<EmbeddedFile> getEFFile() {
        COSObject efDictionary = this.baseObject.getKey(ASAtom.EF);
        if (efDictionary != null && efDictionary.getType().isDictionaryBased()) {
            COSEmbeddedFileDict embeddedFileDict = new COSEmbeddedFileDict((COSDictionary)efDictionary.getDirectBase());
            ArrayList<GFEmbeddedFile> list = new ArrayList<GFEmbeddedFile>();
            for (COSStream embeddedFileStream : embeddedFileDict.getEmbeddedFileStreams()) {
                list.add(new GFEmbeddedFile(embeddedFileStream));
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }
}

