/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.gfse;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.verapdf.gf.model.impl.pd.GFPDStructElem;
import org.verapdf.gf.model.impl.pd.gfse.GFSETD;
import org.verapdf.gf.model.impl.pd.gfse.GFSETH;
import org.verapdf.model.selayer.SETable;
import org.verapdf.pd.structure.PDStructElem;

public class GFSETable
extends GFPDStructElem
implements SETable {
    public static final String TABLE_STRUCTURE_ELEMENT_TYPE = "SETable";

    public GFSETable(PDStructElem structElemDictionary) {
        super(structElemDictionary, "Table", TABLE_STRUCTURE_ELEMENT_TYPE);
    }

    @Override
    public Boolean getuseHeadersAndIdOrScope() {
        Stack<GFPDStructElem> stack = new Stack<GFPDStructElem>();
        boolean hasScope = true;
        boolean hasID = true;
        boolean hasHeaders = true;
        HashSet<String> idSet = new HashSet<String>();
        HashSet<String> headersSet = new HashSet<String>();
        stack.push(this);
        while (!stack.empty()) {
            GFPDStructElem elem = (GFPDStructElem)stack.pop();
            String type = elem.getstandardType();
            if ("TD".equals(type)) {
                List<String> list = ((GFSETD)elem).getHeaders();
                if (list != null && !list.isEmpty()) {
                    headersSet.addAll(list);
                } else {
                    hasHeaders = false;
                }
            } else if ("TH".equals(type)) {
                String id = ((GFSETH)elem).getTHID();
                if (id == null || id.isEmpty()) {
                    hasID = false;
                } else {
                    idSet.add(id);
                }
                if (((GFSETH)elem).getScope() == null) {
                    hasScope = false;
                }
            }
            stack.addAll(elem.getChildren());
        }
        if (hasScope) {
            return true;
        }
        if (!hasID || !hasHeaders) {
            return false;
        }
        for (String headers : headersSet) {
            if (idSet.contains(headers)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean getisRegular() {
        int j;
        int i;
        List<GFPDStructElem> listTR = this.getTR();
        int rowNum = listTR.size();
        if (rowNum == 0) {
            return true;
        }
        int columnNum = this.getColumnNum(listTR.get(0));
        boolean[][] cells = new boolean[rowNum][columnNum];
        for (i = 0; i < rowNum; ++i) {
            j = 0;
            for (org.verapdf.model.pdlayer.PDStructElem pDStructElem : listTR.get(i).getChildren()) {
                long rowSpan;
                long colSpan;
                String type = pDStructElem.getstandardType();
                if ("TH".equals(type)) {
                    colSpan = ((GFSETH)pDStructElem).getColSpan();
                    rowSpan = ((GFSETH)pDStructElem).getRowSpan();
                } else {
                    if (!"TD".equals(type)) continue;
                    colSpan = ((GFSETD)pDStructElem).getColSpan();
                    rowSpan = ((GFSETD)pDStructElem).getRowSpan();
                }
                while (j < columnNum && cells[i][j]) {
                    ++j;
                }
                if (j >= columnNum) {
                    return false;
                }
                if ((long)i + rowSpan > (long)rowNum || (long)j + colSpan > (long)columnNum) {
                    return false;
                }
                if (!this.checkRegular(cells, rowSpan, colSpan, i, j).booleanValue()) {
                    return false;
                }
                j = (int)((long)j + colSpan);
            }
        }
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < columnNum; ++j) {
                if (cells[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    private List<GFPDStructElem> getTR() {
        LinkedList<GFPDStructElem> listTR = new LinkedList<GFPDStructElem>();
        for (GFPDStructElem elem : this.getChildren()) {
            String type = elem.getstandardType();
            if ("TR".equals(type)) {
                listTR.add(elem);
                continue;
            }
            if (!"THead".equals(type) && !"TBody".equals(type) && !"TFoot".equals(type)) continue;
            for (GFPDStructElem child : elem.getChildren()) {
                if (!"TR".equals(child.getstandardType())) continue;
                listTR.add(child);
            }
        }
        return listTR;
    }

    private Integer getColumnNum(GFPDStructElem firstTR) {
        int columnNum = 0;
        for (org.verapdf.model.pdlayer.PDStructElem pDStructElem : firstTR.getChildren()) {
            String type = pDStructElem.getstandardType();
            if ("TH".equals(type)) {
                columnNum = (int)((long)columnNum + ((GFSETH)pDStructElem).getColSpan());
                continue;
            }
            if (!"TD".equals(type)) continue;
            columnNum = (int)((long)columnNum + ((GFSETD)pDStructElem).getColSpan());
        }
        return columnNum;
    }

    private Boolean checkRegular(boolean[][] cells, long rowSpan, long colSpan, int i, int j) {
        int k = 0;
        while ((long)k < rowSpan) {
            int l = 0;
            while ((long)l < colSpan) {
                if (cells[i + k][j + l]) {
                    return false;
                }
                cells[i + k][j + l] = true;
                ++l;
            }
            ++k;
        }
        return true;
    }
}

