/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSNumber;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.PDObject;

public class PDAction
extends PDObject {
    public PDAction(COSObject obj) {
        super(obj);
    }

    public ASAtom getSubtype() {
        return this.getObject().getNameKey(ASAtom.S);
    }

    public List<PDAction> getNext() {
        COSObject next = this.getKey(ASAtom.NEXT);
        if (next != null) {
            COSObjType type = next.getType();
            ArrayList<PDAction> actions = new ArrayList<PDAction>();
            if (type == COSObjType.COS_DICT) {
                actions.add(new PDAction(next));
            } else if (type == COSObjType.COS_ARRAY) {
                for (COSObject obj : (COSArray)next.getDirectBase()) {
                    if (obj == null || obj.getType() != COSObjType.COS_DICT) continue;
                    actions.add(new PDAction(obj));
                }
            }
            return Collections.unmodifiableList(actions);
        }
        return Collections.emptyList();
    }

    public List<COSNumber> getCOSArrayD() {
        COSObject d = this.getKey(ASAtom.D);
        if (d != null && d.getType() == COSObjType.COS_ARRAY) {
            ArrayList<COSNumber> numbers = new ArrayList<COSNumber>();
            for (COSObject obj : (COSArray)d.getDirectBase()) {
                if (obj == null || !obj.getType().isNumber()) continue;
                numbers.add((COSNumber)obj.getDirectBase());
            }
            return Collections.unmodifiableList(numbers);
        }
        return Collections.emptyList();
    }

    public ASAtom getN() {
        return this.getObject().getNameKey(ASAtom.N);
    }

    public COSObject getRendition() {
        return this.getObject().getKey(ASAtom.R);
    }
}

