/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.type1;

import java.io.IOException;
import java.util.Map;
import java.util.Stack;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.pd.font.CFFNumber;
import org.verapdf.pd.font.cff.CFFIndex;

public abstract class BaseCharStringParser {
    private Stack<ASInputStream> streams = new Stack();
    protected Stack<CFFNumber> stack;
    private CFFNumber width;
    protected CFFIndex globalSubrs;
    protected CFFIndex localSubrs;
    protected int bias;
    protected int gBias;
    protected Map<Integer, CFFNumber> subrWidths;

    protected BaseCharStringParser(ASInputStream stream) throws IOException {
        this(stream, null, 0, null, 0);
    }

    protected BaseCharStringParser(ASInputStream stream, Map<Integer, CFFNumber> subrWidths) throws IOException {
        this(stream, null, 0, null, 0, subrWidths);
    }

    protected BaseCharStringParser(ASInputStream stream, CFFIndex localSubrs, int bias, CFFIndex globalSubrs, int gBias) throws IOException {
        this(stream, localSubrs, bias, globalSubrs, gBias, null);
    }

    protected BaseCharStringParser(ASInputStream stream, CFFIndex localSubrs, int bias, CFFIndex globalSubrs, int gBias, Map<Integer, CFFNumber> subrWidths) throws IOException {
        this.streams.push(stream);
        this.stack = new Stack();
        this.width = null;
        this.globalSubrs = globalSubrs == null ? CFFIndex.getEmptyIndex() : globalSubrs;
        this.localSubrs = localSubrs == null ? CFFIndex.getEmptyIndex() : localSubrs;
        this.bias = bias;
        this.gBias = gBias;
        this.subrWidths = subrWidths;
        this.parse();
    }

    public CFFNumber getWidth() {
        return this.width;
    }

    protected void setWidth(CFFNumber width) {
        this.width = width;
    }

    private CFFNumber getNextInteger(int firstByte) throws IOException {
        byte[] buf = new byte[1];
        if (firstByte > 31 && firstByte < 247) {
            return new CFFNumber(firstByte - 139);
        }
        if (firstByte > 246 && firstByte < 251) {
            this.readStreams(buf, 1);
            return new CFFNumber((firstByte - 247 << 8) + (buf[0] & 0xFF) + 108);
        }
        if (firstByte > 250 && firstByte < 255) {
            this.readStreams(buf, 1);
            return new CFFNumber(-(firstByte - 251 << 8) - (buf[0] & 0xFF) - 108);
        }
        return this.readNextNumber(firstByte);
    }

    private void parse() throws IOException {
        byte[] buf = new byte[1];
        int cont = this.readStreams(buf, 1);
        while (cont != -1) {
            int nextByte = buf[0] & 0xFF;
            if (nextByte > 31) {
                this.stack.push(this.getNextInteger(nextByte));
            } else if (this.processNextOperator(nextByte)) break;
            cont = this.readStreams(buf, 1);
        }
        this.clear();
    }

    protected int readStreams(byte[] buffer, int size) throws IOException {
        if (buffer.length < size) {
            throw new IOException("Can't write bytes into passed buffer: too small.");
        }
        if (this.streams.empty()) {
            return -1;
        }
        int bufferIndex = 0;
        int left = size;
        while (left != 0 && !this.streams.empty()) {
            byte[] temp = new byte[left];
            int read = this.streams.peek().read(temp, left);
            if (read > 0) {
                System.arraycopy(temp, 0, buffer, bufferIndex, read);
                bufferIndex += read;
                left -= read;
                continue;
            }
            if (read != -1) continue;
            this.streams.pop().close();
        }
        int read = size - left;
        return read == 0 ? -1 : read;
    }

    protected void addStream(ASInputStream is) {
        if (is != null) {
            this.streams.push(is);
        }
    }

    private void clear() throws IOException {
        this.stack.clear();
        while (!this.streams.empty()) {
            this.streams.pop().close();
        }
    }

    protected void popStack(int num) {
        for (int i = 0; i < num && !this.stack.empty(); ++i) {
            this.stack.pop();
        }
    }

    protected abstract boolean processNextOperator(int var1) throws IOException;

    protected abstract CFFNumber readNextNumber(int var1) throws IOException;
}

