/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.cos.COSNumber;
import org.verapdf.gf.model.impl.cos.GFCosNumber;
import org.verapdf.gf.model.impl.pd.actions.GFPDAction;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosNumber;
import org.verapdf.model.pdlayer.PDGoToAction;
import org.verapdf.pd.actions.PDAction;

public class GFPDGoToAction
extends GFPDAction
implements PDGoToAction {
    public static final String GOTO_ACTION_TYPE = "PDGoToAction";
    public static final String D = "D";

    public GFPDGoToAction(PDAction simplePDObject) {
        super(simplePDObject, GOTO_ACTION_TYPE);
    }

    protected GFPDGoToAction(PDAction simplePDObject, String type) {
        super(simplePDObject, type);
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        if (D.equals(link)) {
            return this.getD();
        }
        return super.getLinkedObjects(link);
    }

    private List<CosNumber> getD() {
        List<COSNumber> numbers = ((PDAction)this.simplePDObject).getCOSArrayD();
        if (!numbers.isEmpty()) {
            ArrayList<GFCosNumber> result = new ArrayList<GFCosNumber>(numbers.size());
            for (COSNumber number : numbers) {
                result.add(GFCosNumber.fromPDFParserNumber(number));
            }
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }
}

