/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.serialize.XMLEmitter;
import net.sf.saxon.str.StringConstants;

public class XHTML1Emitter
extends XMLEmitter {
    static Set<String> emptyTags1 = new HashSet<String>(31);
    private static final String[] emptyTagNames1 = new String[]{"area", "base", "basefont", "br", "col", "embed", "frame", "hr", "img", "input", "isindex", "link", "meta", "param"};

    private boolean isRecognizedHtmlElement(NodeName name) {
        return name.hasURI(NamespaceUri.XHTML);
    }

    @Override
    protected void writeEmptyElementTagCloser(String displayName, NodeName name) throws IOException {
        if (this.isRecognizedHtmlElement(name) && emptyTags1.contains(name.getLocalPart())) {
            this.writer.writeAscii(StringConstants.EMPTY_TAG_END_XHTML);
        } else {
            this.writer.writeAscii(StringConstants.EMPTY_TAG_MIDDLE);
            this.writer.write(displayName);
            this.writer.writeCodePoint(62);
        }
    }

    static {
        Collections.addAll(emptyTags1, emptyTagNames1);
    }
}

