/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.type1;

import java.io.IOException;
import org.verapdf.as.filters.io.ASBufferedInFilter;
import org.verapdf.as.io.ASInputStream;

public class EexecFilterDecode
extends ASBufferedInFilter {
    private static final int EEXEC_C1 = 52845;
    private static final int EEXEC_C2 = 22719;
    private static final int EEXEC_ENCRYPTION_KEY = 55665;
    private static final int EEXEC_NUMBER_OF_RANDOM_BYTES = 4;
    private static final int EEXEC_CHARSTRING_KEY = 4330;
    private int bytesToDiscard;
    private int r;

    EexecFilterDecode(ASInputStream stream, boolean isCharstring, int lenIV) throws IOException {
        super(stream);
        if (!isCharstring) {
            this.bytesToDiscard = 4;
            this.r = 55665;
        } else {
            this.bytesToDiscard = lenIV;
            this.r = 4330;
        }
    }

    public EexecFilterDecode(ASInputStream stream, boolean isCharstring) throws IOException {
        this(stream, isCharstring, 4);
    }

    @Override
    public int read(byte[] buffer, int size) throws IOException {
        int bytesRead = this.feedBuffer(this.bytesToDiscard + size);
        int res = bytesRead - this.bytesToDiscard;
        if (bytesRead < 0) {
            return -1;
        }
        if (size == 0) {
            return 0;
        }
        if (bytesRead == 0) {
            return -1;
        }
        for (int i = 0; i < bytesRead; ++i) {
            int encoded = this.buffer[i] & 0xFF;
            int decoded = encoded ^ this.r >> 8;
            if (i >= this.bytesToDiscard) {
                buffer[i - this.bytesToDiscard] = (byte)decoded;
            }
            this.r = (encoded + this.r) * 52845 + 22719 & 0xFFFF;
        }
        this.bytesToDiscard = Math.max(this.bytesToDiscard - bytesRead, 0);
        return res;
    }
}

