/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.ReleaseDetails;
import org.verapdf.apps.Applications;
import org.verapdf.apps.ConfigManager;
import org.verapdf.apps.SoftwareUpdater;
import org.verapdf.cli.VeraPdfCliProcessor;
import org.verapdf.cli.commands.VeraCliArgParser;
import org.verapdf.core.VeraPDFException;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.validation.profiles.ProfileDirectory;
import org.verapdf.pdfa.validation.profiles.Profiles;
import org.verapdf.pdfa.validation.profiles.ValidationProfile;

public final class VeraPdfCli {
    private static final Logger logger = Logger.getLogger(VeraCliArgParser.class.getCanonicalName());
    private static final ConfigManager configManager = Applications.createAppConfigManager();
    private static final int MEGABYTE = 0x100000;
    private static final String FLAVOURS_HEADING = "veraPDF supported PDF/A profiles:";
    private static final ProfileDirectory PROFILES = Profiles.getVeraProfileDirectory();

    private VeraPdfCli() {
    }

    public static void main(String[] args) throws VeraPDFException {
        MemoryMXBean memoryMan = ManagementFactory.getMemoryMXBean();
        ReleaseDetails.addDetailsFromResource("org/verapdf/release/app.properties");
        VeraCliArgParser cliArgParser = new VeraCliArgParser();
        JCommander jCommander = new JCommander(cliArgParser);
        jCommander.setProgramName("veraPDF");
        try {
            jCommander.parse(args);
        }
        catch (ParameterException e) {
            System.err.println(e.getMessage());
            VeraPdfCli.showVersionInfo(cliArgParser.isVerbose());
            jCommander.usage();
            System.exit(1);
        }
        if (cliArgParser.isHelp()) {
            VeraPdfCli.showVersionInfo(cliArgParser.isVerbose());
            jCommander.usage();
            System.exit(0);
        }
        VeraPdfCli.messagesFromParser(cliArgParser);
        if (VeraPdfCli.isProcess(cliArgParser)) {
            try {
                VeraPdfCliProcessor processor = VeraPdfCliProcessor.createProcessorFromArgs(cliArgParser, configManager);
                if (args.length == 0) {
                    jCommander.usage();
                }
                processor.processPaths(cliArgParser.getPdfPaths());
            }
            catch (OutOfMemoryError oome) {
                String message = "The JVM appears to have run out of memory";
                logger.log(Level.WARNING, "The JVM appears to have run out of memory", oome);
                MemoryUsage heapUsage = memoryMan.getHeapMemoryUsage();
                long maxMemory = heapUsage.getMax() / 0x100000L;
                long usedMemory = heapUsage.getUsed() / 0x100000L;
                System.out.format(",%s\n", "The JVM appears to have run out of memory");
                System.out.format("Memory Use: %sM/%sM\n", usedMemory, maxMemory);
                System.out.format("To increase the memory available to the JVM please assign the JAVA_OPTS environment variable.\n", new Object[0]);
                System.out.format("The examples below increase the maximum heap available to the JVM to 2GB:\n", new Object[0]);
                System.out.format(" - Mac or Linux users:\n", new Object[0]);
                System.out.format("   export JAVA_OPTS=\"-Xmx2048m\"\n", new Object[0]);
                System.out.format(" - Windows users:\n", new Object[0]);
                System.out.format("   SET JAVA_OPTS=\"-Xmx2048m\"\n", new Object[0]);
                System.exit(1);
            }
        }
    }

    private static void messagesFromParser(VeraCliArgParser parser) {
        if (parser.listProfiles()) {
            VeraPdfCli.listProfiles();
        }
        if (parser.showVersion()) {
            VeraPdfCli.showVersionInfo(parser.isVerbose());
        }
    }

    private static void listProfiles() {
        System.out.println(FLAVOURS_HEADING);
        EnumSet<PDFAFlavour> flavs = EnumSet.copyOf(PROFILES.getPDFAFlavours());
        for (PDFAFlavour flav : flavs) {
            ValidationProfile profile = PROFILES.getValidationProfileByFlavour(flav);
            System.out.format("  %s - %s", profile.getPDFAFlavour().getId(), profile.getDetails().getName());
        }
        System.out.println();
    }

    private static void showVersionInfo(boolean isVerbose) {
        ReleaseDetails appDetails = Applications.getAppDetails();
        System.out.format("%s %s\n", "veraPDF", appDetails.getVersion());
        System.out.format("Built: %s\n", appDetails.getBuildDate());
        System.out.format("%s\n", ReleaseDetails.rightsStatement());
        if (isVerbose) {
            VeraPdfCli.showUpdateInfo(appDetails);
        }
    }

    private static void showUpdateInfo(ReleaseDetails details) {
        SoftwareUpdater updater = Applications.softwareUpdater();
        if (!updater.isOnline()) {
            logger.log(Level.WARNING, "Update Service not available");
            return;
        }
        if (!updater.isUpdateAvailable(details)) {
            System.out.format("You are currently running the latest version of veraPDF%s v%s", ",", details.getVersion() + "\n");
            return;
        }
        System.out.format("You are NOT running the latest version of veraPDF.\nYou are running version %s, the latest version is %s.\n", details.getVersion(), updater.getLatestVersion(details));
        System.out.format("You can download the latest version from: %s.\n", "http://downloads.verapdf.org/rel/verapdf-installer.zip");
    }

    private static boolean isProcess(VeraCliArgParser parser) {
        return !parser.getPdfPaths().isEmpty() || !parser.isHelp() && !parser.listProfiles() && !parser.showVersion();
    }
}

