/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.images;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.gf.model.factory.operators.GraphicState;
import org.verapdf.gf.model.impl.pd.GFPDResource;
import org.verapdf.gf.model.impl.pd.images.GFPDSMaskImage;
import org.verapdf.gf.model.impl.pd.images.GFPDXForm;
import org.verapdf.gf.model.impl.pd.images.GFPDXImage;
import org.verapdf.gf.model.impl.pd.util.PDResourcesHandler;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.pdlayer.PDSMaskImage;
import org.verapdf.pd.images.PDXForm;
import org.verapdf.pd.images.PDXImage;
import org.verapdf.pd.images.PDXObject;

public class GFPDXObject
extends GFPDResource
implements org.verapdf.model.pdlayer.PDXObject {
    public static final String X_OBJECT_TYPE = "PDXObject";
    public static final String OPI = "OPI";
    public static final String S_MASK = "SMask";
    protected final PDResourcesHandler resourcesHandler;

    public GFPDXObject(PDXObject simplePDObject, PDResourcesHandler resourcesHandler) {
        this(simplePDObject, resourcesHandler, X_OBJECT_TYPE);
    }

    protected GFPDXObject(PDXObject simplePDObject, PDResourcesHandler resourcesHandler, String type) {
        super(simplePDObject, type);
        this.resourcesHandler = resourcesHandler;
    }

    @Override
    public String getSubtype() {
        ASAtom subtype = ((PDXObject)this.simplePDObject).getSubtype();
        return subtype == null ? null : subtype.getValue();
    }

    @Override
    public Boolean getcontainsOPI() {
        return this.simplePDObject.knownKey(ASAtom.OPI);
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "SMask": {
                return this.getSMask();
            }
        }
        return super.getLinkedObjects(link);
    }

    protected List<PDSMaskImage> getSMask() {
        PDXImage smask = ((PDXObject)this.simplePDObject).getSMask();
        if (smask != null) {
            ArrayList<GFPDSMaskImage> mask = new ArrayList<GFPDSMaskImage>(1);
            mask.add(new GFPDSMaskImage(smask, this.resourcesHandler));
            return Collections.unmodifiableList(mask);
        }
        return Collections.emptyList();
    }

    public static org.verapdf.model.pdlayer.PDXObject getTypedPDXObject(PDXObject xObject, PDResourcesHandler resources, GraphicState inheritedGraphicState) {
        ASAtom type = xObject.getType();
        if (ASAtom.FORM.equals(type)) {
            return new GFPDXForm((PDXForm)xObject, resources, inheritedGraphicState);
        }
        if (ASAtom.IMAGE.equals(type)) {
            return new GFPDXImage((PDXImage)xObject, resources, inheritedGraphicState.getFillColorSpace());
        }
        if (ASAtom.PS.equals(type)) {
            return new GFPDXObject(xObject, resources);
        }
        return null;
    }
}

