/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.structure.PDNameSpaceRoleMapping;
import org.verapdf.pd.structure.PDStructElem;
import org.verapdf.pd.structure.PDStructureNameSpace;
import org.verapdf.pd.structure.StructureType;

public class TaggedPDFHelper {
    private static final Logger LOGGER = Logger.getLogger(TaggedPDFHelper.class.getCanonicalName());
    public static final String PDF_NAMESPACE = "http://iso.org/pdf/ssn";
    public static final String PDF2_NAMESPACE = "http://iso.org/pdf2/ssn";
    public static final String MATH_ML_NAMESPACE = "http://www.w3.org/1998/Math/MathML";
    private static Set<String> PDF_1_7_STANDART_ROLE_TYPES;
    private static Set<String> PDF_2_0_STANDART_ROLE_TYPES;
    private static final int MAX_NUMBER_OF_ELEMENTS = 1;
    private static Map<ASAtom, Set<COSKey>> visitedWithNS;
    private static Set<ASAtom> visitedWithoutNS;

    private TaggedPDFHelper() {
    }

    public static StructureType getDefaultStructureType(StructureType type, Map<ASAtom, ASAtom> rootRoleMap) {
        visitedWithNS.clear();
        visitedWithoutNS.clear();
        TaggedPDFHelper.addVisited(type);
        StructureType curr = TaggedPDFHelper.getEquivalent(type, rootRoleMap);
        if (curr == null || TaggedPDFHelper.isVisited(curr)) {
            return TaggedPDFHelper.isStandardType(type) ? type : null;
        }
        while (curr != null && !TaggedPDFHelper.isVisited(curr)) {
            TaggedPDFHelper.addVisited(curr);
            StructureType next = TaggedPDFHelper.getEquivalent(curr, rootRoleMap);
            if (next == null && TaggedPDFHelper.isStandardType(curr)) {
                return curr;
            }
            curr = next;
        }
        return null;
    }

    private static StructureType getEquivalent(StructureType type, Map<ASAtom, ASAtom> rootRoleMap) {
        ASAtom equiv;
        PDStructureNameSpace nameSpace = type.getNameSpace();
        if (nameSpace != null) {
            PDNameSpaceRoleMapping nameSpaceMapping = nameSpace.getNameSpaceMapping();
            if (nameSpaceMapping != null) {
                return nameSpaceMapping.getEquivalentType(type.getType());
            }
            if (!PDF_NAMESPACE.equals(nameSpace.getNS())) {
                return null;
            }
        }
        return (equiv = rootRoleMap.get(type.getType())) == null ? null : StructureType.createStructureType(equiv);
    }

    private static boolean isStandardType(StructureType type) {
        String structureType = type.getType().getValue();
        PDStructureNameSpace nameSpace = type.getNameSpace();
        if (nameSpace != null) {
            switch (nameSpace.getNS()) {
                case "http://iso.org/pdf/ssn": {
                    return PDF_1_7_STANDART_ROLE_TYPES.contains(structureType);
                }
                case "http://iso.org/pdf2/ssn": {
                    return PDF_2_0_STANDART_ROLE_TYPES.contains(structureType) || structureType.matches("^H[1-9][0-9]*$");
                }
                case "http://www.w3.org/1998/Math/MathML": {
                    return true;
                }
            }
            return false;
        }
        return PDF_1_7_STANDART_ROLE_TYPES.contains(structureType);
    }

    private static void addVisited(StructureType type) {
        ASAtom structType = type.getType();
        PDStructureNameSpace nameSpace = type.getNameSpace();
        if (nameSpace != null) {
            Set<Object> nameSpaces;
            COSKey key = nameSpace.getObject().getObjectKey();
            if (visitedWithNS.containsKey(structType)) {
                nameSpaces = visitedWithNS.get(structType);
            } else {
                nameSpaces = new HashSet();
                visitedWithNS.put(structType, nameSpaces);
            }
            nameSpaces.add(key);
        } else {
            visitedWithoutNS.add(structType);
        }
    }

    private static boolean isVisited(StructureType type) {
        ASAtom structType = type.getType();
        PDStructureNameSpace nameSpace = type.getNameSpace();
        if (nameSpace != null) {
            if (visitedWithNS.containsKey(structType)) {
                Set<COSKey> nameSpaces = visitedWithNS.get(structType);
                COSKey key = nameSpace.getObject().getObjectKey();
                return nameSpaces.contains(key);
            }
            return false;
        }
        return visitedWithoutNS.contains(structType);
    }

    public static List<PDStructElem> getStructTreeRootChildren(COSObject parent, Map<ASAtom, ASAtom> roleMap) {
        return TaggedPDFHelper.getChildren(parent, roleMap, false);
    }

    public static List<PDStructElem> getStructElemChildren(COSObject parent, Map<ASAtom, ASAtom> roleMap) {
        return TaggedPDFHelper.getChildren(parent, roleMap, true);
    }

    private static List<PDStructElem> getChildren(COSObject parent, Map<ASAtom, ASAtom> roleMap, boolean checkType) {
        if (parent == null || parent.getType() != COSObjType.COS_DICT) {
            LOGGER.log(Level.FINE, "Parent element for struct elements is null or not a COSDictionary");
            return Collections.emptyList();
        }
        COSObject children = parent.getKey(ASAtom.K);
        if (children != null) {
            if (children.getType() == COSObjType.COS_DICT && TaggedPDFHelper.isStructElem(children, checkType)) {
                ArrayList<PDStructElem> list = new ArrayList<PDStructElem>(1);
                list.add(new PDStructElem(children, roleMap));
                return Collections.unmodifiableList(list);
            }
            if (children.getType() == COSObjType.COS_ARRAY) {
                return TaggedPDFHelper.getChildrenFromArray(children, roleMap, checkType);
            }
        }
        return Collections.emptyList();
    }

    private static List<PDStructElem> getChildrenFromArray(COSObject children, Map<ASAtom, ASAtom> roleMap, boolean checkType) {
        if (children.size() > 0) {
            ArrayList<PDStructElem> list = new ArrayList<PDStructElem>();
            for (int i = 0; i < children.size(); ++i) {
                COSObject elem = children.at(i);
                if (elem.getType() != COSObjType.COS_DICT || !TaggedPDFHelper.isStructElem(elem, checkType)) continue;
                list.add(new PDStructElem(elem, roleMap));
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private static boolean isStructElem(COSObject dictionary, boolean checkType) {
        if (dictionary == null || dictionary.getType() != COSObjType.COS_DICT) {
            return false;
        }
        ASAtom type = dictionary.getNameKey(ASAtom.TYPE);
        return !checkType || type == null || type.equals(ASAtom.STRUCT_ELEM);
    }

    static {
        HashSet<String> tempSet = new HashSet<String>();
        tempSet.add("Document");
        tempSet.add("Part");
        tempSet.add("Div");
        tempSet.add("Caption");
        tempSet.add("THead");
        tempSet.add("TBody");
        tempSet.add("TFoot");
        tempSet.add("H");
        tempSet.add("P");
        tempSet.add("L");
        tempSet.add("LI");
        tempSet.add("Lbl");
        tempSet.add("LBody");
        tempSet.add("Table");
        tempSet.add("TR");
        tempSet.add("TH");
        tempSet.add("TD");
        tempSet.add("Span");
        tempSet.add("Link");
        tempSet.add("Annot");
        tempSet.add("Ruby");
        tempSet.add("Warichu");
        tempSet.add("Figure");
        tempSet.add("Formula");
        tempSet.add("Form");
        tempSet.add("RB");
        tempSet.add("RT");
        tempSet.add("RP");
        tempSet.add("WT");
        tempSet.add("WP");
        HashSet<String> pdf_1_7 = new HashSet<String>(tempSet);
        pdf_1_7.add("Art");
        pdf_1_7.add("Sect");
        pdf_1_7.add("BlockQuote");
        pdf_1_7.add("TOC");
        pdf_1_7.add("TOCI");
        pdf_1_7.add("Index");
        pdf_1_7.add("NonStruct");
        pdf_1_7.add("Private");
        pdf_1_7.add("Quote");
        pdf_1_7.add("Note");
        pdf_1_7.add("Reference");
        pdf_1_7.add("BibEntry");
        pdf_1_7.add("Code");
        tempSet.add("H1");
        tempSet.add("H2");
        tempSet.add("H3");
        tempSet.add("H4");
        tempSet.add("H5");
        tempSet.add("H6");
        HashSet<String> pdf_2_0 = new HashSet<String>(tempSet);
        pdf_2_0.add("DocumentFragment");
        pdf_2_0.add("Aside");
        pdf_2_0.add("Title");
        pdf_2_0.add("FENote");
        pdf_2_0.add("Sub");
        pdf_2_0.add("Em");
        pdf_2_0.add("Strong");
        pdf_2_0.add("Artifact");
        PDF_1_7_STANDART_ROLE_TYPES = Collections.unmodifiableSet(pdf_1_7);
        PDF_2_0_STANDART_ROLE_TYPES = Collections.unmodifiableSet(pdf_2_0);
        visitedWithNS = new HashMap<ASAtom, Set<COSKey>>();
        visitedWithoutNS = new HashSet<ASAtom>();
    }
}

