/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.apps;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.verapdf.apps.Applications;
import org.verapdf.apps.ConfigManager;
import org.verapdf.apps.VeraAppConfig;
import org.verapdf.apps.VeraAppConfigImpl;
import org.verapdf.features.FeatureExtractorConfig;
import org.verapdf.features.FeatureFactory;
import org.verapdf.metadata.fixer.FixerFactory;
import org.verapdf.metadata.fixer.MetadataFixerConfig;
import org.verapdf.pdfa.validation.validators.ValidatorConfig;
import org.verapdf.pdfa.validation.validators.ValidatorFactory;
import org.verapdf.processor.ProcessorConfig;
import org.verapdf.processor.ProcessorFactory;
import org.verapdf.processor.TaskType;
import org.verapdf.processor.plugins.PluginsCollectionConfig;

final class ConfigManagerImpl
implements ConfigManager {
    private static final Logger LOGGER = Logger.getLogger(ConfigManagerImpl.class.getCanonicalName());
    private static final String nullArgMessage = "Arg tasks can not be null";
    private static final String defaultConfExt = ".xml";
    private static final String defaultValidName = "validator.xml";
    private static final String defaultFixerName = "fixer.xml";
    private static final String defaultFeaturesName = "features.xml";
    private static final String defaultPluginsName = "plugins.xml";
    private static final String defaultAppName = "app.xml";
    private final File root;
    private final File validatorFile;
    private final File fixerFile;
    private final File featuresFile;
    private final File pluginsFile;
    private final File appFile;

    private ConfigManagerImpl(File root) {
        this.root = root;
        this.validatorFile = this.getConfigFile(defaultValidName);
        this.fixerFile = this.getConfigFile(defaultFixerName);
        this.featuresFile = this.getConfigFile(defaultFeaturesName);
        this.pluginsFile = this.getConfigFile(defaultPluginsName);
        this.appFile = this.getConfigFile(defaultAppName);
        this.initialise();
    }

    @Override
    public ValidatorConfig getValidatorConfig() {
        ValidatorConfig validatorConfig;
        FileInputStream fis = new FileInputStream(this.validatorFile);
        try {
            validatorConfig = ValidatorFactory.createConfig((InputStream)fis);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)fis).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | JAXBException excep) {
                LOGGER.log(Level.WARNING, "The validator config file is missing or damaged");
                return ValidatorFactory.defaultConfig();
            }
        }
        ((InputStream)fis).close();
        return validatorConfig;
    }

    @Override
    public FeatureExtractorConfig getFeaturesConfig() {
        FeatureExtractorConfig featureExtractorConfig;
        FileInputStream fis = new FileInputStream(this.featuresFile);
        try {
            featureExtractorConfig = FeatureFactory.configFromXml((InputStream)fis);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)fis).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | JAXBException excep) {
                LOGGER.log(Level.WARNING, "The features config file is missing or damaged");
                return FeatureFactory.defaultConfig();
            }
        }
        ((InputStream)fis).close();
        return featureExtractorConfig;
    }

    @Override
    public PluginsCollectionConfig getPluginsCollectionConfig() {
        PluginsCollectionConfig pluginsCollectionConfig;
        FileInputStream fis = new FileInputStream(this.pluginsFile);
        try {
            pluginsCollectionConfig = PluginsCollectionConfig.create((InputStream)fis);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)fis).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | JAXBException excep) {
                LOGGER.log(Level.WARNING, "The plugins config file is missing or damaged");
                return PluginsCollectionConfig.defaultConfig();
            }
        }
        ((InputStream)fis).close();
        return pluginsCollectionConfig;
    }

    @Override
    public MetadataFixerConfig getFixerConfig() {
        MetadataFixerConfig metadataFixerConfig;
        FileInputStream fis = new FileInputStream(this.fixerFile);
        try {
            metadataFixerConfig = FixerFactory.configFromXml((InputStream)fis);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)fis).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | JAXBException excep) {
                LOGGER.log(Level.WARNING, "The fixer config file is missing or damaged");
                return FixerFactory.defaultConfig();
            }
        }
        ((InputStream)fis).close();
        return metadataFixerConfig;
    }

    @Override
    public ProcessorConfig createProcessorConfig() {
        VeraAppConfig applicationConfig = this.getApplicationConfig();
        return this.createProcessorConfig(applicationConfig.getProcessType().getTasks(), applicationConfig.getFixesFolder());
    }

    @Override
    public ProcessorConfig createProcessorConfig(EnumSet<TaskType> tasks) {
        if (tasks == null) {
            throw new NullPointerException(nullArgMessage);
        }
        return ProcessorFactory.fromValues((ValidatorConfig)this.getValidatorConfig(), (FeatureExtractorConfig)this.getFeaturesConfig(), (PluginsCollectionConfig)this.getPluginsCollectionConfig(), (MetadataFixerConfig)this.getFixerConfig(), tasks);
    }

    @Override
    public ProcessorConfig createProcessorConfig(EnumSet<TaskType> tasks, String mdFolder) {
        if (tasks == null) {
            throw new NullPointerException(nullArgMessage);
        }
        return ProcessorFactory.fromValues((ValidatorConfig)this.getValidatorConfig(), (FeatureExtractorConfig)this.getFeaturesConfig(), (PluginsCollectionConfig)this.getPluginsCollectionConfig(), (MetadataFixerConfig)this.getFixerConfig(), tasks, (String)mdFolder);
    }

    @Override
    public VeraAppConfig getApplicationConfig() {
        VeraAppConfigImpl veraAppConfigImpl;
        FileInputStream fis = new FileInputStream(this.appFile);
        try {
            veraAppConfigImpl = VeraAppConfigImpl.fromXml(fis);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)fis).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | JAXBException excep) {
                LOGGER.log(Level.WARNING, "The application config file is missing or damaged");
                return VeraAppConfigImpl.defaultInstance();
            }
        }
        ((InputStream)fis).close();
        return veraAppConfigImpl;
    }

    @Override
    public File getConfigDir() {
        return this.root;
    }

    @Override
    public void updateValidatorConfig(ValidatorConfig config) throws JAXBException, IOException {
        try (FileOutputStream fos = new FileOutputStream(this.validatorFile, false);){
            ValidatorFactory.configToXml((ValidatorConfig)config, (OutputStream)fos);
        }
    }

    @Override
    public void updateFeaturesConfig(FeatureExtractorConfig config) throws JAXBException, IOException {
        try (FileOutputStream fos = new FileOutputStream(this.featuresFile, false);){
            FeatureFactory.configToXml((FeatureExtractorConfig)config, (OutputStream)fos);
        }
    }

    @Override
    public void updateFixerConfig(MetadataFixerConfig config) throws JAXBException, IOException {
        try (FileOutputStream fos = new FileOutputStream(this.fixerFile, false);){
            FixerFactory.configToXml((MetadataFixerConfig)config, (OutputStream)fos);
        }
    }

    @Override
    public void updateAppConfig(VeraAppConfig config) throws JAXBException, IOException {
        try (FileOutputStream fos = new FileOutputStream(this.appFile, false);){
            VeraAppConfigImpl.toXml(config, fos, Boolean.TRUE);
        }
    }

    static ConfigManagerImpl create(File root) {
        return new ConfigManagerImpl(root);
    }

    private void initialise() {
        block35: {
            try {
                FileOutputStream fos;
                if (!this.validatorFile.exists() && this.validatorFile.createNewFile() || this.validatorFile.length() == 0L) {
                    fos = new FileOutputStream(this.validatorFile, false);
                    try {
                        ValidatorFactory.configToXml((ValidatorConfig)ValidatorFactory.defaultConfig(), (OutputStream)fos);
                    }
                    finally {
                        ((OutputStream)fos).close();
                    }
                }
                if (!this.featuresFile.exists() && this.featuresFile.createNewFile() || this.featuresFile.length() == 0L) {
                    fos = new FileOutputStream(this.featuresFile, false);
                    try {
                        FeatureFactory.configToXml((FeatureExtractorConfig)FeatureFactory.defaultConfig(), (OutputStream)fos);
                    }
                    finally {
                        ((OutputStream)fos).close();
                    }
                }
                if (!this.fixerFile.exists() && this.fixerFile.createNewFile() || this.fixerFile.length() == 0L) {
                    fos = new FileOutputStream(this.fixerFile, false);
                    try {
                        FixerFactory.configToXml((MetadataFixerConfig)FixerFactory.defaultConfig(), (OutputStream)fos);
                    }
                    finally {
                        ((OutputStream)fos).close();
                    }
                }
                if (!this.appFile.exists() && this.appFile.createNewFile() || this.appFile.length() == 0L) {
                    fos = new FileOutputStream(this.appFile, false);
                    try {
                        Applications.toXml(Applications.defaultConfig(), fos, Boolean.TRUE);
                    }
                    finally {
                        ((OutputStream)fos).close();
                    }
                }
                if ((this.pluginsFile.exists() || !this.pluginsFile.createNewFile()) && this.pluginsFile.length() != 0L) break block35;
                fos = new FileOutputStream(this.pluginsFile, false);
                try {
                    PluginsCollectionConfig.configToXml((PluginsCollectionConfig)PluginsCollectionConfig.defaultConfig(), (OutputStream)fos);
                }
                finally {
                    ((OutputStream)fos).close();
                }
            }
            catch (IOException | JAXBException excep) {
                LOGGER.log(Level.WARNING, "One or several of config files are missing or damaged");
                throw new IllegalStateException("Couldn't setup config", excep);
            }
        }
    }

    private final File getConfigFile(String name) {
        File config = new File(this.root, name);
        try {
            if (config.isDirectory() || !config.exists() && !config.createNewFile()) {
                throw new IllegalArgumentException(config.getAbsolutePath() + " must be a creatable or readable file");
            }
        }
        catch (IOException excep) {
            throw new IllegalArgumentException("IOException when creating: " + config.getAbsolutePath(), excep);
        }
        return config;
    }
}

