/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.apps;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.verapdf.ReleaseDetails;
import org.verapdf.SemanticVersionNumber;
import org.verapdf.Versions;
import org.verapdf.apps.Applications;
import org.verapdf.apps.SoftwareUpdater;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SoftwareUpdaterImpl
implements SoftwareUpdater {
    private static final Logger logger = Logger.getLogger(SoftwareUpdaterImpl.class.getCanonicalName());
    private static final SAXParserFactory saxFact = SAXParserFactory.newInstance();
    private static final String jenkinsRoot = "http://jenkins.openpreservation.org/job/veraPDF-apps";
    private static final String jenkinsApiPath = "/lastStableBuild/api/xml";
    private static final String latestGF = "http://jenkins.openpreservation.org/job/veraPDF-apps/lastStableBuild/api/xml";
    private static final String latestPDFBox = "http://jenkins.openpreservation.org/job/veraPDF-apps-" + "PDFBOX".toLowerCase() + "/lastStableBuild/api/xml";
    private final String currentVersion = Applications.getAppDetails().getVersion();

    SoftwareUpdaterImpl() {
    }

    @Override
    public boolean isOnline() {
        try {
            URL url = new URL(SoftwareUpdaterImpl.getEndpointForVersion(this.currentVersion));
            HttpURLConnection huc = (HttpURLConnection)url.openConnection();
            huc.setRequestMethod("HEAD");
            huc.connect();
            if (huc.getResponseCode() != 200) {
                return false;
            }
            url.openStream();
        }
        catch (MalformedURLException excep) {
            throw new IllegalStateException(String.format("Problem parsing hard coded URL %s", jenkinsRoot), excep);
        }
        catch (IOException excep) {
            logger.log(Level.INFO, "Couldn't get latest version info from Jenkins.", excep);
        }
        return true;
    }

    @Override
    public SemanticVersionNumber getLatestAppsVersion() {
        return SoftwareUpdaterImpl.getLatestVersionFromUrl(latestGF);
    }

    @Override
    public SemanticVersionNumber getLatestPdfBoxAppsVersion() {
        return SoftwareUpdaterImpl.getLatestVersionFromUrl(latestPDFBox);
    }

    @Override
    public boolean isUpdateAvailable() {
        return this.isUpdateAvailable(Applications.getAppDetails());
    }

    @Override
    public boolean isUpdateAvailable(String versionString) {
        String endpoint;
        SemanticVersionNumber available;
        if (!this.isOnline()) {
            return false;
        }
        SemanticVersionNumber current = Versions.fromString(versionString);
        return current.compareTo((Object)(available = SoftwareUpdaterImpl.getLatestVersionFromUrl(endpoint = SoftwareUpdaterImpl.getEndpointForVersion(versionString)))) < 0;
    }

    @Override
    public boolean isUpdateAvailable(ReleaseDetails details) {
        return this.isUpdateAvailable(details.getVersion());
    }

    @Override
    public String getLatestVersion(String versionString) {
        if (!this.isOnline()) {
            return versionString;
        }
        String endpoint = SoftwareUpdaterImpl.getEndpointForVersion(versionString);
        SemanticVersionNumber available = SoftwareUpdaterImpl.getLatestVersionFromUrl(endpoint);
        return available.getVersionString();
    }

    @Override
    public String getLatestVersion(ReleaseDetails details) {
        return this.getLatestVersion(details.getVersion());
    }

    private static final SemanticVersionNumber getLatestVersionFromUrl(String endpoint) {
        try {
            URL url = new URL(endpoint);
            SAXParser saxParser = saxFact.newSAXParser();
            VersionParser versionParser = new VersionParser();
            saxParser.parse(new InputSource(url.openStream()), (DefaultHandler)versionParser);
            return versionParser.getVersion();
        }
        catch (IOException | ParserConfigurationException | SAXException excep) {
            excep.printStackTrace();
            throw new IllegalStateException(String.format("Problem parsing version number from URL %s", endpoint), excep);
        }
    }

    private static final String getEndpointForVersion(String versionString) {
        return versionString.endsWith("PDFBOX") ? latestPDFBox : latestGF;
    }

    static class VersionParser
    extends DefaultHandler {
        private static final String verQName = "displayName";
        private SemanticVersionNumber versionNumber = Versions.fromInts(0, 0, 0);
        private boolean isVersion = false;

        VersionParser() {
        }

        public SemanticVersionNumber getVersion() {
            return this.versionNumber;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            this.isVersion = qName.equalsIgnoreCase(verQName);
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (!this.isVersion) {
                return;
            }
            String version = new String(ch, start, length);
            this.versionNumber = Versions.fromString(version);
            this.isVersion = false;
        }
    }
}

