/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cli.multithread;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.verapdf.cli.CliConstants;
import org.verapdf.cli.multithread.MultiThreadProcessor;
import org.verapdf.processor.reports.ResultStructure;

public class BaseCliRunner
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(BaseCliRunner.class.getCanonicalName());
    private final String veraPDFStarterPath;
    private final Queue<File> filesToProcess;
    private final List<String> veraPDFParameters;
    private Process process;
    private OutputStream out;
    private Scanner reportScanner;
    private MultiThreadProcessor multiThreadProcessor;

    BaseCliRunner(MultiThreadProcessor multiThreadProcessor, String veraPDFStarterPath, List<String> veraPDFParameters, Queue<File> filesToProcess) {
        this.multiThreadProcessor = multiThreadProcessor;
        this.filesToProcess = filesToProcess;
        this.veraPDFStarterPath = veraPDFStarterPath;
        this.veraPDFParameters = veraPDFParameters;
    }

    @Override
    public void run() {
        LinkedList<String> command = new LinkedList<String>();
        command.add(this.veraPDFStarterPath);
        command.addAll(this.veraPDFParameters);
        command.add(this.filesToProcess.poll().getAbsolutePath());
        command = command.stream().map(parameter -> {
            if (parameter.isEmpty()) {
                return "\"\"";
            }
            return parameter;
        }).collect(Collectors.toList());
        try {
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.command(command);
            pb.redirectError(ProcessBuilder.Redirect.INHERIT);
            this.process = pb.start();
            this.out = this.process.getOutputStream();
            this.reportScanner = new Scanner(this.process.getInputStream());
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception in process", e);
        }
        while (this.reportScanner.hasNextLine()) {
            this.multiThreadProcessor.write(this.getData());
            File file = this.filesToProcess.poll();
            if (file != null) {
                this.validateFile(file);
                continue;
            }
            this.closeProcess();
        }
    }

    private boolean closeProcess() {
        boolean isClosed = false;
        try {
            this.out.write("q".getBytes());
            this.out.write("\n".getBytes());
            this.out.flush();
            this.process.waitFor();
            isClosed = true;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Can't close process", e);
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.SEVERE, "Process interrupted exception", e);
        }
        this.multiThreadProcessor.countDown(CliConstants.ExitCodes.fromValue(this.process.exitValue()));
        return isClosed;
    }

    private void validateFile(File file) {
        try {
            this.out.write(file.getAbsolutePath().getBytes());
            this.out.write("\n".getBytes());
            this.out.flush();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Can't pass new file to validate", e);
        }
    }

    private ResultStructure getData() {
        return new ResultStructure(new File(this.reportScanner.nextLine()));
    }
}

