/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cli;

import com.beust.jcommander.IUsageFormatter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.ReleaseDetails;
import org.verapdf.apps.Applications;
import org.verapdf.apps.ConfigManager;
import org.verapdf.apps.SoftwareUpdater;
import org.verapdf.cli.CliConstants;
import org.verapdf.cli.FormatterHelper;
import org.verapdf.cli.VeraPdfCliProcessor;
import org.verapdf.cli.commands.VeraCliArgParser;
import org.verapdf.cli.multithread.MultiThreadProcessor;
import org.verapdf.core.VeraPDFException;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.validation.profiles.ProfileDirectory;
import org.verapdf.pdfa.validation.profiles.Profiles;
import org.verapdf.pdfa.validation.profiles.ValidationProfile;
import org.verapdf.processor.FeaturesPluginsLoader;

public final class VeraPdfCli {
    private static final Logger logger = Logger.getLogger(VeraCliArgParser.class.getCanonicalName());
    private static final ConfigManager configManager = Applications.createAppConfigManager();
    private static final int MEGABYTE = 0x100000;
    private static final String FLAVOURS_HEADING = "veraPDF supported PDF/A and PDF/UA profiles:";
    private static final ProfileDirectory PROFILES = Profiles.getVeraProfileDirectory();
    public static final String EXIT = "q";

    private VeraPdfCli() {
    }

    public static void main(String[] args) throws VeraPDFException {
        MemoryMXBean memoryMan = ManagementFactory.getMemoryMXBean();
        FeaturesPluginsLoader.setBaseFolderPath((String)System.getProperty("app.home"));
        ReleaseDetails.addDetailsFromResource((String)"org/verapdf/release/app.properties");
        VeraCliArgParser cliArgParser = new VeraCliArgParser();
        JCommander jCommander = new JCommander((Object)cliArgParser);
        jCommander.setUsageFormatter((IUsageFormatter)new FormatterHelper(jCommander));
        jCommander.setProgramName("veraPDF");
        try {
            jCommander.parse(args);
        }
        catch (ParameterException e) {
            System.err.println(e.getMessage());
            VeraPdfCli.displayHelpAndExit(cliArgParser, jCommander, CliConstants.ExitCodes.BAD_PARAMS);
        }
        if (cliArgParser.isHelp()) {
            VeraPdfCli.displayHelpAndExit(cliArgParser, jCommander, CliConstants.ExitCodes.VALID);
        }
        VeraPdfCli.messagesFromParser(cliArgParser);
        cliArgParser.checkParametersCompatibility();
        if (VeraPdfCli.isProcess(cliArgParser)) {
            try {
                if (args.length == 0 && System.in.available() == 0) {
                    jCommander.usage();
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "STDIN is not available", e);
            }
            try {
                if (cliArgParser.isServerMode() || cliArgParser.getNumberOfProcesses() < 2) {
                    System.exit(VeraPdfCli.singleThreadProcess((VeraCliArgParser)cliArgParser).value);
                } else {
                    System.exit(MultiThreadProcessor.process((VeraCliArgParser)cliArgParser, (String)VeraPdfCli.configManager.getApplicationConfig().getWikiPath()).value);
                }
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "Interrupted", e);
                System.exit(CliConstants.ExitCodes.INTERRUPTED_EXCEPTION.value);
            }
            catch (OutOfMemoryError oome) {
                String message = "The JVM appears to have run out of memory";
                logger.log(Level.WARNING, "The JVM appears to have run out of memory", oome);
                MemoryUsage heapUsage = memoryMan.getHeapMemoryUsage();
                long maxMemory = heapUsage.getMax() / 0x100000L;
                long usedMemory = heapUsage.getUsed() / 0x100000L;
                System.out.format(",%s\n", "The JVM appears to have run out of memory");
                System.out.format("Memory Use: %sM/%sM\n", usedMemory, maxMemory);
                System.out.format("To increase the memory available to the JVM please assign the JAVA_OPTS environment variable.\n", new Object[0]);
                System.out.format("The examples below increase the maximum heap available to the JVM to 2GB:\n", new Object[0]);
                System.out.format(" - Mac or Linux users:\n", new Object[0]);
                System.out.format("   export JAVA_OPTS=\"-Xmx2048m\"\n", new Object[0]);
                System.out.format(" - Windows users:\n", new Object[0]);
                System.out.format("   SET JAVA_OPTS=\"-Xmx2048m\"\n", new Object[0]);
                System.exit(CliConstants.ExitCodes.OOM.value);
            }
            System.exit(CliConstants.ExitCodes.VALID.value);
        }
    }

    private static CliConstants.ExitCodes singleThreadProcess(VeraCliArgParser cliArgParser) throws VeraPDFException {
        try (VeraPdfCliProcessor processor = VeraPdfCliProcessor.createProcessorFromArgs(cliArgParser, configManager);){
            CliConstants.ExitCodes retVal = processor.processPaths(cliArgParser.getPdfPaths(), cliArgParser.nonPdfExt());
            if (cliArgParser.isServerMode()) {
                File tempFile = processor.getTempFile();
                if (tempFile != null) {
                    System.out.println(tempFile.getAbsoluteFile());
                }
                try (Scanner scanner = new Scanner(System.in);){
                    while (scanner.hasNextLine()) {
                        String path = scanner.nextLine();
                        if (path == null) continue;
                        if (path.equals(EXIT)) {
                            break;
                        }
                        ArrayList<String> paths = new ArrayList<String>();
                        paths.add(path);
                        CliConstants.ExitCodes exitCode = processor.processPaths(paths, cliArgParser.nonPdfExt());
                        System.out.println(processor.getTempFile().getAbsolutePath());
                        if (exitCode.value <= retVal.value) continue;
                        retVal = exitCode;
                    }
                }
            }
            CliConstants.ExitCodes exitCodes = retVal;
            return exitCodes;
        }
    }

    public static void displayHelpAndExit(VeraCliArgParser cliArgParser, JCommander jCommander, CliConstants.ExitCodes exitCode) {
        VeraPdfCli.showVersionInfo(cliArgParser.isVerbose());
        jCommander.usage();
        System.exit(exitCode.value);
    }

    private static void messagesFromParser(VeraCliArgParser parser) {
        if (parser.listProfiles()) {
            VeraPdfCli.listProfiles();
        }
        if (parser.showVersion()) {
            VeraPdfCli.showVersionInfo(parser.isVerbose());
        }
    }

    private static void listProfiles() {
        System.out.println(FLAVOURS_HEADING);
        EnumSet<PDFAFlavour> flavs = EnumSet.copyOf(PROFILES.getPDFAFlavours());
        for (PDFAFlavour flav : flavs) {
            ValidationProfile profile = PROFILES.getValidationProfileByFlavour(flav);
            System.out.format("  %s - %s", profile.getPDFAFlavour().getId(), profile.getDetails().getName());
            System.out.println();
        }
    }

    private static void showVersionInfo(boolean isVerbose) {
        ReleaseDetails appDetails = Applications.getAppDetails();
        System.out.format("%s %s\n", "veraPDF", appDetails.getVersion());
        System.out.format("Built: %s\n", appDetails.getBuildDate());
        System.out.format("%s\n", ReleaseDetails.rightsStatement());
        if (isVerbose) {
            VeraPdfCli.showUpdateInfo(appDetails);
        }
    }

    private static void showUpdateInfo(ReleaseDetails details) {
        SoftwareUpdater updater = Applications.softwareUpdater();
        if (!updater.isOnline()) {
            logger.log(Level.WARNING, "Update Service not available");
            return;
        }
        if (!updater.isUpdateAvailable(details)) {
            System.out.format("You are currently running the latest version of veraPDF%s v%s", ",", details.getVersion() + "\n");
            return;
        }
        System.out.format("You are NOT running the latest version of veraPDF.\nYou are running version %s, the latest version is %s.\n", details.getVersion(), updater.getLatestVersion(details));
        System.out.format("You can download the latest version from: %s.\n", "http://downloads.verapdf.org/rel/verapdf-installer.zip");
    }

    private static boolean isProcess(VeraCliArgParser parser) {
        return !parser.getPdfPaths().isEmpty() || !parser.isHelp() && !parser.listProfiles() && !parser.showVersion();
    }
}

