/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cli.commands;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.verapdf.apps.Applications;
import org.verapdf.apps.ProcessType;
import org.verapdf.apps.VeraAppConfig;
import org.verapdf.apps.utils.ApplicationUtils;
import org.verapdf.core.VeraPDFException;
import org.verapdf.features.FeatureExtractorConfig;
import org.verapdf.metadata.fixer.FixerFactory;
import org.verapdf.metadata.fixer.MetadataFixerConfig;
import org.verapdf.pdfa.Foundries;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.validation.profiles.Profiles;
import org.verapdf.pdfa.validation.profiles.ValidationProfile;
import org.verapdf.pdfa.validation.validators.ValidatorConfig;
import org.verapdf.pdfa.validation.validators.ValidatorFactory;
import org.verapdf.processor.FormatOption;
import org.verapdf.processor.ProcessorConfig;
import org.verapdf.processor.ProcessorFactory;
import org.verapdf.processor.plugins.PluginsCollectionConfig;
import org.xml.sax.SAXException;

public class VeraCliArgParser {
    private static final Logger LOGGER = Logger.getLogger(VeraCliArgParser.class.getCanonicalName());
    static final VeraCliArgParser DEFAULT_ARGS = new VeraCliArgParser();
    static final String FLAG_SEP = "-";
    static final String OPTION_SEP = "--";
    static final String HELP_FLAG = "-h";
    static final String HELP = "--help";
    static final String VERSION = "--version";
    static final String FLAVOUR_FLAG = "-f";
    static final String FLAVOUR = "--flavour";
    static final String DEFAULT_FLAVOUR_FLAG = "-df";
    static final String DEFAULT_FLAVOUR = "--defaultflavour";
    static final String SUCCESS = "--success";
    static final String PASSED = "--passed";
    static final String LIST_FLAG = "-l";
    static final String LIST = "--list";
    static final String LOAD_PROFILE_FLAG = "-p";
    static final String LOAD_PROFILE = "--profile";
    static final String EXTRACT_FLAG = "-x";
    static final String EXTRACT = "--extract";
    static final String FORMAT = "--format";
    static final String RECURSE_FLAG = "-r";
    static final String RECURSE = "--recurse";
    static final String SERVER_MODE = "--servermode";
    static final String VERBOSE_FLAG = "-v";
    static final String VERBOSE = "--verbose";
    static final String DEBUG_FLAG = "-d";
    static final String DEBUG = "--debug";
    static final String MAX_FAILURES_DISPLAYED = "--maxfailuresdisplayed";
    static final String MAX_FAILURES = "--maxfailures";
    static final String FIX_METADATA = "--fixmetadata";
    static final String FIX_METADATA_PREFIX = "--prefix";
    static final String FIX_METADATA_FOLDER = "--savefolder";
    static final String NON_PDF_EXTENSION = "--nonpdfext";
    static final String POLICY_FILE = "--policyfile";
    static final String ADD_LOGS = "--addlogs";
    static final String DISABLE_ERROR_MESSAGES = "--disableerrormessages";
    static final String LOG_LEVEL = "--loglevel";
    static final String VALID_OFF_FLAG = "-o";
    static final String VALID_OFF = "--off";
    static final String NUMBER_OF_PROCESSES_FLAG = "--processes";
    static final String VERA_PATH_FLAG = "--verapath";
    @Parameter(names={"-h", "--help"}, description="Shows this message and exits.", help=true)
    private boolean help = false;
    @Parameter(names={"--version"}, description="Displays veraPDF version information.")
    private boolean showVersion = false;
    @Parameter(names={"-f", "--flavour"}, description="Chooses built-in Validation Profile flavour, e.g. '1b'. Alternatively, supply '0' or no argument for automatic flavour detection based on a file's metadata.", converter=FlavourConverter.class)
    private PDFAFlavour flavour = PDFAFlavour.NO_FLAVOUR;
    @Parameter(names={"-df", "--defaultflavour"}, description="Chooses built-in Validation Profile default flavour, e.g. '1b'. This flavor will be applied if automatic flavour detection based on a file's metadata doesn't work.", converter=FlavourConverter.class)
    private PDFAFlavour defaultFlavour = PDFAFlavour.PDFA_1_B;
    @Parameter(names={"--success", "--passed"}, description="Logs successful validation checks.")
    private boolean passed = ValidatorFactory.defaultConfig().isRecordPasses();
    @Parameter(names={"-l", "--list"}, description="Lists built-in Validation Profiles.")
    private boolean listProfiles = false;
    @Parameter(names={"-p", "--profile"}, description="Loads a Validation Profile from given path and exits if loading fails. This overrides any choice or default implied by the -f / --flavour option.", validateWith={FileValidator.class})
    private File profileFile;
    @Parameter(names={"-x", "--extract"}, description="Extracts and reports PDF features.")
    private boolean features = false;
    @Parameter(names={"--format"}, description="Chooses output format.", converter=FormatConverter.class)
    private FormatOption format = Applications.defaultConfig().getFormat();
    @Parameter(names={"-r", "--recurse"}, description="Recurses through directories. Only files with .pdf extensions are processed.")
    private boolean isRecurse = false;
    @Parameter(names={"--servermode"}, description="Run veraPDF in server mode. Changes output and ignore --processesargument.", hidden=true)
    private boolean isServerMode = false;
    @Parameter(names={"-v", "--verbose"}, description="Adds failed test information to text output.")
    private boolean isVerbose = false;
    @Parameter(names={"-d", "--debug"}, description="Outputs all processed file names.")
    private boolean debug = false;
    @Parameter(names={"--maxfailuresdisplayed"}, description="Sets maximum amount of failed checks displayed for each rule.")
    private int maxFailuresDisplayed = 100;
    @Parameter(names={"--maxfailures"}, description="Sets maximum amount of failed checks.")
    private int maxFailures = ValidatorFactory.defaultConfig().getMaxFails();
    @Parameter(names={"--fixmetadata"}, description="Performs metadata fixes.")
    private boolean fixMetadata = false;
    @Parameter(names={"--addlogs"}, description="Add logs to mrr/json report.")
    private boolean addLogs = false;
    @Parameter(names={"--disableerrormessages"}, description="Disable detailed error messages in report.")
    private boolean disableErrorMessages = false;
    @Parameter(names={"--loglevel"}, description="Enables logs with level: 0 - OFF, 1 - SEVERE, 2 - WARNING, SEVERE (default), 3 - CONFIG, INFO, WARNING, SEVERE, 4 - ALL.")
    private int logLevel = 2;
    @Parameter(names={"--prefix"}, description="Sets file name prefix for any fixed files.")
    private String prefix = FixerFactory.defaultConfig().getFixesPrefix();
    @Parameter(names={"--savefolder"}, description="Sets output directory for any fixed files.")
    private String saveFolder = "";
    @Parameter(names={"--nonpdfext"}, description="Select files without .pdf extension")
    private boolean nonPdfExt = false;
    @Parameter(names={"--policyfile"}, description="Select a policy schematron or XSL file.", validateWith={FileValidator.class})
    private File policyFile;
    @Parameter(names={"-o", "--off"}, description="Turns off PDF/A validation")
    private boolean isValidationOff = false;
    @Parameter(names={"--processes"}, description="The number of processes which will be used.")
    private int numberOfProcesses = 1;
    @Parameter(names={"--verapath"}, description="Path to veraPDF Cli", hidden=true, validateWith={FileValidator.class})
    private File veraCLIPath;
    @Parameter(description="FILES")
    private List<String> pdfPaths = new ArrayList<String>();

    public boolean showVersion() {
        return this.showVersion;
    }

    public boolean listProfiles() {
        return this.listProfiles;
    }

    public boolean isVerbose() {
        return this.isVerbose;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public int maxFailuresDisplayed() {
        return this.maxFailuresDisplayed;
    }

    public int maxFailures() {
        return this.maxFailures;
    }

    public boolean fixMetadata() {
        return this.fixMetadata;
    }

    public boolean addLogs() {
        return this.addLogs;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public Level getLoggerLevel() {
        switch (this.getLogLevel()) {
            case 0: {
                return Level.OFF;
            }
            case 1: {
                return Level.SEVERE;
            }
            case 3: {
                return Level.CONFIG;
            }
            case 4: {
                return Level.ALL;
            }
        }
        return Level.WARNING;
    }

    public String prefix() {
        return this.prefix;
    }

    public String saveFolder() {
        return this.saveFolder;
    }

    public boolean nonPdfExt() {
        return this.nonPdfExt;
    }

    public boolean isRecurse() {
        return this.isRecurse;
    }

    public boolean isServerMode() {
        return this.isServerMode;
    }

    public boolean isHelp() {
        return this.help;
    }

    public FormatOption getFormat() {
        return this.format;
    }

    public boolean logPassed() {
        return this.passed;
    }

    public boolean extractFeatures() {
        return this.features | this.isPolicy();
    }

    public PDFAFlavour getDefaultFlavour() {
        return this.defaultFlavour;
    }

    public PDFAFlavour getFlavour() {
        return this.flavour;
    }

    public File getProfileFile() {
        return this.profileFile;
    }

    public File getPolicyFile() {
        return this.policyFile;
    }

    public boolean isPolicy() {
        return this.policyFile != null;
    }

    public File getVeraCLIPath() {
        return this.veraCLIPath;
    }

    public int getNumberOfProcesses() {
        return this.numberOfProcesses;
    }

    public List<String> getPdfPaths() {
        return this.pdfPaths;
    }

    public boolean isValidationOff() {
        return this.isValidationOff | this.isPolicy();
    }

    public boolean isDisableErrorMessages() {
        return this.disableErrorMessages;
    }

    public ValidatorConfig validatorConfig() {
        return ValidatorFactory.createConfig((PDFAFlavour)this.flavour, (PDFAFlavour)this.defaultFlavour, (boolean)this.logPassed(), (int)this.maxFailures, (boolean)this.debug, (boolean)this.addLogs(), (Level)this.getLoggerLevel(), (int)this.maxFailuresDisplayed, (!this.isDisableErrorMessages() ? 1 : 0) != 0);
    }

    public MetadataFixerConfig fixerConfig() {
        return FixerFactory.configFromValues((String)this.prefix, (boolean)true);
    }

    public VeraAppConfig appConfig(VeraAppConfig base) {
        Applications.Builder configBuilder = Applications.Builder.fromConfig(base);
        configBuilder.format(this.getFormat()).isVerbose(this.isVerbose()).fixerFolder(this.saveFolder);
        configBuilder.type(VeraCliArgParser.typeFromArgs(this));
        return configBuilder.build();
    }

    public ProcessorConfig processorConfig(ProcessType procType, FeatureExtractorConfig featConfig, PluginsCollectionConfig plugConfig) throws VeraPDFException {
        ProcessorConfig processorConfig;
        FeatureExtractorConfig featuresConfig = featConfig;
        if (this.isPolicy()) {
            try (FileInputStream policyStream = new FileInputStream(this.policyFile);){
                featuresConfig = ApplicationUtils.mergeEnabledFeaturesFromPolicy(featuresConfig, policyStream);
            }
            catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
                throw new VeraPDFException("Problem during obtaining feature types from policy file", (Throwable)e);
            }
        }
        if (this.profileFile == null) {
            return ProcessorFactory.fromValues((ValidatorConfig)this.validatorConfig(), (FeatureExtractorConfig)featuresConfig, (PluginsCollectionConfig)plugConfig, (MetadataFixerConfig)this.fixerConfig(), procType.getTasks(), (String)this.saveFolder);
        }
        FileInputStream fis = new FileInputStream(this.profileFile);
        try {
            ValidationProfile customProfile = Profiles.profileFromXml((InputStream)fis);
            processorConfig = ProcessorFactory.fromValues((ValidatorConfig)this.validatorConfig(), (FeatureExtractorConfig)featuresConfig, (PluginsCollectionConfig)plugConfig, (MetadataFixerConfig)this.fixerConfig(), procType.getTasks(), (ValidationProfile)customProfile, (String)this.saveFolder);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)fis).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | JAXBException excep) {
                throw new VeraPDFException("Problem loading custom profile", excep);
            }
        }
        ((InputStream)fis).close();
        return processorConfig;
    }

    private static ProcessType typeFromArgs(VeraCliArgParser parser) {
        ProcessType retVal;
        ProcessType processType = retVal = parser.isValidationOff() && !parser.isPolicy() ? ProcessType.NO_PROCESS : ProcessType.VALIDATE;
        if (parser.extractFeatures() || parser.isPolicy()) {
            retVal = ProcessType.addProcess(retVal, ProcessType.EXTRACT);
        }
        if (parser.fixMetadata()) {
            retVal = ProcessType.addProcess(retVal, ProcessType.FIX);
        }
        return retVal;
    }

    public static List<String> getBaseVeraPDFParameters(VeraCliArgParser cliArgParser) {
        File policyFile;
        ArrayList<String> veraPDFParameters = new ArrayList<String>();
        veraPDFParameters.add(SERVER_MODE);
        if (cliArgParser.extractFeatures()) {
            veraPDFParameters.add(EXTRACT_FLAG);
        }
        if (cliArgParser.fixMetadata()) {
            veraPDFParameters.add(FIX_METADATA);
        }
        if (cliArgParser.addLogs()) {
            veraPDFParameters.add(ADD_LOGS);
        }
        if (cliArgParser.isDisableErrorMessages()) {
            veraPDFParameters.add(DISABLE_ERROR_MESSAGES);
        }
        veraPDFParameters.add(LOG_LEVEL);
        veraPDFParameters.add(String.valueOf(cliArgParser.getLogLevel()));
        veraPDFParameters.add(DEFAULT_FLAVOUR);
        veraPDFParameters.add(String.valueOf(cliArgParser.getDefaultFlavour()));
        veraPDFParameters.add(FLAVOUR);
        veraPDFParameters.add(String.valueOf(cliArgParser.getFlavour()));
        veraPDFParameters.add(FORMAT);
        if (cliArgParser.getFormat() == FormatOption.HTML) {
            veraPDFParameters.add(String.valueOf(FormatOption.MRR));
        } else {
            veraPDFParameters.add(String.valueOf(cliArgParser.getFormat()));
        }
        if (cliArgParser.listProfiles()) {
            veraPDFParameters.add(LIST);
        }
        veraPDFParameters.add(MAX_FAILURES);
        veraPDFParameters.add(String.valueOf(cliArgParser.maxFailures()));
        veraPDFParameters.add(MAX_FAILURES_DISPLAYED);
        veraPDFParameters.add(String.valueOf(cliArgParser.maxFailuresDisplayed()));
        if (cliArgParser.isValidationOff()) {
            veraPDFParameters.add(VALID_OFF);
        }
        if ((policyFile = cliArgParser.getPolicyFile()) != null) {
            veraPDFParameters.add(POLICY_FILE);
            veraPDFParameters.add(policyFile.getAbsolutePath());
        }
        veraPDFParameters.add(FIX_METADATA_PREFIX);
        veraPDFParameters.add(cliArgParser.prefix());
        File profileFile = cliArgParser.getProfileFile();
        if (profileFile != null) {
            veraPDFParameters.add(LOAD_PROFILE_FLAG);
            veraPDFParameters.add(profileFile.getAbsolutePath());
        }
        veraPDFParameters.add(FIX_METADATA_FOLDER);
        veraPDFParameters.add(cliArgParser.saveFolder());
        if (cliArgParser.logPassed()) {
            veraPDFParameters.add(SUCCESS);
        }
        if (cliArgParser.isVerbose()) {
            veraPDFParameters.add(VERBOSE);
        }
        if (cliArgParser.isDebug()) {
            veraPDFParameters.add(DEBUG);
        }
        if (cliArgParser.nonPdfExt()) {
            veraPDFParameters.add(NON_PDF_EXTENSION);
        }
        return veraPDFParameters;
    }

    public void checkParametersCompatibility() {
        if (this.format != FormatOption.MRR && this.policyFile != null && !this.policyFile.getAbsolutePath().equals("")) {
            LOGGER.log(Level.WARNING, "Policy report supports only mrr output format.");
            this.format = FormatOption.MRR;
        }
        if (this.format != FormatOption.MRR && this.format != FormatOption.JSON && this.addLogs) {
            LOGGER.log(Level.WARNING, "Log messages in report are supported only in mrr and json formats.");
        }
        if (Foundries.defaultParserIsPDFBox() && !this.disableErrorMessages) {
            LOGGER.log(Level.WARNING, "Detailed error messages are not supported in PDFBox validator.");
            this.disableErrorMessages = true;
        }
    }

    public static final class FileValidator
    implements IParameterValidator {
        public void validate(String name, String value) throws ParameterException {
            File profileFileLocal = new File(value);
            if (!profileFileLocal.isFile() || !profileFileLocal.canRead()) {
                throw new ParameterException("Parameter " + name + " must be the path to an existing, readable file, value=" + value);
            }
        }
    }

    public static final class FlavourConverter
    implements IStringConverter<PDFAFlavour> {
        public PDFAFlavour convert(String value) {
            for (PDFAFlavour flavourLocal : PDFAFlavour.values()) {
                if (!flavourLocal.getId().equalsIgnoreCase(value)) continue;
                return flavourLocal;
            }
            throw new ParameterException("Illegal --flavour argument:" + value);
        }
    }

    public static final class FormatConverter
    implements IStringConverter<FormatOption> {
        public FormatOption convert(String value) {
            try {
                return FormatOption.fromOption((String)value);
            }
            catch (NoSuchElementException e) {
                throw new ParameterException("Illegal format option value: " + value, (Throwable)e);
            }
        }
    }
}

