/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.apps.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javanet.staxutils.SimpleNamespaceContext;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.verapdf.apps.Applications;
import org.verapdf.core.utils.FileUtils;
import org.verapdf.features.FeatureExtractorConfig;
import org.verapdf.features.FeatureFactory;
import org.verapdf.features.FeatureObjectType;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class ApplicationUtils {
    private static final Logger LOGGER = Logger.getLogger(ApplicationUtils.class.getCanonicalName());

    private ApplicationUtils() {
        throw new AssertionError((Object)"Should never happen");
    }

    public static List<File> filterPdfFiles(List<File> toFilter, boolean isRecursive, boolean nonPdfExt) {
        Applications.checkArgNotNull(toFilter, "toFilter");
        ArrayList<File> retVal = new ArrayList<File>();
        for (File file : toFilter) {
            if (!file.exists()) {
                LOGGER.log(Level.SEVERE, "File " + file.getAbsolutePath() + " doesn't exist.");
                continue;
            }
            if (file.isFile()) {
                if (nonPdfExt || FileUtils.hasExtNoCase((String)file.getName(), (String)"pdf") || FileUtils.hasExtNoCase((String)file.getName(), (String)"zip")) {
                    retVal.add(file);
                    continue;
                }
                LOGGER.log(Level.SEVERE, "File " + file.getAbsolutePath() + " doesn't have a .pdf extension. Try using --nonpdfext flag");
                continue;
            }
            if (!file.isDirectory()) continue;
            retVal.addAll(ApplicationUtils.filterPdfFilesFromDirs(Arrays.asList(file.listFiles()), isRecursive, nonPdfExt));
        }
        return Collections.unmodifiableList(retVal);
    }

    private static List<File> filterPdfFilesFromDirs(List<File> toFilter, boolean isRecursive, boolean nonPdfExt) {
        Applications.checkArgNotNull(toFilter, "toFilter");
        ArrayList<File> retVal = new ArrayList<File>();
        for (File file : toFilter) {
            if (file.isFile() && (nonPdfExt || FileUtils.hasExtNoCase((String)file.getName(), (String)"pdf"))) {
                retVal.add(file);
                continue;
            }
            if (!file.isDirectory() || !isRecursive) continue;
            retVal.addAll(ApplicationUtils.filterPdfFilesFromDirs(Arrays.asList(file.listFiles()), isRecursive, nonPdfExt));
        }
        return Collections.unmodifiableList(retVal);
    }

    public static boolean doAllFilesExist(List<File> toCheck) {
        Applications.checkArgNotNull(toCheck, "toCheck");
        if (toCheck.isEmpty()) {
            return false;
        }
        for (File file : toCheck) {
            if (file != null && file.exists()) continue;
            return false;
        }
        return true;
    }

    public static boolean isLegalExtension(List<File> toCheck, String[] extensions) {
        Applications.checkArgNotNull(toCheck, "toCheck");
        for (File file : toCheck) {
            if (file.isFile()) {
                boolean isExtMatch = false;
                for (String extension : extensions) {
                    if (!FileUtils.hasExtNoCase((String)file.getName(), (String)extension)) continue;
                    isExtMatch = true;
                }
                if (isExtMatch) continue;
                return false;
            }
            if (!file.isDirectory() || ApplicationUtils.isLegalExtension(Arrays.asList(file.listFiles()), extensions)) continue;
            return false;
        }
        return true;
    }

    public static FeatureExtractorConfig mergeEnabledFeaturesFromPolicy(FeatureExtractorConfig currentConfig, InputStream policy) throws ParserConfigurationException, IOException, SAXException, XPathExpressionException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.parse(policy);
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xpath = xpf.newXPath();
        SimpleNamespaceContext nsc = new SimpleNamespaceContext();
        nsc.setPrefix("sch", "http://purl.oclc.org/dsdl/schematron");
        xpath.setNamespaceContext((NamespaceContext)nsc);
        String path = "/sch:schema/@veraPDFNecessaryFeatures";
        String value = (String)xpath.evaluate(path, document, XPathConstants.STRING);
        if (value == null) {
            return currentConfig;
        }
        String[] values = value.split(",");
        if (values.length == 0) {
            return currentConfig;
        }
        EnumSet<FeatureObjectType> resFeatures = EnumSet.noneOf(FeatureObjectType.class);
        for (String featureName : values) {
            FeatureObjectType feature = FeatureObjectType.getFeatureObjectTypeByFullName((String)featureName);
            if (feature == null) continue;
            resFeatures.add(feature);
        }
        resFeatures.addAll(currentConfig.getEnabledFeatures());
        return FeatureFactory.configFromValues(resFeatures);
    }
}

