/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cli;

import com.beust.jcommander.DefaultUsageFormatter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.Strings;
import com.beust.jcommander.WrappedParameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.validation.profiles.Profiles;
import org.verapdf.processor.FormatOption;

public class FormatterHelper
extends DefaultUsageFormatter {
    private static final String FLAVOUR = "flavour";

    public FormatterHelper(JCommander commander) {
        super(commander);
    }

    public void appendAllParametersDetails(StringBuilder out, int indentCount, String indent, List<ParameterDescription> sortedParameters) {
        if (!sortedParameters.isEmpty()) {
            out.append(indent).append("  Options:\n");
        }
        for (ParameterDescription pd : sortedParameters) {
            Class type;
            WrappedParameter parameter = pd.getParameter();
            String description = pd.getDescription();
            boolean hasDescription = !description.isEmpty();
            out.append(indent).append("  ").append(parameter.required() ? "* " : "  ").append(pd.getNames()).append('\n');
            if (hasDescription) {
                this.wrapDescription(out, indentCount, FormatterHelper.s((int)indentCount) + description);
            }
            Object def = pd.getDefault();
            if (pd.isDynamicParameter()) {
                String syntax = "Syntax: " + parameter.names()[0] + "key" + parameter.getAssignment() + "value";
                if (hasDescription) {
                    out.append(FormatterHelper.newLineAndIndent(indentCount));
                } else {
                    out.append(FormatterHelper.s((int)indentCount));
                }
                out.append(syntax);
            }
            if (def != null && !pd.isHelp()) {
                String displayedDef = Strings.isStringEmpty((String)def.toString()) ? "<empty string>" : def.toString();
                String defaultText = "Default: " + (parameter.password() ? "********" : displayedDef);
                if (hasDescription) {
                    out.append(FormatterHelper.newLineAndIndent(indentCount));
                } else {
                    out.append(FormatterHelper.s((int)indentCount));
                }
                out.append(defaultText);
            }
            if ((type = pd.getParameterized().getType()).isEnum()) {
                String valueList;
                if (PDFAFlavour.class.getCanonicalName().equals(type.getName())) {
                    EnumSet<PDFAFlavour> flavours = EnumSet.copyOf(Profiles.getVeraProfileDirectory().getPDFAFlavours());
                    if (FLAVOUR.equals(pd.getParameterized().getName())) {
                        flavours.add(PDFAFlavour.NO_FLAVOUR);
                    }
                    valueList = flavours.toString();
                } else if (FormatOption.class.getCanonicalName().equals(type.getName())) {
                    LinkedList<FormatOption> formatOptions = new LinkedList<FormatOption>(Arrays.asList(FormatOption.values()));
                    formatOptions.remove(FormatOption.MRR);
                    valueList = ((Object)formatOptions).toString();
                } else {
                    valueList = EnumSet.allOf(type).toString();
                }
                String possibleValues = "Possible Values: " + valueList;
                if (!description.contains("Options: " + valueList)) {
                    if (hasDescription) {
                        out.append(FormatterHelper.newLineAndIndent(indentCount));
                    } else {
                        out.append(FormatterHelper.s((int)indentCount));
                    }
                    out.append(possibleValues);
                }
            }
            if (List.class.getCanonicalName().equals(type.getCanonicalName())) {
                Type fieldGenericType = pd.getParameterized().findFieldGenericType();
                String valueList = null;
                if (FeatureObjectType.class.equals((Object)fieldGenericType)) {
                    LinkedList<FeatureObjectType> featuresList = new LinkedList<FeatureObjectType>(Arrays.asList(FeatureObjectType.values()));
                    featuresList.remove(FeatureObjectType.ERROR);
                    valueList = ((Object)featuresList).toString();
                }
                if (valueList != null) {
                    String possibleValues = "Possible Values: " + valueList;
                    out.append(FormatterHelper.newLineAndIndent(indentCount));
                    out.append(possibleValues);
                }
            }
            out.append('\n');
        }
    }

    private static String newLineAndIndent(int indent) {
        return '\n' + FormatterHelper.s((int)indent);
    }
}

