/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.PDEncryption;
import org.apache.pdfbox.pdmodel.encryption.SecurityHandler;
import org.verapdf.features.objects.DocSecurityFeaturesObjectAdapter;

public class PBDocSecurityFeaturesObjectAdapter
implements DocSecurityFeaturesObjectAdapter {
    private static final Logger LOGGER = Logger.getLogger(PBDocSecurityFeaturesObjectAdapter.class.getCanonicalName());
    private PDEncryption encryption;
    private String ownerKey;
    private String userKey;
    private boolean isUserPermissionsPresent;
    private boolean isPrintAllowed;
    private boolean isPrintDegradedAllowed;
    private boolean isChangesAllowed;
    private boolean isModifyAnnotationsAllowed;
    private boolean isFillingSigningAllowed;
    private boolean isDocumentAssemblyAllowed;
    private boolean isExtractContentAllowed;
    private boolean isExtractAccessibilityAllowed;
    private List<String> errors;

    public PBDocSecurityFeaturesObjectAdapter(PDEncryption encryption) {
        this.encryption = encryption;
        this.init();
    }

    private void init() {
        if (this.encryption != null) {
            this.errors = new ArrayList<String>();
            try {
                this.ownerKey = new COSString(this.encryption.getOwnerKey()).toHexString();
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, "PDFBox error getting owner key data. " + e.getMessage());
                this.errors.add(e.getMessage());
            }
            try {
                this.userKey = new COSString(this.encryption.getUserKey()).toHexString();
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, "PDFBox error getting user key data. " + e.getMessage());
                this.errors.add(e.getMessage());
            }
            try {
                SecurityHandler securityHandler = this.encryption.getSecurityHandler();
                boolean bl = this.isUserPermissionsPresent = securityHandler != null;
                if (securityHandler != null) {
                    AccessPermission accessPermissions = new AccessPermission(this.encryption.getPermissions());
                    this.isPrintAllowed = accessPermissions.canPrint();
                    this.isPrintDegradedAllowed = accessPermissions.canPrintDegraded();
                    this.isChangesAllowed = accessPermissions.canModify();
                    this.isModifyAnnotationsAllowed = accessPermissions.canModifyAnnotations();
                    this.isFillingSigningAllowed = accessPermissions.canFillInForm();
                    this.isDocumentAssemblyAllowed = accessPermissions.canAssembleDocument();
                    this.isExtractContentAllowed = accessPermissions.canExtractContent();
                    this.isExtractAccessibilityAllowed = accessPermissions.canExtractForAccessibility();
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, "PDFBox reports no matching security handle. " + e.getMessage());
                this.errors.add("PDFBox reports no matching security handle.");
            }
        }
    }

    @Override
    public String getHexEncodedOwnerKey() {
        return this.ownerKey;
    }

    @Override
    public String getHexEncodedUserKey() {
        return this.userKey;
    }

    @Override
    public boolean isUserPermissionsPresent() {
        return this.isUserPermissionsPresent;
    }

    @Override
    public boolean isPrintAllowed() {
        return this.isPrintAllowed;
    }

    @Override
    public boolean isPrintDegradedAllowed() {
        return this.isPrintDegradedAllowed;
    }

    @Override
    public boolean isChangesAllowed() {
        return this.isChangesAllowed;
    }

    @Override
    public boolean isModifyAnnotationsAllowed() {
        return this.isModifyAnnotationsAllowed;
    }

    @Override
    public boolean isFillingSigningAllowed() {
        return this.isFillingSigningAllowed;
    }

    @Override
    public boolean isDocumentAssemblyAllowed() {
        return this.isDocumentAssemblyAllowed;
    }

    @Override
    public boolean isExtractContentAllowed() {
        return this.isExtractContentAllowed;
    }

    @Override
    public boolean isExtractAccessibilityAllowed() {
        return this.isExtractAccessibilityAllowed;
    }

    @Override
    public boolean isPDFObjectPresent() {
        return this.encryption != null;
    }

    @Override
    public List<String> getErrors() {
        return this.errors == null ? Collections.emptyList() : Collections.unmodifiableList(this.errors);
    }

    @Override
    public String getFilter() {
        if (this.encryption != null) {
            return this.encryption.getFilter();
        }
        return null;
    }

    @Override
    public String getSubFilter() {
        if (this.encryption != null) {
            return this.encryption.getSubFilter();
        }
        return null;
    }

    @Override
    public int getVersion() {
        if (this.encryption != null) {
            return this.encryption.getVersion();
        }
        return 0;
    }

    @Override
    public int getLength() {
        if (this.encryption != null) {
            return this.encryption.getLength();
        }
        return 0;
    }

    @Override
    public boolean isEncryptMetadata() {
        return this.encryption == null || this.encryption.isEncryptMetaData();
    }
}

