/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.metadata.fixer.impl.pb.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.verapdf.metadata.fixer.entity.InfoDictionary;
import org.verapdf.metadata.fixer.entity.Metadata;
import org.verapdf.metadata.fixer.entity.PDFDocument;
import org.verapdf.metadata.fixer.impl.pb.model.InfoDictionaryImpl;
import org.verapdf.metadata.fixer.impl.pb.model.MetadataImpl;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.results.MetadataFixerResult;
import org.verapdf.pdfa.results.MetadataFixerResultImpl;
import org.verapdf.xmp.XMPException;
import org.verapdf.xmp.impl.VeraPDFMeta;

public class PDFDocumentImpl
implements PDFDocument {
    private static final Logger LOGGER = Logger.getLogger(PDFDocumentImpl.class.getCanonicalName());
    private final PDDocument document;
    private MetadataImpl metadata;
    private InfoDictionaryImpl info;
    private boolean isUnfiltered = false;

    public PDFDocumentImpl(InputStream pdfStream) throws IOException {
        this(PDDocument.load(pdfStream, false, true));
    }

    public PDFDocumentImpl(PDDocument document) {
        if (document == null) {
            throw new IllegalArgumentException("Document representation can not be null");
        }
        this.document = document;
        this.metadata = this.parseMetadata();
        this.info = this.getInfo();
    }

    private MetadataImpl parseMetadata() {
        PDDocumentCatalog catalog = this.document.getDocumentCatalog();
        PDMetadata meta = catalog.getMetadata();
        if (meta == null) {
            MetadataImpl metadataImpl;
            block9: {
                COSStream stream = this.document.getDocument().createCOSStream();
                try {
                    catalog.setMetadata(new PDMetadata(stream));
                    catalog.getCOSObject().setNeedToBeUpdated(true);
                    VeraPDFMeta xmp = VeraPDFMeta.create();
                    metadataImpl = new MetadataImpl(xmp, stream);
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException excep) {
                        excep.printStackTrace();
                    }
                }
                stream.close();
            }
            return metadataImpl;
        }
        return PDFDocumentImpl.parseMetadata(meta);
    }

    private static MetadataImpl parseMetadata(PDMetadata meta) {
        try {
            VeraPDFMeta xmp = VeraPDFMeta.parse(meta.getStream().getUnfilteredStream());
            if (xmp != null) {
                return new MetadataImpl(xmp, meta.getStream());
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Problems with document parsing or structure. " + e.getMessage());
        }
        catch (XMPException e) {
            LOGGER.log(Level.INFO, "Problems with XMP parsing. " + e.getMessage());
        }
        return null;
    }

    private InfoDictionaryImpl getInfo() {
        COSDictionary trailer = this.document.getDocument().getTrailer();
        COSBase infoDict = trailer.getDictionaryObject(COSName.INFO);
        return !(infoDict instanceof COSDictionary) ? null : new InfoDictionaryImpl(new PDDocumentInformation((COSDictionary)infoDict));
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public InfoDictionary getInfoDictionary() {
        return this.info;
    }

    @Override
    public boolean isNeedToBeUpdated() {
        boolean metaUpd = this.metadata != null && this.metadata.isNeedToBeUpdated();
        boolean infoUpd = this.info != null && this.info.isNeedToBeUpdated();
        return metaUpd || infoUpd || this.isUnfiltered;
    }

    @Override
    public MetadataFixerResult saveDocumentIncremental(MetadataFixerResult.RepairStatus status, OutputStream output, PDFAFlavour flavour) {
        MetadataFixerResultImpl.Builder builder = new MetadataFixerResultImpl.Builder();
        try {
            boolean isMetaAdd;
            PDMetadata meta = this.document.getDocumentCatalog().getMetadata();
            boolean isMetaPresent = meta != null && this.isNeedToBeUpdated();
            boolean bl = isMetaAdd = meta == null && this.metadata != null;
            if (isMetaPresent || isMetaAdd) {
                this.metadata.updateMetadataStream(builder, flavour);
                if (isMetaAdd) {
                    this.document.getDocumentCatalog().getCOSObject().setNeedToBeUpdated(true);
                }
                this.document.saveIncremental(output);
                output.close();
                builder.status(PDFDocumentImpl.getStatus(status));
            } else {
                builder.status(status);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, e.getMessage());
            builder.status(MetadataFixerResult.RepairStatus.FIX_ERROR).addFix("Problems with document save. " + e.getMessage());
        }
        return builder.build();
    }

    /*
     * Exception decompiling
     */
    @Override
    public int removeFiltersForAllMetadataObjects() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static MetadataFixerResult.RepairStatus getStatus(MetadataFixerResult.RepairStatus status) {
        return status == MetadataFixerResult.RepairStatus.NO_ACTION ? MetadataFixerResult.RepairStatus.SUCCESS : status;
    }
}

