/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.util.Charsets;

public abstract class BaseParser {
    private static final long OBJECT_NUMBER_THRESHOLD = 10000000000L;
    private static final long GENERATION_NUMBER_THRESHOLD = 65535L;
    public static final String PROP_PUSHBACK_SIZE = "org.apache.pdfbox.baseParser.pushBackSize";
    private static final Log LOG = LogFactory.getLog(BaseParser.class);
    protected static final int E = 101;
    protected static final int N = 110;
    protected static final int D = 100;
    protected static final int S = 115;
    protected static final int T = 116;
    protected static final int R = 114;
    protected static final int A = 97;
    protected static final int M = 109;
    protected static final int O = 111;
    protected static final int B = 98;
    protected static final int J = 106;
    public static final String DEF = "def";
    protected static final String ENDOBJ_STRING = "endobj";
    protected static final String ENDSTREAM_STRING = "endstream";
    protected static final String STREAM_STRING = "stream";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String NULL = "null";
    protected static final byte ASCII_LF = 10;
    protected static final byte ASCII_CR = 13;
    private static final byte ASCII_ZERO = 48;
    private static final byte ASCII_NINE = 57;
    protected static final byte ASCII_SPACE = 32;
    protected boolean validationParsing = false;
    protected RandomAccessRead pdfSource;
    protected COSDocument document;

    public BaseParser() {
    }

    public BaseParser(COSStream stream) throws IOException {
        this.pdfSource = stream.getUnfilteredRandomAccess();
    }

    public BaseParser(RandomAccessRead input) throws IOException {
        this.pdfSource = input;
    }

    private static boolean isHexDigit(char ch) {
        return BaseParser.isDigit(ch) || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F';
    }

    private COSBase parseCOSDictionaryValue() throws IOException {
        long numOffset = this.pdfSource.getPosition();
        COSBase number = this.parseDirObject();
        this.skipSpaces();
        if (!this.isDigit()) {
            return number;
        }
        long genOffset = this.pdfSource.getPosition();
        COSBase generationNumber = this.parseDirObject();
        this.skipSpaces();
        this.readExpectedChar('R');
        if (!(number instanceof COSInteger)) {
            throw new IOException("expected number, actual=" + number + " at offset " + numOffset);
        }
        if (!(generationNumber instanceof COSInteger)) {
            throw new IOException("expected number, actual=" + number + " at offset " + genOffset);
        }
        COSObjectKey key = new COSObjectKey(((COSInteger)number).longValue(), ((COSInteger)generationNumber).intValue());
        return this.getObjectFromPool(key);
    }

    private COSBase getObjectFromPool(COSObjectKey key) throws IOException {
        if (this.document == null) {
            throw new IOException("object reference " + key + " at offset " + this.pdfSource.getPosition() + " in content stream");
        }
        return this.document.getObjectFromPool(key);
    }

    protected COSDictionary parseCOSDictionary() throws IOException {
        this.readExpectedChar('<');
        this.readExpectedChar('<');
        this.skipSpaces();
        COSDictionary obj = new COSDictionary();
        boolean done = false;
        while (!done) {
            this.skipSpaces();
            char c = (char)this.pdfSource.peek();
            if (c == '>') {
                done = true;
                continue;
            }
            if (c == '/') {
                this.parseCOSDictionaryNameValuePair(obj);
                continue;
            }
            LOG.debug("Invalid dictionary, found: '" + c + "' but expected: '/'");
            if (!this.readUntilEndOfCOSDictionary()) continue;
            return obj;
        }
        this.readExpectedChar('>');
        this.readExpectedChar('>');
        return obj;
    }

    private boolean readUntilEndOfCOSDictionary() throws IOException {
        int c = this.pdfSource.read();
        while (c != -1 && c != 47 && c != 62) {
            if (c == 101 && (c = this.pdfSource.read()) == 110 && (c = this.pdfSource.read()) == 100) {
                boolean isObj;
                c = this.pdfSource.read();
                boolean isStream = c == 115 && this.pdfSource.read() == 116 && this.pdfSource.read() == 114 && this.pdfSource.read() == 101 && this.pdfSource.read() == 97 && this.pdfSource.read() == 109;
                boolean bl = isObj = !isStream && c == 111 && this.pdfSource.read() == 98 && this.pdfSource.read() == 106;
                if (isStream || isObj) {
                    return true;
                }
            }
            c = this.pdfSource.read();
        }
        if (c == -1) {
            return true;
        }
        this.pdfSource.rewind(1);
        return false;
    }

    private void parseCOSDictionaryNameValuePair(COSDictionary obj) throws IOException {
        COSName key = this.parseCOSName();
        COSBase value = this.parseCOSDictionaryValue();
        this.skipSpaces();
        if ((char)this.pdfSource.peek() == 'd') {
            String potentialDEF = this.readString();
            if (!potentialDEF.equals(DEF)) {
                this.pdfSource.rewind(potentialDEF.getBytes(Charsets.ISO_8859_1).length);
            } else {
                this.skipSpaces();
            }
        }
        if (value == null) {
            LOG.debug("Bad Dictionary Declaration " + this.pdfSource);
        } else {
            value.setDirect(true);
            obj.setItem(key, value);
        }
    }

    protected void skipWhiteSpaces() throws IOException {
        int whitespace = this.pdfSource.read();
        while (32 == whitespace) {
            whitespace = this.pdfSource.read();
        }
        if (13 == whitespace) {
            whitespace = this.pdfSource.read();
            if (10 != whitespace) {
                this.pdfSource.rewind(1);
            }
        } else if (10 != whitespace) {
            this.pdfSource.rewind(1);
        }
    }

    private int checkForMissingCloseParen(int bracesParameter) throws IOException {
        int braces = bracesParameter;
        byte[] nextThreeBytes = new byte[3];
        int amountRead = this.pdfSource.read(nextThreeBytes);
        if (amountRead == 3 && (nextThreeBytes[0] == 13 && nextThreeBytes[1] == 10 && nextThreeBytes[2] == 47 || nextThreeBytes[0] == 13 && nextThreeBytes[1] == 47)) {
            braces = 0;
        }
        if (amountRead > 0) {
            this.pdfSource.rewind(amountRead);
        }
        return braces;
    }

    protected COSString parseCOSString() throws IOException {
        char nextChar = (char)this.pdfSource.read();
        if (nextChar != '(') {
            if (nextChar == '<') {
                return this.parseCOSHexString();
            }
            throw new IOException("parseCOSString string should start with '(' or '<' and not '" + nextChar + "' " + this.pdfSource);
        }
        char openBrace = '(';
        char closeBrace = ')';
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int braces = 1;
        int c = this.pdfSource.read();
        while (braces > 0 && c != -1) {
            char ch = (char)c;
            int nextc = -2;
            if (ch == closeBrace) {
                --braces;
                if ((braces = this.checkForMissingCloseParen(braces)) != 0) {
                    out.write(ch);
                }
            } else if (ch == openBrace) {
                ++braces;
                out.write(ch);
            } else if (ch == '\\') {
                char next = (char)this.pdfSource.read();
                switch (next) {
                    case 'n': {
                        out.write(10);
                        break;
                    }
                    case 'r': {
                        out.write(13);
                        break;
                    }
                    case 't': {
                        out.write(9);
                        break;
                    }
                    case 'b': {
                        out.write(8);
                        break;
                    }
                    case 'f': {
                        out.write(12);
                        break;
                    }
                    case ')': {
                        braces = this.checkForMissingCloseParen(braces);
                        if (braces != 0) {
                            out.write(next);
                            break;
                        }
                        out.write(92);
                        break;
                    }
                    case '(': 
                    case '\\': {
                        out.write(next);
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        c = this.pdfSource.read();
                        while (this.isEOL(c) && c != -1) {
                            c = this.pdfSource.read();
                        }
                        nextc = c;
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        StringBuffer octal = new StringBuffer();
                        octal.append(next);
                        c = this.pdfSource.read();
                        char digit = (char)c;
                        if (digit >= '0' && digit <= '7') {
                            octal.append(digit);
                            c = this.pdfSource.read();
                            digit = (char)c;
                            if (digit >= '0' && digit <= '7') {
                                octal.append(digit);
                            } else {
                                nextc = c;
                            }
                        } else {
                            nextc = c;
                        }
                        int character = 0;
                        try {
                            character = Integer.parseInt(octal.toString(), 8);
                        }
                        catch (NumberFormatException e) {
                            throw new IOException("Error: Expected octal character, actual='" + octal + "'", e);
                        }
                        out.write(character);
                        break;
                    }
                    default: {
                        out.write(next);
                        break;
                    }
                }
            } else {
                out.write(ch);
            }
            if (nextc != -2) {
                c = nextc;
                continue;
            }
            c = this.pdfSource.read();
        }
        if (c != -1) {
            this.pdfSource.rewind(1);
        }
        return new COSString(out.toByteArray());
    }

    private COSString parseCOSHexString() throws IOException {
        StringBuilder sBuf;
        block7: {
            int c;
            if (this.validationParsing) {
                return this.validationParseCOSHexString();
            }
            sBuf = new StringBuilder();
            while (true) {
                if (BaseParser.isHexDigit((char)(c = this.pdfSource.read()))) {
                    sBuf.append((char)c);
                    continue;
                }
                if (c == 62) break block7;
                if (c < 0) {
                    throw new IOException("Missing closing bracket for hex string. Reached EOS.");
                }
                if (c != 32 && c != 10 && c != 9 && c != 13 && c != 8 && c != 12) break;
            }
            if (sBuf.length() % 2 != 0) {
                sBuf.deleteCharAt(sBuf.length() - 1);
            }
            while ((c = this.pdfSource.read()) != 62 && c >= 0) {
            }
            if (c < 0) {
                throw new IOException("Missing closing bracket for hex string. Reached EOS.");
            }
        }
        return COSString.parseHex(sBuf.toString());
    }

    private COSString validationParseCOSHexString() throws IOException {
        Boolean isHexSymbols = Boolean.TRUE;
        Long hexCount = 0L;
        StringBuilder sBuf = new StringBuilder();
        while (true) {
            Long l;
            Long l2;
            int c;
            if (BaseParser.isHexDigit((char)(c = this.pdfSource.read()))) {
                sBuf.append((char)c);
                l2 = hexCount;
                l = hexCount = Long.valueOf(hexCount + 1L);
                continue;
            }
            if (c == 62) break;
            if (c < 0) {
                throw new IOException("Missing closing bracket for hex string. Reached EOS.");
            }
            if (this.isWhitespace(c)) continue;
            isHexSymbols = Boolean.FALSE;
            l2 = hexCount;
            l = hexCount = Long.valueOf(hexCount + 1L);
        }
        COSString result = COSString.parseHex(sBuf.toString());
        result.setHexCount(hexCount);
        result.setContainsOnlyHex(isHexSymbols);
        return result;
    }

    protected COSArray parseCOSArray() throws IOException {
        int i;
        this.readExpectedChar('[');
        COSArray po = new COSArray();
        this.skipSpaces();
        while ((i = this.pdfSource.peek()) > 0 && (char)i != ']') {
            COSBase pbo = this.parseDirObject();
            if (pbo instanceof COSObject) {
                if (po.get(po.size() - 1) instanceof COSInteger) {
                    COSInteger genNumber = (COSInteger)po.remove(po.size() - 1);
                    if (po.get(po.size() - 1) instanceof COSInteger) {
                        COSInteger number = (COSInteger)po.remove(po.size() - 1);
                        COSObjectKey key = new COSObjectKey(number.longValue(), genNumber.intValue());
                        pbo = this.getObjectFromPool(key);
                    } else {
                        pbo = null;
                    }
                } else {
                    pbo = null;
                }
            }
            if (pbo != null) {
                po.add(pbo);
            } else {
                LOG.debug("Corrupt object reference at offset " + this.pdfSource.getPosition());
                String isThisTheEnd = this.readString();
                this.pdfSource.rewind(isThisTheEnd.getBytes(Charsets.ISO_8859_1).length);
                if (ENDOBJ_STRING.equals(isThisTheEnd) || ENDSTREAM_STRING.equals(isThisTheEnd)) {
                    return po;
                }
            }
            this.skipSpaces();
        }
        this.pdfSource.read();
        this.skipSpaces();
        return po;
    }

    protected boolean isEndOfName(int ch) {
        return ch == 32 || ch == 13 || ch == 10 || ch == 9 || ch == 62 || ch == 60 || ch == 91 || ch == 47 || ch == 93 || ch == 41 || ch == 40;
    }

    protected COSName parseCOSName() throws IOException {
        this.readExpectedChar('/');
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        int c = this.pdfSource.read();
        while (c != -1) {
            int ch = c;
            if (ch == 35) {
                char ch1 = (char)this.pdfSource.read();
                char ch2 = (char)this.pdfSource.read();
                if (BaseParser.isHexDigit(ch1) && BaseParser.isHexDigit(ch2)) {
                    String hex = "" + ch1 + ch2;
                    try {
                        buffer.write(Integer.parseInt(hex, 16));
                    }
                    catch (NumberFormatException e) {
                        throw new IOException("Error: expected hex digit, actual='" + hex + "'", e);
                    }
                    c = this.pdfSource.read();
                    continue;
                }
                this.pdfSource.rewind(1);
                c = ch1;
                buffer.write(ch);
                continue;
            }
            if (this.isEndOfName(ch)) break;
            buffer.write(ch);
            c = this.pdfSource.read();
        }
        if (c != -1) {
            this.pdfSource.rewind(1);
        }
        String string = new String(buffer.toByteArray());
        return COSName.getPDFName(string);
    }

    protected COSBoolean parseBoolean() throws IOException {
        COSBoolean retval = null;
        char c = (char)this.pdfSource.peek();
        if (c == 't') {
            String trueString = new String(this.pdfSource.readFully(4), Charsets.ISO_8859_1);
            if (!trueString.equals(TRUE)) {
                throw new IOException("Error parsing boolean: expected='true' actual='" + trueString + "' at offset " + this.pdfSource.getPosition());
            }
            retval = COSBoolean.TRUE;
        } else if (c == 'f') {
            String falseString = new String(this.pdfSource.readFully(5), Charsets.ISO_8859_1);
            if (!falseString.equals(FALSE)) {
                throw new IOException("Error parsing boolean: expected='true' actual='" + falseString + "' at offset " + this.pdfSource.getPosition());
            }
            retval = COSBoolean.FALSE;
        } else {
            throw new IOException("Error parsing boolean expected='t or f' actual='" + c + "' at offset " + this.pdfSource.getPosition());
        }
        return retval;
    }

    protected COSBase parseDirObject() throws IOException {
        COSBase retval = null;
        this.skipSpaces();
        int nextByte = this.pdfSource.peek();
        char c = (char)nextByte;
        switch (c) {
            case '<': {
                int leftBracket = this.pdfSource.read();
                c = (char)this.pdfSource.peek();
                this.pdfSource.rewind(1);
                if (c == '<') {
                    retval = this.parseCOSDictionary();
                    this.skipSpaces();
                    break;
                }
                retval = this.parseCOSString();
                break;
            }
            case '[': {
                retval = this.parseCOSArray();
                break;
            }
            case '(': {
                retval = this.parseCOSString();
                break;
            }
            case '/': {
                retval = this.parseCOSName();
                break;
            }
            case 'n': {
                this.readExpectedString(NULL);
                retval = COSNull.NULL;
                break;
            }
            case 't': {
                String trueString = new String(this.pdfSource.readFully(4), Charsets.ISO_8859_1);
                if (trueString.equals(TRUE)) {
                    retval = COSBoolean.TRUE;
                    break;
                }
                throw new IOException("expected true actual='" + trueString + "' " + this.pdfSource + "' at offset " + this.pdfSource.getPosition());
            }
            case 'f': {
                String falseString = new String(this.pdfSource.readFully(5), Charsets.ISO_8859_1);
                if (falseString.equals(FALSE)) {
                    retval = COSBoolean.FALSE;
                    break;
                }
                throw new IOException("expected false actual='" + falseString + "' " + this.pdfSource + "' at offset " + this.pdfSource.getPosition());
            }
            case 'R': {
                this.pdfSource.read();
                retval = new COSObject(null);
                break;
            }
            case '\uffff': {
                return null;
            }
            default: {
                if (Character.isDigit(c) || c == '-' || c == '+' || c == '.') {
                    StringBuilder buf = new StringBuilder();
                    int ic = this.pdfSource.read();
                    c = (char)ic;
                    while (Character.isDigit(c) || c == '-' || c == '+' || c == '.' || c == 'E' || c == 'e') {
                        buf.append(c);
                        ic = this.pdfSource.read();
                        c = (char)ic;
                    }
                    if (ic != -1) {
                        this.pdfSource.rewind(1);
                    }
                    retval = COSNumber.get(buf.toString());
                    break;
                }
                String badString = this.readString();
                if (badString == null || badString.length() == 0) {
                    int peek = this.pdfSource.peek();
                    throw new IOException("Unknown dir object c='" + c + "' cInt=" + c + " peek='" + (char)peek + "' peekInt=" + peek + " " + this.pdfSource.getPosition());
                }
                if (!ENDOBJ_STRING.equals(badString) && !ENDSTREAM_STRING.equals(badString)) break;
                this.pdfSource.rewind(badString.getBytes(Charsets.ISO_8859_1).length);
            }
        }
        return retval;
    }

    protected String readString() throws IOException {
        this.skipSpaces();
        StringBuilder buffer = new StringBuilder();
        int c = this.pdfSource.read();
        while (!this.isEndOfName((char)c) && c != -1) {
            buffer.append((char)c);
            c = this.pdfSource.read();
        }
        if (c != -1) {
            this.pdfSource.rewind(1);
        }
        return buffer.toString();
    }

    protected void readExpectedString(String expectedString) throws IOException {
        this.readExpectedString(expectedString.toCharArray(), false);
    }

    protected final void readExpectedString(char[] expectedString, boolean skipSpaces) throws IOException {
        if (skipSpaces) {
            this.skipSpaces();
        }
        for (char c : expectedString) {
            if (this.pdfSource.read() == c) continue;
            throw new IOException("Expected string '" + new String(expectedString) + "' but missed at character '" + c + "' at offset " + this.pdfSource.getPosition());
        }
        if (skipSpaces) {
            this.skipSpaces();
        }
    }

    protected void readExpectedChar(char ec) throws IOException {
        char c = (char)this.pdfSource.read();
        if (c != ec) {
            throw new IOException("expected='" + ec + "' actual='" + c + "' at offset " + this.pdfSource.getPosition());
        }
    }

    protected String readString(int length) throws IOException {
        this.skipSpaces();
        int c = this.pdfSource.read();
        StringBuilder buffer = new StringBuilder(length);
        while (!this.isWhitespace(c) && !this.isClosing(c) && c != -1 && buffer.length() < length && c != 91 && c != 60 && c != 40 && c != 47) {
            buffer.append((char)c);
            c = this.pdfSource.read();
        }
        if (c != -1) {
            this.pdfSource.rewind(1);
        }
        return buffer.toString();
    }

    protected boolean isClosing() throws IOException {
        return this.isClosing(this.pdfSource.peek());
    }

    protected boolean isClosing(int c) {
        return c == 93;
    }

    protected String readLine() throws IOException {
        int c;
        if (this.pdfSource.isEOF()) {
            throw new IOException("Error: End-of-File, expected line");
        }
        StringBuilder buffer = new StringBuilder(11);
        while ((c = this.pdfSource.read()) != -1 && !this.isEOL(c)) {
            buffer.append((char)c);
        }
        if (this.isCR(c) && this.isLF(this.pdfSource.peek())) {
            this.pdfSource.read();
        }
        return buffer.toString();
    }

    protected String readLineWithoutWhitespacesSkip() throws IOException {
        int c;
        if (this.pdfSource.isEOF()) {
            throw new IOException("Error: End-of-File, expected line");
        }
        StringBuilder buffer = new StringBuilder(11);
        while ((c = this.pdfSource.read()) != -1) {
            if (this.isEOL(c) || c == 32) {
                this.pdfSource.rewind(1);
                break;
            }
            buffer.append((char)c);
        }
        return buffer.toString();
    }

    protected boolean isEOL() throws IOException {
        return this.isEOL(this.pdfSource.peek());
    }

    protected boolean isEOL(int c) {
        return this.isLF(c) || this.isCR(c);
    }

    private boolean isLF(int c) {
        return 10 == c;
    }

    private boolean isCR(int c) {
        return 13 == c;
    }

    protected boolean isWhitespace() throws IOException {
        return this.isWhitespace(this.pdfSource.peek());
    }

    protected boolean isWhitespace(int c) {
        return c == 0 || c == 9 || c == 12 || c == 10 || c == 13 || c == 32;
    }

    protected boolean isSpace() throws IOException {
        return this.isSpace(this.pdfSource.peek());
    }

    protected boolean isSpace(int c) {
        return 32 == c;
    }

    protected boolean isDigit() throws IOException {
        return BaseParser.isDigit(this.pdfSource.peek());
    }

    protected static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    protected int skipSpaces() throws IOException {
        int c = this.pdfSource.read();
        int count = 1;
        while (this.isWhitespace(c) || c == 37) {
            if (c == 37) {
                c = this.pdfSource.read();
                while (!this.isEOL(c) && c != -1) {
                    c = this.pdfSource.read();
                    ++count;
                }
            } else {
                c = this.pdfSource.read();
            }
            ++count;
        }
        if (c != -1) {
            this.pdfSource.rewind(1);
            --count;
        }
        return count;
    }

    protected long readObjectNumber() throws IOException {
        long retval = this.readLong();
        if (retval < 0L || retval >= 10000000000L) {
            throw new IOException("Object Number '" + retval + "' has more than 10 digits or is negative");
        }
        return retval;
    }

    protected int readGenerationNumber() throws IOException {
        int retval = this.readInt();
        if (retval < 0 || (long)retval > 65535L) {
            throw new IOException("Generation Number '" + retval + "' has more than 5 digits");
        }
        return retval;
    }

    protected int readInt() throws IOException {
        this.skipSpaces();
        int retval = 0;
        StringBuilder intBuffer = this.readStringNumber();
        try {
            retval = Integer.parseInt(intBuffer.toString());
        }
        catch (NumberFormatException e) {
            this.pdfSource.rewind(intBuffer.toString().getBytes(Charsets.ISO_8859_1).length);
            throw new IOException("Error: Expected an integer type at offset " + this.pdfSource.getPosition(), e);
        }
        return retval;
    }

    protected long readLong() throws IOException {
        this.skipSpaces();
        long retval = 0L;
        StringBuilder longBuffer = this.readStringNumber();
        try {
            retval = Long.parseLong(longBuffer.toString());
        }
        catch (NumberFormatException e) {
            this.pdfSource.rewind(longBuffer.toString().getBytes(Charsets.ISO_8859_1).length);
            throw new IOException("Error: Expected a long type at offset " + this.pdfSource.getPosition() + ", instead got '" + longBuffer + "'", e);
        }
        return retval;
    }

    protected final StringBuilder readStringNumber() throws IOException {
        int lastByte = 0;
        StringBuilder buffer = new StringBuilder();
        while ((lastByte = this.pdfSource.read()) != 32 && lastByte != 10 && lastByte != 13 && lastByte != 60 && lastByte != 91 && lastByte != 40 && lastByte != 0 && lastByte != -1) {
            buffer.append((char)lastByte);
        }
        if (lastByte != -1) {
            this.pdfSource.rewind(1);
        }
        return buffer;
    }
}

