/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.FontBoxFont;
import org.apache.fontbox.cff.CFFCIDFont;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.ttf.NamingTable;
import org.apache.fontbox.ttf.OTFParser;
import org.apache.fontbox.ttf.OpenTypeFont;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeCollection;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.type1.Type1Font;
import org.apache.fontbox.util.autodetect.FontFileFinder;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.font.FontCache;
import org.apache.pdfbox.pdmodel.font.FontFormat;
import org.apache.pdfbox.pdmodel.font.FontInfo;
import org.apache.pdfbox.pdmodel.font.FontProvider;
import org.apache.pdfbox.pdmodel.font.PDCIDSystemInfo;

final class FileSystemFontProvider
extends FontProvider {
    private static final Log LOG = LogFactory.getLog(FileSystemFontProvider.class);
    private final List<FSFontInfo> fontInfoList = new ArrayList<FSFontInfo>();
    private final FontCache cache;

    FileSystemFontProvider(FontCache cache) {
        this.cache = cache;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Will search the local system for fonts");
        }
        ArrayList<File> files = new ArrayList<File>();
        FontFileFinder fontFileFinder = new FontFileFinder();
        List<URI> fonts = fontFileFinder.find();
        for (URI font : fonts) {
            files.add(new File(font));
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Found " + files.size() + " fonts on the local system");
        }
        for (File file : files) {
            try {
                if (file.getPath().toLowerCase().endsWith(".ttf") || file.getPath().toLowerCase().endsWith(".otf")) {
                    this.addTrueTypeFont(file);
                    continue;
                }
                if (file.getPath().toLowerCase().endsWith(".ttc") || file.getPath().toLowerCase().endsWith(".otc")) {
                    this.addTrueTypeCollection(file);
                    continue;
                }
                if (!file.getPath().toLowerCase().endsWith(".pfb")) continue;
                this.addType1Font(file);
            }
            catch (IOException e) {
                LOG.error("Error parsing font " + file.getPath(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTrueTypeCollection(File ttcFile) throws IOException {
        TrueTypeCollection ttc = null;
        try {
            ttc = new TrueTypeCollection(ttcFile);
            for (TrueTypeFont ttf : ttc.getFonts()) {
                this.addTrueTypeFontImpl(ttf, ttcFile);
            }
        }
        catch (NullPointerException e) {
            LOG.error("Could not load font file: " + ttcFile, e);
        }
        catch (IOException e) {
            LOG.error("Could not load font file: " + ttcFile, e);
        }
        finally {
            if (ttc != null) {
                ttc.close();
            }
        }
    }

    private void addTrueTypeFont(File ttfFile) throws IOException {
        try {
            if (ttfFile.getPath().endsWith(".otf")) {
                OTFParser parser = new OTFParser(false, true);
                OpenTypeFont otf = parser.parse(ttfFile);
                this.addTrueTypeFontImpl(otf, ttfFile);
            } else {
                TTFParser parser = new TTFParser(false, true);
                TrueTypeFont ttf = parser.parse(ttfFile);
                this.addTrueTypeFontImpl(ttf, ttfFile);
            }
        }
        catch (NullPointerException e) {
            LOG.error("Could not load font file: " + ttfFile, e);
        }
        catch (IOException e) {
            LOG.error("Could not load font file: " + ttfFile, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTrueTypeFontImpl(TrueTypeFont ttf, File file) throws IOException {
        try {
            NamingTable nameTable = null;
            if (ttf != null) {
                nameTable = ttf.getNaming();
            }
            if (nameTable == null) {
                LOG.debug("Missing 'name' table in font " + file);
            } else if (ttf.getName() != null) {
                String format;
                if (ttf instanceof OpenTypeFont && ((OpenTypeFont)ttf).isPostScript()) {
                    format = "OTF";
                    CFFFont cff = ((OpenTypeFont)ttf).getCFF().getFont();
                    PDCIDSystemInfo ros = null;
                    if (cff instanceof CFFCIDFont) {
                        CFFCIDFont cidFont = (CFFCIDFont)cff;
                        String registry = cidFont.getRegistry();
                        String ordering = cidFont.getOrdering();
                        int supplement = cidFont.getSupplement();
                        ros = new PDCIDSystemInfo(registry, ordering, supplement);
                    }
                    this.fontInfoList.add(new FSFontInfo(file, FontFormat.OTF, ttf.getName(), ros));
                } else {
                    format = "TTF";
                    this.fontInfoList.add(new FSFontInfo(file, FontFormat.TTF, ttf.getName(), null));
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace(format + ": '" + ttf.getName() + "' / '" + nameTable.getFontFamily() + "' / '" + nameTable.getFontSubFamily() + "'");
                }
            } else {
                LOG.debug("Missing 'name' entry for PostScript name in font " + file);
            }
        }
        catch (IOException e) {
            LOG.error("Could not load font file: " + file, e);
        }
        finally {
            if (ttf != null) {
                ttf.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addType1Font(File pfbFile) throws IOException {
        FileInputStream input = new FileInputStream(pfbFile);
        try {
            Type1Font type1 = Type1Font.createWithPFB(input);
            this.fontInfoList.add(new FSFontInfo(pfbFile, FontFormat.PFB, type1.getName(), null));
            if (LOG.isTraceEnabled()) {
                LOG.trace("PFB: '" + type1.getName() + "' / '" + type1.getFamilyName() + "' / '" + type1.getWeight() + "'");
            }
        }
        catch (IOException e) {
            LOG.error("Could not load font file: " + pfbFile, e);
        }
        finally {
            ((InputStream)input).close();
        }
    }

    private TrueTypeFont getTrueTypeFont(String postScriptName, File file) {
        try {
            TrueTypeFont ttf = this.readTrueTypeFont(postScriptName, file);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loaded " + postScriptName + " from " + file);
            }
            return ttf;
        }
        catch (NullPointerException e) {
            LOG.error("Could not load font file: " + file, e);
        }
        catch (IOException e) {
            LOG.error("Could not load font file: " + file, e);
        }
        return null;
    }

    private TrueTypeFont readTrueTypeFont(String postScriptName, File file) throws IOException {
        if (file.getName().toLowerCase().endsWith(".ttc")) {
            TrueTypeCollection ttc = new TrueTypeCollection(file);
            for (TrueTypeFont ttf : ttc.getFonts()) {
                if (!ttf.getName().equals(postScriptName)) continue;
                return ttf;
            }
            throw new IOException("Font " + postScriptName + " not found in " + file);
        }
        TTFParser ttfParser = new TTFParser(false, true);
        return ttfParser.parse(file);
    }

    private OpenTypeFont getOTFFont(String postScriptName, File file) {
        try {
            if (file.getName().toLowerCase().endsWith(".ttc")) {
                TrueTypeCollection ttc = new TrueTypeCollection(file);
                for (TrueTypeFont otf : ttc.getFonts()) {
                    if (!otf.getName().equals(postScriptName)) continue;
                    return (OpenTypeFont)otf;
                }
                throw new IOException("Font " + postScriptName + " not found in " + file);
            }
            OTFParser parser = new OTFParser(false, true);
            OpenTypeFont otf = parser.parse(file);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loaded " + postScriptName + " from " + file);
            }
            return otf;
        }
        catch (IOException e) {
            LOG.error("Could not load font file: " + file, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Type1Font getType1Font(String postScriptName, File file) {
        Type1Font type1Font;
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            Type1Font type1 = Type1Font.createWithPFB(input);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loaded " + postScriptName + " from " + file);
            }
            type1Font = type1;
        }
        catch (IOException e) {
            try {
                LOG.error("Could not load font file: " + file, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                throw throwable;
            }
            IOUtils.closeQuietly(input);
            return null;
        }
        IOUtils.closeQuietly(input);
        return type1Font;
    }

    @Override
    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        for (FSFontInfo info : this.fontInfoList) {
            sb.append((Object)info.getFormat());
            sb.append(": ");
            sb.append(info.getPostScriptName());
            sb.append(": ");
            sb.append(info.file.getPath());
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public List<? extends FontInfo> getFontInfo() {
        return this.fontInfoList;
    }

    private class FSFontInfo
    extends FontInfo {
        private final String postScriptName;
        private final FontFormat format;
        private final PDCIDSystemInfo cidSystemInfo;
        private final File file;

        private FSFontInfo(File file, FontFormat format, String postScriptName, PDCIDSystemInfo cidSystemInfo) {
            this.file = file;
            this.format = format;
            this.postScriptName = postScriptName;
            this.cidSystemInfo = cidSystemInfo;
        }

        @Override
        public String getPostScriptName() {
            return this.postScriptName;
        }

        @Override
        public FontFormat getFormat() {
            return this.format;
        }

        @Override
        public PDCIDSystemInfo getCIDSystemInfo() {
            return this.cidSystemInfo;
        }

        @Override
        public FontBoxFont getFont() {
            FontBoxFont font;
            FontBoxFont cached = FileSystemFontProvider.this.cache.getFont(this);
            if (cached != null) {
                return cached;
            }
            switch (this.format) {
                case PFB: {
                    font = FileSystemFontProvider.this.getType1Font(this.postScriptName, this.file);
                    break;
                }
                case TTF: {
                    font = FileSystemFontProvider.this.getTrueTypeFont(this.postScriptName, this.file);
                    break;
                }
                case OTF: {
                    font = FileSystemFontProvider.this.getOTFFont(this.postScriptName, this.file);
                    break;
                }
                default: {
                    throw new RuntimeException("can't happen");
                }
            }
            FileSystemFontProvider.this.cache.addFont(this, font);
            return font;
        }

        @Override
        public String toString() {
            return super.toString() + " " + this.file;
        }
    }
}

