/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.pattern;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.contentstream.PDContentStream;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;

public class PDTilingPattern
extends PDAbstractPattern
implements PDContentStream {
    private static final Log LOG = LogFactory.getLog(PDTilingPattern.class);
    public static final int PAINT_COLORED = 1;
    public static final int PAINT_UNCOLORED = 2;
    public static final int TILING_CONSTANT_SPACING = 1;
    public static final int TILING_NO_DISTORTION = 2;
    public static final int TILING_CONSTANT_SPACING_FASTER_TILING = 3;

    public PDTilingPattern() {
        this.getCOSObject().setInt(COSName.PATTERN_TYPE, 1);
    }

    public PDTilingPattern(COSDictionary resourceDictionary) {
        super(resourceDictionary);
    }

    @Override
    public int getPatternType() {
        return 1;
    }

    @Override
    public void setLength(int length) {
        this.getCOSObject().setInt(COSName.LENGTH, length);
    }

    @Override
    public int getLength() {
        return this.getCOSObject().getInt(COSName.LENGTH, 0);
    }

    @Override
    public void setPaintType(int paintType) {
        this.getCOSObject().setInt(COSName.PAINT_TYPE, paintType);
    }

    public int getPaintType() {
        return this.getCOSObject().getInt(COSName.PAINT_TYPE, 0);
    }

    public void setTilingType(int tilingType) {
        this.getCOSObject().setInt(COSName.TILING_TYPE, tilingType);
    }

    public int getTilingType() {
        return this.getCOSObject().getInt(COSName.TILING_TYPE, 0);
    }

    public void setXStep(float xStep) {
        this.getCOSObject().setFloat(COSName.X_STEP, xStep);
    }

    public float getXStep() {
        float xStep = this.getCOSObject().getFloat(COSName.X_STEP, 0.0f);
        return xStep == 32767.0f ? 0.0f : xStep;
    }

    public void setYStep(float yStep) {
        this.getCOSObject().setFloat(COSName.Y_STEP, yStep);
    }

    public float getYStep() {
        float yStep = this.getCOSObject().getFloat(COSName.Y_STEP, 0.0f);
        return yStep == 32767.0f ? 0.0f : yStep;
    }

    @Override
    public COSStream getContentStream() {
        COSDictionary dict = this.getCOSObject();
        if (dict instanceof COSStream) {
            return (COSStream)this.getCOSObject();
        }
        LOG.debug("Invalid Tiling Pattern object type. Assuming the pattern has no content.");
        return null;
    }

    @Override
    public PDResources getResources() {
        PDResources retval = null;
        COSDictionary resources = (COSDictionary)this.getCOSObject().getDictionaryObject(COSName.RESOURCES);
        if (resources != null) {
            retval = new PDResources(resources);
        }
        return retval;
    }

    public void setResources(PDResources resources) {
        this.getCOSObject().setItem(COSName.RESOURCES, (COSObjectable)resources);
    }

    @Override
    public PDRectangle getBBox() {
        PDRectangle retval = null;
        COSArray array = (COSArray)this.getCOSObject().getDictionaryObject(COSName.BBOX);
        if (array != null) {
            retval = new PDRectangle(array);
        }
        return retval;
    }

    public void setBBox(PDRectangle bbox) {
        if (bbox == null) {
            this.getCOSObject().removeItem(COSName.BBOX);
        } else {
            this.getCOSObject().setItem(COSName.BBOX, (COSBase)bbox.getCOSArray());
        }
    }
}

