/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdfwriter.ContentStreamWriter;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.interactive.action.PDFormFieldAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceEntry;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.form.AppearanceStyle;
import org.apache.pdfbox.pdmodel.interactive.form.PDAppearanceString;
import org.apache.pdfbox.pdmodel.interactive.form.PDTextField;
import org.apache.pdfbox.pdmodel.interactive.form.PDVariableText;
import org.apache.pdfbox.pdmodel.interactive.form.PlainText;
import org.apache.pdfbox.pdmodel.interactive.form.PlainTextFormatter;

class AppearanceGeneratorHelper {
    private static final Operator BMC = Operator.getOperator("BMC");
    private static final Operator EMC = Operator.getOperator("EMC");
    private final PDVariableText field;
    private final PDAppearanceString defaultAppearance;
    private String value;

    AppearanceGeneratorHelper(PDVariableText field) throws IOException {
        this.field = field;
        this.defaultAppearance = field.getDefaultAppearanceString();
    }

    public void setAppearanceValue(String apValue) throws IOException {
        this.value = apValue;
        for (PDAnnotationWidget widget : this.field.getWidgets()) {
            PDAppearanceStream appearanceStream;
            PDAppearanceEntry appearance;
            PDFormFieldAdditionalActions actions = this.field.getActions();
            if (actions != null && actions.getF() != null && widget.getCOSObject().getDictionaryObject(COSName.AP) == null) continue;
            PDAppearanceDictionary appearanceDict = widget.getAppearance();
            if (appearanceDict == null) {
                appearanceDict = new PDAppearanceDictionary();
                widget.setAppearance(appearanceDict);
            }
            if ((appearance = appearanceDict.getNormalAppearance()).isStream()) {
                appearanceStream = appearance.getAppearanceStream();
            } else {
                appearanceStream = new PDAppearanceStream(this.field.getAcroForm().getDocument());
                appearanceStream.setBBox(widget.getRectangle().createRetranslatedRectangle());
                appearanceDict.setNormalAppearance(appearanceStream);
            }
            this.setAppearanceContent(widget, appearanceStream);
        }
    }

    private List<Object> tokenize(PDAppearanceStream appearanceStream) throws IOException {
        COSStream stream = appearanceStream.getCOSStream();
        PDFStreamParser parser = new PDFStreamParser(stream);
        parser.parse();
        return parser.getTokens();
    }

    private void setAppearanceContent(PDAnnotationWidget widget, PDAppearanceStream appearanceStream) throws IOException {
        this.defaultAppearance.copyNeededResourcesTo(appearanceStream);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ContentStreamWriter writer = new ContentStreamWriter(output);
        List<Object> tokens = this.tokenize(appearanceStream);
        int bmcIndex = tokens.indexOf(Operator.getOperator("BMC"));
        if (bmcIndex == -1) {
            writer.writeTokens(tokens);
            writer.writeTokens(COSName.TX, BMC);
        } else {
            writer.writeTokens(tokens.subList(0, bmcIndex + 1));
        }
        this.insertGeneratedAppearance(widget, appearanceStream, output);
        int emcIndex = tokens.indexOf(Operator.getOperator("EMC"));
        if (emcIndex == -1) {
            writer.writeTokens(EMC);
        } else {
            writer.writeTokens(tokens.subList(emcIndex, tokens.size()));
        }
        output.close();
        this.writeToStream(output.toByteArray(), appearanceStream);
    }

    private void insertGeneratedAppearance(PDAnnotationWidget widget, PDAppearanceStream appearanceStream, OutputStream output) throws IOException {
        float y;
        PDPageContentStream contents = new PDPageContentStream(this.field.getAcroForm().getDocument(), appearanceStream, output);
        float borderWidth = 0.0f;
        if (widget.getBorderStyle() != null) {
            borderWidth = widget.getBorderStyle().getWidth();
        }
        PDRectangle bbox = this.resolveBoundingBox(widget, appearanceStream);
        PDRectangle clipRect = this.applyPadding(bbox, Math.max(1.0f, borderWidth));
        PDRectangle contentRect = this.applyPadding(clipRect, Math.max(1.0f, borderWidth));
        contents.saveGraphicsState();
        if (borderWidth > 0.0f) {
            contents.addRect(clipRect.getLowerLeftX(), clipRect.getLowerLeftY(), clipRect.getWidth(), clipRect.getHeight());
            contents.clip();
        }
        contents.beginText();
        PDFont font = this.field.getDefaultAppearanceString().getFont();
        float fontSize = this.calculateFontSize(font, contentRect);
        this.field.getDefaultAppearanceString().writeTo(contents, fontSize);
        if (this.field instanceof PDTextField && ((PDTextField)this.field).isMultiline()) {
            float height = font.getBoundingBox().getHeight() / 1000.0f * fontSize;
            y = contentRect.getUpperRightY() - height;
        } else {
            float minY = font.getBoundingBox().getLowerLeftY() / 1000.0f * fontSize;
            y = Math.max(bbox.getHeight() / 2.0f + minY, 0.0f);
        }
        float x = contentRect.getLowerLeftX();
        PlainText textContent = new PlainText(this.value);
        AppearanceStyle appearanceStyle = new AppearanceStyle();
        appearanceStyle.setFont(font);
        appearanceStyle.setFontSize(fontSize);
        appearanceStyle.setLeading(font.getBoundingBox().getHeight() / 1000.0f * fontSize);
        PlainTextFormatter formatter = new PlainTextFormatter.Builder(contents).style(appearanceStyle).text(textContent).width(contentRect.getWidth()).wrapLines(true).initialOffset(x, y).textAlign(this.field.getQ()).build();
        formatter.format();
        contents.endText();
        contents.restoreGraphicsState();
        contents.close();
    }

    private boolean isMultiLine() {
        return this.field instanceof PDTextField && ((PDTextField)this.field).isMultiline();
    }

    private void writeToStream(byte[] data, PDAppearanceStream appearanceStream) throws IOException {
        OutputStream out = appearanceStream.getCOSStream().createUnfilteredStream();
        out.write(data);
        out.flush();
    }

    private float calculateFontSize(PDFont font, PDRectangle contentRect) throws IOException {
        float fontSize = this.defaultAppearance.getFontSize();
        if (fontSize == 0.0f) {
            if (this.isMultiLine()) {
                return 12.0f;
            }
            float width = font.getStringWidth(this.value) / 1000.0f;
            float widthBasedFontSize = contentRect.getWidth() / width;
            float height = (font.getFontDescriptor().getAscent() + -font.getFontDescriptor().getDescent()) / 1000.0f;
            if (height <= 0.0f) {
                height = font.getBoundingBox().getHeight() / 1000.0f;
            }
            float heightBasedFontSize = contentRect.getHeight() / height;
            return Math.min(heightBasedFontSize, widthBasedFontSize);
        }
        return fontSize;
    }

    private PDRectangle resolveBoundingBox(PDAnnotationWidget fieldWidget, PDAppearanceStream appearanceStream) {
        PDRectangle boundingBox = appearanceStream.getBBox();
        if (boundingBox == null) {
            boundingBox = fieldWidget.getRectangle().createRetranslatedRectangle();
        }
        return boundingBox;
    }

    private PDRectangle applyPadding(PDRectangle box, float padding) {
        return new PDRectangle(box.getLowerLeftX() + padding, box.getLowerLeftY() + padding, box.getWidth() - 2.0f * padding, box.getHeight() - 2.0f * padding);
    }
}

