/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.external;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.verapdf.model.external.ICCProfile;
import org.verapdf.model.impl.pb.external.PBoxExternal;

public class PBoxICCProfile
extends PBoxExternal
implements ICCProfile {
    private static final Logger LOGGER = Logger.getLogger(PBoxICCProfile.class.getCanonicalName());
    public static final int HEADER_LENGTH = 128;
    public static final int DEVICE_CLASS_OFFSET = 12;
    public static final int COLOR_SPACE_OFFSET = 16;
    public static final int REQUIRED_LENGTH = 4;
    public static final int VERSION_LENGTH = 3;
    public static final int VERSION_BYTE = 8;
    public static final int SUBVERSION_BYTE = 9;
    private byte[] profileHeader;
    private InputStream profileStream;
    private Long dictionaryNumberOfColors;
    private boolean isValid;

    protected PBoxICCProfile(COSStream profileStream, String type) {
        block3: {
            super(type);
            this.isValid = true;
            try {
                this.profileStream = profileStream.getUnfilteredStream();
                this.dictionaryNumberOfColors = profileStream.getLong(COSName.N);
                if (this.dictionaryNumberOfColors == -1L) {
                    this.dictionaryNumberOfColors = null;
                }
                this.initializeProfileHeader();
            }
            catch (IOException e) {
                this.isValid = false;
                if (this.profileHeader != null) break block3;
                this.profileHeader = new byte[0];
            }
        }
    }

    private void initializeProfileHeader() throws IOException {
        int size;
        int available = this.profileStream.available();
        int n = size = available > 128 ? 128 : available;
        if (size != 128) {
            this.isValid = false;
        }
        this.profileHeader = new byte[size];
        this.profileStream.mark(size);
        this.profileStream.read(this.profileHeader, 0, size);
        this.profileStream.reset();
        this.profileStream.close();
    }

    @Override
    public String getdeviceClass() {
        return this.getSubArray(12, 4);
    }

    @Override
    public Long getN() {
        return this.dictionaryNumberOfColors;
    }

    @Override
    public String getcolorSpace() {
        return this.getSubArray(16, 4);
    }

    private String getSubArray(int start, int length) {
        if (start + length <= this.profileHeader.length) {
            byte[] buffer = new byte[length];
            System.arraycopy(this.profileHeader, start, buffer, 0, length);
            return new String(buffer);
        }
        LOGGER.log(Level.INFO, "Length of icc profile less than " + (start + length));
        return null;
    }

    @Override
    public Double getversion() {
        if (this.profileHeader.length > 9) {
            StringBuilder version = new StringBuilder(3);
            version.append(this.profileHeader[8] & 0xFF).append('.');
            version.append(this.profileHeader[9] >>> 4 & 0xFF);
            return Double.valueOf(version.toString());
        }
        LOGGER.log(Level.INFO, "ICC profile contain less than 10 bytes of data.");
        return null;
    }

    @Override
    public Boolean getisValid() {
        return this.isValid;
    }
}

