/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.tools.transparency;

import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.font.encoding.Encoding;
import org.verapdf.model.factory.operator.GraphicState;
import org.verapdf.model.impl.pb.pd.PBoxPDContentStream;
import org.verapdf.model.impl.pb.pd.colors.PBoxPDColorSpace;
import org.verapdf.model.impl.pb.pd.font.PBoxPDFont;
import org.verapdf.model.impl.pb.pd.font.PBoxPDType3Font;
import org.verapdf.model.impl.pb.pd.images.PBoxPDXForm;
import org.verapdf.model.impl.pb.pd.images.PBoxPDXImage;
import org.verapdf.model.impl.pb.pd.images.PBoxPDXObject;
import org.verapdf.model.impl.pb.pd.pattern.PBoxPDTilingPattern;
import org.verapdf.model.pdlayer.PDContentStream;

public class TransparencyBehaviour {
    private boolean isFillCheck = false;
    private boolean isStrokeCheck = false;
    private boolean isXObjectCheck = false;
    private boolean isColorSpaceCheck = false;
    private boolean isFontCheck = false;

    private TransparencyBehaviour() {
    }

    public static TransparencyBehaviour createFillInstance() {
        TransparencyBehaviour tb = new TransparencyBehaviour();
        tb.isFillCheck = true;
        return tb;
    }

    public static TransparencyBehaviour createFillXObjectInstance() {
        TransparencyBehaviour tb = TransparencyBehaviour.createFillInstance();
        tb.isXObjectCheck = true;
        return tb;
    }

    public static TransparencyBehaviour createFillColorSpaceInstance() {
        TransparencyBehaviour tb = TransparencyBehaviour.createFillInstance();
        tb.isColorSpaceCheck = true;
        return tb;
    }

    public static TransparencyBehaviour createFillColorSpaceFontInstance() {
        TransparencyBehaviour tb = TransparencyBehaviour.createFillColorSpaceInstance();
        tb.isFontCheck = true;
        return tb;
    }

    public static TransparencyBehaviour createStrokeColorSpaceInstance() {
        TransparencyBehaviour tb = new TransparencyBehaviour();
        tb.isStrokeCheck = true;
        tb.isColorSpaceCheck = true;
        return tb;
    }

    public static TransparencyBehaviour createStrokeColorSpaceFontInstance() {
        TransparencyBehaviour tb = TransparencyBehaviour.createStrokeColorSpaceInstance();
        tb.isFontCheck = true;
        return tb;
    }

    public static TransparencyBehaviour createFillStrokeColorSpaceInstance() {
        TransparencyBehaviour tb = new TransparencyBehaviour();
        tb.isFillCheck = true;
        tb.isStrokeCheck = true;
        tb.isColorSpaceCheck = true;
        return tb;
    }

    public static TransparencyBehaviour createFillStrokeColorSpaceFontInstance() {
        TransparencyBehaviour tb = TransparencyBehaviour.createFillStrokeColorSpaceInstance();
        tb.isFontCheck = true;
        return tb;
    }

    public boolean containsTransparency(GraphicState graphicState) {
        if (TransparencyBehaviour.baseCheck(graphicState)) {
            return true;
        }
        if (this.isFillCheck && graphicState.getCa_ns() < 1.0f) {
            return true;
        }
        if (this.isStrokeCheck && graphicState.getCa() < 1.0f) {
            return true;
        }
        if (this.isXObjectCheck && TransparencyBehaviour.xObjectContainsTransparency(graphicState.getVeraXObject())) {
            return true;
        }
        if (this.isColorSpaceCheck && this.colorSpaceCheck(graphicState)) {
            return true;
        }
        return this.isFontCheck && TransparencyBehaviour.fontCheck(graphicState);
    }

    private static boolean fontCheck(GraphicState graphicState) {
        PBoxPDType3Font type3Font;
        Encoding encoding;
        PBoxPDFont font = graphicState.getVeraFont();
        if (font instanceof PBoxPDType3Font && (encoding = (type3Font = (PBoxPDType3Font)font).getEncodingObject()) != null) {
            boolean result = false;
            Map<String, PDContentStream> charProcStreams = type3Font.getCharProcStreams();
            for (byte glyphCode : graphicState.getCharCodes()) {
                String glyphName = encoding.getName(glyphCode);
                PBoxPDContentStream glyphStream = (PBoxPDContentStream)charProcStreams.get(glyphName);
                if (glyphStream == null) continue;
                result |= glyphStream.isContainsTransparency();
            }
            return result;
        }
        return false;
    }

    private boolean colorSpaceCheck(GraphicState graphicState) {
        PBoxPDColorSpace strokeCS;
        PBoxPDColorSpace fillCS;
        if (this.isFillCheck && (fillCS = graphicState.getVeraFillColorSpace()) instanceof PBoxPDTilingPattern && ((PBoxPDTilingPattern)fillCS).isContainsTransparency()) {
            return true;
        }
        return this.isStrokeCheck && (strokeCS = graphicState.getVeraStrokeColorSpace()) instanceof PBoxPDTilingPattern && ((PBoxPDTilingPattern)strokeCS).isContainsTransparency();
    }

    private static boolean baseCheck(GraphicState graphicState) {
        COSBase sMask = graphicState.getSMask();
        if (sMask instanceof COSDictionary) {
            return true;
        }
        COSBase bm = graphicState.getBm();
        if (bm instanceof COSName) {
            COSName bmName = (COSName)bm;
            if (!bmName.equals(COSName.getPDFName("Normal"))) {
                return true;
            }
        } else if (bm instanceof COSArray) {
            COSArray bmArray = (COSArray)bm;
            if (bmArray.size() != 1) {
                return true;
            }
            COSBase bmValue = bmArray.get(0);
            if (!(bmValue instanceof COSName) || !bmValue.equals(COSName.getPDFName("Normal"))) {
                return true;
            }
        } else if (bm != null) {
            return true;
        }
        return false;
    }

    private static boolean xObjectContainsTransparency(PBoxPDXObject xobj) {
        if (xobj instanceof PBoxPDXForm) {
            return ((PBoxPDXForm)xobj).containsTransparency();
        }
        if (xobj instanceof PBoxPDXImage) {
            return ((PBoxPDXImage)xobj).containsTransparency();
        }
        return false;
    }
}

