/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.flavours;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public enum PDFAFlavour {
    NO_FLAVOUR(Specification.NO_STANDARD, Level.NO_LEVEL),
    PDFA_1_A(Specification.ISO_19005_1, Level.A),
    PDFA_1_B(Specification.ISO_19005_1, Level.B),
    PDFA_2_A(Specification.ISO_19005_2, Level.A),
    PDFA_2_B(Specification.ISO_19005_2, Level.B),
    PDFA_2_U(Specification.ISO_19005_2, Level.U),
    PDFA_3_A(Specification.ISO_19005_3, Level.A),
    PDFA_3_B(Specification.ISO_19005_3, Level.B),
    PDFA_3_U(Specification.ISO_19005_3, Level.U),
    PDFA_4(Specification.ISO_19005_4, Level.NO_LEVEL),
    PDFA_4_F(Specification.ISO_19005_4, Level.F),
    PDFA_4_E(Specification.ISO_19005_4, Level.E),
    PDFUA_1(Specification.ISO_14289_1, Level.NO_LEVEL),
    WCAG2_1(Specification.WCAG_2_1, Level.NO_LEVEL);

    private static final Map<String, PDFAFlavour> FLAVOUR_LOOKUP;
    private final Specification part;
    private final Level level;
    private final String id;

    private PDFAFlavour(Specification standard, Level level) {
        this(PDFAFlavour.getPrefix(standard) + standard.getPartNumber() + level.getCode(), standard, level);
    }

    private PDFAFlavour(String id, Specification standard, Level level) {
        this.part = standard;
        this.level = level;
        this.id = id;
    }

    private static String getPrefix(Specification standard) {
        if ("PDF/UA".equals(standard.family)) {
            return "ua";
        }
        if ("WCAG".equals(standard.family)) {
            return "wcag";
        }
        return "";
    }

    public final Specification getPart() {
        return this.part;
    }

    public final Level getLevel() {
        return this.level;
    }

    public final String getId() {
        return this.id;
    }

    public final String toString() {
        return this.id;
    }

    public static PDFAFlavour byFlavourId(String flavourId) {
        PDFAFlavour flavour = FLAVOUR_LOOKUP.get(flavourId.toLowerCase());
        if (flavour == null) {
            flavour = NO_FLAVOUR;
        }
        return flavour;
    }

    public static PDFAFlavour fromString(String toParse) {
        for (String id : PDFAFlavour.getFlavourIds()) {
            if (!toParse.toLowerCase().contains(id)) continue;
            return PDFAFlavour.byFlavourId(id);
        }
        return NO_FLAVOUR;
    }

    public static Set<String> getFlavourIds() {
        return FLAVOUR_LOOKUP.keySet();
    }

    static {
        FLAVOUR_LOOKUP = new HashMap<String, PDFAFlavour>();
        for (PDFAFlavour flavour : PDFAFlavour.values()) {
            FLAVOUR_LOOKUP.put(flavour.id, flavour);
        }
    }

    public static enum Specification {
        NO_STANDARD(IsoStandardSeries.NO_SERIES, "", 0, "", ""),
        ISO_14289_1(IsoStandardSeries.ISO_14289, "PDF/UA", 1, "2014", "Use of ISO 32000-1 (PDF/UA-1)"),
        ISO_19005_1(IsoStandardSeries.ISO_19005, "PDF/A", 1, "2005", "Use of PDF 1.4"),
        ISO_19005_2(IsoStandardSeries.ISO_19005, "PDF/A", 2, "2011", "Use of ISO 32000-1"),
        ISO_19005_3(IsoStandardSeries.ISO_19005, "PDF/A", 3, "2012", "Use of ISO 32000-1 with support for embedded files"),
        ISO_19005_4(IsoStandardSeries.ISO_19005, "PDF/A", 4, "2020", "Use of ISO 32000-2"),
        ISO_32005(IsoStandardSeries.ISO_32005, "Tagged PDF", 0, "202X", "Document management -- Portable document format -- PDF 1.7 and 2.0 structure namespace inclusion in ISO 32000-2"),
        WCAG_2_1(IsoStandardSeries.NO_SERIES, "WCAG", 2, "2018", "Web Content Accessibility Guidelines");

        private final IsoStandardSeries series;
        private final int partNumber;
        private final String id;
        private final String year;
        private final String family;
        private final String name;
        private final String description;

        private Specification(IsoStandardSeries series, String family, int partNumber, String year, String description) {
            this.series = series;
            this.partNumber = partNumber;
            this.year = year;
            this.description = description;
            this.family = family;
            this.name = family + "-" + this.getPartNumber();
            this.id = this.calculateID();
        }

        private String calculateID() {
            if ("Web Content Accessibility Guidelines".equals(this.description)) {
                return "WCAG2.1";
            }
            if ("Document management -- Portable document format -- PDF 1.7 and 2.0 structure namespace inclusion in ISO 32000-2".equals(this.description)) {
                return this.series.getName() + ":" + this.getYear();
            }
            return this.series.getName() + "-" + this.getPartNumber() + ":" + this.getYear();
        }

        public final int getPartNumber() {
            return this.partNumber;
        }

        public final String getId() {
            return this.id;
        }

        public final String getYear() {
            return this.year;
        }

        public final String getName() {
            return this.name;
        }

        public final String getFamily() {
            return this.family;
        }

        public String getDescription() {
            return this.description;
        }

        public IsoStandardSeries getSeries() {
            return this.series;
        }

        public String toString() {
            return this.id;
        }
    }

    public static enum Level {
        NO_LEVEL("", ""),
        A("a", "accessible"),
        B("b", "basic"),
        U("u", "unicode"),
        F("f", "embedded files"),
        E("e", "engineering");

        private final String code;
        private final String name;

        private Level(String code, String name) {
            this.code = code;
            this.name = name;
        }

        public final String getCode() {
            return this.code;
        }

        public final String getName() {
            return this.name;
        }
    }

    public static enum IsoStandardSeries {
        NO_SERIES(0, ""),
        ISO_14289(14289, "Document management applications \u2014 Electronic document file format enhancement for accessibility"),
        ISO_19005(19005, "Document management -- Electronic document file format for long-term preservation"),
        ISO_32000(32000, "Document management -- Portable document format"),
        ISO_32005(32005, "Document management -- Portable document format -- PDF 1.7 and 2.0 structure namespace inclusion in ISO 32000-2");

        private final int id;
        private final String name;
        private final String description;

        private IsoStandardSeries(int id, String description) {
            this.id = id;
            this.name = "ISO " + this.getId();
            this.description = description;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.getName() + " " + this.getDescription();
        }
    }
}

