/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.verapdf.features.FeatureExtractorConfig;
import org.verapdf.features.FeatureFactory;
import org.verapdf.features.FeatureObjectType;

public class FeaturesConfigPanel
extends JPanel {
    private static final long serialVersionUID = -6602264333993164990L;
    private final JButton okButton;
    boolean ok;
    JDialog dialog;
    private final EnumMap<FeatureObjectType, JCheckBox> featureGrid = new EnumMap(FeatureObjectType.class);

    FeaturesConfigPanel() {
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(5, 3));
        for (FeatureObjectType type : FeatureObjectType.values()) {
            if (type == FeatureObjectType.ERROR) continue;
            this.featureGrid.put(type, new JCheckBox(type.getFullName()));
            panel.add(this.featureGrid.get((Object)type));
        }
        this.add((Component)panel, "Center");
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FeaturesConfigPanel.this.ok = true;
                FeaturesConfigPanel.this.dialog.setVisible(false);
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FeaturesConfigPanel.this.dialog.setVisible(false);
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.okButton);
        buttonPanel.add(cancelButton);
        this.add((Component)buttonPanel, "South");
    }

    boolean showDialog(Component parent, String title, FeatureExtractorConfig featureExtractorConfig) {
        Frame owner;
        this.ok = false;
        for (FeatureObjectType type : FeatureObjectType.values()) {
            if (type == FeatureObjectType.ERROR) continue;
            this.featureGrid.get((Object)type).setSelected(true);
            this.featureGrid.get((Object)type).setSelected(featureExtractorConfig.isFeatureEnabled(type));
        }
        Frame frame = owner = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        if (this.dialog == null || this.dialog.getOwner() != owner) {
            this.dialog = new JDialog(owner, true);
            this.dialog.setResizable(false);
            this.dialog.add(this);
            this.dialog.getRootPane().setDefaultButton(this.okButton);
            this.dialog.pack();
            this.dialog.setTitle(title);
        }
        this.dialog.setLocation(150, 150);
        this.dialog.setVisible(true);
        return this.ok;
    }

    FeatureExtractorConfig getFeaturesConfig() {
        EnumSet<FeatureObjectType> enabledFeatures = EnumSet.noneOf(FeatureObjectType.class);
        for (Map.Entry<FeatureObjectType, JCheckBox> entry : this.featureGrid.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            enabledFeatures.add(entry.getKey());
        }
        return FeatureFactory.configFromValues(enabledFeatures);
    }
}

