/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.form;

import java.io.IOException;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;

public final class PDGroup
implements COSObjectable {
    private final COSDictionary dictionary;
    private COSName subType;
    private PDColorSpace colorSpace;

    public PDGroup(COSDictionary dic) {
        this.dictionary = dic;
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.dictionary;
    }

    public COSName getSubType() {
        if (this.subType == null) {
            this.subType = (COSName)this.getCOSObject().getDictionaryObject(COSName.S);
        }
        return this.subType;
    }

    public PDColorSpace getColorSpace() throws IOException {
        if (this.colorSpace == null) {
            this.colorSpace = PDColorSpace.create(this.getCOSObject().getDictionaryObject(COSName.CS));
        }
        return this.colorSpace;
    }

    public boolean isIsolated() {
        return this.getCOSObject().getBoolean(COSName.I, false);
    }

    public boolean isKnockout() {
        return this.getCOSObject().getBoolean(COSName.K, false);
    }
}

