/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.annotation;

import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationMarkup;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;

public class PDAnnotationLine
extends PDAnnotationMarkup {
    public static final String IT_LINE_ARROW = "LineArrow";
    public static final String IT_LINE_DIMENSION = "LineDimension";
    public static final String LE_SQUARE = "Square";
    public static final String LE_CIRCLE = "Circle";
    public static final String LE_DIAMOND = "Diamond";
    public static final String LE_OPEN_ARROW = "OpenArrow";
    public static final String LE_CLOSED_ARROW = "ClosedArrow";
    public static final String LE_NONE = "None";
    public static final String LE_BUTT = "Butt";
    public static final String LE_R_OPEN_ARROW = "ROpenArrow";
    public static final String LE_R_CLOSED_ARROW = "RClosedArrow";
    public static final String LE_SLASH = "Slash";
    public static final String SUB_TYPE = "Line";

    public PDAnnotationLine() {
        this.getCOSObject().setItem(COSName.SUBTYPE, (COSBase)COSName.getPDFName(SUB_TYPE));
        this.setLine(new float[]{0.0f, 0.0f, 0.0f, 0.0f});
    }

    public PDAnnotationLine(COSDictionary field) {
        super(field);
    }

    public void setLine(float[] l) {
        COSArray newL = new COSArray();
        newL.setFloatArray(l);
        this.getCOSObject().setItem(COSName.L, (COSBase)newL);
    }

    public float[] getLine() {
        COSArray l = (COSArray)this.getCOSObject().getDictionaryObject(COSName.L);
        return l.toFloatArray();
    }

    public void setStartPointEndingStyle(String style) {
        COSArray array;
        if (style == null) {
            style = LE_NONE;
        }
        if ((array = (COSArray)this.getCOSObject().getDictionaryObject(COSName.LE)) == null) {
            array = new COSArray();
            array.add(COSName.getPDFName(style));
            array.add(COSName.getPDFName(LE_NONE));
            this.getCOSObject().setItem(COSName.LE, (COSBase)array);
        } else {
            array.setName(0, style);
        }
    }

    public String getStartPointEndingStyle() {
        String retval = LE_NONE;
        COSArray array = (COSArray)this.getCOSObject().getDictionaryObject(COSName.LE);
        if (array != null) {
            retval = array.getName(0);
        }
        return retval;
    }

    public void setEndPointEndingStyle(String style) {
        COSArray array;
        if (style == null) {
            style = LE_NONE;
        }
        if ((array = (COSArray)this.getCOSObject().getDictionaryObject(COSName.LE)) == null) {
            array = new COSArray();
            array.add(COSName.getPDFName(LE_NONE));
            array.add(COSName.getPDFName(style));
            this.getCOSObject().setItem(COSName.LE, (COSBase)array);
        } else {
            array.setName(1, style);
        }
    }

    public String getEndPointEndingStyle() {
        String retval = LE_NONE;
        COSArray array = (COSArray)this.getCOSObject().getDictionaryObject(COSName.LE);
        if (array != null) {
            retval = array.getName(1);
        }
        return retval;
    }

    public void setInteriorColor(PDColor ic) {
        this.getCOSObject().setItem(COSName.IC, (COSBase)ic.toCOSArray());
    }

    public PDColor getInteriorColor() {
        return this.getColor(COSName.IC);
    }

    public void setCaption(boolean cap) {
        this.getCOSObject().setBoolean(COSName.CAP, cap);
    }

    public boolean getCaption() {
        return this.getCOSObject().getBoolean(COSName.CAP, false);
    }

    public void setBorderStyle(PDBorderStyleDictionary bs) {
        this.getCOSObject().setItem(COSName.BS, (COSObjectable)bs);
    }

    public PDBorderStyleDictionary getBorderStyle() {
        COSDictionary bs = (COSDictionary)this.getCOSObject().getItem(COSName.BS);
        if (bs != null) {
            return new PDBorderStyleDictionary(bs);
        }
        return null;
    }

    public float getLeaderLineLength() {
        return this.getCOSObject().getFloat(COSName.LL);
    }

    public void setLeaderLineLength(float leaderLineLength) {
        this.getCOSObject().setFloat(COSName.LL, leaderLineLength);
    }

    public float getLeaderLineExtensionLength() {
        return this.getCOSObject().getFloat(COSName.LLE);
    }

    public void setLeaderLineExtensionLength(float leaderLineExtensionLength) {
        this.getCOSObject().setFloat(COSName.LLE, leaderLineExtensionLength);
    }

    public float getLeaderLineOffsetLength() {
        return this.getCOSObject().getFloat(COSName.LLO);
    }

    public void setLeaderLineOffsetLength(float leaderLineOffsetLength) {
        this.getCOSObject().setFloat(COSName.LLO, leaderLineOffsetLength);
    }

    public String getCaptionPositioning() {
        return this.getCOSObject().getString(COSName.CP);
    }

    public void setCaptionPositioning(String captionPositioning) {
        this.getCOSObject().setString(COSName.CP, captionPositioning);
    }

    public void setCaptionHorizontalOffset(float offset) {
        COSArray array = (COSArray)this.getCOSObject().getDictionaryObject(COSName.CO);
        if (array == null) {
            array = new COSArray();
            array.setFloatArray(new float[]{offset, 0.0f});
            this.getCOSObject().setItem(COSName.CO, (COSBase)array);
        } else {
            array.set(0, new COSFloat(offset));
        }
    }

    public float getCaptionHorizontalOffset() {
        float retval = 0.0f;
        COSArray array = (COSArray)this.getCOSObject().getDictionaryObject(COSName.CO);
        if (array != null) {
            retval = array.toFloatArray()[0];
        }
        return retval;
    }

    public void setCaptionVerticalOffset(float offset) {
        COSArray array = (COSArray)this.getCOSObject().getDictionaryObject(COSName.CO);
        if (array == null) {
            array = new COSArray();
            array.setFloatArray(new float[]{0.0f, offset});
            this.getCOSObject().setItem(COSName.CO, (COSBase)array);
        } else {
            array.set(1, new COSFloat(offset));
        }
    }

    public float getCaptionVerticalOffset() {
        float retval = 0.0f;
        COSArray array = (COSArray)this.getCOSObject().getDictionaryObject(COSName.CO);
        if (array != null) {
            retval = array.toFloatArray()[1];
        }
        return retval;
    }
}

